/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.contract.entity.ContractEntity;
import com.biz.crm.contract.entity.ContractSalesAreaEntity;
import com.biz.crm.contract.mapper.ContractSalesAreaMapper;
import com.biz.crm.contract.service.ContractSalesAreaService;
import com.biz.crm.nebular.dms.contract.ContractSalesAreaVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"contractSalesAreaServiceExpand"})
@Service(value="contractSalesAreaService")
public class ContractSalesAreaServiceImpl
extends ServiceImpl<ContractSalesAreaMapper, ContractSalesAreaEntity>
implements ContractSalesAreaService {
    @Autowired
    private ContractSalesAreaMapper contractSalesAreaMapper;

    @Override
    @Transactional
    public void replace(final ContractEntity contractEntity, List<ContractSalesAreaVo> salesAreas) {
        this.removeByMap(new HashMap<String, Object>(){
            {
                this.put("contract_id", contractEntity.getId());
            }
        });
        if (CollectionUtils.isEmpty(salesAreas)) {
            return;
        }
        ArrayList<ContractSalesAreaEntity> entities = new ArrayList<ContractSalesAreaEntity>(salesAreas.size());
        for (ContractSalesAreaVo vo : salesAreas) {
            ContractSalesAreaEntity entity = new ContractSalesAreaEntity();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
            entity.setContractId(contractEntity.getId());
            entities.add(entity);
        }
        this.saveBatch(entities);
    }

    @Override
    public List<ContractSalesAreaVo> findByContractId(String contractId) {
        if (StringUtils.isEmpty((Object)contractId)) {
            return new ArrayList<ContractSalesAreaVo>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        List salesAreaEntities = this.contractSalesAreaMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)salesAreaEntities)) {
            return new ArrayList<ContractSalesAreaVo>();
        }
        ArrayList<ContractSalesAreaVo> salesAreaVos = new ArrayList<ContractSalesAreaVo>(salesAreaEntities.size());
        for (ContractSalesAreaEntity entity : salesAreaEntities) {
            ContractSalesAreaVo salesAreaVo = new ContractSalesAreaVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)salesAreaVo);
            salesAreaVos.add(salesAreaVo);
        }
        return salesAreaVos;
    }

    @Override
    @Transactional
    public void delByContractIds(List<String> contractIds) {
        if (CollectionUtils.isEmpty(contractIds)) {
            throw new BusinessException("\u5408\u540cid\u4e3a\u7a7a");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"contract_id", contractIds);
        this.contractSalesAreaMapper.delete((Wrapper)wrapper);
    }
}

