/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salestarget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.salestarget.SalesMonthTargetVo;
import com.biz.crm.salestarget.entity.SalesMonthTargetEntity;
import com.biz.crm.salestarget.entity.SalesTargetEntity;
import com.biz.crm.salestarget.mapper.SalesMonthTargetMapper;
import com.biz.crm.salestarget.service.SalesMonthTargetService;
import com.biz.crm.salestarget.utils.SalesMonthTargetUtil;
import com.biz.crm.util.ValidateUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"salesMonthTargetServiceExpand"})
@Service(value="salesMonthTargetService")
public class SalesMonthTargetServiceImpl
extends ServiceImpl<SalesMonthTargetMapper, SalesMonthTargetEntity>
implements SalesMonthTargetService {
    @Autowired
    private SalesMonthTargetMapper salesMonthTargetMapper;

    @Override
    public void add(SalesTargetEntity salesTargetEntity, SalesMonthTargetVo salesMonthTargetVo) {
        if (salesMonthTargetVo == null) {
            throw new BusinessException("\u6708\u76ee\u6807\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.salesMonthTargetMapper.insert((Object)SalesMonthTargetUtil.packageEntityForAdd(salesTargetEntity, salesMonthTargetVo));
    }

    @Override
    public void update(SalesMonthTargetVo salesMonthTargetVo) {
        ValidateUtils.validate((Object)salesMonthTargetVo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u6708\u9500\u552e\u76ee\u6807!");
        SalesMonthTargetEntity entity = (SalesMonthTargetEntity)((Object)this.salesMonthTargetMapper.selectById((Serializable)((Object)salesMonthTargetVo.getId())));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u60a8\u8981\u7f16\u8f91\u7684\u9500\u552e\u76ee\u6807\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664!");
        BeanUtils.copyProperties((Object)salesMonthTargetVo, (Object)((Object)entity));
        this.salesMonthTargetMapper.updateById((Object)entity);
    }

    @Override
    public SalesMonthTargetVo findBySalesTargetId(String salesTargetId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"sales_target_id", (Object)salesTargetId);
        List monthTargetEntities = this.salesMonthTargetMapper.selectList((Wrapper)wrapper);
        SalesMonthTargetVo vo = new SalesMonthTargetVo();
        BeanUtils.copyProperties(monthTargetEntities.get(0), (Object)vo);
        SalesMonthTargetUtil.salesTargetToStr(vo);
        return vo;
    }

    @Override
    public Map<String, SalesMonthTargetVo> findBySalesTargetIds(List<String> salesTargetIds) {
        HashMap<String, SalesMonthTargetVo> reMap = new HashMap<String, SalesMonthTargetVo>();
        if (CollectionUtils.isEmpty(salesTargetIds)) {
            return reMap;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"sales_target_id", salesTargetIds);
        List monthTargetEntities = this.salesMonthTargetMapper.selectList((Wrapper)wrapper);
        Map<Object, Object> entityMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)monthTargetEntities)) {
            entityMap = monthTargetEntities.stream().collect(Collectors.toMap(SalesMonthTargetEntity::getSalesTargetId, a -> a, (k1, k2) -> k1));
        }
        for (String str : salesTargetIds) {
            SalesMonthTargetVo vo = null;
            SalesMonthTargetEntity entity = (SalesMonthTargetEntity)((Object)entityMap.get(str));
            if (null != entity) {
                vo = new SalesMonthTargetVo();
                BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            }
            reMap.put(str, vo);
        }
        return reMap;
    }
}

