/**
 * 条件规则- 数量~数量
 * @param productBuyNo
 * @param ladder
 * @return
 */
def func(productBuyNo, ladder) {
    /**
     * 该阶梯用户设置的满赠数量
     */
    ladderNo = ladder.get( 'controls').get(0).get('value');
    /**
     * 返回订单购买数量对满赠数量取余结果，计算规则脚本可依据该结果进行灵活的阶梯计算
     */
    BigDecimal[] temp = new BigDecimal(productBuyNo).divideAndRemainder(new BigDecimal(ladderNo)) ;
    BigDecimal[] result = [temp[0], temp[1], BigDecimal.ZERO];
    return result;
};
func(productBuyNo, ladder);



/**
 * 调试参数
 * {"productBuyNo":10,"ladder":{"text":"本单中本品数量购买满","controlKey":5,"controls":[{"key":"buyNo","value":50},{"key":"buyUnit","value":"xiang"},{"key":"giftNo","value":5},{"key":"giftUnit","value":"jian"}]}}
 */




//def func(productBuyNo, ladder) {
//    ladderNo = ladder.get( 'controls').get(0).get('value');
//    BigDecimal[] temp = new BigDecimal(productBuyNo).divideAndRemainder(new BigDecimal(ladderNo)) ;
//    BigDecimal[] result = [temp[0], temp[1], BigDecimal.ZERO];
//    return result;
//};
//func(productBuyNo, ladder);