/**
 * 条件规则- 金额~金额
 * @param productBuyNo
 * @param ladder
 * @return
 */
def func(productBuyAmount, ladder) {
    if(null == productBuyAmount){
        throw new Exception('中断执行脚本[' + shellName + ']，订单购买金额必传');
    };
    if(null == productBuyAmount){
        throw new Exception('中断执行脚本[' + shellName + ']，请指定阶梯信息');
    };
    /**
     * 该阶梯用户设置的满赠数量
     */
    ladderNo = ladder.get( 'controls').get(0).get('value');
    /**
     * //返回订单购买数量对满赠数量取余结果，计算规则脚本可依据该结果进行灵活的阶梯计算\n
     */
    BigDecimal[] temp = new BigDecimal(productBuyAmount).divideAndRemainder(new BigDecimal(ladderNo)) ;
    BigDecimal[] result = [temp[0], temp[1], BigDecimal.ONE];
    return result;
};
func(productBuyAmount, ladder);


/**
 * 调试参数
 * {"productBuyNo":10,"productBuyAmount":10,"ladder":{"text":"本单中本品数量购买满","controlKey":5,"controls":[{"key":"buyNo","value":50},{"key":"buyUnit","value":"xiang"},{"key":"giftNo","value":5},{"key":"giftUnit","value":"jian"}]}}
 */




//def func(productBuyNo, ladder) {
//    if(null == productBuyNo){
//        throw new Exception('中断执行脚本[' + shellName + ']，订单购买数量必传');
//    };
//    if(null == productBuyNo){
//        throw new Exception('中断执行脚本[' + shellName + ']，请指定阶梯信息');
//    };
//    ladderNo = ladder.get( 'controls').get(0).get('value');
//    BigDecimal[] temp = new BigDecimal(productBuyNo).divideAndRemainder(new BigDecimal(ladderNo)) ;
//    BigDecimal[] result = [temp[0], temp[1], BigDecimal.ZERO];
//    return result;
//};
//func(productBuyNo, ladder);