/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.notice.NoticeAreaVo;
import com.biz.crm.notice.entity.NoticeAreaEntity;
import com.biz.crm.notice.entity.NoticeEntity;
import com.biz.crm.notice.mapper.NoticeAreaMapper;
import com.biz.crm.notice.service.NoticeAreaService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"noticeAreaServiceExpand"})
@Service(value="noticeAreaService")
public class NoticeAreaServiceImpl
extends ServiceImpl<NoticeAreaMapper, NoticeAreaEntity>
implements NoticeAreaService {
    @Autowired
    private NoticeAreaMapper noticeAreaMapper;

    @Override
    @Transactional
    public void replace(final NoticeEntity noticeEntity, List<NoticeAreaVo> areaVos) {
        this.removeByMap(new HashMap<String, Object>(){
            {
                this.put("notice_id", noticeEntity.getId());
            }
        });
        ArrayList<NoticeAreaEntity> entities = new ArrayList<NoticeAreaEntity>();
        if (CollectionUtils.isEmpty(areaVos)) {
            NoticeAreaEntity entity = new NoticeAreaEntity();
            entity.setOrgCode("000");
            entity.setOrgName("\u5168\u90e8");
            entity.setNoticeId(noticeEntity.getId());
            entities.add(entity);
        } else {
            for (NoticeAreaVo vo : areaVos) {
                NoticeAreaEntity entity = new NoticeAreaEntity();
                BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
                entity.setNoticeId(noticeEntity.getId());
                entities.add(entity);
            }
        }
        this.saveBatch(entities);
    }

    @Override
    public List<NoticeAreaVo> findByNoticeId(String noticeId) {
        if (StringUtils.isEmpty((Object)noticeId)) {
            return new ArrayList<NoticeAreaVo>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"notice_id", (Object)noticeId);
        List areaEntities = this.noticeAreaMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)areaEntities)) {
            return new ArrayList<NoticeAreaVo>();
        }
        ArrayList<NoticeAreaVo> reList = new ArrayList<NoticeAreaVo>(areaEntities.size());
        for (NoticeAreaEntity entity : areaEntities) {
            NoticeAreaVo vo = new NoticeAreaVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            reList.add(vo);
        }
        return reList;
    }

    @Override
    @Transactional
    public void delByNoticeIds(List<String> noticeIds) {
        if (CollectionUtils.isEmpty(noticeIds)) {
            throw new BusinessException("\u516c\u544aid\u4e3a\u7a7a");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"notice_id", noticeIds);
        this.noticeAreaMapper.delete((Wrapper)wrapper);
    }
}

