/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.notice.NoticeFileVo;
import com.biz.crm.notice.entity.NoticeEntity;
import com.biz.crm.notice.entity.NoticeFileEntity;
import com.biz.crm.notice.mapper.NoticeFileMapper;
import com.biz.crm.notice.service.NoticeFileService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"noticeFileServiceExpand"})
@Service(value="noticeFileService")
public class NoticeFileServiceImpl
extends ServiceImpl<NoticeFileMapper, NoticeFileEntity>
implements NoticeFileService {
    @Autowired
    private NoticeFileMapper noticeFileMapper;

    @Override
    @Transactional
    public void replace(final NoticeEntity noticeEntity, List<NoticeFileVo> files) {
        this.removeByMap(new HashMap<String, Object>(){
            {
                this.put("notice_id", noticeEntity.getId());
            }
        });
        if (CollectionUtils.isEmpty(files)) {
            return;
        }
        ArrayList<NoticeFileEntity> entities = new ArrayList<NoticeFileEntity>(files.size());
        int i = 0;
        for (NoticeFileVo vo : files) {
            vo.setSortNum(Integer.valueOf(++i));
            NoticeFileEntity entity = new NoticeFileEntity();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
            entity.setNoticeId(noticeEntity.getId());
            entities.add(entity);
        }
        this.saveBatch(entities);
    }

    @Override
    public List<NoticeFileVo> findByNoticeId(String noticeId) {
        if (StringUtils.isEmpty((Object)noticeId)) {
            return new ArrayList<NoticeFileVo>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"notice_id", (Object)noticeId);
        List fileEntities = this.noticeFileMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)fileEntities)) {
            return new ArrayList<NoticeFileVo>();
        }
        ArrayList<NoticeFileVo> reList = new ArrayList<NoticeFileVo>(fileEntities.size());
        for (NoticeFileEntity entity : fileEntities) {
            NoticeFileVo vo = new NoticeFileVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            reList.add(vo);
        }
        Collections.sort(reList, (a, b) -> a.getSortNum().compareTo(b.getSortNum()));
        return reList;
    }

    @Override
    public Map<String, List<NoticeFileVo>> findByNoticeIds(List<String> noticeIds) {
        Map<String, List<NoticeFileVo>> reMap = new HashMap<String, List<NoticeFileVo>>();
        if (CollectionUtils.isEmpty(noticeIds)) {
            return reMap;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"notice_id", noticeIds);
        List fileEntities = this.noticeFileMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)fileEntities)) {
            return reMap;
        }
        reMap = fileEntities.stream().map(entity -> {
            NoticeFileVo vo = new NoticeFileVo();
            BeanUtils.copyProperties((Object)entity, (Object)vo);
            return vo;
        }).collect(Collectors.groupingBy(NoticeFileVo::getNoticeId));
        for (String informationId : reMap.keySet()) {
            Collections.sort(reMap.get(informationId), (a, b) -> a.getSortNum().compareTo(b.getSortNum()));
        }
        return reMap;
    }

    @Override
    @Transactional
    public void delByNoticeIds(List<String> noticeIds) {
        if (CollectionUtils.isEmpty(noticeIds)) {
            throw new BusinessException("\u516c\u544aid\u4e3a\u7a7a");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"notice_id", noticeIds);
        this.noticeFileMapper.delete((Wrapper)wrapper);
    }
}

