/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRule;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRuleEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleSelectionVo;
import com.biz.crm.promotion.entity.PromotionPolicyRuleEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyRuleMapper;
import com.biz.crm.promotion.service.PromotionPolicyRuleService;
import com.biz.crm.promotion.service.PromotionPolicyTemplateService;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional
@ConditionalOnMissingBean(name={"promotionPolicyRuleServiceExpand"})
@Service(value="promotionPolicyRuleService")
public class PromotionPolicyRuleServiceImpl
extends ServiceImpl<PromotionPolicyRuleMapper, PromotionPolicyRuleEntity>
implements PromotionPolicyRuleService {
    @Resource
    private PromotionPolicyRuleMapper promotionPolicyRuleMapper;
    @Resource
    private PromotionPolicyTemplateService promotionPolicyTemplateService;

    @Override
    public void refreshRule(PromotionPolicyEditReqVo editVo) {
        if (StringUtils.isNotBlank((CharSequence)editVo.getId())) {
            this.doDelByPromotionPolicyIdOrCode(Lists.newArrayList((Object[])new String[]{editVo.getId()}), null);
        }
        List tempEditVos = editVo.takeAllRules();
        ArrayList newEntitys = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)tempEditVos)) {
            return;
        }
        HashSet keys = Sets.newHashSet();
        for (PromotionPolicyRuleEditVo temp : tempEditVos) {
            String key = temp.getPromotionPolicyId() + temp.getPromotionRuleId();
            if (keys.contains(key)) continue;
            PromotionPolicyRuleEntity entity = (PromotionPolicyRuleEntity)((Object)CrmBeanUtil.copy((Object)temp, PromotionPolicyRuleEntity.class));
            entity.setId(null);
            entity.setPromotionPolicyCode(editVo.getPromotionPolicyCode());
            entity.setPromotionPolicyId(editVo.getId());
            entity.setPromotionPolicyTemplateCode(editVo.getTemplateCode());
            entity.setPromotionPolicyTemplateId(editVo.getTemplateId());
            if (CollectionUtils.isEmpty((Collection)temp.getControlRows())) {
                entity.setParams("[]");
            } else {
                entity.setParams(JsonPropertyUtil.toJsonString((Object)temp.getControlRows()));
            }
            newEntitys.add(entity);
            keys.add(key);
        }
        this.saveBatch(newEntitys);
    }

    @Override
    public void loadListForEditPromotionPolicy(PromotionPolicyEditVo editVo) {
        Map<Object, Object> limited;
        Map<Object, Object> condition;
        Map<Object, Object> calculate;
        if (StringUtils.isBlank((CharSequence)editVo.getTemplateId())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u653f\u7b56\u6a21\u677f");
        }
        if (StringUtils.isNotBlank((CharSequence)editVo.getId())) {
            QueryWrapper wrapper = Wrappers.query();
            wrapper.in((Object)"promotion_policy_id", new Object[]{editVo.getId()});
            Map<String, List<PromotionPolicyRuleEntity>> groupByCurrentProduct = this.promotionPolicyRuleMapper.selectList((Wrapper)wrapper).stream().collect(Collectors.groupingBy(PromotionPolicyRuleEntity::getRuleType));
            calculate = groupByCurrentProduct.get(CommonConstant.DMS.PromotionPolicyRuleType.CALCULATE.getItemCode()).stream().collect(Collectors.toMap(PromotionPolicyRuleEntity::getPromotionRuleId, v -> v, (t, t2) -> t2));
            condition = groupByCurrentProduct.get(CommonConstant.DMS.PromotionPolicyRuleType.CONDITION.getItemCode()).stream().collect(Collectors.toMap(PromotionPolicyRuleEntity::getPromotionRuleId, v -> v, (t, t2) -> t2));
            limited = groupByCurrentProduct.get(CommonConstant.DMS.PromotionPolicyRuleType.LIMITED.getItemCode()).stream().collect(Collectors.toMap(PromotionPolicyRuleEntity::getPromotionRuleId, v -> v, (t, t2) -> t2));
        } else {
            condition = calculate = Maps.newHashMap();
            limited = calculate;
        }
        PromotionPolicyTemplateEditVo promotionPolicyTemplateEditVo = this.promotionPolicyTemplateService.loadTemplateInfo(editVo.getTemplateId());
        editVo.setTemplateEditVo(promotionPolicyTemplateEditVo);
        editVo.setTemplateCode(promotionPolicyTemplateEditVo.getTemplateCode());
        editVo.setTemplateName(promotionPolicyTemplateEditVo.getTemplateName());
        List<PromotionPolicyRuleEditVo> rulesAsCondition = this.bulidPromotionPolicyRule(promotionPolicyTemplateEditVo.getCondition(), condition, editVo);
        List<PromotionPolicyRuleEditVo> rulesAsCalculate = this.bulidPromotionPolicyRule(promotionPolicyTemplateEditVo.getCalculate(), calculate, editVo);
        List<PromotionPolicyRuleEditVo> rulesAsLimited = this.bulidPromotionPolicyRule(promotionPolicyTemplateEditVo.getLimited(), limited, editVo);
        PromotionPolicyRule promotionPolicyRule = new PromotionPolicyRule();
        promotionPolicyRule.setRulesAsCalculate(rulesAsCalculate);
        promotionPolicyRule.setRulesAsCondition(rulesAsCondition);
        promotionPolicyRule.setRulesAsLimited(rulesAsLimited);
        editVo.setPromotionPolicyRule(promotionPolicyRule);
    }

    private List<PromotionPolicyRuleEditVo> bulidPromotionPolicyRule(List<PromotionRuleSelectionVo> templateRules, Map<String, PromotionPolicyRuleEntity> promotionRuleMapId, PromotionPolicyEditVo editVo) {
        ArrayList promotionRulerules = Lists.newArrayList();
        for (PromotionRuleSelectionVo templateRule : templateRules) {
            PromotionPolicyRuleEditVo promotionPolicyRuleEditVo;
            List<PromotionRuleEditVo.ControlRow> controlRows = null;
            if (promotionRuleMapId.containsKey(templateRule.getId())) {
                PromotionPolicyRuleEntity entity = promotionRuleMapId.get(templateRule.getId());
                promotionPolicyRuleEditVo = (PromotionPolicyRuleEditVo)CrmBeanUtil.copy((Object)((Object)entity), PromotionPolicyRuleEditVo.class);
                controlRows = JsonPropertyUtil.toArray((String)entity.getParams(), PromotionRuleEditVo.ControlRow.class);
                promotionPolicyRuleEditVo.setSelected(Boolean.valueOf(true));
            } else {
                controlRows = Lists.newArrayList();
                promotionPolicyRuleEditVo = (PromotionPolicyRuleEditVo)CrmBeanUtil.copy((Object)templateRule, PromotionPolicyRuleEditVo.class);
                PromotionRuleEditVo.TestParam testParam = (PromotionRuleEditVo.TestParam)JsonPropertyUtil.toObject((String)templateRule.getTestJsonParams(), PromotionRuleEditVo.TestParam.class);
                if (null != testParam && null != testParam.getControlRow() && !CollectionUtils.isEmpty((Collection)testParam.getControlRow().getControls())) {
                    PromotionRuleEditVo.ControlRow controlRow = testParam.getControlRow();
                    controlRow.getControls().forEach(v -> v.setValue(null));
                    controlRows.add(controlRow);
                }
                promotionPolicyRuleEditVo.setSelected(Boolean.valueOf(false));
            }
            promotionPolicyRuleEditVo.setControlRows((List)controlRows);
            promotionPolicyRuleEditVo.setRuleName(templateRule.getRuleName());
            promotionPolicyRuleEditVo.setPromotionPolicyTemplateId(editVo.getTemplateId());
            promotionPolicyRuleEditVo.setPromotionPolicyTemplateCode(editVo.getTemplateCode());
            promotionPolicyRuleEditVo.setPromotionRuleId(templateRule.getId());
            promotionRulerules.add(promotionPolicyRuleEditVo);
        }
        return promotionRulerules;
    }

    @Override
    public void delByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        this.doDelByPromotionPolicyIdOrCode(promotionPolicyId, promotionPolicyCode);
    }

    @Override
    public List<PromotionPolicyRuleEntity> getRuleByPromotionPolicyIdOrCode(String promotionPolicyId, String promotionPolicyCode) {
        QueryWrapper wrapper = Wrappers.query();
        if (StringUtils.isNotBlank((CharSequence)promotionPolicyId)) {
            wrapper.eq((Object)"promotion_policy_id", (Object)promotionPolicyId);
        } else if (StringUtils.isNotBlank((CharSequence)promotionPolicyCode)) {
            wrapper.eq((Object)"promotion_policy_code", (Object)promotionPolicyCode);
        } else {
            return Lists.newArrayList();
        }
        return this.promotionPolicyRuleMapper.selectList((Wrapper)wrapper);
    }

    private void doDelByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        QueryWrapper wrapper = Wrappers.query();
        if (!CollectionUtils.isEmpty(promotionPolicyId)) {
            wrapper.in((Object)"promotion_policy_id", promotionPolicyId);
        } else if (!CollectionUtils.isEmpty(promotionPolicyCode)) {
            wrapper.in((Object)"promotion_policy_code", promotionPolicyCode);
        } else {
            return;
        }
        this.promotionPolicyRuleMapper.delete((Wrapper)wrapper);
    }
}

