/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.feepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.feepool.entity.FeePoolDetailEntity;
import com.biz.crm.feepool.entity.FeePoolDetailLogEntity;
import com.biz.crm.feepool.entity.FeePoolEntity;
import com.biz.crm.feepool.mapper.FeePoolDetailMapper;
import com.biz.crm.feepool.service.FeePoolDetailGoodsService;
import com.biz.crm.feepool.service.FeePoolDetailLogService;
import com.biz.crm.feepool.service.FeePoolDetailService;
import com.biz.crm.feepool.utils.FeePoolDetailLogUtil;
import com.biz.crm.nebular.dms.feepool.FeePoolDetailGoodsVo;
import com.biz.crm.nebular.dms.feepool.FeePoolDetailVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ValidateUtils;
import com.bizunited.platform.common.vo.UuidVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"feePoolDetailServiceExpandImpl"})
@Service(value="feePoolDetailService")
public class FeePoolDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<FeePoolDetailMapper, FeePoolDetailEntity>
implements FeePoolDetailService {
    @Autowired
    private FeePoolDetailMapper feePoolDetailMapper;
    @Resource
    private FeePoolDetailGoodsService feePoolDetailGoodsService;
    @Resource
    private FeePoolDetailLogService feePoolDetailLogService;

    @Override
    @Transactional
    public Map<String, BigDecimal> addBatch(List<FeePoolDetailVo> addVos, FeePoolEntity feePool) {
        HashMap<String, BigDecimal> reMap = new HashMap<String, BigDecimal>();
        reMap.put("add", BigDecimal.ZERO);
        reMap.put("sub", BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(addVos)) {
            return reMap;
        }
        if (null == feePool) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5ba2\u6237\u8d39\u7528\u6c60!");
        }
        BigDecimal addtotal = BigDecimal.ZERO;
        BigDecimal subtotal = BigDecimal.ZERO;
        ArrayList<FeePoolDetailEntity> feePoolDetailEntityList = new ArrayList<FeePoolDetailEntity>(addVos.size());
        HashMap<String, List<FeePoolDetailGoodsVo>> FeePoolDetailGoodsVoMap = new HashMap<String, List<FeePoolDetailGoodsVo>>(addVos.size());
        ArrayList<FeePoolDetailLogEntity> feePoolDetailLogEntities = new ArrayList<FeePoolDetailLogEntity>(addVos.size());
        for (FeePoolDetailVo vo : addVos) {
            ValidateUtils.validate((Object)vo.getPayType(), (String)"\u652f\u4ed8\u65b9\u5f0f\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)vo.getBalance(), (String)"\u4e0a\u8d26\u91d1\u989d\u4e3a\u7a7a");
            FeePoolDetailEntity entity = new FeePoolDetailEntity();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
            entity.setCode(CodeUtil.createCode());
            entity.setRemarks(vo.getRemarks());
            entity.setCusCode(feePool.getCusCode());
            entity.setCusName(feePool.getCusName());
            entity.setCusChannelCode(feePool.getCusChannelCode());
            entity.setCusChannelName(feePool.getCusChannelName());
            entity.setCusOrgCode(feePool.getCusOrgCode());
            entity.setCusOrgName(feePool.getCusOrgName());
            entity.setFeePoolCode(feePool.getCode());
            feePoolDetailEntityList.add(entity);
            for (FeePoolDetailGoodsVo feePoolDetailGoodsVo : vo.getGoods()) {
                feePoolDetailGoodsVo.setFeePoolDetailCode(entity.getCode());
            }
            FeePoolDetailGoodsVoMap.put(entity.getCode(), vo.getGoods());
            FeePoolDetailLogUtil.ADJUSTMENTTYPE adjustmenttype = FeePoolDetailLogUtil.ADJUSTMENTTYPE.ADDBYMANUAL;
            if (vo.getAdjustmentType().intValue() == FeePoolDetailLogUtil.ADJUSTMENTTYPE.ADDBYMANUAL.getCode().intValue()) {
                addtotal = addtotal.add(entity.getBalance());
            } else if (vo.getAdjustmentType().intValue() == FeePoolDetailLogUtil.ADJUSTMENTTYPE.REDUCEBYMANUAL.getCode().intValue()) {
                subtotal = subtotal.subtract(entity.getBalance());
                entity.setBalance(BigDecimal.ZERO.subtract(entity.getBalance()));
                adjustmenttype = FeePoolDetailLogUtil.ADJUSTMENTTYPE.REDUCEBYMANUAL;
            } else if (vo.getAdjustmentType().intValue() == FeePoolDetailLogUtil.ADJUSTMENTTYPE.INITIAL.getCode().intValue()) {
                addtotal = addtotal.add(entity.getBalance());
                adjustmenttype = FeePoolDetailLogUtil.ADJUSTMENTTYPE.INITIAL;
            } else {
                throw new BusinessException("\u8c03\u6574\u7c7b\u578b\u9519\u8bef!");
            }
            feePoolDetailLogEntities.add(FeePoolDetailLogUtil.packageEntity(feePool.getCode(), entity.getCode(), entity.getBalance(), adjustmenttype, StringUtils.isEmpty((Object)vo.getSourbNo()) ? CodeUtil.createCode() : vo.getSourbNo()));
        }
        this.saveBatch(feePoolDetailEntityList);
        this.feePoolDetailGoodsService.addBatch(FeePoolDetailGoodsVoMap);
        this.feePoolDetailLogService.addBatch(feePoolDetailLogEntities);
        reMap.put("add", addtotal);
        reMap.put("sub", subtotal);
        return reMap;
    }

    @Override
    @Transactional
    public Map<String, BigDecimal> updateBatch(List<FeePoolDetailVo> updateVos, FeePoolEntity feePool) {
        HashMap<String, BigDecimal> reMap = new HashMap<String, BigDecimal>();
        reMap.put("add", BigDecimal.ZERO);
        reMap.put("sub", BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(updateVos)) {
            return reMap;
        }
        List entities = this.feePoolDetailMapper.selectBatchIds(updateVos.stream().map(UuidVo::getId).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty((Collection)entities) || entities.size() != updateVos.size()) {
            throw new BusinessException("\u8d39\u7528\u6761\u76ee\u5df2\u6539\u53d8\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c!");
        }
        List codeValidateList = entities.stream().filter(entity -> StringUtils.isEmpty((Object)entity.getFeePoolCode()) || !entity.getFeePoolCode().equals(feePool.getCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(codeValidateList)) {
            throw new BusinessException("\u8bf7\u6309\u7167\u8d39\u7528\u6c60\u6279\u91cf\u66f4\u65b0\u6761\u76ee\uff0c\u6682\u4e0d\u652f\u6301\u6df7\u5408\u6279\u91cf\u66f4\u65b0\u6761\u76ee!");
        }
        Map<String, FeePoolDetailEntity> entityMap = entities.stream().collect(Collectors.toMap(BaseIdEntity::getId, a -> a, (k1, k2) -> k1));
        BigDecimal addtotal = BigDecimal.ZERO;
        BigDecimal subtotal = BigDecimal.ZERO;
        ArrayList<FeePoolDetailLogEntity> feePoolDetailLogEntities = new ArrayList<FeePoolDetailLogEntity>(updateVos.size());
        for (FeePoolDetailVo vo : updateVos) {
            FeePoolDetailEntity entity2 = entityMap.get(vo.getId());
            ValidateUtils.validate((Object)vo.getAdjustmentType(), (String)"\u8bf7\u6307\u5b9a\u8c03\u6574\u7c7b\u578b");
            FeePoolDetailLogUtil.ADJUSTMENTTYPE adjustmentType = FeePoolDetailLogUtil.ADJUSTMENTTYPE.ADDBYMANUAL;
            if (vo.getAdjustmentType().intValue() == FeePoolDetailLogUtil.ADJUSTMENTTYPE.ADDBYMANUAL.getCode().intValue()) {
                entity2.setBalance(entity2.getBalance().add(vo.getAdjustmentAmount()));
                addtotal = addtotal.add(vo.getAdjustmentAmount());
            } else if (vo.getAdjustmentType().intValue() == FeePoolDetailLogUtil.ADJUSTMENTTYPE.REDUCEBYMANUAL.getCode().intValue()) {
                entity2.setBalance(entity2.getBalance().subtract(vo.getAdjustmentAmount()));
                subtotal = subtotal.subtract(vo.getAdjustmentAmount());
                adjustmentType = FeePoolDetailLogUtil.ADJUSTMENTTYPE.REDUCEBYMANUAL;
            } else {
                throw new BusinessException("\u8c03\u6574\u7c7b\u578b\u9519\u8bef!");
            }
            feePoolDetailLogEntities.add(FeePoolDetailLogUtil.packageEntity(entity2.getFeePoolCode(), entity2.getCode(), vo.getAdjustmentAmount(), adjustmentType, "-"));
        }
        this.updateBatchById(entities);
        this.feePoolDetailLogService.addBatch(feePoolDetailLogEntities);
        reMap.put("add", addtotal);
        reMap.put("sub", subtotal);
        return reMap;
    }

    @Override
    public PageResult<FeePoolDetailVo> list(FeePoolDetailVo feePoolDetailVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq(null != feePoolDetailVo.getPayType(), (Object)"pay_type", (Object)feePoolDetailVo.getPayType())).eq(!StringUtils.isEmpty((Object)feePoolDetailVo.getFeePoolCode()), (Object)"fee_pool_code", (Object)feePoolDetailVo.getFeePoolCode())).orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = PageUtil.buildPage((Integer)feePoolDetailVo.getPageNum(), (Integer)feePoolDetailVo.getPageSize());
        List<FeePoolDetailVo> list = this.feePoolDetailMapper.list(page, (QueryWrapper<FeePoolDetailVo>)wrapper);
        if (!CollectionUtils.isEmpty(list)) {
            List<String> codes = list.stream().map(FeePoolDetailVo::getCode).collect(Collectors.toList());
            Map<String, List<FeePoolDetailGoodsVo>> goodsMap = this.feePoolDetailGoodsService.selectBydetailCodes(codes);
            for (FeePoolDetailVo vo : list) {
                List<FeePoolDetailGoodsVo> goodsVos = goodsMap.get(vo.getCode());
                vo.setGoods(goodsVos);
                if (CollectionUtils.isEmpty(goodsVos)) continue;
                StringBuilder goodsNameBuffer = new StringBuilder();
                for (FeePoolDetailGoodsVo goods : goodsVos) {
                    goodsNameBuffer.append(goods.getGoodsName()).append(";");
                }
                String goodsNameStr = goodsNameBuffer.toString();
                vo.setGoodsNameStr(goodsNameStr.substring(0, goodsNameStr.length() - 2));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

