/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.companyinformation.utils;

import com.biz.crm.companyinformation.entity.CompanyInformationAreaEntity;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationAreaVo;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CompanyInformationAreaUtil {
    public static List<CompanyInformationAreaVo> addAllAreas(CompanyInformationVo companyInformationVo) {
        ArrayList<CompanyInformationAreaVo> areaVos = new ArrayList<CompanyInformationAreaVo>();
        if (!CollectionUtils.isEmpty((Collection)companyInformationVo.getOrgs())) {
            areaVos.addAll(companyInformationVo.getOrgs());
        }
        if (!CollectionUtils.isEmpty((Collection)companyInformationVo.getNonOrgs())) {
            areaVos.addAll(companyInformationVo.getNonOrgs());
        }
        if (!CollectionUtils.isEmpty((Collection)companyInformationVo.getCustomers())) {
            areaVos.addAll(companyInformationVo.getCustomers());
        }
        if (!CollectionUtils.isEmpty((Collection)companyInformationVo.getNonCustomers())) {
            areaVos.addAll(companyInformationVo.getNonCustomers());
        }
        return areaVos;
    }

    public static List<CompanyInformationAreaEntity> judegeOffsetFlag(List<CompanyInformationAreaEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return new ArrayList<CompanyInformationAreaEntity>();
        }
        List containEntities = entities.stream().filter(entitiy -> entitiy.getContainFlag().intValue() == CONTAINFLAG.CONTAIN.getCode().intValue()).collect(Collectors.toList());
        List<CompanyInformationAreaEntity> nonContainEntities = entities.stream().filter(entitiy -> entitiy.getContainFlag().intValue() == CONTAINFLAG.NONCONTAIN.getCode().intValue()).collect(Collectors.toList());
        for (CompanyInformationAreaEntity entity : containEntities) {
            entity.setOffsetFlag(OFFSETFLAG.NONOFFSET.code);
            if (!CompanyInformationAreaUtil.judegeFromNonContain(nonContainEntities, entity)) continue;
            entity.setOffsetFlag(OFFSETFLAG.OFFSET.code);
        }
        for (CompanyInformationAreaEntity entity : nonContainEntities) {
            entity.setOffsetFlag(OFFSETFLAG.NONOFFSET.code);
        }
        ArrayList<CompanyInformationAreaEntity> reList = new ArrayList<CompanyInformationAreaEntity>(entities.size());
        reList.addAll(containEntities);
        reList.addAll(nonContainEntities);
        return reList;
    }

    public static boolean judegeFromNonContain(List<CompanyInformationAreaEntity> nonContainEntities, CompanyInformationAreaEntity entity) {
        if (CollectionUtils.isEmpty(nonContainEntities)) {
            return false;
        }
        for (CompanyInformationAreaEntity noEntity : nonContainEntities) {
            if (!StringUtils.isEmpty((Object)noEntity.getOrgCode()) && !StringUtils.isEmpty((Object)entity.getOrgCode()) && noEntity.getOrgCode().equals(entity.getOrgCode())) {
                return true;
            }
            if (StringUtils.isEmpty((Object)noEntity.getCusCode()) || StringUtils.isEmpty((Object)entity.getCusCode()) || !noEntity.getCusCode().equals(entity.getCusCode())) continue;
            return true;
        }
        return false;
    }

    public static Map<String, List<CompanyInformationAreaVo>> distArea(List<CompanyInformationAreaVo> areaVos) {
        HashMap<String, List<CompanyInformationAreaVo>> areaMap = new HashMap<String, List<CompanyInformationAreaVo>>();
        ArrayList blankList = new ArrayList();
        areaMap.put("org", blankList);
        areaMap.put("nonOrg", blankList);
        areaMap.put("customer", blankList);
        areaMap.put("nonCustomer", blankList);
        if (CollectionUtils.isEmpty(areaVos)) {
            return areaMap;
        }
        List org = areaVos.stream().filter(areaVo -> !StringUtils.isEmpty((Object)areaVo.getOrgCode()) && areaVo.getContainFlag().intValue() == CONTAINFLAG.CONTAIN.getCode().intValue()).collect(Collectors.toList());
        List nonOrg = areaVos.stream().filter(areaVo -> !StringUtils.isEmpty((Object)areaVo.getOrgCode()) && areaVo.getContainFlag().intValue() == CONTAINFLAG.NONCONTAIN.getCode().intValue()).collect(Collectors.toList());
        List customer = areaVos.stream().filter(areaVo -> !StringUtils.isEmpty((Object)areaVo.getCusCode()) && areaVo.getContainFlag().intValue() == CONTAINFLAG.CONTAIN.getCode().intValue()).collect(Collectors.toList());
        List nonCustomer = areaVos.stream().filter(areaVo -> !StringUtils.isEmpty((Object)areaVo.getCusCode()) && areaVo.getContainFlag().intValue() == CONTAINFLAG.NONCONTAIN.getCode().intValue()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(org)) {
            areaMap.put("org", org);
        }
        if (!CollectionUtils.isEmpty(nonOrg)) {
            areaMap.put("nonOrg", nonOrg);
        }
        if (!CollectionUtils.isEmpty(customer)) {
            areaMap.put("customer", customer);
        }
        if (!CollectionUtils.isEmpty(nonCustomer)) {
            areaMap.put("nonCustomer", nonCustomer);
        }
        return areaMap;
    }

    public static enum OFFSETFLAG {
        OFFSET(0, "\u62b5\u6d88"),
        NONOFFSET(1, "\u975e\u62b5\u6d88");

        private Integer code;
        private String value;

        private OFFSETFLAG() {
        }

        private OFFSETFLAG(Integer code, String value) {
            this.code = code;
            this.value = value;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum CONTAINFLAG {
        CONTAIN(0, "\u5305\u542b"),
        NONCONTAIN(1, "\u975e\u5305\u542b");

        private Integer code;
        private String value;

        private CONTAINFLAG() {
        }

        private CONTAINFLAG(Integer code, String value) {
            this.code = code;
            this.value = value;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }
    }
}

