/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.notice.ListReq;
import com.biz.crm.nebular.dms.notice.ListRes;
import com.biz.crm.nebular.dms.notice.NoticeVisitedLogVo;
import com.biz.crm.notice.service.NoticeService;
import com.biz.crm.notice.service.NoticeVisitedLogService;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5fae\u4fe1\u7aef-\u516c\u544a", tags={"\u5fae\u4fe1\u7aef-\u516c\u544a"})
@RestController
@RequestMapping(value={"/v/notice"})
public class NoticevController {
    @Resource
    private NoticeService noticeService;
    @Resource
    private NoticeVisitedLogService noticeVisitedLogService;

    @CrmLog
    @CrossOrigin
    @ApiOperation(value="\u5206\u9875\u5c55\u793a\u516c\u544a")
    @PostMapping(value={"list"})
    public Result<PageResult<ListRes>> list(@RequestBody ListReq listReq) {
        UserRedis userRedis = UserUtils.getUser();
        listReq.setCusCode(userRedis.getCustcode());
        listReq.setOrgCode(userRedis.getOrgcode());
        return Result.ok(this.noticeService.listByUser(listReq));
    }

    @CrmLog
    @CrossOrigin
    @ApiOperation(value="\u901a\u8fc7\u516c\u544aid\u67e5\u8be2\u516c\u544a")
    @PostMapping(value={"findById"})
    public Result findById(@RequestParam(value="id") String id) {
        return Result.ok((Object)this.noticeService.findById(id));
    }

    @CrmLog
    @CrossOrigin
    @ApiOperation(value="\u9605\u8bfb\u516c\u544a")
    @PostMapping(value={"readNotice"})
    public Result readNotice(@RequestBody NoticeVisitedLogVo noticeVisitedLogVo) {
        UserRedis userRedis = UserUtils.getUser();
        noticeVisitedLogVo.setCusCode(userRedis.getCustcode());
        noticeVisitedLogVo.setCusName(userRedis.getCustname());
        this.noticeVisitedLogService.readNotice(noticeVisitedLogVo);
        return Result.ok();
    }
}

