/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.ShellResult;
import com.biz.crm.common.param.BaseGroovyShellParam;
import com.biz.crm.nebular.dms.promotion.CalculateRuleShellParam;
import com.biz.crm.nebular.dms.promotion.LimitedRuleShellParam;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRuleVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.component.DefaultRuleResult;
import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.RuleExecutor;
import com.biz.crm.rule.utils.GroovyShellUtil;
import com.biz.crm.util.JsonPropertyUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="defaultRuleExecutor")
public class DefaultRuleExecutor
implements RuleExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultRuleExecutor.class);

    @Override
    public DefaultRuleResult execute(RuleExecuteParam ruleExecuteParam) {
        this.checkParam(ruleExecuteParam);
        PromotionPolicyRuleVo condition = ruleExecuteParam.getCondition();
        PromotionPolicyRuleVo calculate = ruleExecuteParam.getCalculate();
        CalculateRuleShellParam shellParam = new CalculateRuleShellParam();
        Map<String, Object> customerParamsMap = this.customerParams(ruleExecuteParam);
        shellParam.setTestParamMap(customerParamsMap);
        shellParam.setConditionShellBody(condition.getFuncBody());
        shellParam.setConditionShellName(condition.getRuleCode());
        shellParam.setLadderList((List)JsonPropertyUtil.toObject((String)condition.getParams(), List.class));
        shellParam.setShellBody(calculate.getFuncBody());
        shellParam.setShellName(calculate.getRuleCode());
        ShellResult shellResult = GroovyShellUtil.runShell((BaseGroovyShellParam)shellParam);
        DefaultRuleResult defaultRuleResult = null;
        if (shellResult.getState().booleanValue()) {
            defaultRuleResult = (DefaultRuleResult)JsonPropertyUtil.toObject((String)((String)shellResult.getResultData()), DefaultRuleResult.class);
            if (null == defaultRuleResult) {
                String error = "\u4fc3\u9500\u653f\u7b56\u89c4\u5219[" + calculate.getRuleCode() + "]\u89e3\u6790\u8ba1\u7b97\u7ed3\u679c\u5931\u8d25";
                log.error(error + ", getResultData={}", shellResult.getResultData());
                throw new BusinessException(error);
            }
            if (null == (defaultRuleResult = this.calculateRuleExecuted(ruleExecuteParam, defaultRuleResult))) {
                throw new BusinessException("\u8ba1\u7b97\u89c4\u5219\u7ed3\u679c\u6269\u5c55\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002");
            }
        } else {
            throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u89c4\u5219[" + calculate.getRuleCode() + "]\u8ba1\u7b97\u5931\u8d25\uff0c" + shellResult.getErrMsg(), shellResult.getThrowable());
        }
        this.doLimited(ruleExecuteParam, defaultRuleResult, customerParamsMap);
        return defaultRuleResult;
    }

    private void doLimited(RuleExecuteParam ruleExecuteParam, DefaultRuleResult defaultRuleResult, Map<String, Object> customerParamsMap) {
        List<PromotionPolicyRuleVo> limited = ruleExecuteParam.getLimited();
        if (CollectionUtils.isEmpty(limited)) {
            return;
        }
        LimitedRuleShellParam shellParam = new LimitedRuleShellParam();
        shellParam.setTestParamMap(customerParamsMap);
        for (PromotionPolicyRuleVo ruleVo : limited) {
            shellParam.setGift(defaultRuleResult.getResultData());
            PromotionRuleEditVo.KeyValParamControl keyValParamControl = this.limitedKeyValParam(ruleVo.getParams());
            shellParam.setConfigNo(keyValParamControl.getValue());
            shellParam.setShellBody(ruleVo.getFuncBody());
            shellParam.setShellName(ruleVo.getRuleCode());
            ShellResult shellResult = GroovyShellUtil.runShell((BaseGroovyShellParam)shellParam);
            if (shellResult.getState().booleanValue()) {
                defaultRuleResult.setResultData((BigDecimal)shellResult.getResultData());
                continue;
            }
            throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u9650\u91cf\u89c4\u5219[" + ruleVo.getRuleCode() + "]\u8ba1\u7b97\u5931\u8d25\uff0c" + shellResult.getErrMsg(), shellResult.getThrowable());
        }
    }

    private PromotionRuleEditVo.KeyValParamControl limitedKeyValParam(String paramStr) {
        PromotionRuleEditVo.ControlRow controlRow;
        List controlRows;
        if (StringUtils.isNotBlank((CharSequence)paramStr) && !CollectionUtils.isEmpty((Collection)(controlRows = JsonPropertyUtil.toArray((String)paramStr, PromotionRuleEditVo.ControlRow.class))) && null != controlRows.get(0) && !CollectionUtils.isEmpty((Collection)(controlRow = (PromotionRuleEditVo.ControlRow)controlRows.get(0)).getControls())) {
            return (PromotionRuleEditVo.KeyValParamControl)controlRow.getControls().get(0);
        }
        return new PromotionRuleEditVo.KeyValParamControl();
    }

    protected Map<String, Object> customerParams(RuleExecuteParam ruleExecuteParam) {
        return null;
    }

    protected DefaultRuleResult calculateRuleExecuted(RuleExecuteParam ruleExecuteParam, DefaultRuleResult defaultRuleResult) {
        return defaultRuleResult;
    }

    protected void checkParam(RuleExecuteParam ruleExecuteParam) {
        if (null == ruleExecuteParam) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PromotionPolicyRuleVo condition = ruleExecuteParam.getCondition();
        PromotionPolicyRuleVo calculate = ruleExecuteParam.getCalculate();
        if (null == calculate) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u8ba1\u7b97\u89c4\u5219");
        }
        if (StringUtils.isBlank((CharSequence)condition.getRuleCode())) {
            throw new BusinessException("\u8ba1\u7b97\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)condition.getFuncBody())) {
            throw new BusinessException("\u8ba1\u7b97\u89c4\u5219\u811a\u672c\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == condition) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6761\u4ef6\u89c4\u5219");
        }
        if (StringUtils.isBlank((CharSequence)condition.getRuleCode())) {
            throw new BusinessException("\u6761\u4ef6\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)condition.getFuncBody())) {
            throw new BusinessException("\u6761\u4ef6\u89c4\u5219\u811a\u672c\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)condition.getParams())) {
            throw new BusinessException("\u6761\u4ef6\u89c4\u5219\u9636\u68af\u914d\u7f6e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

