/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemVo;
import com.biz.crm.repfeepool.service.RepFeePoolItemService;
import com.biz.crm.util.ValidateUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service(value="repFeePoolItemService")
@ConditionalOnMissingBean(name={"repFeePoolItemServiceImpl"})
public class RepFeePoolItemServiceImpl
implements RepFeePoolItemService {
    @Override
    public Map<String, BigDecimal> findAvailableBalance(RepFeePoolItemVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap result = Maps.newHashMap();
        List<String> pCodes = Arrays.asList(vo.getProductCode().split(","));
        for (int i = 0; i < pCodes.size(); ++i) {
            if (i == 1) {
                result.put(pCodes.get(i), BigDecimal.ZERO);
            }
            result.put(pCodes.get(i), BigDecimal.valueOf(1000L));
        }
        return result;
    }

    @Override
    public PageResult<RepFeePoolItemVo> findPageByConditions(RepFeePoolItemVo vo) {
        List<RepFeePoolItemVo> content = this.getExampleData();
        return PageResult.builder().data(content).count(Long.valueOf(content.size())).build();
    }

    private List<RepFeePoolItemVo> getExampleData() {
        List list;
        String jsonStr = "[{\n\t\"availableCount\": 1000,\n\t\"availableFee\": 3.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 359,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD1\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u90531\",\n\t\t\"cusCode\": \"CUS1\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u62371\",\n\t\t\"cusOrgCode\": \"ORG1\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec71\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce81\",\n\t\t\"saleCompanyCode\": \"SC1\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f81\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1001,\n\t\"availableFee\": 4.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 360,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD2\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u90532\",\n\t\t\"cusCode\": \"CUS2\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u62372\",\n\t\t\"cusOrgCode\": \"ORG2\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec72\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce82\",\n\t\t\"saleCompanyCode\": \"SC2\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f82\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1002,\n\t\"availableFee\": 5.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 361,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD3\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u90533\",\n\t\t\"cusCode\": \"CUS3\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u62373\",\n\t\t\"cusOrgCode\": \"ORG3\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec73\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce83\",\n\t\t\"saleCompanyCode\": \"SC3\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f83\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1003,\n\t\"availableFee\": 6.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 362,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD4\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u90534\",\n\t\t\"cusCode\": \"CUS4\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u62374\",\n\t\t\"cusOrgCode\": \"ORG4\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec74\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce84\",\n\t\t\"saleCompanyCode\": \"SC4\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f84\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1004,\n\t\"availableFee\": 7.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 363,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD5\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u90535\",\n\t\t\"cusCode\": \"CUS5\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u62375\",\n\t\t\"cusOrgCode\": \"ORG5\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec75\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce85\",\n\t\t\"saleCompanyCode\": \"SC5\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f85\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1005,\n\t\"availableFee\": 8.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 364,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD6\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u90536\",\n\t\t\"cusCode\": \"CUS6\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u62376\",\n\t\t\"cusOrgCode\": \"ORG6\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec76\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce86\",\n\t\t\"saleCompanyCode\": \"SC6\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f86\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1006,\n\t\"availableFee\": 9.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 365,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD7\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u90537\",\n\t\t\"cusCode\": \"CUS7\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u62377\",\n\t\t\"cusOrgCode\": \"ORG7\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec77\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce87\",\n\t\t\"saleCompanyCode\": \"SC7\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f87\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1007,\n\t\"availableFee\": 10.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 366,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD8\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u90538\",\n\t\t\"cusCode\": \"CUS8\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u62378\",\n\t\t\"cusOrgCode\": \"ORG8\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec78\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce88\",\n\t\t\"saleCompanyCode\": \"SC8\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f88\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1008,\n\t\"availableFee\": 11.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 367,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD9\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u90539\",\n\t\t\"cusCode\": \"CUS9\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u62379\",\n\t\t\"cusOrgCode\": \"ORG9\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec79\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce89\",\n\t\t\"saleCompanyCode\": \"SC9\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f89\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1009,\n\t\"availableFee\": 12.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 368,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD10\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u905310\",\n\t\t\"cusCode\": \"CUS10\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u623710\",\n\t\t\"cusOrgCode\": \"ORG10\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec710\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce810\",\n\t\t\"saleCompanyCode\": \"SC10\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f810\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1010,\n\t\"availableFee\": 13.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 369,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD11\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u905311\",\n\t\t\"cusCode\": \"CUS11\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u623711\",\n\t\t\"cusOrgCode\": \"ORG11\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec711\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce811\",\n\t\t\"saleCompanyCode\": \"SC11\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f811\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1011,\n\t\"availableFee\": 14.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 370,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD12\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u905312\",\n\t\t\"cusCode\": \"CUS12\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u623712\",\n\t\t\"cusOrgCode\": \"ORG12\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec712\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce812\",\n\t\t\"saleCompanyCode\": \"SC12\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f812\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1012,\n\t\"availableFee\": 15.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 371,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD13\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u905313\",\n\t\t\"cusCode\": \"CUS13\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u623713\",\n\t\t\"cusOrgCode\": \"ORG13\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec713\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce813\",\n\t\t\"saleCompanyCode\": \"SC13\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f813\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1013,\n\t\"availableFee\": 16.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 372,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD14\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u905314\",\n\t\t\"cusCode\": \"CUS14\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u623714\",\n\t\t\"cusOrgCode\": \"ORG14\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec714\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce814\",\n\t\t\"saleCompanyCode\": \"SC14\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f814\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1014,\n\t\"availableFee\": 17.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 373,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD15\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u905315\",\n\t\t\"cusCode\": \"CUS15\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u623715\",\n\t\t\"cusOrgCode\": \"ORG15\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec715\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce815\",\n\t\t\"saleCompanyCode\": \"SC15\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f815\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1015,\n\t\"availableFee\": 18.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 374,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD16\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u905316\",\n\t\t\"cusCode\": \"CUS16\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u623716\",\n\t\t\"cusOrgCode\": \"ORG16\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec716\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce816\",\n\t\t\"saleCompanyCode\": \"SC16\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f816\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1016,\n\t\"availableFee\": 19.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 375,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD17\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u905317\",\n\t\t\"cusCode\": \"CUS17\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u623717\",\n\t\t\"cusOrgCode\": \"ORG17\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec717\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce817\",\n\t\t\"saleCompanyCode\": \"SC17\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f817\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1017,\n\t\"availableFee\": 20.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 376,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD18\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u905318\",\n\t\t\"cusCode\": \"CUS18\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u623718\",\n\t\t\"cusOrgCode\": \"ORG18\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec718\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce818\",\n\t\t\"saleCompanyCode\": \"SC18\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f818\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1018,\n\t\"availableFee\": 21.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 377,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD19\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u905319\",\n\t\t\"cusCode\": \"CUS19\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u623719\",\n\t\t\"cusOrgCode\": \"ORG19\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec719\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce819\",\n\t\t\"saleCompanyCode\": \"SC19\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f819\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}, {\n\t\"availableCount\": 1019,\n\t\"availableFee\": 22.3,\n\t\"code\": \"RPI0028\",\n\t\"costPrice\": 378,\n\t\"ext1\": \"\",\n\t\"ext10\": \"\",\n\t\"ext11\": \"\",\n\t\"ext12\": \"\",\n\t\"ext13\": \"\",\n\t\"ext14\": \"\",\n\t\"ext15\": \"\",\n\t\"ext16\": \"\",\n\t\"ext17\": \"\",\n\t\"ext18\": \"\",\n\t\"ext19\": \"\",\n\t\"ext2\": \"\",\n\t\"ext20\": \"\",\n\t\"ext21\": \"\",\n\t\"ext22\": \"\",\n\t\"ext23\": \"\",\n\t\"ext24\": \"\",\n\t\"ext25\": \"\",\n\t\"ext26\": \"\",\n\t\"ext27\": \"\",\n\t\"ext28\": \"\",\n\t\"ext29\": \"\",\n\t\"ext3\": \"\",\n\t\"ext30\": \"\",\n\t\"ext31\": \"\",\n\t\"ext32\": \"\",\n\t\"ext33\": \"\",\n\t\"ext34\": \"\",\n\t\"ext35\": \"\",\n\t\"ext36\": \"\",\n\t\"ext37\": \"\",\n\t\"ext38\": \"\",\n\t\"ext39\": \"\",\n\t\"ext4\": \"\",\n\t\"ext40\": \"\",\n\t\"ext41\": \"\",\n\t\"ext42\": \"\",\n\t\"ext43\": \"\",\n\t\"ext44\": \"\",\n\t\"ext45\": \"\",\n\t\"ext46\": \"\",\n\t\"ext47\": \"\",\n\t\"ext48\": \"\",\n\t\"ext49\": \"\",\n\t\"ext5\": \"\",\n\t\"ext50\": \"\",\n\t\"ext6\": \"\",\n\t\"ext7\": \"\",\n\t\"ext8\": \"\",\n\t\"ext9\": \"\",\n\t\"frozenCount\": 0,\n\t\"frozenFee\": 0,\n\t\"onAccountCount\": 0,\n\t\"ouAccountFee\": 0,\n\t\"pageNum\": 0,\n\t\"pageSize\": 25,\n\t\"payType\": 1,\n\t\"productSize\": 1,\n\t\"redTrickCount\": 0,\n\t\"repFeePoolVo\": {\n\t\t\"code\": \"RP002\",\n\t\t\"cusChannelCode\": \"QD20\",\n\t\t\"cusChannelName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6e20\u905320\",\n\t\t\"cusCode\": \"CUS20\",\n\t\t\"cusName\": \"\u6d4b\u8bd5\u5ba2\u623720\",\n\t\t\"cusOrgCode\": \"ORG20\",\n\t\t\"cusOrgName\": \"\u6d4b\u8bd5\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec720\",\n\t\t\"ext1\": \"\",\n\t\t\"ext10\": \"\",\n\t\t\"ext11\": \"\",\n\t\t\"ext12\": \"\",\n\t\t\"ext13\": \"\",\n\t\t\"ext14\": \"\",\n\t\t\"ext15\": \"\",\n\t\t\"ext16\": \"\",\n\t\t\"ext17\": \"\",\n\t\t\"ext18\": \"\",\n\t\t\"ext19\": \"\",\n\t\t\"ext2\": \"\",\n\t\t\"ext20\": \"\",\n\t\t\"ext21\": \"\",\n\t\t\"ext22\": \"\",\n\t\t\"ext23\": \"\",\n\t\t\"ext24\": \"\",\n\t\t\"ext25\": \"\",\n\t\t\"ext26\": \"\",\n\t\t\"ext27\": \"\",\n\t\t\"ext28\": \"\",\n\t\t\"ext29\": \"\",\n\t\t\"ext3\": \"\",\n\t\t\"ext30\": \"\",\n\t\t\"ext31\": \"\",\n\t\t\"ext32\": \"\",\n\t\t\"ext33\": \"\",\n\t\t\"ext34\": \"\",\n\t\t\"ext35\": \"\",\n\t\t\"ext36\": \"\",\n\t\t\"ext37\": \"\",\n\t\t\"ext38\": \"\",\n\t\t\"ext39\": \"\",\n\t\t\"ext4\": \"\",\n\t\t\"ext40\": \"\",\n\t\t\"ext41\": \"\",\n\t\t\"ext42\": \"\",\n\t\t\"ext43\": \"\",\n\t\t\"ext44\": \"\",\n\t\t\"ext45\": \"\",\n\t\t\"ext46\": \"\",\n\t\t\"ext47\": \"\",\n\t\t\"ext48\": \"\",\n\t\t\"ext49\": \"\",\n\t\t\"ext5\": \"\",\n\t\t\"ext50\": \"\",\n\t\t\"ext6\": \"\",\n\t\t\"ext7\": \"\",\n\t\t\"ext8\": \"\",\n\t\t\"ext9\": \"\",\n\t\t\"pageNum\": 0,\n\t\t\"pageSize\": 25,\n\t\t\"remarks\": \"\u5907\u6ce820\",\n\t\t\"saleCompanyCode\": \"SC20\",\n\t\t\"saleCompanyName\": \"\u6d4b\u8bd5\u9500\u552e\u516c\u53f820\",\n\t\t\"totalCount\": 0,\n\t\t\"totalFee\": 0,\n\t\t\"uniqueDictCode\": \"DIC_REBATE\"\n\t},\n\t\"salePrice\": 0,\n\t\"subtractCount\": 0,\n\t\"unit\": \"\u74f6\",\n\t\"usedCount\": 0,\n\t\"usedFee\": 0\n}]";
        ObjectMapper mapper = new ObjectMapper();
        try {
            list = (List)mapper.readValue(jsonStr, (TypeReference)new TypeReference<List<RepFeePoolItemVo>>(){});
        }
        catch (IOException e) {
            e.printStackTrace();
            list = Lists.newArrayList();
        }
        return list;
    }
}

