/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component.function;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.promotion.service.component.function.param.RuleParam;
import com.biz.crm.promotion.service.component.function.response.CalculateRuleResponse;
import com.biz.crm.promotion.service.component.function.response.ConditionRuleResponse;
import com.biz.crm.util.JsonPropertyUtil;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;

@Component(value="jiSuanManZeng")
public class JiSuanManZeng
implements RuleFunction<CalculateRuleParam, CalculateRuleResponse> {
    @Override
    public CalculateRuleResponse apply(CalculateRuleParam calculateRuleParam) {
        RuleFunction ruleFunction;
        try {
            ruleFunction = (RuleFunction)SpringApplicationContextUtil.getApplicationContext().getBean(calculateRuleParam.getConditionRuleFunctionBeanName(), RuleFunction.class);
        }
        catch (BeansException e) {
            throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u6761\u4ef6\u89c4\u5219[" + calculateRuleParam.getConditionRuleFunctionBeanName() + "]\u8ba1\u7b97\u5931\u8d25, \u672a\u67e5\u627e\u5230\u8be5\u89c4\u5219\u7684\u8ba1\u7b97\u5b9e\u4f8b", (Throwable)e);
        }
        String resultDataType = null;
        String resultDataUnitType = null;
        BigDecimal result = BigDecimal.ZERO;
        List<PromotionRuleEditVo.ControlRow> ladderList = calculateRuleParam.getLadderList();
        for (int i = ladderList.size() - 1; i >= 0; --i) {
            PromotionRuleEditVo.ControlRow tempLadder = ladderList.get(i);
            ConditionRuleParam conditionRuleParam = new ConditionRuleParam();
            conditionRuleParam.setLadder(tempLadder);
            conditionRuleParam.setProductOrderBuy(calculateRuleParam.getProductOrderBuy());
            ConditionRuleResponse conditionRuleResponse = (ConditionRuleResponse)ruleFunction.apply(conditionRuleParam);
            if (i == ladderList.size() - 1) {
                resultDataType = conditionRuleResponse.getResultDataType();
                resultDataUnitType = conditionRuleResponse.getResultDataUnitType();
            }
            if (conditionRuleResponse.getDivide().compareTo(BigDecimal.ZERO) <= 0) continue;
            Object giftVavle = ((PromotionRuleEditVo.KeyValParamControl)tempLadder.getControls().get(2)).getValue();
            if (null == giftVavle || StringUtils.isBlank((CharSequence)giftVavle.toString())) {
                throw new BusinessException("\u653f\u7b56\u9636\u68af\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u914d\u7f6e\u9636\u68af\u8d60\u9001\u6570\u91cf");
            }
            result = new BigDecimal(giftVavle.toString());
            break;
        }
        CalculateRuleResponse calculateRuleResponse = new CalculateRuleResponse();
        calculateRuleResponse.setResultData(result);
        calculateRuleResponse.setResultDataType(resultDataType);
        calculateRuleResponse.setResultDataUnitType(resultDataUnitType);
        return calculateRuleResponse;
    }

    @Override
    public CalculateRuleResponse test(RuleParam ruleParam) {
        PromotionRuleEditVo.TestParam testParam = (PromotionRuleEditVo.TestParam)JsonPropertyUtil.toObject((String)ruleParam.getTestJsonParams(), PromotionRuleEditVo.TestParam.class);
        CalculateRuleParam calculateRuleParam = new CalculateRuleParam();
        String productOrderBuyStr = JsonPropertyUtil.toJsonString(testParam.getBizParam().get("productOrderBuy"));
        List productOrderBuy = JsonPropertyUtil.toArray((String)productOrderBuyStr, RuleExecuteParam.ProductOrderBuy.class);
        calculateRuleParam.setProductOrderBuy(productOrderBuy);
        String ladderListStr = JsonPropertyUtil.toJsonString(testParam.getBizParam().get("ladderList"));
        List ladderList = JsonPropertyUtil.toArray((String)ladderListStr, PromotionRuleEditVo.ControlRow.class);
        calculateRuleParam.setLadderList(ladderList);
        calculateRuleParam.setConditionRuleFunctionBeanName(testParam.getBizParam().get("conditionRuleFunctionBeanName").toString());
        calculateRuleParam.setRuleCode(ruleParam.getRuleCode());
        return this.apply(calculateRuleParam);
    }
}

