/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebatefeepool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolDetailLogVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolDetailVo;
import com.biz.crm.rebatefeepool.entity.RebateFeePoolDetailLogEntity;
import com.biz.crm.rebatefeepool.mapper.RebateFeePoolDetailLogMapper;
import com.biz.crm.rebatefeepool.service.RebateFeePoolDetailLogService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolDetailService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolFileService;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolDetailLogUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rebateFeePoolDetailLogService")
@ConditionalOnMissingBean(name={"rebateFeePoolDetailLogServiceImpl"})
public class RebateFeePoolDetailLogServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateFeePoolDetailLogMapper, RebateFeePoolDetailLogEntity>
implements RebateFeePoolDetailLogService {
    @Resource
    private RebateFeePoolDetailLogMapper rebateFeePoolDetailLogMapper;
    @Resource
    private RebateFeePoolFileService rebateFeePoolFileService;
    @Resource
    private RebateFeePoolDetailService rebateFeePoolDetailService;

    @Override
    @Transactional
    public void create(RebateFeePoolDetailLogVo rebateFeePoolDetailLogVo) {
        RebateFeePoolDetailLogUtil.validate(rebateFeePoolDetailLogVo);
        FieldHandleUtil.initCreateFields(rebateFeePoolDetailLogVo);
        rebateFeePoolDetailLogVo.setCode(CodeUtil.getCode());
        RebateFeePoolDetailLogEntity rebateFeePoolDetailLogEntity = new RebateFeePoolDetailLogEntity();
        BeanUtils.copyProperties((Object)rebateFeePoolDetailLogVo, (Object)((Object)rebateFeePoolDetailLogEntity));
        this.rebateFeePoolDetailLogMapper.insert((Object)rebateFeePoolDetailLogEntity);
        List files = rebateFeePoolDetailLogVo.getFiles();
        if (!CollectionUtils.isEmpty((Collection)files)) {
            this.rebateFeePoolFileService.createAll(files);
        }
    }

    @Override
    public PageResult<RebateFeePoolDetailLogVo> findPageByConditions(RebateFeePoolDetailLogVo param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        String rebateFeePoolDetailCode = param.getRebateFeePoolDetailCode();
        RebateFeePoolDetailVo rebateFeePoolDetailVo = this.rebateFeePoolDetailService.findByDetailCode(rebateFeePoolDetailCode);
        ValidateUtils.validate((Object)rebateFeePoolDetailVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6298\u6263\u8d39\u7528\u6c60\u6761\u76ee\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u771f\u786e\u4f20\u5165\u6298\u6263\u8d39\u7528\u6c60\u6761\u76ee\u7f16\u7801");
        Integer adjustType = param.getAdjustType();
        List<RebateFeePoolDetailLogVo> list = this.rebateFeePoolDetailLogMapper.findPageByConditions((Page<RebateFeePoolDetailLogVo>)page, rebateFeePoolDetailCode, adjustType);
        if (CollectionUtils.isEmpty(list)) {
            return PageResult.builder().build();
        }
        list.forEach(l -> l.setRebateFeePoolDetailVo(rebateFeePoolDetailVo));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

