/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebatefeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.rebatefeepool.FeePoolFindAccountReportRes;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolDetailVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolVo;
import com.biz.crm.rebatefeepool.entity.RebateFeePoolEntity;
import com.biz.crm.rebatefeepool.mapper.RebateFeePoolMapper;
import com.biz.crm.rebatefeepool.service.RebateFeePoolDetailService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolService;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rebateFeePoolService")
@ConditionalOnMissingBean(name={"rebateFeePoolServiceImpl"})
public class RebateFeePoolServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateFeePoolMapper, RebateFeePoolEntity>
implements RebateFeePoolService {
    @Resource
    private RebateFeePoolMapper rebateFeePoolMapper;
    @Resource
    private RebateFeePoolDetailService rebateFeePoolDetailService;

    @Override
    public List<RebateFeePoolEntity> selectList(QueryWrapper<RebateFeePoolEntity> wrapper) {
        return this.rebateFeePoolMapper.selectList((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void onAccount(RebateFeePoolVo vo) {
    }

    @Override
    @Transactional
    public void adjust(RebateFeePoolVo vo) {
        RebateFeePoolUtil.validate(vo);
        ValidateUtils.validate((Object)vo.getId(), (String)"\u7f16\u8f91\u6298\u6263\u8d39\u7528\u6c60\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a");
        RebateFeePoolEntity rebateFeePoolEntity = (RebateFeePoolEntity)((Object)this.rebateFeePoolMapper.selectById((Serializable)((Object)vo.getId())));
        ValidateUtils.validate((Object)((Object)rebateFeePoolEntity), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6298\u6263\u8d39\u7528\u6c60\u539f\u59cb\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4id\u662f\u5426\u6b63\u786e");
        List rebateFeePoolDetailVos = vo.getRebateFeePoolDetailVos();
        ValidateUtils.notEmpty((Collection)rebateFeePoolDetailVos, (String)"\u7f16\u7801\u6298\u6263\u8d39\u7528\u6c60\u65f6\uff0c\u6298\u6263\u8d39\u7528\u6c60\u6761\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal frozen = BigDecimal.ZERO;
        BigDecimal used = BigDecimal.ZERO;
        BigDecimal balance = BigDecimal.ZERO;
        for (RebateFeePoolDetailVo v : rebateFeePoolDetailVos) {
            total = total.add(v.getItemTotalFee());
            frozen = frozen.add(v.getItemFrozenFee());
            used = used.add(v.getItemUsedFee());
            balance = balance.add(v.getItemAvailableBalance());
            this.rebateFeePoolDetailService.saveDetail(v);
        }
        rebateFeePoolEntity.setTotalFee(total);
        rebateFeePoolEntity.setBalance(balance);
        rebateFeePoolEntity.setFrozenFee(frozen);
        rebateFeePoolEntity.setUsedFee(used);
        this.rebateFeePoolMapper.updateById((Object)rebateFeePoolEntity);
    }

    @Override
    public BigDecimal findAvailableBalance(RebateFeePoolVo vo) {
        return BigDecimal.valueOf(10000L);
    }

    @Override
    public boolean subtractBalance(RebateFeePoolVo vo) {
        return true;
    }

    @Override
    public BigDecimal subtractBalanceFree(RebateFeePoolVo vo) {
        return BigDecimal.ZERO;
    }

    @Override
    public boolean redTrick(RebateFeePoolVo vo) {
        return false;
    }

    @Override
    public PageResult<RebateFeePoolVo> findPageByConditions(RebateFeePoolVo param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        List<RebateFeePoolVo> list = this.rebateFeePoolMapper.findPageByConditions((Page<RebateFeePoolVo>)page, param.getCusOrgName(), param.getCusName(), param.getCusChannelName());
        if (CollectionUtil.listEmpty(list)) {
            return PageResult.builder().count(Long.valueOf(page.getTotal())).build();
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public RebateFeePoolVo findByCode(String rebateFeePoolCode) {
        if (StringUtils.isEmpty((String)rebateFeePoolCode)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"code", (Object)rebateFeePoolCode);
        RebateFeePoolEntity entity = (RebateFeePoolEntity)((Object)this.rebateFeePoolMapper.selectOne((Wrapper)wrapper));
        if (entity == null) {
            return null;
        }
        RebateFeePoolVo vo = new RebateFeePoolVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        return vo;
    }

    @Override
    public FeePoolFindAccountReportRes findAccountReport(String yearMonth) {
        ValidateUtils.validate((Object)yearMonth, (String)"\u4f20\u5165\u53c2\u6570\u2018\u5e74\u6708\u2019\u4e0d\u80fd\u4e3a\u7a7a");
        return null;
    }

    private static /* synthetic */ void lambda$onAccount$48(QueryWrapper queryWrapper, String k, Object v) {
        QueryWrapper cfr_ignored_0 = (QueryWrapper)queryWrapper.eq((Object)FieldHandleUtil.FieldHumpToLine(k), v);
    }
}

