/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldHandleUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldHandleUtil.class);

    public static void initCreateFields(Object vo) {
        if (vo == null || !(vo instanceof CrmBaseVo)) {
            return;
        }
        try {
            Class<?> c = vo.getClass();
            String[] timeStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()).split(" ");
            UserRedis user = UserUtils.getUser();
            if (user == null) {
                return;
            }
            HashMap attributes = Maps.newHashMap();
            attributes.put("delFlag", "1");
            attributes.put("enableStatus", "1");
            attributes.put("createDate", timeStr[0]);
            attributes.put("createDateSecond", timeStr[1]);
            attributes.put("createCode", user.getCustcode());
            attributes.put("createName", user.getCustname());
            attributes.put("createOrgCode", user.getOrgcode());
            attributes.put("createOrgName", user.getOrgname());
            attributes.put("createPosCode", user.getPoscode());
            attributes.put("createPosName", user.getPosname());
            for (Map.Entry entry : attributes.entrySet()) {
                Field field = c.getDeclaredField((String)entry.getKey());
                field.setAccessible(true);
                field.set(vo, entry.getValue());
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u5904\u7406\u516c\u5171\u5b57\u6bb5\u5931\u8d25", (Throwable)e);
        }
    }

    public static void initUpdateFields(Object vo) {
        if (vo == null || !(vo instanceof CrmBaseVo)) {
            return;
        }
        try {
            Class<?> c = vo.getClass();
            String[] timeStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()).split(" ");
            UserRedis user = UserUtils.getUser();
            if (user == null) {
                return;
            }
            HashMap attributes = Maps.newHashMap();
            attributes.put("updateDate", timeStr[0]);
            attributes.put("updateDateSecond", timeStr[1]);
            attributes.put("updateCode", user.getCustcode());
            attributes.put("updateName", user.getCustname());
            attributes.put("updateOrgCode", user.getOrgcode());
            attributes.put("updateOrgName", user.getOrgname());
            attributes.put("updatePosCode", user.getPoscode());
            attributes.put("updatePosName", user.getPosname());
            for (Map.Entry entry : attributes.entrySet()) {
                Field field = c.getDeclaredField((String)entry.getKey());
                field.setAccessible(true);
                field.set(vo, entry.getValue());
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u5904\u7406\u516c\u5171\u5b57\u6bb5\u5931\u8d25", (Throwable)e);
        }
    }

    public static Map<String, Object> fieldsValue(Object o, String ... fieldNames) {
        HashMap result = Maps.newHashMap();
        try {
            Class<?> c = o.getClass();
            for (String fieldName : fieldNames) {
                Field field = c.getDeclaredField(fieldName);
                field.setAccessible(true);
                result.put(fieldName, field.get(o));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Maps.newHashMap();
        }
        return result;
    }

    public static String FieldHumpToLine(String sourceName) {
        Pattern humpPattern = Pattern.compile("[A-Z]");
        Matcher matcher = humpPattern.matcher(sourceName);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String FieldLineToHump(String sourceName) {
        Pattern linePattern = Pattern.compile("_(\\w)");
        Matcher matcher = linePattern.matcher(sourceName.toLowerCase());
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

