/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolFileVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailLogVo;
import com.biz.crm.repfeepool.entity.RepFeePoolItemDetailLogEntity;
import com.biz.crm.repfeepool.mapper.RepFeePoolItemDetailLogMapper;
import com.biz.crm.repfeepool.service.RepFeePoolFileService;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailLogService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service(value="repFeePoolItemDetailLogService")
@ConditionalOnMissingBean(name={"repFeePoolItemDetailLogServiceImpl"})
public class RepFeePoolIItemDetailLogServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RepFeePoolItemDetailLogMapper, RepFeePoolItemDetailLogEntity>
implements RepFeePoolIItemDetailLogService {
    @Resource
    private RepFeePoolItemDetailLogMapper repFeePoolItemDetailLogMapper;
    @Resource
    private RepFeePoolFileService repFeePoolFileService;

    @Override
    public void create(RepFeePoolItemDetailLogVo logVo) {
        ValidateUtils.validate((Object)logVo, (String)"\u65b0\u589e\u5355\u6761\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65e5\u5fd7\u8bb0\u5f55\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.isTrue((logVo.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u5355\u6761\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65e5\u5fd7\u8bb0\u5f55\u65f6\uff0cid\u4e0d\u80fd\u6709\u503c");
        ValidateUtils.validate((Object)logVo.getRepFeePoolItemDetailCode(), (String)"\u65b0\u589e\u5355\u6761\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65e5\u5fd7\u8bb0\u5f55\u65f6\uff0c\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        logVo.setCode(CodeUtil.getCode());
        RepFeePoolItemDetailLogEntity entity = new RepFeePoolItemDetailLogEntity();
        BeanUtils.copyProperties((Object)logVo, (Object)((Object)entity));
        this.repFeePoolItemDetailLogMapper.insert((Object)entity);
        List files = logVo.getFiles();
        if (!CollectionUtil.listEmpty((List)files)) {
            this.repFeePoolFileService.createAll(files);
        }
    }

    @Override
    public PageResult<RepFeePoolItemDetailLogVo> findPageByConditions(RepFeePoolItemDetailLogVo param) {
        Page page;
        List<RepFeePoolItemDetailLogVo> list;
        if (param == null) {
            param = new RepFeePoolItemDetailLogVo();
        }
        if (CollectionUtil.listEmpty(list = this.repFeePoolItemDetailLogMapper.findPageByConditions((Page<RepFeePoolItemDetailLogVo>)(page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue())), param.getRepFeePoolItemDetailCode(), param.getAdjustCountType()))) {
            return PageResult.builder().build();
        }
        list.forEach(li -> {
            List<RepFeePoolFileVo> files = this.repFeePoolFileService.findByLogCode(li.getCode());
            li.setFiles(files);
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

