/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebatefeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolDetailLogVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolDetailVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolVo;
import com.biz.crm.rebatefeepool.entity.RebateFeePoolDetailEntity;
import com.biz.crm.rebatefeepool.mapper.RebateFeePoolDetailMapper;
import com.biz.crm.rebatefeepool.service.RebateFeePoolDetailLogService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolDetailService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolService;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolDetailUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rebateFeePoolDetailService")
@ConditionalOnMissingBean(name={"rebateFeePoolDetailServiceImpl"})
public class RebateFeePoolDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateFeePoolDetailMapper, RebateFeePoolDetailEntity>
implements RebateFeePoolDetailService {
    @Resource
    private RebateFeePoolDetailMapper rebateFeePoolDetailMapper;
    @Resource
    private RebateFeePoolDetailLogService rebateFeePoolDetailLogService;
    @Resource
    private RebateFeePoolService rebateFeePoolService;

    @Override
    @Transactional
    public void create(RebateFeePoolDetailVo vo) {
        RebateFeePoolDetailUtil.validate(vo);
        FieldHandleUtil.initCreateFields(vo);
        vo.setCode(CodeUtil.getCode());
        FieldHandleUtil.initCreateFields(vo);
        RebateFeePoolDetailEntity rebateFeePoolDetailEntity = new RebateFeePoolDetailEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)rebateFeePoolDetailEntity));
        this.rebateFeePoolDetailMapper.insert((Object)rebateFeePoolDetailEntity);
        RebateFeePoolDetailLogVo rebateFeePoolDetailLogVo = new RebateFeePoolDetailLogVo();
        rebateFeePoolDetailLogVo.setRebateFeePoolDetailCode(vo.getCode());
        rebateFeePoolDetailLogVo.setAdjustFee(vo.getItemTotalFee());
        rebateFeePoolDetailLogVo.setAdjustType(vo.getAdjustType());
        rebateFeePoolDetailLogVo.setPayType(vo.getPayType());
        rebateFeePoolDetailLogVo.setFiles(vo.getFiles());
        rebateFeePoolDetailLogVo.setResourceCode(vo.getResourceCode());
        rebateFeePoolDetailLogVo.setRemarks(vo.getRemarks());
        this.rebateFeePoolDetailLogService.create(rebateFeePoolDetailLogVo);
    }

    @Override
    @Transactional
    public void update(RebateFeePoolDetailVo vo) {
        RebateFeePoolDetailUtil.validate(vo);
        ValidateUtils.isTrue((vo.getId() != null ? 1 : 0) != 0, (String)"\u4fee\u6539\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0cid\u5fc5\u987b\u4f20\u9012", (String[])new String[0]);
        RebateFeePoolDetailEntity entity = (RebateFeePoolDetailEntity)((Object)this.rebateFeePoolDetailMapper.selectById((Serializable)((Object)vo.getId())));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u4fee\u6539\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u786e\u8ba4id\u662f\u5426\u4f20\u9012\u6b63\u786e");
        if (Objects.equals(vo.getItemFrozenFee().setScale(6, 0), entity.getItemFrozenFee().setScale(6, 0)) && Objects.equals(vo.getItemAvailableBalance().setScale(6, 0), entity.getItemAvailableBalance().setScale(6, 0)) && Objects.equals(vo.getItemTotalFee().setScale(6, 0), entity.getItemTotalFee().setScale(6, 0)) && Objects.equals(vo.getItemUsedFee().setScale(6, 0), entity.getItemUsedFee().setScale(6, 0))) {
            return;
        }
        FieldHandleUtil.initUpdateFields(vo);
        RebateFeePoolDetailEntity rebateFeePoolDetailEntity = new RebateFeePoolDetailEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)rebateFeePoolDetailEntity));
        this.rebateFeePoolDetailMapper.updateById((Object)rebateFeePoolDetailEntity);
        RebateFeePoolDetailLogVo rebateFeePoolDetailLogVo = new RebateFeePoolDetailLogVo();
        rebateFeePoolDetailLogVo.setRebateFeePoolDetailCode(vo.getCode());
        rebateFeePoolDetailLogVo.setAdjustFee(vo.getAdjustFee());
        rebateFeePoolDetailLogVo.setAdjustType(vo.getAdjustType());
        rebateFeePoolDetailLogVo.setFrozenFee(vo.getAdjustFrozenFee());
        rebateFeePoolDetailLogVo.setPayType(vo.getPayType());
        rebateFeePoolDetailLogVo.setFiles(vo.getFiles());
        rebateFeePoolDetailLogVo.setResourceCode(vo.getResourceCode());
        rebateFeePoolDetailLogVo.setRemarks(vo.getRemarks());
        this.rebateFeePoolDetailLogService.create(rebateFeePoolDetailLogVo);
    }

    @Override
    public PageResult<RebateFeePoolDetailVo> findPageByConditions(RebateFeePoolDetailVo param) {
        RebateFeePoolVo rebateFeePoolVo = this.rebateFeePoolService.findPoolByCode(param.getRebateFeePoolCode());
        ValidateUtils.validate((Object)rebateFeePoolVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6298\u6263\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u6298\u6263\u8d39\u7528\u6c60\u7f16\u7801\u662f\u5426\u4f20\u9012\u6b63\u786e");
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        List<RebateFeePoolDetailVo> list = this.rebateFeePoolDetailMapper.findPageByConditions((Page<RebateFeePoolDetailVo>)page, param.getRebateFeePoolCode());
        if (CollectionUtil.listEmpty(list)) {
            return PageResult.builder().build();
        }
        list.forEach(l -> l.setRebateFeePoolVo(rebateFeePoolVo));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public RebateFeePoolDetailVo findByDetailCode(String rebateFeePoolDetailCode) {
        if (StringUtils.isEmpty((String)rebateFeePoolDetailCode)) {
            return null;
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"code", (Object)rebateFeePoolDetailCode);
        RebateFeePoolDetailEntity entity = (RebateFeePoolDetailEntity)((Object)this.rebateFeePoolDetailMapper.selectOne((Wrapper)wrapper));
        if (entity == null) {
            return null;
        }
        RebateFeePoolDetailVo vo = new RebateFeePoolDetailVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        return vo;
    }

    @Override
    public List<RebateFeePoolDetailVo> findByPoolCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"rebate_fee_pool_code", (Object)code);
        wrapper.orderByDesc((Object)"create_date");
        List entities = this.rebateFeePoolDetailMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        ArrayList vos = Lists.newArrayList();
        entities.forEach(e -> {
            RebateFeePoolDetailVo vo = new RebateFeePoolDetailVo();
            BeanUtils.copyProperties((Object)e, (Object)vo);
            vos.add(vo);
        });
        return vos;
    }

    @Override
    @Transactional
    public void saveDetail(RebateFeePoolDetailVo v) {
        ValidateUtils.validate((Object)v, (String)"\u65b0\u589e\u8d39\u7528\u6298\u6263\u6c60\u6761\u76ee\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((String)v.getId())) {
            this.create(v);
        } else {
            this.update(v);
        }
    }
}

