/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolVo;
import com.biz.crm.repfeepool.entity.RepFeePoolEntity;
import com.biz.crm.repfeepool.mapper.RepFeePoolMapper;
import com.biz.crm.repfeepool.service.RepFeePoolItemService;
import com.biz.crm.repfeepool.service.RepFeePoolService;
import com.biz.crm.repfeepool.utils.RepFeePoolUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="repFeePoolService")
@ConditionalOnMissingBean(name={"repFeePoolServiceImpl"})
public class RepFeePoolServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RepFeePoolMapper, RepFeePoolEntity>
implements RepFeePoolService {
    @Resource
    private RepFeePoolMapper repFeePoolMapper;
    @Resource
    private RepFeePoolItemService repFeePoolItemService;

    @Override
    public Map<String, Boolean> subtractBalance(RepFeePoolVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List items = vo.getRepFeePoolItemVos();
        ValidateUtils.notEmpty((Collection)items, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap result = Maps.newHashMap();
        for (int i = 0; i < items.size(); ++i) {
            if (i == 1 || i == 3) {
                result.put(((RepFeePoolItemVo)items.get(i)).getProductCode(), false);
                continue;
            }
            result.put(((RepFeePoolItemVo)items.get(i)).getProductCode(), true);
        }
        return result;
    }

    @Override
    public Map<String, BigDecimal> subtractBalanceFree(RepFeePoolVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List items = vo.getRepFeePoolItemVos();
        ValidateUtils.notEmpty((Collection)items, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap result = Maps.newHashMap();
        for (int i = 0; i < items.size(); ++i) {
            if (i != 1) continue;
            result.put(((RepFeePoolItemVo)items.get(i)).getProductCode(), BigDecimal.valueOf(200L));
        }
        return result;
    }

    @Override
    public boolean redTrick(RepFeePoolVo vo) {
        return false;
    }

    @Override
    public void create(RepFeePoolVo vo) {
    }

    @Override
    @Transactional
    public void onAccount(RepFeePoolVo vo) {
        RepFeePoolEntity entity;
        RepFeePoolUtil.validate(vo);
        ValidateUtils.notEmpty((Collection)vo.getRepFeePoolItemVos(), (String)"\u4e0a\u8d26\u65f6\uff0c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        String uniqueDictCode = vo.getUniqueDictCode();
        Map uniqueDictValues = DictUtil.dictMap((String)uniqueDictCode);
        ValidateUtils.notEmpty((Map)uniqueDictValues, (String)"\u4e0a\u8d26\u65f6\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u552f\u4e00\u7ea6\u675f\u5b57\u5178");
        String[] dictValueArray = new String[uniqueDictValues.size()];
        ArrayList dicValueList = Lists.newArrayList(uniqueDictValues.values());
        for (int i = 0; i < uniqueDictValues.size(); ++i) {
            dictValueArray[i] = (String)dicValueList.get(i);
        }
        Map<String, Object> fieldsValue = FieldHandleUtil.fieldsValue(vo, dictValueArray);
        QueryWrapper wrapper = Wrappers.query();
        fieldsValue.forEach((k, v) -> wrapper.eq((Object)FieldHandleUtil.FieldHumpToLine(k), v));
        List entities = this.repFeePoolMapper.selectList((Wrapper)wrapper);
        BigDecimal totalFee = BigDecimal.ZERO;
        BigDecimal totalCount = BigDecimal.ZERO;
        for (RepFeePoolItemVo item : vo.getRepFeePoolItemVos()) {
            item.setCode(vo.getCode());
            totalFee = totalFee.add(item.getOnAccountFee());
            totalCount = totalCount.add(item.getOnAccountCount());
        }
        if (CollectionUtil.listEmpty((List)entities)) {
            entity = new RepFeePoolEntity();
            FieldHandleUtil.initCreateFields(vo);
            BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
            entity.setCode(CodeUtil.getCode());
            entity.setTotalCount(totalCount);
            entity.setTotalFee(totalFee);
            this.repFeePoolMapper.insert((Object)entity);
        } else {
            ValidateUtils.isTrue((entities.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636e\u552f\u4e00\u7ea6\u675f\u5b57\u6bb5\u67e5\u51fa\u591a\u6761\u8d27\u8865\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u662f\u5426\u8bbe\u7f6e\u6b63\u786e", (String[])new String[0]);
            entity = (RepFeePoolEntity)((Object)entities.get(0));
            FieldHandleUtil.initUpdateFields((Object)entity);
            entity.setTotalCount(totalCount);
            entity.setTotalFee(totalFee);
            this.repFeePoolMapper.updateById((Object)entity);
        }
        vo.getRepFeePoolItemVos().forEach(v -> v.setRepFeePoolCode(entity.getCode()));
        this.repFeePoolItemService.createAll(vo.getRepFeePoolItemVos());
    }

    @Override
    @Transactional
    public void summaryItems(String repFeePoolCode) {
        ValidateUtils.validate((Object)repFeePoolCode, (String)"\u6c47\u603b\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u8d27\u8865\u8d39\u7528\u6c60\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        QueryWrapper wrapper = Wrappers.query();
        RepFeePoolEntity entity = (RepFeePoolEntity)((Object)this.repFeePoolMapper.selectOne((Wrapper)wrapper));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u6c47\u603b\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u8d27\u8865\u8d39\u7528\u6c60\u539f\u59cb\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4f20\u5165\u6b63\u786e\u7684\u8d27\u8865\u8d39\u7528\u6c60\u7f16\u7801");
        wrapper.eq((Object)"code", (Object)repFeePoolCode);
        List<RepFeePoolItemVo> items = this.repFeePoolItemService.findByCode(repFeePoolCode);
        if (CollectionUtil.listEmpty(items)) {
            return;
        }
        BigDecimal totalCount = BigDecimal.ZERO;
        BigDecimal totalFee = BigDecimal.ZERO;
        for (RepFeePoolItemVo item : items) {
            totalCount = totalCount.add(item.getOnAccountCount());
            totalFee = totalFee.add(item.getOnAccountFee());
        }
        entity.setTotalFee(totalFee);
        entity.setTotalCount(totalCount);
        this.repFeePoolMapper.updateById((Object)entity);
    }

    @Override
    public PageResult<RepFeePoolVo> findPageByConditions(RepFeePoolVo param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        List<RepFeePoolVo> list = this.repFeePoolMapper.findPageByConditions((Page<RepFeePoolVo>)page, param.getCusName(), param.getCusOrgName(), param.getCusChannelName());
        if (CollectionUtil.listEmpty(list)) {
            return PageResult.builder().build();
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

