/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebatefeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.feepool.FeePoolDetailLogVo;
import com.biz.crm.nebular.dms.rebatefeepool.FeePoolFindAccountReportRes;
import com.biz.crm.nebular.dms.rebatefeepool.FeePoolSumReportRes;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolDetailVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolVo;
import com.biz.crm.rebatefeepool.entity.RebateFeePoolEntity;
import com.biz.crm.rebatefeepool.mapper.RebateFeePoolDetailLogMapper;
import com.biz.crm.rebatefeepool.mapper.RebateFeePoolMapper;
import com.biz.crm.rebatefeepool.service.RebateFeePoolDetailService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolService;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolDetailLogUtil;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rebateFeePoolService")
@ConditionalOnMissingBean(name={"rebateFeePoolServiceImpl"})
public class RebateFeePoolServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateFeePoolMapper, RebateFeePoolEntity>
implements RebateFeePoolService {
    @Resource
    private RebateFeePoolMapper rebateFeePoolMapper;
    @Resource
    private RebateFeePoolDetailService rebateFeePoolDetailService;
    @Resource
    private RebateFeePoolDetailLogMapper rebateFeePoolDetailLogMapper;

    @Override
    public List<RebateFeePoolEntity> selectPoolList(QueryWrapper<RebateFeePoolEntity> wrapper) {
        return this.rebateFeePoolMapper.selectList((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void onAccount(RebateFeePoolVo vo) {
        RebateFeePoolEntity rebateFeePoolEntity;
        RebateFeePoolUtil.validate(vo);
        if (vo.getSaleCompanyCode() == null) {
            vo.setSaleCompanyCode("");
        }
        QueryWrapper<RebateFeePoolEntity> wrapper = RebateFeePoolUtil.buildUniqueWrapperParam(vo);
        List rebateFeePoolEntities = this.rebateFeePoolMapper.selectList((Wrapper)wrapper);
        FieldHandleUtil.initDecimalZero(vo);
        if (CollectionUtil.listNotEmpty((List)rebateFeePoolEntities)) {
            rebateFeePoolEntity = (RebateFeePoolEntity)((Object)rebateFeePoolEntities.get(0));
            FieldHandleUtil.initUpdateFields((Object)rebateFeePoolEntity);
            rebateFeePoolEntity.setBalance(rebateFeePoolEntity.getBalance().add(vo.getTotalFee()));
            rebateFeePoolEntity.setTotalFee(rebateFeePoolEntity.getTotalFee().add(vo.getTotalFee()));
            this.rebateFeePoolMapper.updateById((Object)rebateFeePoolEntity);
        } else {
            FieldHandleUtil.initCreateFields(vo);
            vo.setCode(CodeUtil.getCode());
            vo.setUsedFee(BigDecimal.ZERO);
            vo.setBalance(vo.getTotalFee());
            rebateFeePoolEntity = new RebateFeePoolEntity();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)rebateFeePoolEntity));
            this.rebateFeePoolMapper.insert((Object)rebateFeePoolEntity);
        }
        RebateFeePoolDetailVo rebateFeePoolDetailVo = new RebateFeePoolDetailVo();
        rebateFeePoolDetailVo.setCode(CodeUtil.getCode());
        rebateFeePoolDetailVo.setItemTotalFee(vo.getTotalFee());
        rebateFeePoolDetailVo.setItemAvailableBalance(vo.getTotalFee());
        rebateFeePoolDetailVo.setItemFrozenFee(BigDecimal.ZERO);
        rebateFeePoolDetailVo.setItemUsedFee(BigDecimal.ZERO);
        rebateFeePoolDetailVo.setPayType(vo.getPayType());
        rebateFeePoolDetailVo.setItemAvailableBalance(vo.getTotalFee());
        rebateFeePoolDetailVo.setRebateFeePoolCode(rebateFeePoolEntity.getCode());
        rebateFeePoolDetailVo.setAdjustType(vo.getAdjustType());
        rebateFeePoolDetailVo.setFiles(vo.getFiles());
        rebateFeePoolDetailVo.setRemarks(vo.getRemarks());
        this.rebateFeePoolDetailService.create(rebateFeePoolDetailVo);
    }

    @Override
    @Transactional
    public void adjust(RebateFeePoolVo vo) {
        RebateFeePoolUtil.validate(vo);
        ValidateUtils.validate((Object)vo.getId(), (String)"\u7f16\u8f91\u6298\u6263\u8d39\u7528\u6c60\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a");
        RebateFeePoolEntity rebateFeePoolEntity = (RebateFeePoolEntity)((Object)this.rebateFeePoolMapper.selectById((Serializable)((Object)vo.getId())));
        ValidateUtils.validate((Object)((Object)rebateFeePoolEntity), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6298\u6263\u8d39\u7528\u6c60\u539f\u59cb\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4id\u662f\u5426\u6b63\u786e");
        List rebateFeePoolDetailVos = vo.getRebateFeePoolDetailVos();
        ValidateUtils.notEmpty((Collection)rebateFeePoolDetailVos, (String)"\u7f16\u7801\u6298\u6263\u8d39\u7528\u6c60\u65f6\uff0c\u6298\u6263\u8d39\u7528\u6c60\u6761\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal frozen = BigDecimal.ZERO;
        BigDecimal used = BigDecimal.ZERO;
        BigDecimal balance = BigDecimal.ZERO;
        for (RebateFeePoolDetailVo v : rebateFeePoolDetailVos) {
            FieldHandleUtil.initDecimalZero(v);
            this.computeAdjustFee(v);
            total = total.add(v.getItemTotalFee());
            frozen = frozen.add(v.getItemFrozenFee());
            used = used.add(v.getItemUsedFee());
            balance = balance.add(v.getItemAvailableBalance());
            if (StringUtils.isEmpty((String)v.getRebateFeePoolCode())) {
                v.setRebateFeePoolCode(vo.getCode());
            }
            this.rebateFeePoolDetailService.saveDetail(v);
        }
        rebateFeePoolEntity.setTotalFee(total);
        rebateFeePoolEntity.setBalance(balance);
        rebateFeePoolEntity.setFrozenFee(frozen);
        rebateFeePoolEntity.setUsedFee(used);
        this.rebateFeePoolMapper.updateById((Object)rebateFeePoolEntity);
    }

    private void computeAdjustFee(RebateFeePoolDetailVo v) {
        if (v == null || v.getAdjustFee() == null || v.getAdjustFee().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        RebateFeePoolDetailLogUtil.AdjustTypeEnum adjustTypeEnum = RebateFeePoolDetailLogUtil.AdjustTypeEnum.getEnumByCode(v.getAdjustType());
        ValidateUtils.validate((Object)((Object)adjustTypeEnum), (String)"\u8c03\u6574\u7c7b\u578b\u4e0d\u6b63\u786e");
        ValidateUtils.isTrue((v.getAdjustFee().compareTo(BigDecimal.ZERO) > -1 ? 1 : 0) != 0, (String)"\u8c03\u6574\u6761\u76ee\u65f6\uff0c\u8c03\u6574\u91d1\u989d\u8bf7\u8f93\u5165\u6b63\u6570", (String[])new String[0]);
        switch (RebateFeePoolDetailLogUtil.AdjustTypeEnum.getEnumByCode(v.getAdjustType())) {
            case HAND_ON_ACCOUNT: 
            case BACK_REBATE_ON_ACCOUNT: 
            case FEE_ON_ACCOUNT: {
                v.setItemTotalFee(v.getItemTotalFee().add(v.getAdjustFee()));
                v.setItemAvailableBalance(v.getItemAvailableBalance().add(v.getAdjustFee()));
                break;
            }
            case HAND_REDUCE: 
            case ORDER_REDUCE: {
                ValidateUtils.isTrue((v.getItemAvailableBalance().compareTo(v.getAdjustFee()) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u53ef\u7528\u4f59\u91cf\u4e0d\u8db3\u4ee5\u6263\u51cf\u4e0d\u8db3\uff0c\u8bf7\u786e\u8ba4", (String[])new String[]{v.getCode()});
                v.setItemAvailableBalance(v.getItemAvailableBalance().subtract(v.getAdjustFee()));
                v.setItemUsedFee(v.getItemUsedFee().add(v.getAdjustFee()));
                break;
            }
            default: {
                throw new BusinessException("\u8c03\u6574\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8be5\u529f\u80fd\u53ea\u652f\u6301\u624b\u52a8\u4e0a\u8d26\u3001\u8fd4\u5229\u4e0a\u8d26\u3001\u8d39\u7528\u4e0a\u8d26\u3001\u624b\u52a8\u6263\u51cf\u3001\u8ba2\u5355\u6263\u51cf");
            }
        }
    }

    @Override
    public BigDecimal findAvailableBalance(RebateFeePoolVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u67e5\u8be2\u6298\u6263\u8d39\u7528\u6c60\u53ef\u7528\u4f59\u989d\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getUniqueDictCode(), (String)"\u6298\u6263\u8d39\u7528\u6c60\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper<RebateFeePoolEntity> wrapper = StringUtils.isEmpty((String)vo.getUniqueDictCode()) ? Wrappers.query() : RebateFeePoolUtil.buildUniqueWrapperParam(vo);
        wrapper.eq(StringUtils.isNotEmpty((String)vo.getCusOrgCode()), (Object)"cus_org_code", (Object)vo.getCusOrgCode());
        wrapper.eq(StringUtils.isNotEmpty((String)vo.getSaleCompanyCode()), (Object)"sale_company_code", (Object)vo.getSaleCompanyCode());
        List rebateFeePoolEntities = this.rebateFeePoolMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)rebateFeePoolEntities)) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalBalance = BigDecimal.ZERO;
        for (RebateFeePoolEntity entity : rebateFeePoolEntities) {
            totalBalance = totalBalance.add(entity.getBalance());
        }
        return totalBalance;
    }

    @Override
    public boolean subtractBalance(RebateFeePoolVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u6298\u6263\u8d39\u7528\u6263\u51cf\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getUniqueDictCode(), (String)"\u6298\u6263\u8d39\u7528\u6263\u51cf\u65f6\uff0c\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        BigDecimal subtractFee = vo.getSubtractFee();
        QueryWrapper<RebateFeePoolEntity> wrapper = RebateFeePoolUtil.buildUniqueWrapperParam(vo);
        List entities = this.rebateFeePoolMapper.selectList((Wrapper)wrapper);
        ValidateUtils.notEmpty((Collection)entities, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u6298\u6263\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6b63\u786e\u4f20\u5165\u552f\u4e00\u7ea6\u675f\uff0c\u6216\u8005\u552f\u4e00\u7ea6\u675f\u5bf9\u5e94\u7684\u5b57\u6bb5\u503c\u662f\u5426\u6b63\u786e");
        ValidateUtils.isTrue((entities.size() == 1 ? 1 : 0) != 0, (String)"\u901a\u8fc7\u552f\u4e00\u7ea6\u675f\u6761\u4ef6\u67e5\u5230\u591a\u6761\u6298\u6263\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6b63\u786e\u4f20\u5165\u552f\u4e00\u7ea6\u675f\uff0c\u6216\u8005\u552f\u4e00\u7ea6\u675f\u5bf9\u5e94\u7684\u5b57\u6bb5\u503c\u662f\u5426\u6b63\u786e", (String[])new String[0]);
        RebateFeePoolEntity entity = (RebateFeePoolEntity)((Object)entities.get(0));
        List<RebateFeePoolDetailVo> rebateFeePoolDetailVos = this.rebateFeePoolDetailService.findByPoolCode(entity.getCode());
        ValidateUtils.notEmpty(rebateFeePoolDetailVos, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6298\u6263\u8d39\u7528");
        return true;
    }

    @Override
    public BigDecimal subtractBalanceFree(RebateFeePoolVo vo) {
        return BigDecimal.ZERO;
    }

    @Override
    public boolean redTrick(RebateFeePoolVo vo) {
        return false;
    }

    @Override
    public PageResult<RebateFeePoolVo> findPageByConditions(RebateFeePoolVo param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        List<RebateFeePoolVo> list = this.rebateFeePoolMapper.findPageByConditions((Page<RebateFeePoolVo>)page, param.getCusOrgName(), param.getCusName(), param.getCusChannelName());
        if (CollectionUtil.listEmpty(list)) {
            return PageResult.builder().count(Long.valueOf(page.getTotal())).build();
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public RebateFeePoolVo findPoolByCode(String rebateFeePoolCode) {
        if (StringUtils.isEmpty((String)rebateFeePoolCode)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"code", (Object)rebateFeePoolCode);
        RebateFeePoolEntity entity = (RebateFeePoolEntity)((Object)this.rebateFeePoolMapper.selectOne((Wrapper)wrapper));
        if (entity == null) {
            return null;
        }
        RebateFeePoolVo vo = new RebateFeePoolVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        return vo;
    }

    @Override
    public FeePoolFindAccountReportRes findAccountReport(String yearMonth) {
        ValidateUtils.validate((Object)yearMonth, (String)"\u4f20\u5165\u53c2\u6570\u2018\u5e74\u6708\u2019\u4e0d\u80fd\u4e3a\u7a7a");
        return null;
    }

    @Override
    public FeePoolSumReportRes findFeePoolSum(RebateFeePoolVo param) {
        ValidateUtils.validate((Object)param, (String)"\u67e5\u8be2\u8d39\u7528\u6c47\u603b\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.validate((Object)param.getUniqueDictCode(), (String)"\u67e5\u8be2\u8d39\u7528\u6c47\u603b\u65f6\uff0c\u552f\u4e00\u7ea6\u675f\u6570\u636e\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        Map<String, Object> map = RebateFeePoolUtil.buildUniqueMapParam(param);
        FeePoolSumReportRes result = this.rebateFeePoolMapper.findFeePoolSum(map);
        return null;
    }

    @Override
    public List<FeePoolDetailLogVo> listLog(RebateFeePoolVo vo) {
        if (vo == null) {
            return Lists.newArrayList();
        }
        UserRedis user = UserUtils.getUser();
        ValidateUtils.validate((Object)user, (String)"\u6ca1\u6709\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u767b\u5f55");
        vo.setCusCode(user.getCustcode());
        List<FeePoolDetailLogVo> logs = this.rebateFeePoolDetailLogMapper.listLog(vo);
        return logs;
    }
}

