/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolFileVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailLogVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailVo;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolDetailLogUtil;
import com.biz.crm.repfeepool.entity.RepFeePoolItemDetailLogEntity;
import com.biz.crm.repfeepool.mapper.RepFeePoolItemDetailLogMapper;
import com.biz.crm.repfeepool.service.RepFeePoolFileService;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailLogService;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service(value="repFeePoolItemDetailLogService")
@ConditionalOnMissingBean(name={"repFeePoolItemDetailLogServiceImpl"})
public class RepFeePoolIItemDetailLogServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RepFeePoolItemDetailLogMapper, RepFeePoolItemDetailLogEntity>
implements RepFeePoolIItemDetailLogService {
    @Resource
    private RepFeePoolItemDetailLogMapper repFeePoolItemDetailLogMapper;
    @Resource
    private RepFeePoolFileService repFeePoolFileService;
    @Resource
    private RepFeePoolIItemDetailService repFeePoolIItemDetailService;

    @Override
    public void create(RepFeePoolItemDetailLogVo logVo) {
        ValidateUtils.validate((Object)logVo, (String)"\u65b0\u589e\u5355\u6761\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65e5\u5fd7\u8bb0\u5f55\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.isTrue((logVo.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u5355\u6761\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65e5\u5fd7\u8bb0\u5f55\u65f6\uff0cid\u4e0d\u80fd\u6709\u503c", (String[])new String[0]);
        ValidateUtils.validate((Object)logVo.getRepFeePoolItemDetailCode(), (String)"\u65b0\u589e\u5355\u6761\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65e5\u5fd7\u8bb0\u5f55\u65f6\uff0c\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        logVo.setCode(CodeUtil.getCode());
        RepFeePoolItemDetailLogEntity entity = new RepFeePoolItemDetailLogEntity();
        BeanUtils.copyProperties((Object)logVo, (Object)((Object)entity));
        this.repFeePoolItemDetailLogMapper.insert((Object)entity);
        List files = logVo.getFiles();
        if (!CollectionUtil.listEmpty((List)files)) {
            this.repFeePoolFileService.createAll(files);
        }
    }

    @Override
    public PageResult<RepFeePoolItemDetailLogVo> findPageByConditions(RepFeePoolItemDetailLogVo param) {
        Page page;
        List<RepFeePoolItemDetailLogVo> list;
        if (param == null) {
            param = new RepFeePoolItemDetailLogVo();
        }
        if (CollectionUtil.listEmpty(list = this.repFeePoolItemDetailLogMapper.findPageByConditions((Page<RepFeePoolItemDetailLogVo>)(page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue())), param.getRepFeePoolItemDetailCode(), param.getAdjustCountType(), param.getRepFeePoolItemCode()))) {
            return PageResult.builder().build();
        }
        list.forEach(li -> {
            List<RepFeePoolFileVo> files = this.repFeePoolFileService.findByLogCode(li.getCode());
            li.setFiles(files);
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public RepFeePoolItemDetailVo frozen(RepFeePoolItemDetailLogVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u51bb\u7ed3\u6216\u8005\u89e3\u51bb\u6761\u76ee\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.validate((Object)vo.getRepFeePoolItemDetailCode(), (String)"\u51bb\u7ed3\u6216\u8005\u89e3\u51bb\u6761\u76ee\u65f6\uff0c\u8d39\u7528\u6c60\u6761\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.isTrue((Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.FROZEN.getCode(), vo.getAdjustFeeType()) || Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode(), vo.getAdjustFeeType()) ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u6216\u8005\u89e3\u51bb\u6761\u76ee\u65f6\uff0c\u8c03\u6574\u7c7b\u578b\u53ea\u80fd\u65f6\u51bb\u7ed3\u6216\u8005\u89e3\u51bb", (String[])new String[0]);
        RepFeePoolItemDetailVo detailVo = this.repFeePoolIItemDetailService.findByDetailCode(vo.getRepFeePoolItemDetailCode());
        ValidateUtils.validate((Object)detailVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u6761\u76ee\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u6761\u76ee\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u9012");
        detailVo.setAdjustFrozenFee(vo.getFrozenFee());
        if (Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.FROZEN.getCode(), vo.getAdjustFeeType())) {
            ValidateUtils.isTrue((detailVo.getAvailableFee().compareTo(vo.getFrozenFee()) >= 0 ? 1 : 0) != 0, (String)"\u6761\u76ee\u53ef\u7528\u91d1\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u51bb\u7ed3", (String[])new String[0]);
            detailVo.setFrozenFee(detailVo.getAvailableFee().add(vo.getFrozenFee()));
            detailVo.setAvailableFee(detailVo.getAvailableFee().subtract(vo.getFrozenFee()));
            ValidateUtils.isTrue((detailVo.getAvailableCount().compareTo(vo.getFrozenCount()) >= 0 ? 1 : 0) != 0, (String)"\u6761\u76ee\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u51bb\u7ed3", (String[])new String[0]);
            detailVo.setFrozenCount(detailVo.getAvailableCount().add(vo.getFrozenCount()));
            detailVo.setAvailableCount(detailVo.getAvailableCount().subtract(vo.getFrozenCount()));
        } else if (Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode(), vo.getAdjustFeeType())) {
            ValidateUtils.isTrue((detailVo.getFrozenFee().compareTo(vo.getFrozenFee()) >= 0 ? 1 : 0) != 0, (String)"\u6761\u76ee\u51bb\u7ed3\u91d1\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u89e3\u51bb", (String[])new String[0]);
            detailVo.setFrozenFee(detailVo.getFrozenFee().subtract(vo.getFrozenFee()));
            detailVo.setAvailableFee(detailVo.getAvailableFee().add(vo.getFrozenFee()));
            ValidateUtils.isTrue((detailVo.getFrozenCount().compareTo(vo.getFrozenCount()) >= 0 ? 1 : 0) != 0, (String)"\u6761\u76ee\u51bb\u7ed3\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u89e3\u51bb", (String[])new String[0]);
            detailVo.setFrozenCount(detailVo.getFrozenCount().subtract(vo.getFrozenCount()));
            detailVo.setAvailableCount(detailVo.getFrozenCount().add(vo.getFrozenCount()));
        }
        this.repFeePoolIItemDetailService.update(detailVo);
        return detailVo;
    }
}

