/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailLogVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailVo;
import com.biz.crm.repfeepool.entity.RepFeePoolItemDetailEntity;
import com.biz.crm.repfeepool.mapper.RepFeePoolItemDetailMapper;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailLogService;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailService;
import com.biz.crm.repfeepool.utils.RepFeePoolItemDetailUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="repFeePoolItemDetailService")
@ConditionalOnMissingBean(name={"repFeePoolItemDetailServiceImpl"})
public class RepFeePoolIItemDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RepFeePoolItemDetailMapper, RepFeePoolItemDetailEntity>
implements RepFeePoolIItemDetailService {
    @Resource
    private RepFeePoolItemDetailMapper repFeePoolItemDetailMapper;
    @Resource
    private RepFeePoolIItemDetailLogService repFeePoolIItemDetailLogService;

    @Override
    @Transactional
    public void create(RepFeePoolItemDetailVo detailVo) {
        RepFeePoolItemDetailUtil.validate(detailVo);
        ValidateUtils.isTrue((detailVo.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u4e0d\u80fd\u5b58\u5728id\u503c", (String[])new String[0]);
        detailVo.setCode(CodeUtil.getCode());
        RepFeePoolItemDetailEntity entity = new RepFeePoolItemDetailEntity();
        BeanUtils.copyProperties((Object)detailVo, (Object)((Object)entity));
        FieldHandleUtil.initCreateFields((Object)entity);
        this.repFeePoolItemDetailMapper.insert((Object)entity);
        RepFeePoolItemDetailLogVo logVo = new RepFeePoolItemDetailLogVo();
        logVo.setFiles(detailVo.getFiles());
        logVo.setAdjustCount(detailVo.getOnAccountCount());
        logVo.setAdjustCountType(detailVo.getAdjustCountType());
        logVo.setAdjustFee(detailVo.getOnAccountFee());
        logVo.setAdjustFeeType(detailVo.getAdjustFeeType());
        logVo.setPayType(detailVo.getPayType());
        logVo.setRepFeePoolItemDetailCode(entity.getCode());
        logVo.setRemarks(detailVo.getRemarks());
        this.repFeePoolIItemDetailLogService.create(logVo);
    }

    @Override
    @Transactional
    public void createAll(List<RepFeePoolItemDetailVo> createItems) {
        ValidateUtils.notEmpty(createItems, (String)"\u6279\u91cf\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        createItems.forEach(item -> this.create((RepFeePoolItemDetailVo)item));
    }

    @Override
    @Transactional
    public void updateAll(List<RepFeePoolItemDetailVo> updateItems) {
        ValidateUtils.notEmpty(updateItems, (String)"\u6279\u91cf\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        updateItems.forEach(item -> this.update((RepFeePoolItemDetailVo)item));
    }

    @Override
    @Transactional
    public void update(RepFeePoolItemDetailVo item) {
        RepFeePoolItemDetailUtil.validate(item);
        ValidateUtils.isTrue((item.getId() != null ? 1 : 0) != 0, (String)"\u4fee\u6539\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u5fc5\u987b\u5b58\u5728id\u503c", (String[])new String[0]);
        RepFeePoolItemDetailEntity entity = (RepFeePoolItemDetailEntity)((Object)this.repFeePoolItemDetailMapper.selectById((Serializable)((Object)item.getId())));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u4fee\u6539\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8bb0\u5f55");
        if (Objects.equals(entity.getCostPrice(), item.getCostPrice()) && Objects.equals(entity.getSalePrice(), item.getSalePrice()) && Objects.equals(entity.getOnAccountCount(), item.getOnAccountCount()) && Objects.equals(entity.getUsedCount(), item.getUsedCount()) && Objects.equals(entity.getFrozenCount(), entity.getFrozenCount()) && Objects.equals(entity.getAvailableCount(), item.getAvailableCount()) && Objects.equals(entity.getOnAccountFee(), item.getOnAccountFee()) && Objects.equals(entity.getUsedFee(), item.getUsedFee()) && Objects.equals(entity.getFrozenFee(), item.getFrozenFee()) && Objects.equals(entity.getAvailableFee(), item.getAvailableFee())) {
            return;
        }
        entity.setCostPrice(item.getCostPrice());
        entity.setSalePrice(item.getSalePrice());
        entity.setOnAccountCount(item.getOnAccountCount());
        entity.setUsedCount(item.getUsedCount());
        entity.setFrozenCount(item.getFrozenCount());
        entity.setAvailableCount(item.getAvailableCount());
        entity.setOnAccountFee(item.getOnAccountFee());
        entity.setUsedFee(item.getUsedFee());
        entity.setFrozenFee(item.getFrozenFee());
        entity.setAvailableFee(item.getAvailableFee());
        entity.setPayType(item.getPayType());
        entity.setUnit(item.getUnit());
        FieldHandleUtil.initUpdateFields((Object)entity);
        this.repFeePoolItemDetailMapper.updateById((Object)entity);
        RepFeePoolItemDetailLogVo logVo = new RepFeePoolItemDetailLogVo();
        logVo.setFiles(item.getFiles());
        logVo.setAdjustCount(item.getAdjustCount());
        logVo.setAdjustCountType(item.getAdjustCountType());
        logVo.setAdjustFee(item.getAdjustFee());
        logVo.setFrozenFee(item.getAdjustFrozenFee());
        logVo.setAdjustFeeType(item.getAdjustFeeType());
        logVo.setPayType(item.getPayType());
        logVo.setRepFeePoolItemDetailCode(entity.getCode());
        logVo.setRemarks(item.getRemarks());
        this.repFeePoolIItemDetailLogService.create(logVo);
    }

    @Override
    public PageResult<RepFeePoolItemDetailVo> findPageByConditions(RepFeePoolItemDetailVo param) {
        Page page;
        List<RepFeePoolItemDetailVo> list;
        if (param == null) {
            param = new RepFeePoolItemDetailVo();
        }
        if (CollectionUtil.listEmpty(list = this.repFeePoolItemDetailMapper.findPageByConditions((Page<RepFeePoolItemDetailVo>)(page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue())), param.getRepFeePoolItemCode()))) {
            return PageResult.builder().build();
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public RepFeePoolItemDetailVo findByDetailCode(String repFeePoolItemDetailCode) {
        if (StringUtils.isEmpty((String)repFeePoolItemDetailCode)) {
            return null;
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"code", (Object)repFeePoolItemDetailCode);
        RepFeePoolItemDetailEntity entity = (RepFeePoolItemDetailEntity)((Object)this.repFeePoolItemDetailMapper.selectOne((Wrapper)wrapper));
        if (entity == null) {
            return null;
        }
        RepFeePoolItemDetailVo vo = new RepFeePoolItemDetailVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        return vo;
    }
}

