/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemVo;
import com.biz.crm.repfeepool.entity.RepFeePoolItemEntity;
import com.biz.crm.repfeepool.mapper.RepFeePoolItemMapper;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailService;
import com.biz.crm.repfeepool.service.RepFeePoolItemService;
import com.biz.crm.repfeepool.service.RepFeePoolService;
import com.biz.crm.repfeepool.utils.RepFeePoolItemDetailLogUtil;
import com.biz.crm.repfeepool.utils.RepFeePoolItemUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="repFeePoolItemService")
@ConditionalOnMissingBean(name={"repFeePoolItemServiceImpl"})
public class RepFeePoolItemServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RepFeePoolItemMapper, RepFeePoolItemEntity>
implements RepFeePoolItemService {
    @Resource
    private RepFeePoolItemMapper repFeePoolItemMapper;
    @Resource
    private RepFeePoolIItemDetailService repFeePoolIItemDetailService;
    @Resource
    private RepFeePoolService repFeePoolService;

    @Override
    public Map<String, BigDecimal> findAvailableBalance(RepFeePoolItemVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap result = Maps.newHashMap();
        List<String> pCodes = Arrays.asList(vo.getProductCode().split(","));
        for (int i = 0; i < pCodes.size(); ++i) {
            if (i == 1) {
                result.put(pCodes.get(i), BigDecimal.ZERO);
            }
            result.put(pCodes.get(i), BigDecimal.valueOf(1000L));
        }
        return result;
    }

    @Override
    public PageResult<RepFeePoolItemVo> findPageByConditions(RepFeePoolItemVo vo) {
        if (vo == null) {
            vo = new RepFeePoolItemVo();
        }
        HashMap map = Maps.newHashMap();
        if (vo.getRepFeePoolVo() != null) {
            map.put("cusName", vo.getRepFeePoolVo().getCusName());
            map.put("cusOrgName", vo.getRepFeePoolVo().getCusOrgName());
            map.put("saleCompanyName", vo.getRepFeePoolVo().getSaleCompanyName());
            map.put("cusChannelName", vo.getRepFeePoolVo().getCusChannelName());
        }
        map.put("repFeePoolCode", vo.getRepFeePoolCode());
        map.put("code", vo.getCode());
        map.put("payType", vo.getPayType());
        map.put("productName", vo.getProductName());
        map.put("productCode", vo.getProductCode());
        Page page = new Page((long)vo.getPageNum().intValue(), (long)vo.getPageSize().intValue());
        List<RepFeePoolItemVo> list = this.repFeePoolItemMapper.findPageByConditions((Page<RepFeePoolItemVo>)page, map);
        if (CollectionUtil.listEmpty(list)) {
            return PageResult.builder().build();
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void onCountItems(List<RepFeePoolItemVo> repFeePoolItemVos) {
        ValidateUtils.notEmpty(repFeePoolItemVos, (String)"\u65b0\u589e\u591a\u6761\u8d27\u8865\u8d39\u7528\u6c60\u660e\u7ec6\u8bb0\u5f55\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        repFeePoolItemVos.forEach(item -> this.save((RepFeePoolItemVo)item));
    }

    @Override
    @Transactional
    public void save(RepFeePoolItemVo itemVo) {
        RepFeePoolItemEntity entity;
        RepFeePoolItemUtil.validate(itemVo);
        itemVo.setProductSize(Integer.valueOf(itemVo.getProductCode().split(",").length));
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"rep_fee_pool_code", (Object)itemVo.getRepFeePoolCode());
        wrapper.eq((Object)"product_code", (Object)itemVo.getProductCode());
        List entities = this.repFeePoolItemMapper.selectList((Wrapper)wrapper);
        FieldHandleUtil.initDecimalZero(itemVo);
        if (CollectionUtil.listEmpty((List)entities)) {
            entity = new RepFeePoolItemEntity();
            FieldHandleUtil.initCreateFields(itemVo);
            BeanUtils.copyProperties((Object)itemVo, (Object)((Object)entity));
            entity.setCode(CodeUtil.getCode());
            entity.setId(null);
            entity.setAvailableFee(entity.getOnAccountFee());
            entity.setAvailableCount(entity.getOnAccountCount());
            this.repFeePoolItemMapper.insert((Object)entity);
        } else {
            ValidateUtils.isTrue((entities.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636e\u8d27\u8865\u8d39\u7528\u6c60\u552f\u4e00\u7ea6\u675f\u67e5\u5230\u540c\u4e00\u4e2a\u4ea7\u54c1\u5b58\u5728\u591a\u6761\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e", (String[])new String[0]);
            entity = (RepFeePoolItemEntity)((Object)entities.get(0));
            entity.setPayType(itemVo.getPayType());
            entity.setOnAccountCount(itemVo.getOnAccountCount().add(entity.getOnAccountCount()));
            entity.setOnAccountFee(itemVo.getOnAccountFee().add(entity.getOnAccountFee()));
            entity.setAvailableFee(itemVo.getAvailableFee().add(entity.getOnAccountFee()));
            entity.setAvailableCount(itemVo.getAvailableCount().add(entity.getOnAccountCount()));
            FieldHandleUtil.initUpdateFields((Object)entity);
            this.repFeePoolItemMapper.updateById((Object)entity);
        }
        RepFeePoolItemDetailVo detailVo = new RepFeePoolItemDetailVo();
        detailVo.setFiles(itemVo.getFiles());
        detailVo.setPayType(entity.getPayType());
        detailVo.setProductCode(entity.getProductCode());
        detailVo.setProductName(entity.getProductName());
        detailVo.setCostPrice(entity.getCostPrice());
        detailVo.setRepFeePoolItemCode(entity.getCode());
        detailVo.setSalePrice(entity.getSalePrice());
        detailVo.setUnit(entity.getUnit());
        detailVo.setOnAccountCount(itemVo.getOnAccountCount());
        detailVo.setUsedCount(BigDecimal.ZERO);
        detailVo.setFrozenCount(BigDecimal.ZERO);
        detailVo.setAvailableCount(itemVo.getOnAccountCount());
        detailVo.setOnAccountFee(itemVo.getOnAccountFee());
        detailVo.setUsedFee(BigDecimal.ZERO);
        detailVo.setFrozenFee(BigDecimal.ZERO);
        detailVo.setAvailableFee(itemVo.getOnAccountFee());
        detailVo.setAdjustCountType(itemVo.getAdjustCountType());
        detailVo.setAdjustFeeType(itemVo.getAdjustFeeType());
        this.repFeePoolIItemDetailService.create(detailVo);
    }

    @Override
    @Transactional
    public void adjust(RepFeePoolItemVo vo) {
        RepFeePoolItemUtil.validate(vo);
        List detailVos = vo.getDetailVos();
        ValidateUtils.notEmpty((Collection)detailVos, (String)"\u8c03\u6574\u8d27\u8865\u8d39\u7528\u6c60\u65f6\uff0c\u6761\u76ee\u5fc5\u987b\u4f20\u5165");
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"code", (Object)vo.getCode());
        RepFeePoolItemEntity entity = (RepFeePoolItemEntity)((Object)this.repFeePoolItemMapper.selectOne((Wrapper)wrapper));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u8c03\u6574\u8d27\u8865\u8d39\u7528\u6c60\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u8d27\u8865\u8d39\u7528\u6c60\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u660e\u7ec6\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
        vo.setProductSize(Integer.valueOf(vo.getProductCode().split(",").length));
        ArrayList createItems = Lists.newArrayList();
        ArrayList updateItems = Lists.newArrayList();
        BigDecimal costPrice = BigDecimal.ZERO;
        BigDecimal salePrice = BigDecimal.ZERO;
        BigDecimal onAccountCount = BigDecimal.ZERO;
        BigDecimal usedCount = BigDecimal.ZERO;
        BigDecimal frozenCount = BigDecimal.ZERO;
        BigDecimal availableCount = BigDecimal.ZERO;
        BigDecimal onAccountFee = BigDecimal.ZERO;
        BigDecimal usedFee = BigDecimal.ZERO;
        BigDecimal frozenFee = BigDecimal.ZERO;
        BigDecimal availableFee = BigDecimal.ZERO;
        for (RepFeePoolItemDetailVo detail : detailVos) {
            FieldHandleUtil.initDecimalZero(detail);
            this.computeAdjustCount(detail);
            this.computeAdjustFee(detail);
            costPrice = costPrice.add(detail.getCostPrice());
            salePrice = salePrice.add(detail.getSalePrice());
            onAccountCount = onAccountCount.add(detail.getOnAccountCount());
            usedCount = usedCount.add(detail.getUsedCount());
            frozenCount = frozenCount.add(detail.getFrozenCount());
            availableCount = availableCount.add(detail.getAvailableCount());
            onAccountFee = onAccountFee.add(detail.getOnAccountFee());
            usedFee = usedFee.add(detail.getUsedFee());
            frozenFee = frozenFee.add(detail.getFrozenFee());
            availableFee = availableFee.add(detail.getAvailableFee());
            if (StringUtils.isEmpty((String)detail.getId())) {
                detail.setRepFeePoolItemCode(entity.getCode());
                createItems.add(detail);
                continue;
            }
            updateItems.add(detail);
        }
        entity.setCostPrice(costPrice);
        entity.setSalePrice(salePrice);
        entity.setOnAccountCount(onAccountCount);
        entity.setUsedCount(usedCount);
        entity.setFrozenCount(frozenCount);
        entity.setAvailableCount(availableCount);
        entity.setOnAccountFee(onAccountFee);
        entity.setUsedFee(usedFee);
        entity.setFrozenFee(frozenFee);
        entity.setAvailableFee(availableFee);
        this.repFeePoolItemMapper.updateById((Object)entity);
        if (!CollectionUtil.listEmpty((List)createItems)) {
            this.repFeePoolIItemDetailService.createAll(createItems);
        }
        if (!CollectionUtil.listEmpty((List)updateItems)) {
            this.repFeePoolIItemDetailService.updateAll(updateItems);
        }
        this.repFeePoolService.summaryItems(vo.getRepFeePoolCode());
    }

    private void computeAdjustFee(RepFeePoolItemDetailVo vo) {
        if (vo == null || vo.getAdjustFee() == null || vo.getAdjustFee().compareTo(BigDecimal.ZERO) == 0 || vo.getAdjustFee().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal adjustFee = vo.getAdjustFee();
        ValidateUtils.isTrue((adjustFee.compareTo(BigDecimal.ZERO) > -1 ? 1 : 0) != 0, (String)"\u8c03\u6574\u6761\u76ee\u65f6\uff0c\u8c03\u6574\u91d1\u989d\u8bf7\u8f93\u5165\u6b63\u6570", (String[])new String[0]);
        switch (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.getEnumByCode(vo.getAdjustFeeType())) {
            case HAND_ON_ACCOUNT: 
            case BACK_REBATE_ON_ACCOUNT: 
            case FEE_ON_ACCOUNT: {
                vo.setOnAccountFee(vo.getOnAccountFee().add(adjustFee));
                vo.setAvailableFee(vo.getAvailableFee().add(adjustFee));
                break;
            }
            case HAND_REDUCE: 
            case ORDER_REDUCE: {
                ValidateUtils.isTrue((vo.getAvailableFee().compareTo(adjustFee) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\u4ee5\u6263\u51cf\u4e0d\u8db3\uff0c\u8bf7\u786e\u8ba4", (String[])new String[]{vo.getCode()});
                vo.setAvailableFee(vo.getAvailableFee().subtract(adjustFee));
                vo.setUsedFee(vo.getUsedFee().add(adjustFee));
                break;
            }
            default: {
                throw new BusinessException("\u8c03\u6574\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8be5\u529f\u80fd\u53ea\u652f\u6301\u624b\u52a8\u4e0a\u8d26\u3001\u8fd4\u5229\u4e0a\u8d26\u3001\u8d39\u7528\u4e0a\u8d26\u3001\u624b\u52a8\u6263\u51cf\u3001\u8ba2\u5355\u6263\u51cf");
            }
        }
    }

    private void computeAdjustCount(RepFeePoolItemDetailVo vo) {
        if (vo == null || vo.getAdjustCount() == null || vo.getAdjustCount().compareTo(BigDecimal.ZERO) == 0 || vo.getAdjustCount().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal adjustCount = vo.getAdjustCount();
        ValidateUtils.isTrue((adjustCount.compareTo(BigDecimal.ZERO) > -1 ? 1 : 0) != 0, (String)"\u8c03\u6574\u6761\u76ee\u65f6\uff0c\u8c03\u6574\u6570\u91cf\u8bf7\u8f93\u5165\u6b63\u6570", (String[])new String[0]);
        switch (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.getEnumByCode(vo.getAdjustCountType())) {
            case HAND_ON_ACCOUNT: 
            case BACK_REBATE_ON_ACCOUNT: 
            case FEE_ON_ACCOUNT: {
                vo.setOnAccountCount(vo.getOnAccountCount().add(adjustCount));
                vo.setAvailableCount(vo.getAvailableCount().add(adjustCount));
                break;
            }
            case HAND_REDUCE: 
            case ORDER_REDUCE: {
                ValidateUtils.isTrue((vo.getAvailableCount().compareTo(adjustCount) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u53ef\u7528\u4f59\u91cf\u4e0d\u8db3\u4ee5\u6263\u51cf\u4e0d\u8db3\uff0c\u8bf7\u786e\u8ba4", (String[])new String[]{vo.getCode()});
                vo.setAvailableCount(vo.getAvailableCount().subtract(adjustCount));
                vo.setUsedCount(vo.getUsedCount().add(adjustCount));
                break;
            }
            default: {
                throw new BusinessException("\u8c03\u6574\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8be5\u529f\u80fd\u53ea\u652f\u6301\u624b\u52a8\u4e0a\u8d26\u548c\u624b\u52a8\u6263\u51cf");
            }
        }
    }

    @Override
    public List<RepFeePoolItemVo> findByCode(String repFeePoolCode) {
        if (StringUtils.isEmpty((String)repFeePoolCode)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"rep_fee_pool_code", (Object)repFeePoolCode);
        List entities = this.repFeePoolItemMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        ArrayList itemVos = Lists.newArrayList();
        entities.forEach(entity -> {
            RepFeePoolItemVo itemVo = new RepFeePoolItemVo();
            BeanUtils.copyProperties((Object)entity, (Object)itemVo);
            itemVos.add(itemVo);
        });
        return itemVos;
    }
}

