/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salestarget.utils;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.dms.SalesTargetEunm;
import com.biz.crm.nebular.dms.salestarget.SalesTargetVo;
import com.biz.crm.salestarget.entity.SalesTargetEntity;
import com.biz.crm.salestarget.utils.SalesMonthTargetUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.ValidateUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class SalesTargetUtil {
    public static void validateAddParam(SalesTargetVo salesTargetVo) {
        ValidateUtils.validate((Object)salesTargetVo.getCusCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)salesTargetVo.getCusName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)salesTargetVo.getCusOrgCode(), (String)"\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)salesTargetVo.getCusOrgName(), (String)"\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)salesTargetVo.getCusChannelCode(), (String)"\u5ba2\u6237\u6240\u5c5e\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)salesTargetVo.getCusChannelName(), (String)"\u5ba2\u6237\u6240\u5c5e\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)salesTargetVo.getTargetYear(), (String)"\u76ee\u6807\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)salesTargetVo.getType(), (String)"\u9500\u91cf\u76ee\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        if (salesTargetVo.getType().intValue() == SalesTargetEunm.type.PRODUCTLQVEL.getCode().intValue()) {
            ValidateUtils.validate((Object)salesTargetVo.getProductLevelCode(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)salesTargetVo.getProductLevelName(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (salesTargetVo.getType().intValue() == SalesTargetEunm.type.GOODS.getCode().intValue()) {
            ValidateUtils.validate((Object)salesTargetVo.getGoodsCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)salesTargetVo.getGoodsName(), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    public static void validateParamForAddBatch(List<SalesTargetVo> salesTargetVos) {
        if (CollectionUtils.isEmpty(salesTargetVos)) {
            return;
        }
        Integer type2 = salesTargetVos.get(0).getType();
        if (!CollectionUtils.isEmpty((Collection)salesTargetVos.stream().filter(vo -> type2.intValue() != vo.getType().intValue()).collect(Collectors.toList()))) {
            throw new BusinessException("\u6682\u4e0d\u652f\u6301\u8de8\u76ee\u6807\u7c7b\u578b\u6279\u91cf\u64cd\u4f5c\uff01");
        }
        String cusCode = salesTargetVos.get(0).getCusCode();
        if (!CollectionUtils.isEmpty((Collection)salesTargetVos.stream().filter(vo -> !vo.getCusCode().equals(cusCode)).collect(Collectors.toList()))) {
            throw new BusinessException("\u6682\u65f6\u4ec5\u652f\u6301\u540c\u4e00\u4e2a\u5ba2\u6237\u6279\u91cf\u64cd\u4f5c\uff01");
        }
        for (SalesTargetVo vo2 : salesTargetVos) {
            SalesTargetUtil.validateAddParam(vo2);
        }
        HashMap<String, String> map = new HashMap<String, String>(salesTargetVos.size());
        for (SalesTargetVo vo3 : salesTargetVos) {
            String key = "";
            String repeat = "";
            if (vo3.getType().intValue() == SalesTargetEunm.type.GOODS.getCode().intValue()) {
                key = vo3.getGoodsCode() + vo3.getTargetYear();
                repeat = vo3.getGoodsName();
            } else if (vo3.getType().intValue() == SalesTargetEunm.type.PRODUCTLQVEL.getCode().intValue()) {
                key = vo3.getProductLevelCode() + vo3.getTargetYear();
                repeat = vo3.getProductLevelName();
            } else {
                key = vo3.getTargetYear().toString();
            }
            if (map.get(key) != null) {
                StringBuilder msg = new StringBuilder("\u76ee\u6807\u91cd\u590d");
                if (!StringUtils.isEmpty((String)repeat)) {
                    msg.append(",\u4ea7\u54c1/\u4ea7\u54c1\u5c42\u7ea7:").append(repeat);
                }
                msg.append(",\u76ee\u6807\u5e74\u4efd:").append(vo3.getTargetYear());
                throw new BusinessException(msg.toString());
            }
            map.put(key, key);
        }
    }

    public static SalesTargetEntity packageEntityForAdd(SalesTargetVo vo) {
        SalesTargetEntity entity = new SalesTargetEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
        entity.setId(UUIDGenerator.generate());
        if (vo.getType().intValue() == SalesTargetEunm.type.PRODUCTLQVEL.getCode().intValue()) {
            entity.setGoodsCode(null);
            entity.setGoodsName(null);
            entity.setProductSpec(null);
            entity.setOnlyKey(vo.getProductLevelCode() + "," + vo.getTargetYear());
        }
        if (vo.getType().intValue() == SalesTargetEunm.type.ROUTINE.getCode().intValue()) {
            entity.setGoodsCode(null);
            entity.setGoodsName(null);
            entity.setProductSpec(null);
            entity.setProductLevelCode(null);
            entity.setProductLevelName(null);
            entity.setOnlyKey(vo.getTargetYear().toString());
        }
        if (vo.getType().intValue() == SalesTargetEunm.type.GOODS.getCode().intValue()) {
            entity.setOnlyKey(vo.getGoodsCode() + "," + vo.getTargetYear());
        }
        entity.setTargetNum(SalesMonthTargetUtil.countTargetNum(vo.getSalesMonthTargetVo()));
        return entity;
    }
}

