/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BeanCopyUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanCopyUtil.class);

    public static T copyBen(Object source, Class<T> cls) {
        if (source == null) {
            return null;
        }
        T target = null;
        try {
            target = cls.newInstance();
            BeanUtils.copyProperties((Object)source, (Object)target);
        }
        catch (InstantiationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        ValidateUtils.validate((Object)target, (String)"\u5bf9\u8c61\u62f7\u8d1d\u5931\u8d25");
        return target;
    }

    public static Collection<T> copyCollection(Collection source, Class<T> cls) {
        if (!CollectionUtil.collectionNotEmpty((Collection)source)) {
            return CollectionUtils.emptyCollection();
        }
        ArrayList list = Lists.newArrayList();
        source.forEach(f -> list.add(BeanCopyUtil.copyBen(f, cls)));
        return list;
    }
}

