/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemProductVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemVo;
import com.biz.crm.repfeepool.entity.RepFeePoolItemProductEntity;
import com.biz.crm.repfeepool.mapper.RepFeePoolItemProductMapper;
import com.biz.crm.repfeepool.service.RepFeePoolItemProductService;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service(value="repFeePoolItemProductService")
@ConditionalOnMissingBean(name={"repFeePoolItemProductServiceImpl"})
public class RepFeePoolItemProductServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RepFeePoolItemProductMapper, RepFeePoolItemProductEntity>
implements RepFeePoolItemProductService {
    @Override
    public void createAll(List<RepFeePoolItemProductVo> vos) {
        ValidateUtils.notEmpty(vos, (String)"\u65b0\u589e\u660e\u7ec6\u5173\u8054\u4ea7\u54c1\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        vos.forEach(vo -> FieldHandleUtil.initCreateFields(vo));
        List<RepFeePoolItemProductEntity> entities = new BeanCopyUtil<RepFeePoolItemProductEntity>().copyList(vos, RepFeePoolItemProductEntity.class);
        this.saveBatch(entities);
    }

    @Override
    public void createAll(RepFeePoolItemVo itemVo, List<RepFeePoolItemProductVo> repFeePoolItemProductVos) {
        ValidateUtils.validate((Object)itemVo, (String)"\u65b0\u589e\u660e\u7ec6\u5173\u8054\u4ea7\u54c1\u65f6\uff0c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList productVos = Lists.newArrayList();
        if (CollectionUtil.listEmpty(repFeePoolItemProductVos)) {
            RepFeePoolItemProductVo productVo = new RepFeePoolItemProductVo();
            productVo.setCostPrice(itemVo.getCostPrice());
            productVo.setProductCode(itemVo.getProductCode());
            productVo.setSalePrice(itemVo.getSalePrice());
            productVo.setProductName(itemVo.getProductName());
            productVo.setRepFeePoolItemCode(itemVo.getCode());
            productVos.add(productVo);
        } else {
            productVos.addAll(repFeePoolItemProductVos);
        }
        this.createAll(productVos);
    }
}

