/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BeanCopyUtil<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanCopyUtil.class);

    public T copyBen(Object source, Class<T> cls) {
        if (source == null) {
            return null;
        }
        T target = null;
        try {
            target = cls.newInstance();
            BeanUtils.copyProperties((Object)source, target);
        }
        catch (InstantiationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        ValidateUtils.validate(target, (String)"\u5bf9\u8c61\u62f7\u8d1d\u5931\u8d25");
        return target;
    }

    public List<T> copyList(Collection source, Class<T> cls) {
        if (!CollectionUtil.collectionNotEmpty((Collection)source)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        source.forEach(f -> list.add(this.copyBen(f, cls)));
        return list;
    }
}

