/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebatefeepool.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolDetailLogVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolDetailVo;
import com.biz.crm.rebatefeepool.entity.RebateFeePoolDetailLogEntity;
import com.biz.crm.rebatefeepool.mapper.RebateFeePoolDetailLogMapper;
import com.biz.crm.rebatefeepool.service.RebateFeePoolDetailLogService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolDetailService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolFileService;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolDetailLogUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.ValidateUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rebateFeePoolDetailLogService")
@ConditionalOnMissingBean(name={"rebateFeePoolDetailLogServiceImpl"})
public class RebateFeePoolDetailLogServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateFeePoolDetailLogMapper, RebateFeePoolDetailLogEntity>
implements RebateFeePoolDetailLogService {
    @Resource
    private RebateFeePoolDetailLogMapper rebateFeePoolDetailLogMapper;
    @Resource
    private RebateFeePoolFileService rebateFeePoolFileService;
    @Resource
    private RebateFeePoolDetailService rebateFeePoolDetailService;

    @Override
    @Transactional
    public void create(RebateFeePoolDetailLogVo rebateFeePoolDetailLogVo) {
        RebateFeePoolDetailLogUtil.validate(rebateFeePoolDetailLogVo);
        FieldHandleUtil.initCreateFields(rebateFeePoolDetailLogVo);
        rebateFeePoolDetailLogVo.setCode(CodeUtil.getCode());
        RebateFeePoolDetailLogEntity rebateFeePoolDetailLogEntity = new RebateFeePoolDetailLogEntity();
        BeanUtils.copyProperties((Object)rebateFeePoolDetailLogVo, (Object)((Object)rebateFeePoolDetailLogEntity));
        this.setAmounts(rebateFeePoolDetailLogEntity);
        this.rebateFeePoolDetailLogMapper.insert((Object)rebateFeePoolDetailLogEntity);
        List files = rebateFeePoolDetailLogVo.getFiles();
        if (!CollectionUtils.isEmpty((Collection)files)) {
            files.forEach(f -> f.setRebateFeePoolDetailLogCode(rebateFeePoolDetailLogEntity.getCode()));
            this.rebateFeePoolFileService.createAll(files);
        }
    }

    private void setAmounts(RebateFeePoolDetailLogEntity entity) {
        Integer adjustType = entity.getAdjustType();
        int type = RebateFeePoolDetailLogUtil.AdjustTypeEnum.getType(adjustType);
        RebateFeePoolDetailVo detail = this.rebateFeePoolDetailService.findByDetailCode(entity.getRebateFeePoolDetailCode());
        ValidateUtils.validate((Object)detail, (String)"\u65b0\u589e\u65e5\u5fd7\u65f6\u6ca1\u6709\u83b7\u53d6\u5230\u5176\u5173\u8054\u7684\u6761\u76ee\u8bb0\u5f55");
        entity.setAvailableFee(detail.getItemAvailableBalance());
        switch (type) {
            case 0: {
                entity.setOnAccountFee(BigDecimal.ZERO);
                entity.setUsedFee(entity.getAdjustFee());
                break;
            }
            case 1: {
                entity.setOnAccountFee(entity.getAdjustFee());
                entity.setUsedFee(BigDecimal.ZERO);
                break;
            }
            case 2: {
                entity.setOnAccountFee(BigDecimal.ZERO);
                entity.setUsedFee(BigDecimal.ZERO);
                break;
            }
            case 3: {
                entity.setOnAccountFee(BigDecimal.ZERO);
                entity.setUsedFee(entity.getAdjustFee().multiply(BigDecimal.valueOf(-1.0)));
                break;
            }
            default: {
                throw new BusinessException("\u65b0\u589e\u6298\u6263\u8d39\u7528\u6c60\u6761\u76ee\u65e5\u5fd7\u65f6\uff0c\u68c0\u6d4b\u5230\u8c03\u6574\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
        }
    }

    @Override
    public PageResult<RebateFeePoolDetailLogVo> findPageByConditions(RebateFeePoolDetailLogVo param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        String rebateFeePoolDetailCode = param.getRebateFeePoolDetailCode();
        String rebateFeePoolCode = param.getRebateFeePoolCode();
        RebateFeePoolDetailVo rebateFeePoolDetailVo = this.rebateFeePoolDetailService.findByDetailCode(rebateFeePoolDetailCode);
        Integer adjustType = param.getAdjustType();
        List<RebateFeePoolDetailLogVo> list = this.rebateFeePoolDetailLogMapper.findPageByConditions((Page<RebateFeePoolDetailLogVo>)page, rebateFeePoolDetailCode, adjustType, rebateFeePoolCode);
        if (CollectionUtils.isEmpty(list)) {
            return PageResult.builder().build();
        }
        list.forEach(l -> {
            l.setRebateFeePoolDetailVo(rebateFeePoolDetailVo);
            l.setAdjustTypeName(RebateFeePoolDetailLogUtil.AdjustTypeEnum.getDesc(l.getAdjustType()));
            l.setFiles(this.rebateFeePoolFileService.findByLogCode(l.getCode()));
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public RebateFeePoolDetailVo frozen(RebateFeePoolDetailLogVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u51bb\u7ed3\u6216\u8005\u89e3\u51bb\u6761\u76ee\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.validate((Object)vo.getRebateFeePoolDetailCode(), (String)"\u51bb\u7ed3\u6216\u8005\u89e3\u51bb\u6761\u76ee\u65f6\uff0c\u8d39\u7528\u6c60\u6761\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.isTrue((Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.FROZEN.getCode(), vo.getAdjustType()) || Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode(), vo.getAdjustType()) ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u6216\u8005\u89e3\u51bb\u6761\u76ee\u65f6\uff0c\u8c03\u6574\u7c7b\u578b\u53ea\u80fd\u65f6\u51bb\u7ed3\u6216\u8005\u89e3\u51bb", (String[])new String[0]);
        RebateFeePoolDetailVo detailVo = this.rebateFeePoolDetailService.findByDetailCode(vo.getRebateFeePoolDetailCode());
        ValidateUtils.validate((Object)detailVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u6761\u76ee\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u6761\u76ee\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u9012");
        detailVo.setAdjustFrozenFee(vo.getFrozenFee());
        if (Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.FROZEN.getCode(), vo.getAdjustType())) {
            ValidateUtils.isTrue((detailVo.getItemAvailableBalance().compareTo(vo.getFrozenFee()) >= 0 ? 1 : 0) != 0, (String)"\u6761\u76ee\u53ef\u7528\u91d1\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u51bb\u7ed3", (String[])new String[0]);
            detailVo.setItemFrozenFee(detailVo.getItemFrozenFee().add(vo.getFrozenFee()));
            detailVo.setItemAvailableBalance(detailVo.getItemAvailableBalance().subtract(vo.getFrozenFee()));
        } else if (Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode(), vo.getAdjustType())) {
            ValidateUtils.isTrue((detailVo.getItemFrozenFee().compareTo(vo.getFrozenFee()) >= 0 ? 1 : 0) != 0, (String)"\u6761\u76ee\u51bb\u7ed3\u91d1\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u89e3\u51bb", (String[])new String[0]);
            detailVo.setItemFrozenFee(detailVo.getItemTotalFee().subtract(vo.getFrozenFee()));
            detailVo.setItemAvailableBalance(detailVo.getItemAvailableBalance().add(vo.getFrozenFee()));
        } else {
            throw new BusinessException("\u8c03\u6574\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u53ea\u5141\u8bb8\u4f20\u5165\u51bb\u7ed3\u6216\u8005\u89e3\u51bb");
        }
        this.rebateFeePoolDetailService.update(detailVo);
        return detailVo;
    }
}

