/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolVo;
import com.biz.crm.rebatefeepool.entity.RebateFeePoolEntity;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolDetailLogUtil;
import com.biz.crm.repfeepool.entity.RepFeePoolEntity;
import com.biz.crm.repfeepool.mapper.RepFeePoolMapper;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailService;
import com.biz.crm.repfeepool.service.RepFeePoolItemService;
import com.biz.crm.repfeepool.service.RepFeePoolService;
import com.biz.crm.repfeepool.utils.RepFeePoolItemDetailUtil;
import com.biz.crm.repfeepool.utils.RepFeePoolUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="repFeePoolService")
@ConditionalOnMissingBean(name={"repFeePoolServiceImpl"})
public class RepFeePoolServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RepFeePoolMapper, RepFeePoolEntity>
implements RepFeePoolService {
    @Resource
    private RepFeePoolMapper repFeePoolMapper;
    @Resource
    private RepFeePoolItemService repFeePoolItemService;
    @Resource
    private RepFeePoolIItemDetailService repFeePoolIItemDetailService;

    @Override
    @Transactional
    public Map<String, Boolean> subtractBalance(RepFeePoolVo vo) {
        throw new BusinessException("\u8be5\u529f\u80fd\u6682\u672a\u63d0\u4f9b");
    }

    @Override
    @Transactional
    public Map<String, BigDecimal> subtractBalanceFree(RepFeePoolVo vo) {
        return this.subtractOrRedTrickCount(vo);
    }

    private Map<String, BigDecimal> subtractOrRedTrickCount(RepFeePoolVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.validate((Object)vo.getUniqueDictCode(), (String)"\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.notEmpty((Collection)vo.getRepFeePoolItemVos(), (String)"\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        TreeMap result = Maps.newTreeMap();
        QueryWrapper<RebateFeePoolEntity> wrapper = RepFeePoolUtil.buildUniqueWrapperParam(vo);
        List repFeePoolEntities = this.repFeePoolMapper.selectList((Wrapper)wrapper);
        ValidateUtils.notEmpty((Collection)repFeePoolEntities, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8d39\u7528\u6c60\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u662f\u5426\u4f20\u9012\u6b63\u786e");
        ValidateUtils.isTrue((repFeePoolEntities.size() == 1 ? 1 : 0) != 0, (String)"\u83b7\u53d6\u5230\u591a\u6761\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u662f\u5426\u4f20\u9012\u6b63\u786e", (String[])new String[0]);
        RepFeePoolEntity repFeePoolEntity = (RepFeePoolEntity)((Object)repFeePoolEntities.get(0));
        List<RepFeePoolItemVo> itemVos = this.repFeePoolItemService.findByPoolCode(repFeePoolEntity.getCode());
        ValidateUtils.notEmpty(itemVos, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8d39\u7528\u6c60\u660e\u7ec6\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4e0a\u8fc7\u8d26");
        HashMap itemVoMap = Maps.newHashMap();
        itemVos.forEach(item -> itemVoMap.put(item.getProductCode(), item));
        HashSet productCodes = Sets.newHashSet();
        vo.getRepFeePoolItemVos().forEach(v -> productCodes.add(v.getProductCode()));
        ValidateUtils.isTrue((productCodes.size() == vo.getRepFeePoolItemVos().size() ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u6bcf\u6761\u660e\u7ec6\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (String[])new String[0]);
        for (RepFeePoolItemVo item2 : vo.getRepFeePoolItemVos()) {
            BigDecimal reducer;
            RepFeePoolItemVo dbItem = (RepFeePoolItemVo)itemVoMap.get(item2.getProductCode());
            if (dbItem == null) {
                result.put(item2.getProductCode(), item2.getSubtractCount());
                continue;
            }
            List<RepFeePoolItemDetailVo> detailVos = this.repFeePoolIItemDetailService.findByItemCodeAndDictRule(dbItem.getCode(), item2.getIndexDictCode());
            if (CollectionUtil.listEmpty(detailVos)) {
                result.put(item2.getProductCode(), item2.getSubtractCount());
                continue;
            }
            switch (RebateFeePoolDetailLogUtil.AdjustTypeEnum.getType(item2.getAdjustCountType())) {
                case 0: {
                    reducer = this.computeSubtractCount(item2, detailVos);
                    break;
                }
                case 3: {
                    reducer = this.computeRedTrickCount(item2, detailVos);
                    break;
                }
                default: {
                    throw new BusinessException("\u8c03\u6574\u72b6\u6001[adjustCountType]\u4e0d\u6b63\u786e\uff0c\u51b2\u9500\u8bf7\u4f206\uff0c\u6263\u51cf\u8bf7\u4f203\u62167");
                }
            }
            result.put(item2.getProductCode(), reducer);
            dbItem.setDetailVos(detailVos);
            this.repFeePoolItemService.adjust(dbItem);
        }
        return result;
    }

    private BigDecimal computeRedTrickCount(RepFeePoolItemVo item, List<RepFeePoolItemDetailVo> detailVos) {
        BigDecimal reducer = item.getSubtractCount();
        for (RepFeePoolItemDetailVo detail : detailVos) {
            if (reducer.compareTo(BigDecimal.ZERO) < 1) continue;
            detail.setAdjustCountType(item.getAdjustCountType());
            detail.setRemarks(item.getRemarks());
            detail.setResourceCode(item.getResourceCode());
            detail.setFiles(item.getFiles());
            if (detail.getUsedCount().compareTo(reducer) > -1) {
                detail.setAdjustCount(reducer);
                reducer = BigDecimal.ZERO;
                continue;
            }
            detail.setAdjustFee(detail.getUsedCount());
            reducer = reducer.subtract(detail.getUsedCount());
        }
        return reducer;
    }

    private BigDecimal computeSubtractCount(RepFeePoolItemVo item, List<RepFeePoolItemDetailVo> detailVos) {
        Iterator<RepFeePoolItemDetailVo> iterator = detailVos.iterator();
        BigDecimal reducer = item.getSubtractCount();
        while (iterator.hasNext()) {
            RepFeePoolItemDetailVo detail = iterator.next();
            if (reducer.compareTo(BigDecimal.ZERO) < 1) continue;
            detail.setAdjustCountType(item.getAdjustCountType());
            detail.setRemarks(item.getRemarks());
            detail.setResourceCode(item.getResourceCode());
            detail.setFiles(item.getFiles());
            if (detail.getAvailableCount().compareTo(reducer) > -1) {
                detail.setAdjustCount(reducer);
                reducer = BigDecimal.ZERO;
                continue;
            }
            detail.setAdjustCount(detail.getAvailableCount());
            reducer = reducer.subtract(detail.getAvailableCount());
        }
        return reducer;
    }

    @Override
    @Transactional
    public Map<String, BigDecimal> redTrick(RepFeePoolVo vo) {
        return this.subtractOrRedTrickCount(vo);
    }

    @Override
    @Transactional
    public void onAccount(RepFeePoolVo vo) {
        RepFeePoolEntity entity;
        RepFeePoolUtil.validate(vo);
        ValidateUtils.notEmpty((Collection)vo.getRepFeePoolItemVos(), (String)"\u4e0a\u8d26\u65f6\uff0c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper<RebateFeePoolEntity> wrapper = RepFeePoolUtil.buildUniqueWrapperParam(vo);
        List entities = this.repFeePoolMapper.selectList((Wrapper)wrapper);
        BigDecimal totalFee = BigDecimal.ZERO;
        BigDecimal totalCount = BigDecimal.ZERO;
        for (RepFeePoolItemVo item : vo.getRepFeePoolItemVos()) {
            FieldHandleUtil.initDecimalZero(item);
            item.setRepFeePoolCode(vo.getCode());
            this.computeOnAccountFeeByCount(item);
            totalFee = totalFee.add(item.getOnAccountFee());
            totalCount = totalCount.add(item.getOnAccountCount());
        }
        if (CollectionUtil.listEmpty((List)entities)) {
            entity = new RepFeePoolEntity();
            FieldHandleUtil.initCreateFields(vo);
            BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
            entity.setCode(CodeUtil.getCode());
            entity.setTotalCount(totalCount);
            entity.setTotalFee(totalFee);
            this.repFeePoolMapper.insert((Object)entity);
        } else {
            ValidateUtils.isTrue((entities.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636e\u552f\u4e00\u7ea6\u675f\u5b57\u6bb5\u67e5\u51fa\u591a\u6761\u8d27\u8865\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u662f\u5426\u8bbe\u7f6e\u6b63\u786e", (String[])new String[0]);
            entity = (RepFeePoolEntity)((Object)entities.get(0));
            FieldHandleUtil.initUpdateFields((Object)entity);
            entity.setTotalCount(totalCount);
            entity.setTotalFee(totalFee);
            this.repFeePoolMapper.updateById((Object)entity);
        }
        vo.getRepFeePoolItemVos().forEach(v -> {
            v.setRepFeePoolCode(entity.getCode());
            v.setPayType(RepFeePoolItemDetailUtil.PayTypeEnum.REP.getCode());
        });
        this.repFeePoolItemService.onCountItems(vo.getRepFeePoolItemVos());
        this.summaryItems(entity.getCode());
    }

    private void computeOnAccountFeeByCount(RepFeePoolItemVo item) {
        ValidateUtils.validate((Object)item.getAdjustCountType(), (String)"\u4e0a\u8d26\u65f6\uff0c\u8c03\u6574\u6570\u91cf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)item.getCostPrice(), (String)"\u4e0a\u8d26\u65f6\uff0c\u6210\u672c\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)item.getOnAccountCount(), (String)"\u4e0a\u8d26\u65f6\uff0c\u4e0a\u8d26\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        item.setAdjustFeeType(item.getAdjustCountType());
        ValidateUtils.isTrue((item.getOnAccountCount().compareTo(BigDecimal.ZERO) > -1 ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u65f6\uff0c\u4e0a\u8d26\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0", (String[])new String[0]);
        ValidateUtils.isTrue((item.getCostPrice().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u65f6\uff0c\u6210\u672c\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0", (String[])new String[0]);
        item.setOnAccountFee(item.getOnAccountCount().multiply(item.getCostPrice()));
    }

    @Override
    @Transactional
    public void summaryItems(String repFeePoolCode) {
        ValidateUtils.validate((Object)repFeePoolCode, (String)"\u6c47\u603b\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u8d27\u8865\u8d39\u7528\u6c60\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"code", (Object)repFeePoolCode);
        RepFeePoolEntity entity = (RepFeePoolEntity)((Object)this.repFeePoolMapper.selectOne((Wrapper)wrapper));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u6c47\u603b\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u8d27\u8865\u8d39\u7528\u6c60\u539f\u59cb\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4f20\u5165\u6b63\u786e\u7684\u8d27\u8865\u8d39\u7528\u6c60\u7f16\u7801");
        List<RepFeePoolItemVo> items = this.repFeePoolItemService.findByPoolCode(repFeePoolCode);
        if (CollectionUtil.listEmpty(items)) {
            return;
        }
        BigDecimal totalCount = BigDecimal.ZERO;
        BigDecimal totalFee = BigDecimal.ZERO;
        for (RepFeePoolItemVo item : items) {
            totalCount = totalCount.add(item.getOnAccountCount());
            totalFee = totalFee.add(item.getOnAccountFee());
        }
        entity.setTotalFee(totalFee);
        entity.setTotalCount(totalCount);
        this.repFeePoolMapper.updateById((Object)entity);
    }

    @Override
    public PageResult<RepFeePoolVo> findPageByConditions(RepFeePoolVo param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        List<RepFeePoolVo> list = this.repFeePoolMapper.findPageByConditions((Page<RepFeePoolVo>)page, param.getCusName(), param.getCusOrgName(), param.getCusChannelName());
        if (CollectionUtil.listEmpty(list)) {
            return PageResult.builder().build();
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

