/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailLogVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailVo;
import com.biz.crm.repfeepool.entity.RepFeePoolItemDetailEntity;
import com.biz.crm.repfeepool.mapper.RepFeePoolItemDetailMapper;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailLogService;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailService;
import com.biz.crm.repfeepool.utils.RepFeePoolItemDetailLogUtil;
import com.biz.crm.repfeepool.utils.RepFeePoolItemDetailUtil;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="repFeePoolItemDetailService")
@ConditionalOnMissingBean(name={"repFeePoolItemDetailServiceImpl"})
public class RepFeePoolIItemDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RepFeePoolItemDetailMapper, RepFeePoolItemDetailEntity>
implements RepFeePoolIItemDetailService {
    @Resource
    private RepFeePoolItemDetailMapper repFeePoolItemDetailMapper;
    @Resource
    private RepFeePoolIItemDetailLogService repFeePoolIItemDetailLogService;

    @Override
    @Transactional
    public void create(RepFeePoolItemDetailVo detailVo) {
        RepFeePoolItemDetailUtil.validate(detailVo);
        ValidateUtils.isTrue((detailVo.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u4e0d\u80fd\u5b58\u5728id\u503c", (String[])new String[0]);
        if (detailVo.getAdjustCountType() != null) {
            ValidateUtils.isTrue((RepFeePoolItemDetailLogUtil.AdjustTypeEnum.getType(detailVo.getAdjustCountType()) == 1 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6761\u76ee\uff0c\u8c03\u6574\u7c7b\u578b\u53ea\u80fd\u662f\u4e0a\u8d26\u7c7b\uff0c\u5305\u542b\u671f\u521d\u3001\u624b\u52a8\u4e0a\u8d26\u3001\u8d39\u7528\u4e0a\u8d26\u3001\u8fd4\u5229\u4e0a\u8d26\u7b49", (String[])new String[0]);
        }
        if (detailVo.getAdjustFeeType() != null) {
            ValidateUtils.isTrue((RepFeePoolItemDetailLogUtil.AdjustTypeEnum.getType(detailVo.getAdjustFeeType()) == 1 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6761\u76ee\uff0c\u8c03\u6574\u7c7b\u578b\u53ea\u80fd\u662f\u4e0a\u8d26\u7c7b\uff0c\u5305\u542b\u671f\u521d\u3001\u624b\u52a8\u4e0a\u8d26\u3001\u8d39\u7528\u4e0a\u8d26\u3001\u8fd4\u5229\u4e0a\u8d26\u7b49", (String[])new String[0]);
        }
        detailVo.setCode(CodeUtil.getCode());
        RepFeePoolItemDetailEntity entity = new RepFeePoolItemDetailEntity();
        BeanUtils.copyProperties((Object)detailVo, (Object)((Object)entity));
        FieldHandleUtil.initCreateFields((Object)entity);
        entity.setRemarks(null);
        this.repFeePoolItemDetailMapper.insert((Object)entity);
        RepFeePoolItemDetailLogVo logVo = new RepFeePoolItemDetailLogVo();
        logVo.setFiles(detailVo.getFiles());
        logVo.setAdjustCount(detailVo.getOnAccountCount());
        logVo.setAdjustCountType(detailVo.getAdjustCountType());
        logVo.setAdjustFee(detailVo.getOnAccountFee());
        logVo.setAdjustFeeType(detailVo.getAdjustFeeType());
        logVo.setPayType(detailVo.getPayType());
        logVo.setRepFeePoolItemDetailCode(entity.getCode());
        logVo.setRemarks(detailVo.getRemarks());
        this.repFeePoolIItemDetailLogService.create(logVo);
    }

    @Override
    @Transactional
    public void createAll(List<RepFeePoolItemDetailVo> createItems) {
        ValidateUtils.notEmpty(createItems, (String)"\u6279\u91cf\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165", (String[])new String[0]);
        createItems.forEach(item -> this.create((RepFeePoolItemDetailVo)item));
    }

    @Override
    @Transactional
    public void updateAll(List<RepFeePoolItemDetailVo> updateItems) {
        ValidateUtils.notEmpty(updateItems, (String)"\u6279\u91cf\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165", (String[])new String[0]);
        updateItems.forEach(item -> this.update((RepFeePoolItemDetailVo)item));
    }

    @Override
    @Transactional
    public void update(RepFeePoolItemDetailVo detail) {
        RepFeePoolItemDetailUtil.validate(detail);
        ValidateUtils.isTrue((detail.getId() != null ? 1 : 0) != 0, (String)"\u4fee\u6539\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u5fc5\u987b\u5b58\u5728id\u503c", (String[])new String[0]);
        RepFeePoolItemDetailEntity entity = (RepFeePoolItemDetailEntity)((Object)this.repFeePoolItemDetailMapper.selectById((Serializable)((Object)detail.getId())));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u4fee\u6539\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8bb0\u5f55");
        FieldHandleUtil.initDecimalZero(detail);
        if (Objects.equals(entity.getOnAccountCount().setScale(6, 0), detail.getOnAccountCount().setScale(6, 0)) && Objects.equals(entity.getUsedCount().setScale(6, 0), detail.getUsedCount().setScale(6, 0)) && Objects.equals(entity.getFrozenCount().setScale(6, 0), detail.getFrozenCount().setScale(6, 0)) && Objects.equals(entity.getAvailableCount().setScale(6, 0), detail.getAvailableCount().setScale(6, 0)) && Objects.equals(entity.getOnAccountFee().setScale(6, 0), detail.getOnAccountFee().setScale(6, 0)) && Objects.equals(entity.getUsedFee().setScale(6, 0), detail.getUsedFee().setScale(6, 0)) && Objects.equals(entity.getFrozenFee().setScale(6, 0), detail.getFrozenFee().setScale(6, 0)) && Objects.equals(entity.getAvailableFee().setScale(6, 0), detail.getAvailableFee().setScale(6, 0))) {
            return;
        }
        if (detail.getAdjustCountType() == null || detail.getAdjustFeeType() == null) {
            return;
        }
        entity.setOnAccountCount(detail.getOnAccountCount());
        entity.setUsedCount(detail.getUsedCount());
        entity.setFrozenCount(detail.getFrozenCount());
        entity.setAvailableCount(detail.getAvailableCount());
        entity.setOnAccountFee(detail.getOnAccountFee());
        entity.setUsedFee(detail.getUsedFee());
        entity.setFrozenFee(detail.getFrozenFee());
        entity.setAvailableFee(detail.getAvailableFee());
        entity.setPayType(detail.getPayType());
        entity.setUnit(detail.getUnit());
        FieldHandleUtil.initUpdateFields((Object)entity);
        this.repFeePoolItemDetailMapper.updateById((Object)entity);
        RepFeePoolItemDetailLogVo logVo = new RepFeePoolItemDetailLogVo();
        logVo.setFiles(detail.getFiles());
        logVo.setAdjustCount(detail.getAdjustCount());
        logVo.setAdjustCountType(detail.getAdjustCountType());
        logVo.setAdjustFee(detail.getAdjustFee());
        logVo.setFrozenFee(detail.getAdjustFrozenFee());
        logVo.setAdjustFeeType(detail.getAdjustFeeType());
        logVo.setPayType(detail.getPayType());
        logVo.setRepFeePoolItemDetailCode(entity.getCode());
        logVo.setRemarks(detail.getRemarks());
        this.repFeePoolIItemDetailLogService.create(logVo);
    }

    @Override
    public PageResult<RepFeePoolItemDetailVo> findPageByConditions(RepFeePoolItemDetailVo param) {
        Page page;
        List<RepFeePoolItemDetailVo> list;
        if (param == null) {
            param = new RepFeePoolItemDetailVo();
        }
        if (CollectionUtil.listEmpty(list = this.repFeePoolItemDetailMapper.findPageByConditions((Page<RepFeePoolItemDetailVo>)(page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue())), param.getRepFeePoolItemCode()))) {
            return PageResult.builder().data((List)Lists.newArrayList()).build();
        }
        list.forEach(l -> l.setPayTypeName(RepFeePoolItemDetailUtil.PayTypeEnum.getDesc(l.getPayType())));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public RepFeePoolItemDetailVo findByDetailCode(String repFeePoolItemDetailCode) {
        if (StringUtils.isEmpty((String)repFeePoolItemDetailCode)) {
            return null;
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"code", (Object)repFeePoolItemDetailCode);
        RepFeePoolItemDetailEntity entity = (RepFeePoolItemDetailEntity)((Object)this.repFeePoolItemDetailMapper.selectOne((Wrapper)wrapper));
        if (entity == null) {
            return null;
        }
        RepFeePoolItemDetailVo vo = new RepFeePoolItemDetailVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        return vo;
    }

    @Override
    public List<RepFeePoolItemDetailVo> findByItemCodeAndDictRule(String itemCode, String indexDictCode) {
        if (StringUtils.isEmpty((String)itemCode) || StringUtils.isEmpty((String)indexDictCode)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"rep_fee_pool_item_code", (Object)itemCode);
        wrapper = FieldHandleUtil.buildIndexByIndexDictCode(wrapper, indexDictCode);
        List entities = this.repFeePoolItemDetailMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        return BeanCopyUtil.copyList(entities, RepFeePoolItemDetailVo.class);
    }
}

