/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.contract.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.contract.entity.ContractEntity;
import com.biz.crm.contract.entity.ContractFileEntity;
import com.biz.crm.contract.mapper.ContractFileMapper;
import com.biz.crm.contract.service.ContractFileService;
import com.biz.crm.nebular.dms.contract.ContractFileVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"contractFileServiceExpandImpl"})
@Service(value="contractFileService")
public class ContractFileServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<ContractFileMapper, ContractFileEntity>
implements ContractFileService {
    @Autowired
    private ContractFileMapper contractFileMapper;

    @Override
    @Transactional
    public void replace(final ContractEntity contractEntity, List<ContractFileVo> files) {
        this.removeByMap(new HashMap<String, Object>(){
            {
                this.put("contract_id", contractEntity.getId());
            }
        });
        if (CollectionUtils.isEmpty(files)) {
            return;
        }
        ArrayList<ContractFileEntity> entities = new ArrayList<ContractFileEntity>(files.size());
        int i = 1;
        for (ContractFileVo vo : files) {
            vo.setSortNum(Integer.valueOf(++i));
            ContractFileEntity entity = new ContractFileEntity();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
            entity.setContractId(contractEntity.getId());
            entities.add(entity);
        }
        this.saveBatch(entities);
    }

    @Override
    public List<ContractFileVo> findByContractId(String contractId) {
        if (StringUtils.isEmpty((Object)contractId)) {
            return new ArrayList<ContractFileVo>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        List fileEntities = this.contractFileMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)fileEntities)) {
            return new ArrayList<ContractFileVo>();
        }
        ArrayList<ContractFileVo> fileVos = new ArrayList<ContractFileVo>(fileEntities.size());
        for (ContractFileEntity entity : fileEntities) {
            ContractFileVo fileVo = new ContractFileVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)fileVo);
            fileVos.add(fileVo);
        }
        Collections.sort(fileVos, (a, b) -> a.getSortNum().compareTo(b.getSortNum()));
        return fileVos;
    }
}

