/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.contract.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.contract.entity.ContractEntity;
import com.biz.crm.contract.mapper.ContractMapper;
import com.biz.crm.contract.service.ContractFileService;
import com.biz.crm.contract.service.ContractSalesAreaService;
import com.biz.crm.contract.service.ContractService;
import com.biz.crm.nebular.dms.contract.ContractVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import io.jsonwebtoken.lang.Collections;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"contractServiceExpandImpl"})
@Service(value="contractService")
public class ContractServiceImpl<M extends BaseMapper<T>, T>
implements ContractService {
    @Resource
    private ContractMapper contractMapper;
    @Resource
    private ContractFileService contractFileService;
    @Resource
    private ContractSalesAreaService contractSalesAreaService;

    @Override
    @Transactional
    public void add(final ContractVo contractVo) {
        ValidateUtils.validate((Object)contractVo.getType(), (String)"\u8bf7\u6307\u5b9a\u5408\u540c\u7c7b\u578b");
        ValidateUtils.validate((Object)contractVo.getYear(), (String)"\u8bf7\u6307\u5b9a\u5408\u540c\u5e74\u5ea6");
        ValidateUtils.validate((Object)contractVo.getCode(), (String)"\u8bf7\u8f93\u5165\u5408\u540c\u7f16\u53f7\u540e\u518d\u63d0\u4ea4");
        ValidateUtils.validate((Object)contractVo.getCusCode(), (String)"\u8bf7\u6307\u5b9a\u5ba2\u6237\u7f16\u53f7");
        ValidateUtils.validate((Object)contractVo.getCusName(), (String)"\u8bf7\u6307\u5b9a\u5ba2\u6237\u540d\u79f0");
        ValidateUtils.validate((Object)contractVo.getStartTime(), (String)"\u8bf7\u6307\u5b9a\u6709\u6548\u65f6\u95f4\u6bb5");
        ValidateUtils.validate((Object)contractVo.getEndTime(), (String)"\u8bf7\u6307\u5b9a\u6709\u6548\u65f6\u95f4\u6bb5");
        List entities = this.contractMapper.selectByMap(new HashMap<String, Object>(){
            {
                this.put("code", contractVo.getCode());
            }
        });
        if (!CollectionUtils.isEmpty((Collection)entities)) {
            throw new BusinessException("\u60a8\u8f93\u5165\u7684\u5408\u540c\u7f16\u53f7" + contractVo.getCode() + "\u5df2\u5b58\u5728");
        }
        ContractEntity contractEntity = new ContractEntity();
        BeanUtils.copyProperties((Object)contractVo, (Object)((Object)contractEntity));
        this.contractMapper.insert((Object)contractEntity);
        this.contractFileService.replace(contractEntity, contractVo.getFiles());
        this.contractSalesAreaService.replace(contractEntity, contractVo.getSalesAreas());
    }

    @Override
    @Transactional
    public void edit(final ContractVo contractVo) {
        List entities;
        boolean codeChange;
        ValidateUtils.validate((Object)contractVo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u8d44\u6599");
        ValidateUtils.validate((Object)contractVo.getType(), (String)"\u8bf7\u6307\u5b9a\u5408\u540c\u7c7b\u578b");
        ValidateUtils.validate((Object)contractVo.getYear(), (String)"\u8bf7\u6307\u5b9a\u5408\u540c\u5e74\u5ea6");
        ValidateUtils.validate((Object)contractVo.getCode(), (String)"\u8bf7\u8f93\u5165\u5408\u540c\u7f16\u53f7\u540e\u518d\u63d0\u4ea4");
        ValidateUtils.validate((Object)contractVo.getCusCode(), (String)"\u8bf7\u6307\u5b9a\u5ba2\u6237\u7f16\u53f7");
        ValidateUtils.validate((Object)contractVo.getCusName(), (String)"\u8bf7\u6307\u5b9a\u5ba2\u6237\u540d\u79f0");
        ValidateUtils.validate((Object)contractVo.getStartTime(), (String)"\u8bf7\u6307\u5b9a\u6709\u6548\u65f6\u95f4\u6bb5");
        ValidateUtils.validate((Object)contractVo.getEndTime(), (String)"\u8bf7\u6307\u5b9a\u6709\u6548\u65f6\u95f4\u6bb5");
        ContractEntity entity = (ContractEntity)((Object)this.contractMapper.selectById((Serializable)((Object)contractVo.getId())));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u60a8\u8981\u7f16\u8f91\u7684\u8d44\u6599\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664!");
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"code", (Object)contractVo.getCode());
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractMapper.selectOne((Wrapper)wrapper));
        ValidateUtils.isTrue((contractEntity == null || Objects.equals(contractEntity.getCode(), contractVo.getCode()) && Objects.equals(contractEntity.getId(), contractVo.getId()) ? 1 : 0) != 0, (String)"\u8be5\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String[])new String[0]);
        boolean bl = codeChange = !contractVo.getCode().equals(entity.getCode());
        if (codeChange && !CollectionUtils.isEmpty((Collection)(entities = this.contractMapper.selectByMap(new HashMap<String, Object>(){
            {
                this.put("code", contractVo.getCode());
            }
        }))) && entities.size() > 1) {
            throw new BusinessException("\u60a8\u8f93\u5165\u7684\u5408\u540c\u7f16\u53f7" + contractVo.getCode() + "\u5df2\u5b58\u5728");
        }
        BeanUtils.copyProperties((Object)contractVo, (Object)((Object)entity));
        this.contractMapper.updateById((Object)entity);
        this.contractFileService.replace(entity, contractVo.getFiles());
        this.contractSalesAreaService.replace(entity, contractVo.getSalesAreas());
    }

    @Override
    @CrmDictMethod
    public ContractVo findById(String id) {
        ContractVo vo = null;
        ValidateUtils.validate((Object)id, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u8d44\u6599\uff01");
        ContractEntity entity = (ContractEntity)((Object)this.contractMapper.selectById((Serializable)((Object)id)));
        if (null == entity) {
            return vo;
        }
        vo = new ContractVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        vo.setFiles(this.contractFileService.findByContractId(id));
        vo.setSalesAreas(this.contractSalesAreaService.findByContractId(id));
        this.buildCusChannelName(vo);
        return vo;
    }

    private void buildCusChannelName(ContractVo ... vos) {
        Map channelDict = DictUtil.dictMap((String)"channel");
        if (!CollectionUtil.mapNotEmpty((Map)channelDict) || vos == null) {
            return;
        }
        Arrays.asList(vos).forEach(vo -> vo.setCusChannelName(this.buildCusChannelName(vo.getCusChannelCode(), channelDict)));
    }

    private String buildCusChannelName(String cusChannelCode, Map<String, String> channelDict) {
        if (StringUtils.isEmpty((Object)cusChannelCode) || !CollectionUtil.mapNotEmpty(channelDict)) {
            return null;
        }
        String[] cusChannelCodes = cusChannelCode.split(",");
        StringBuilder builder = new StringBuilder();
        Arrays.asList(cusChannelCodes).forEach(code -> builder.append((String)channelDict.get(code)).append(","));
        return builder.substring(0, builder.length() > 0 ? builder.length() - 1 : 0);
    }

    @Override
    @CrmDictMethod
    public PageResult<ContractVo> list(ContractVo contractVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq(!StringUtils.isEmpty((Object)contractVo.getType()), (Object)"type", (Object)contractVo.getType())).eq(!StringUtils.isEmpty((Object)contractVo.getCusChannelCode()), (Object)"cus_channel_code", (Object)contractVo.getCusChannelCode())).like(!StringUtils.isEmpty((Object)contractVo.getCode()), (Object)"code", (Object)contractVo.getCode())).like(!StringUtils.isEmpty((Object)contractVo.getCusCode()), (Object)"cus_code", (Object)contractVo.getCusCode())).like(!StringUtils.isEmpty((Object)contractVo.getCusName()), (Object)"cus_name", (Object)contractVo.getCusName())).ge(!StringUtils.isEmpty((Object)contractVo.getStartTime()), (Object)"start_time", (Object)contractVo.getStartTime())).le(!StringUtils.isEmpty((Object)contractVo.getEndTime()), (Object)"end_time", (Object)contractVo.getEndTime())).like(!StringUtils.isEmpty((Object)contractVo.getSaleCompanyCode()), (Object)"sale_company_code", (Object)contractVo.getSaleCompanyCode())).like(!StringUtils.isEmpty((Object)contractVo.getSaleCompanyName()), (Object)"sale_company_name", (Object)contractVo.getSaleCompanyName())).orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = PageUtil.buildPage((Integer)contractVo.getPageNum(), (Integer)contractVo.getPageSize());
        List<ContractVo> contractVos = this.contractMapper.list(page, (QueryWrapper<ContractVo>)wrapper);
        if (!CollectionUtil.listEmpty(contractVos)) {
            this.buildCusChannelName(contractVos.toArray(new ContractVo[contractVos.size()]));
        }
        return PageResult.builder().data(contractVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public void delByIds(ArrayList<String> ids) {
        if (Collections.isEmpty(ids)) {
            return;
        }
        this.contractMapper.deleteBatchIds(ids);
        this.contractSalesAreaService.delByContractIds(ids);
    }

    @Override
    @Transactional
    public void delByParam(ContractVo contractVo) {
        if (null == contractVo) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u67e5\u8be2\u6761\u4ef6!");
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq(!StringUtils.isEmpty((Object)contractVo.getType()), (Object)"type", (Object)contractVo.getType())).eq(!StringUtils.isEmpty((Object)contractVo.getCusChannelCode()), (Object)"cus_channel_code", (Object)contractVo.getCusChannelCode())).like(!StringUtils.isEmpty((Object)contractVo.getCode()), (Object)"code", (Object)contractVo.getCode())).like(!StringUtils.isEmpty((Object)contractVo.getCusCode()), (Object)"cus_code", (Object)contractVo.getCusCode());
        List entities = this.contractMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return;
        }
        List<String> ids = entities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        this.contractMapper.delete((Wrapper)wrapper);
        this.contractSalesAreaService.delByContractIds(ids);
    }

    @Override
    @CrmDictMethod
    public List<ContractVo> findByConditions(ContractVo contractVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq(!StringUtils.isEmpty((Object)contractVo.getType()), (Object)"type", (Object)contractVo.getType())).eq(!StringUtils.isEmpty((Object)contractVo.getCusChannelCode()), (Object)"cus_channel_code", (Object)contractVo.getCusChannelCode())).like(!StringUtils.isEmpty((Object)contractVo.getCode()), (Object)"code", (Object)contractVo.getCode())).like(!StringUtils.isEmpty((Object)contractVo.getCusCode()), (Object)"cus_code", (Object)contractVo.getCusCode())).ge(!StringUtils.isEmpty((Object)contractVo.getStartTime()), (Object)"start_time", (Object)contractVo.getStartTime())).le(!StringUtils.isEmpty((Object)contractVo.getEndTime()), (Object)"end_time", (Object)contractVo.getEndTime())).like(!StringUtils.isEmpty((Object)contractVo.getSaleCompanyCode()), (Object)"sale_company_code", (Object)contractVo.getSaleCompanyCode())).like(!StringUtils.isEmpty((Object)contractVo.getSaleCompanyName()), (Object)"sale_company_name", (Object)contractVo.getSaleCompanyName())).orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        List<ContractVo> contractVos = this.contractMapper.findByConditions((QueryWrapper<ContractVo>)wrapper);
        if (CollectionUtil.listEmpty(contractVos)) {
            return Lists.newArrayList();
        }
        if (!CollectionUtil.listEmpty(contractVos)) {
            this.buildCusChannelName(contractVos.toArray(new ContractVo[contractVos.size()]));
        }
        return contractVos;
    }
}

