/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScope;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScopeEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScopeGroup;
import com.biz.crm.nebular.mdm.customer.CustomerCodeConditionReqVo;
import com.biz.crm.promotion.entity.PromotionPolicyScopeEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyScopeMapper;
import com.biz.crm.promotion.service.PromotionPolicyScopeService;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional
@ConditionalOnMissingBean(name={"promotionPolicyScopeServiceExpandImpl"})
@Service(value="promotionPolicyScopeService")
public class PromotionPolicyScopeServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<PromotionPolicyScopeMapper, PromotionPolicyScopeEntity>
implements PromotionPolicyScopeService {
    @Resource
    private PromotionPolicyScopeMapper promotionPolicyScopeMapper;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Override
    public void refreshScope(PromotionPolicyEditReqVo editVo) {
        if (StringUtils.isNotBlank((CharSequence)editVo.getId())) {
            this.doDelByPromotionPolicyIdOrCode(Lists.newArrayList((Object[])new String[]{editVo.getId()}), null);
        }
        List tempEditVos = editVo.takeAllScopes();
        ArrayList editVos = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)tempEditVos)) {
            return;
        }
        HashSet keys = Sets.newHashSet();
        for (PromotionPolicyScopeEditVo temp : tempEditVos) {
            String key = temp.getPromotionPolicyId() + temp.getScopeCode() + temp.getScopeType() + temp.getContainable();
            if (keys.contains(key)) continue;
            temp.setId(null);
            temp.setPromotionPolicyCode(editVo.getPromotionPolicyCode());
            temp.setPromotionPolicyId(editVo.getId());
            temp.setPromotionPolicyName(editVo.getPromotionPolicyName());
            editVos.add(temp);
            keys.add(key);
        }
        this.saveBatch(CrmBeanUtil.copyList((List)editVos, PromotionPolicyScopeEntity.class));
    }

    @Override
    public void loadListForEditPromotionPolicy(PromotionPolicyEditVo editVo) {
        List<PromotionPolicyScopeEntity> custY = null;
        List<PromotionPolicyScopeEntity> custN = null;
        List<PromotionPolicyScopeEntity> orgY = null;
        List<PromotionPolicyScopeEntity> orgN = null;
        if (StringUtils.isNotBlank((CharSequence)editVo.getId())) {
            QueryWrapper wrapper = Wrappers.query();
            wrapper.in((Object)"promotion_policy_id", new Object[]{editVo.getId()});
            Map<String, List<PromotionPolicyScopeEntity>> groupByScopeType = this.promotionPolicyScopeMapper.selectList((Wrapper)wrapper).stream().collect(Collectors.groupingBy(v -> v.getScopeType() + v.getContainable()));
            custY = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.CUST.getItemCode() + CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            custN = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.CUST.getItemCode() + CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
            orgY = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.ORG.getItemCode() + CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            orgN = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.ORG.getItemCode() + CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
        }
        PromotionPolicyScopeGroup scopesAsOrg = new PromotionPolicyScopeGroup();
        scopesAsOrg.setContainN(CrmBeanUtil.copyList(orgN, PromotionPolicyScopeEditVo.class));
        scopesAsOrg.setContainY(CrmBeanUtil.copyList(orgY, PromotionPolicyScopeEditVo.class));
        PromotionPolicyScopeGroup scopesAsCust = new PromotionPolicyScopeGroup();
        scopesAsCust.setContainN(CrmBeanUtil.copyList(custN, PromotionPolicyScopeEditVo.class));
        scopesAsCust.setContainY(CrmBeanUtil.copyList(custY, PromotionPolicyScopeEditVo.class));
        PromotionPolicyScope promotionPolicyScope = new PromotionPolicyScope();
        promotionPolicyScope.setScopesAsCust(scopesAsCust);
        promotionPolicyScope.setScopesAsOrg(scopesAsOrg);
        editVo.setPromotionPolicyScope(promotionPolicyScope);
    }

    @Override
    public void delByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        this.doDelByPromotionPolicyIdOrCode(promotionPolicyId, promotionPolicyCode);
    }

    @Override
    public Set<String> selectPromotionPolicyIdByScopeCode(String custCode, Set<String> orgCodes) {
        if (null == orgCodes) {
            orgCodes = Sets.newHashSet();
        }
        HashSet matchedPromotionPolicyId = Sets.newHashSet();
        if (StringUtils.isBlank((CharSequence)custCode) && CollectionUtils.isEmpty((Collection)orgCodes)) {
            return matchedPromotionPolicyId;
        }
        Map<String, List<PromotionPolicyScopeEntity>> promotionPolicyIdMapScope = this.promotionPolicyScopeMapper.selectList((Wrapper)Wrappers.lambdaQuery(PromotionPolicyScopeEntity.class)).stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity::getPromotionPolicyId));
        for (Map.Entry<String, List<PromotionPolicyScopeEntity>> entry : promotionPolicyIdMapScope.entrySet()) {
            List<PromotionPolicyScopeEntity> scopeEntities = entry.getValue();
            Map<String, List<PromotionPolicyScopeEntity>> scopeTypeMapScope = scopeEntities.stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity::getScopeType));
            List<PromotionPolicyScopeEntity> scopeAsCust = scopeTypeMapScope.get(CommonConstant.DMS.PromotionPolicyScopeType.CUST.getItemCode());
            List<PromotionPolicyScopeEntity> scopeAsOrg = scopeTypeMapScope.get(CommonConstant.DMS.PromotionPolicyScopeType.ORG.getItemCode());
            boolean matchedAsCust = this.doMatchScope(scopeAsCust, Sets.newHashSet((Object[])new String[]{custCode}));
            boolean matchedAsOrg = this.doMatchScope(scopeAsOrg, orgCodes);
            if (!matchedAsCust || !matchedAsOrg) continue;
            matchedPromotionPolicyId.add(entry.getKey());
        }
        return matchedPromotionPolicyId;
    }

    private boolean doMatchScope(List<PromotionPolicyScopeEntity> scope, Set<String> codes) {
        if (CollectionUtils.isEmpty(scope)) {
            return false;
        }
        Map<String, List<PromotionPolicyScopeEntity>> containableMapScope = scope.stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity::getContainable));
        List<PromotionPolicyScopeEntity> scopeAsContainableY = containableMapScope.get(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
        List<PromotionPolicyScopeEntity> scopeAsContainableN = containableMapScope.get(CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
        boolean isMatch = false;
        if (null != scopeAsContainableY) {
            for (PromotionPolicyScopeEntity scopeEntity : scopeAsContainableY) {
                if (!codes.contains(scopeEntity.getScopeCode())) continue;
                isMatch = true;
            }
        }
        if (null != scopeAsContainableN) {
            for (PromotionPolicyScopeEntity scopeEntity : scopeAsContainableN) {
                if (!codes.contains(scopeEntity.getScopeCode())) continue;
                isMatch = false;
            }
        }
        return isMatch;
    }

    @Override
    public List<String> countCustCodesByPromotionPolicyId(Set<String> promotionPolicyIds) {
        Result custResult;
        CustomerCodeConditionReqVo reqVo;
        if (CollectionUtils.isEmpty(promotionPolicyIds)) {
            return Lists.newArrayList();
        }
        HashSet custCodes = Sets.newHashSet();
        List<String> custCodesAsCust = this.promotionPolicyScopeMapper.selectCustCodesByPromotionPolicyId(Lists.newArrayList(promotionPolicyIds));
        custCodes.addAll(custCodesAsCust);
        List<String> channelCodes = this.promotionPolicyScopeMapper.selectChannelCodesByPromotionPolicyId(Lists.newArrayList(promotionPolicyIds));
        List<String> orgCodes = this.promotionPolicyScopeMapper.selectOrgCodesByPromotionPolicyId(Lists.newArrayList(promotionPolicyIds));
        if (!CollectionUtils.isEmpty(orgCodes)) {
            reqVo = new CustomerCodeConditionReqVo();
            reqVo.setOrgCodeList((List)Lists.newArrayList((Iterable)Sets.newHashSet(orgCodes)));
            custResult = this.mdmCustomerMsgFeign.findCustomerCodeConditionList(reqVo);
            List custCodesAsOrg = (List)ApiResultUtil.objResult((Result)custResult, (boolean)true);
            custCodes.addAll(custCodesAsOrg);
        }
        if (!CollectionUtils.isEmpty(channelCodes)) {
            reqVo = new CustomerCodeConditionReqVo();
            reqVo.setChannelList((List)Lists.newArrayList((Iterable)Sets.newHashSet(channelCodes)));
            custResult = this.mdmCustomerMsgFeign.findCustomerCodeConditionList(reqVo);
            List custCodesAsChannel = (List)ApiResultUtil.objResult((Result)custResult, (boolean)true);
            custCodes.addAll(custCodesAsChannel);
        }
        return Lists.newArrayList((Iterable)custCodes);
    }

    private void doDelByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        QueryWrapper wrapper = Wrappers.query();
        if (!CollectionUtils.isEmpty(promotionPolicyId)) {
            wrapper.in((Object)"promotion_policy_id", promotionPolicyId);
        } else if (!CollectionUtils.isEmpty(promotionPolicyCode)) {
            wrapper.in((Object)"promotion_policy_code", promotionPolicyCode);
        } else {
            return;
        }
        this.promotionPolicyScopeMapper.delete((Wrapper)wrapper);
    }
}

