/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolFileVo;
import com.biz.crm.repfeepool.entity.RepFeePoolFileEntity;
import com.biz.crm.repfeepool.mapper.RepFeePoolFileMapper;
import com.biz.crm.repfeepool.service.RepFeePoolFileService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="repFeePoolFileService")
@ConditionalOnMissingBean(name={"repFeePoolFileServiceImpl"})
public class RepFeePoolFileServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RepFeePoolFileMapper, RepFeePoolFileEntity>
implements RepFeePoolFileService {
    @Resource
    private RepFeePoolFileMapper repFeePoolFileMapper;

    @Override
    @Transactional
    public void createAll(List<RepFeePoolFileVo> files) {
        ValidateUtils.notEmpty(files, (String)"\u6279\u91cf\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u6587\u4ef6\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        files.forEach(file -> this.create((RepFeePoolFileVo)file));
    }

    @Override
    public void create(RepFeePoolFileVo file) {
        ValidateUtils.validate((Object)file, (String)"\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u6587\u4ef6\u8bb0\u5f55\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)file.getFileName(), (String)"\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u65f6\uff0c\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)file.getUrlPath(), (String)"\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u65f6\uff0c\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)file.getRebateFeePoolDetailLogCode(), (String)"\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u65f6\uff0c\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65e5\u5fd7\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.isTrue((file.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u65f6\uff0c\u4e0d\u80fd\u5b58\u5728id\u503c", (String[])new String[0]);
        RepFeePoolFileEntity entity = new RepFeePoolFileEntity();
        BeanUtils.copyProperties((Object)file, (Object)entity);
        this.repFeePoolFileMapper.insert(entity);
    }

    @Override
    public List<RepFeePoolFileVo> findByLogCode(String repFeePoolItemDetailCode) {
        if (StringUtils.isEmpty((String)repFeePoolItemDetailCode)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"rebate_fee_pool_detail_log_code", (Object)repFeePoolItemDetailCode);
        List entities = this.repFeePoolFileMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        ArrayList files = Lists.newArrayList();
        entities.forEach(e -> {
            RepFeePoolFileVo file = new RepFeePoolFileVo();
            BeanUtils.copyProperties((Object)e, (Object)file);
            files.add(file);
        });
        return files;
    }
}

