/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.pricesetting.MdmPriceSettingFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.dms.repfeepool.RepFeePooItemProductInfoResVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePooItemProductInfoRqeVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolFrozenFileVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolFrozenItemVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolVo;
import com.biz.crm.nebular.dms.repfeepool.RepItemReflushVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceSettingRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.rebatefeepool.entity.RebateFeePoolEntity;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolDetailLogUtil;
import com.biz.crm.repfeepool.entity.RepFeePoolEntity;
import com.biz.crm.repfeepool.entity.RepFeePoolItemEntity;
import com.biz.crm.repfeepool.mapper.RepFeePoolItemMapper;
import com.biz.crm.repfeepool.service.RepFeePoolFrozenItemService;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailService;
import com.biz.crm.repfeepool.service.RepFeePoolItemProductService;
import com.biz.crm.repfeepool.service.RepFeePoolItemService;
import com.biz.crm.repfeepool.service.RepFeePoolService;
import com.biz.crm.repfeepool.utils.RepFeePoolItemDetailLogUtil;
import com.biz.crm.repfeepool.utils.RepFeePoolItemUtil;
import com.biz.crm.repfeepool.utils.RepFeePoolUtil;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="repFeePoolItemService")
@ConditionalOnMissingBean(name={"repFeePoolItemServiceImpl"})
public class RepFeePoolItemServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RepFeePoolItemMapper, RepFeePoolItemEntity>
implements RepFeePoolItemService {
    @Resource
    private RepFeePoolItemMapper repFeePoolItemMapper;
    @Resource
    private RepFeePoolIItemDetailService repFeePoolIItemDetailService;
    @Resource
    private RepFeePoolService repFeePoolService;
    @Resource
    private RepFeePoolItemProductService repFeePoolItemProductService;
    @Resource
    private MdmPriceSettingFeign mdmPriceSettingFeign;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Resource
    private RepFeePoolFrozenItemService repFeePoolFrozenItemService;

    @Override
    public PageResult<RepFeePooItemProductInfoResVo> findPageByCusCodeAndSaleCompanyCode(RepFeePooItemProductInfoRqeVo rqeVo) {
        if (null == rqeVo || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)rqeVo.getCusCode()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)rqeVo.getSaleCompanyCode())) {
            throw new BusinessException("\u7ecf\u9500\u5546\u7f16\u7801\u3001\u9500\u552e\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        RepFeePoolEntity repFeePoolEntity = (RepFeePoolEntity)((Object)this.repFeePoolService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RepFeePoolEntity.class).eq(RepFeePoolEntity::getCusCode, (Object)rqeVo.getCusCode())).eq(RepFeePoolEntity::getSaleCompanyCode, (Object)rqeVo.getSaleCompanyCode())));
        if (null == repFeePoolEntity) {
            return PageResult.builder().data((List)Lists.newArrayList()).count(Long.valueOf(0L)).build();
        }
        Page page = new Page((long)rqeVo.getPageNum().intValue(), (long)rqeVo.getPageSize().intValue());
        Page pageData = (Page)this.repFeePoolItemMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RepFeePoolItemEntity.class).eq(RepFeePoolItemEntity::getRepFeePoolCode, (Object)repFeePoolEntity.getCode())).gt(RepFeePoolItemEntity::getAvailableCount, (Object)0));
        List dataVos = CrmBeanUtil.copyList((List)pageData.getRecords(), RepFeePooItemProductInfoResVo.class);
        if (!CollectionUtils.isEmpty((Collection)dataVos)) {
            List productRespVos = (List)ApiResultUtil.objResult((Result)this.mdmProductFeign.queryBatchByProductCodeList(dataVos.stream().map(RepFeePooItemProductInfoResVo::getProductCode).collect(Collectors.toList())), (boolean)true);
            Map<String, MdmProductRespVo> productCodeMapVo = productRespVos.stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, v -> v, (mdmProductRespVo, mdmProductRespVo2) -> mdmProductRespVo2));
            dataVos.forEach(v -> {
                MdmProductRespVo mdmProductRespVo = (MdmProductRespVo)productCodeMapVo.get(v.getProductCode());
                if (null != mdmProductRespVo) {
                    v.setSpec(mdmProductRespVo.getSpec());
                    v.setRepFeePoolCode(repFeePoolEntity.getCode());
                }
            });
        }
        return PageResult.builder().data(dataVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public Map<String, BigDecimal> findAvailableBalance(RepFeePoolItemVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u67e5\u8be2\u53ef\u7528\u4f59\u989d\uff0c\u5fc5\u987b\u4f20\u5165\u53c2\u6570");
        ValidateUtils.validate((Object)vo.getRepFeePoolVo(), (String)"\u67e5\u8be2\u53ef\u7528\u4f59\u989d\uff0c\u5fc5\u987b\u4f20\u5165\u53c2\u6570\u3010repFeePoolVo\u3011");
        ValidateUtils.validate((Object)vo.getRepFeePoolVo().getUniqueDictCode(), (String)"\u67e5\u8be2\u53ef\u7528\u4f59\u989d\uff0c\u552f\u4e00\u7ea6\u675f\u6570\u636e\u5b57\u5178\u5fc5\u987b\u4f20\u5165");
        QueryWrapper<RebateFeePoolEntity> wrapper = RepFeePoolUtil.buildUniqueWrapperParam(vo.getRepFeePoolVo());
        List<RepFeePoolVo> poolVos = this.repFeePoolService.findByWrapper(wrapper);
        ValidateUtils.notEmpty(poolVos, (String)"\u6839\u636e\u552f\u4e00\u7ea6\u675f\u6ca1\u6709\u83b7\u53d6\u5230\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u552f\u4e00\u7ea6\u675f\u5b57\u6bb5\u503c\u662f\u5426\u6b63\u786e", (String[])new String[0]);
        ValidateUtils.isTrue((poolVos.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636e\u552f\u4e00\u7ea6\u675f\u83b7\u53d6\u5230\u591a\u6761\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u552f\u4e00\u7ea6\u675f\u5b57\u6bb5\u503c\u662f\u5426\u6b63\u786e", (String[])new String[0]);
        QueryWrapper itemWrapper = Wrappers.query();
        itemWrapper.eq((Object)"rep_fee_pool_code", (Object)poolVos.get(0).getCode());
        itemWrapper.eq((Object)"product_code", (Object)vo.getProductCode());
        List entities = this.repFeePoolItemMapper.selectList((Wrapper)itemWrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return Maps.newHashMap();
        }
        TreeMap result = Maps.newTreeMap();
        entities.forEach(en -> result.put(en.getProductCode(), en.getAvailableCount()));
        return result;
    }

    @Override
    public PageResult<RepFeePoolItemVo> findPageByConditions(RepFeePoolItemVo vo) {
        if (vo == null) {
            vo = new RepFeePoolItemVo();
        }
        HashMap map = Maps.newHashMap();
        if (vo.getRepFeePoolVo() != null) {
            map.put("cusName", vo.getRepFeePoolVo().getCusName());
            map.put("cusOrgName", vo.getRepFeePoolVo().getCusOrgName());
            map.put("saleCompanyName", vo.getRepFeePoolVo().getSaleCompanyName());
            map.put("cusChannelName", vo.getRepFeePoolVo().getCusChannelName());
        } else {
            vo.setRepFeePoolVo(new RepFeePoolVo());
        }
        if (StringUtils.isEmpty((String)vo.getRepFeePoolVo().getCusName())) {
            map.put("cusName", vo.getCusName());
        }
        if (StringUtils.isEmpty((String)vo.getRepFeePoolVo().getCusOrgName())) {
            map.put("cusOrgName", vo.getCusOrgName());
        }
        if (StringUtils.isEmpty((String)vo.getRepFeePoolVo().getSaleCompanyName())) {
            map.put("saleCompanyName", vo.getSaleCompanyName());
        }
        if (StringUtils.isEmpty((String)vo.getRepFeePoolVo().getCusChannelName())) {
            map.put("cusChannelName", vo.getCusChannelName());
        }
        map.put("repFeePoolCode", vo.getRepFeePoolCode());
        map.put("code", vo.getCode());
        map.put("payType", vo.getPayType());
        map.put("productName", vo.getProductName());
        map.put("productCode", vo.getProductCode());
        Page page = new Page((long)vo.getPageNum().intValue(), (long)vo.getPageSize().intValue());
        List<RepFeePoolItemVo> list = this.repFeePoolItemMapper.findPageByConditions((Page<RepFeePoolItemVo>)page, map);
        if (CollectionUtil.listEmpty(list)) {
            return PageResult.builder().data((List)Lists.newArrayList()).build();
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public void onCountItems(List<RepFeePoolItemVo> repFeePoolItemVos) {
        ValidateUtils.notEmpty(repFeePoolItemVos, (String)"\u65b0\u589e\u591a\u6761\u8d27\u8865\u8d39\u7528\u6c60\u660e\u7ec6\u8bb0\u5f55\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        repFeePoolItemVos.forEach(item -> this.onCountItem((RepFeePoolItemVo)item));
    }

    @Override
    @Transactional
    public void onCountItem(RepFeePoolItemVo itemVo) {
        RepFeePoolItemEntity entity;
        RepFeePoolItemUtil.validate(itemVo);
        ValidateUtils.isTrue((RepFeePoolItemDetailLogUtil.AdjustTypeEnum.isType(itemVo.getAdjustCountType(), 1) || RepFeePoolItemDetailLogUtil.AdjustTypeEnum.isType(itemVo.getAdjustFeeType(), 1) ? 1 : 0) != 0, (String)"\u8c03\u6574\u7c7b\u578b\u4e0d\u6b63\u786e", (String[])new String[0]);
        itemVo.setProductSize(Integer.valueOf(itemVo.getProductCode().split(",").length));
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"rep_fee_pool_code", (Object)itemVo.getRepFeePoolCode());
        wrapper.eq((Object)"product_code", (Object)itemVo.getProductCode());
        List entities = this.repFeePoolItemMapper.selectList((Wrapper)wrapper);
        FieldHandleUtil.initDecimalZero(itemVo);
        ValidateUtils.isTrue((itemVo.getOnAccountCount().compareTo(BigDecimal.ZERO) > -1 ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u6570\u91cf\u4e0d\u80fd\u4e3a\u8d1f\u6570", (String[])new String[0]);
        ValidateUtils.isTrue((itemVo.getOnAccountFee().compareTo(BigDecimal.ZERO) > -1 ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570", (String[])new String[0]);
        if (CollectionUtil.listEmpty((List)entities)) {
            entity = new RepFeePoolItemEntity();
            FieldHandleUtil.initCreateFields(itemVo);
            BeanUtils.copyProperties((Object)itemVo, (Object)((Object)entity));
            entity.setCode(CodeUtil.getCode());
            entity.setId(null);
            entity.setRemarks(null);
            entity.setAvailableCount(entity.getOnAccountCount());
            entity.setAvailableFee(entity.getOnAccountFee());
            this.repFeePoolItemMapper.insert((Object)entity);
            itemVo.setCode(entity.getCode());
            this.repFeePoolItemProductService.createAll(itemVo, itemVo.getRepFeePoolItemProductVos());
        } else {
            ValidateUtils.isTrue((entities.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636e\u8d27\u8865\u8d39\u7528\u6c60\u552f\u4e00\u7ea6\u675f\u67e5\u5230\u540c\u4e00\u4e2a\u4ea7\u54c1\u5b58\u5728\u591a\u6761\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e", (String[])new String[0]);
            entity = (RepFeePoolItemEntity)((Object)entities.get(0));
            entity.setPayType(itemVo.getPayType());
            entity.setOnAccountCount(itemVo.getOnAccountCount().add(entity.getOnAccountCount()));
            entity.setAvailableCount(itemVo.getOnAccountCount().add(entity.getAvailableCount()));
            entity.setOnAccountFee(itemVo.getOnAccountFee().add(entity.getOnAccountFee()));
            entity.setAvailableFee(itemVo.getOnAccountFee().add(entity.getAvailableFee()));
            FieldHandleUtil.initUpdateFields((Object)entity);
            this.repFeePoolItemMapper.updateById((Object)entity);
        }
        RepFeePoolItemDetailVo detailVo = new RepFeePoolItemDetailVo();
        detailVo.setFiles(itemVo.getFiles());
        detailVo.setPrice(itemVo.getPrice());
        detailVo.setPayType(entity.getPayType());
        detailVo.setProductCode(entity.getProductCode());
        detailVo.setProductName(entity.getProductName());
        detailVo.setRepFeePoolItemCode(entity.getCode());
        detailVo.setUnit(entity.getUnit());
        detailVo.setUnitName(entity.getUnitName());
        detailVo.setOnAccountCount(itemVo.getOnAccountCount());
        detailVo.setUsedCount(BigDecimal.ZERO);
        detailVo.setFrozenCount(BigDecimal.ZERO);
        detailVo.setAvailableCount(itemVo.getOnAccountCount());
        detailVo.setOnAccountFee(itemVo.getOnAccountFee());
        detailVo.setUsedFee(BigDecimal.ZERO);
        detailVo.setFrozenFee(BigDecimal.ZERO);
        detailVo.setAvailableFee(itemVo.getOnAccountFee());
        detailVo.setAdjustCountType(itemVo.getAdjustCountType());
        detailVo.setAdjustFeeType(itemVo.getAdjustFeeType());
        detailVo.setRemarks(itemVo.getRemarks());
        detailVo.setAdjustReason(itemVo.getAdjustReason());
        detailVo.setOnAccountReason(itemVo.getOnAccountReason());
        this.repFeePoolIItemDetailService.create(detailVo);
    }

    @Override
    @Transactional
    public void adjust(RepFeePoolItemVo itemVo) {
        RepFeePoolItemUtil.validate(itemVo);
        List detailVos = itemVo.getDetailVos();
        ValidateUtils.notEmpty((Collection)detailVos, (String)"\u8c03\u6574\u8d27\u8865\u8d39\u7528\u6c60\u65f6\uff0c\u6761\u76ee\u5fc5\u987b\u4f20\u5165", (String[])new String[0]);
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"code", (Object)itemVo.getCode());
        RepFeePoolItemEntity entity = (RepFeePoolItemEntity)((Object)this.repFeePoolItemMapper.selectOne((Wrapper)wrapper));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u8c03\u6574\u8d27\u8865\u8d39\u7528\u6c60\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u8d27\u8865\u8d39\u7528\u6c60\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u660e\u7ec6\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
        QueryWrapper poolWrapper = Wrappers.query();
        poolWrapper.eq((Object)"code", (Object)entity.getRepFeePoolCode());
        List<RepFeePoolVo> repFeePoolVos = this.repFeePoolService.findByWrapper(poolWrapper);
        ValidateUtils.notEmpty(repFeePoolVos, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8d39\u7528\u6c60\u8bb0\u5f55", (String[])new String[0]);
        RepFeePoolVo repFeePoolVo = repFeePoolVos.get(0);
        String[] productCodeArray = itemVo.getProductCode().split(",");
        itemVo.setProductSize(Integer.valueOf(productCodeArray.length));
        ArrayList createDetails = Lists.newArrayList();
        ArrayList updateDetails = Lists.newArrayList();
        BigDecimal onAccountCount = BigDecimal.ZERO;
        BigDecimal usedCount = BigDecimal.ZERO;
        BigDecimal frozenCount = BigDecimal.ZERO;
        BigDecimal availableCount = BigDecimal.ZERO;
        BigDecimal onAccountFee = BigDecimal.ZERO;
        BigDecimal usedFee = BigDecimal.ZERO;
        BigDecimal frozenFee = BigDecimal.ZERO;
        BigDecimal availableFee = BigDecimal.ZERO;
        BigDecimal price = itemVo.getPrice();
        for (RepFeePoolItemDetailVo detail : detailVos) {
            if (StringUtils.isEmpty((String)detail.getCode())) {
                ValidateUtils.isTrue((RepFeePoolItemDetailLogUtil.AdjustTypeEnum.getType(detail.getAdjustCountType()) == 1 ? 1 : 0) != 0, (String)"\u8c03\u6574\u7684\u65f6\u5019\uff0c\u65b0\u589e\u7684\u6761\u76ee\u53ea\u80fd\u662f\u4e0a\u8d26\u7c7b\u578b", (String[])new String[0]);
            }
            FieldHandleUtil.initDecimalZero(detail);
            this.computeAdjustCount(detail);
            BigDecimal computePrice = price;
            if (!StringUtils.isEmpty((String)detail.getId())) {
                computePrice = detail.getPrice();
            }
            if (itemVo.isUseItemPrice()) {
                computePrice = itemVo.getPrice();
            }
            this.computeAdjustFeeByCount(detail, computePrice);
            this.computeAdjustFee(detail);
            onAccountCount = onAccountCount.add(detail.getOnAccountCount());
            usedCount = usedCount.add(detail.getUsedCount());
            frozenCount = frozenCount.add(detail.getFrozenCount());
            availableCount = availableCount.add(detail.getAvailableCount());
            onAccountFee = onAccountFee.add(detail.getOnAccountFee());
            usedFee = usedFee.add(detail.getUsedFee());
            frozenFee = frozenFee.add(detail.getFrozenFee());
            availableFee = availableFee.add(detail.getAvailableFee());
            detail.setAdjustReason(itemVo.getAdjustReason());
            if (StringUtils.isEmpty((String)detail.getId())) {
                detail.setUnitName(entity.getUnitName());
                detail.setPrice(price);
                detail.setRepFeePoolItemCode(entity.getCode());
                createDetails.add(detail);
                continue;
            }
            updateDetails.add(detail);
        }
        entity.setOnAccountCount(onAccountCount);
        entity.setUsedCount(usedCount);
        entity.setFrozenCount(frozenCount);
        entity.setAvailableCount(availableCount);
        entity.setOnAccountFee(onAccountFee);
        entity.setUsedFee(usedFee);
        entity.setFrozenFee(frozenFee);
        entity.setAvailableFee(availableFee);
        this.repFeePoolItemMapper.updateById((Object)entity);
        this.saveFrozenItem(itemVo);
        if (!CollectionUtil.listEmpty((List)createDetails)) {
            this.repFeePoolIItemDetailService.createAll(createDetails);
        }
        if (!CollectionUtil.listEmpty((List)updateDetails)) {
            this.repFeePoolIItemDetailService.updateAll(updateDetails);
        }
        this.repFeePoolService.summaryItems(itemVo.getRepFeePoolCode());
    }

    private void saveFrozenItem(RepFeePoolItemVo itemVo) {
        if (itemVo == null || CollectionUtil.listEmpty((List)itemVo.getDetailVos())) {
            return;
        }
        List files = Lists.newArrayList();
        BigDecimal frozenFee = BigDecimal.ZERO;
        BigDecimal unfrozenFee = BigDecimal.ZERO;
        BigDecimal frozenCount = BigDecimal.ZERO;
        BigDecimal unfrozenCount = BigDecimal.ZERO;
        for (RepFeePoolItemDetailVo detailVo : itemVo.getDetailVos()) {
            FieldHandleUtil.initDecimalZero(detailVo);
            if (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.FROZEN.getCode().equals(detailVo.getAdjustCountType())) {
                frozenCount = frozenCount.add(detailVo.getAdjustCount());
                files = detailVo.getFiles();
            }
            if (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.FROZEN.getCode().equals(detailVo.getAdjustFeeType())) {
                frozenFee = frozenFee.add(detailVo.getAdjustFee());
                files = detailVo.getFiles();
            }
            if (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode().equals(detailVo.getAdjustCountType())) {
                unfrozenCount = unfrozenCount.add(detailVo.getAdjustCount());
                files = detailVo.getFiles();
            }
            if (!RepFeePoolItemDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode().equals(detailVo.getAdjustFeeType())) continue;
            unfrozenFee = unfrozenFee.add(detailVo.getAdjustFee());
            files = detailVo.getFiles();
        }
        List<RepFeePoolFrozenFileVo> frozenFiles = BeanCopyUtil.copyList(files, RepFeePoolFrozenFileVo.class);
        if (frozenFee.compareTo(BigDecimal.ZERO) > 0) {
            RepFeePoolFrozenItemVo frozenItemVo = new RepFeePoolFrozenItemVo();
            frozenItemVo.setFrozenCount(frozenCount);
            frozenItemVo.setUnfrozenCount(unfrozenCount);
            frozenItemVo.setRemainFrozenCount(BigDecimal.ZERO);
            frozenItemVo.setFrozenFee(frozenFee);
            frozenItemVo.setFrozenReason(itemVo.getAdjustReason());
            frozenItemVo.setRepFeePoolItemCode(itemVo.getCode());
            frozenItemVo.setUnfrozenFee(BigDecimal.ZERO);
            frozenItemVo.setRemainFrozenFee(frozenFee);
            frozenItemVo.setRemarks(itemVo.getRemarks());
            frozenItemVo.setFiles(frozenFiles);
            this.repFeePoolFrozenItemService.create(frozenItemVo);
        }
        if (unfrozenFee.compareTo(BigDecimal.ZERO) > 0) {
            ArrayList frozenItemVos;
            if (StringUtils.isEmpty((String)itemVo.getRepFeePoolFrozenItemCode())) {
                frozenItemVos = this.repFeePoolFrozenItemService.findByPoolItemCode(itemVo.getCode());
            } else {
                RepFeePoolFrozenItemVo frozenItemVo = this.repFeePoolFrozenItemService.findByCode(itemVo.getRepFeePoolFrozenItemCode());
                ValidateUtils.validate((Object)frozenItemVo, (String)"\u51bb\u7ed3\u660e\u7ec6\u3010%s\u3011\u4e0d\u5b58\u5728", (String[])new String[]{itemVo.getRepFeePoolFrozenItemCode()});
                frozenItemVos = Lists.newArrayList((Object[])new RepFeePoolFrozenItemVo[]{frozenItemVo});
            }
            ValidateUtils.notEmpty(frozenItemVos, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u51bb\u7ed3\u660e\u7ec6\uff0c\u4e0d\u80fd\u89e3\u51bb\u8be5\u6298\u6263\u8d39\u7528\u6c60", (String[])new String[0]);
            Iterator<RepFeePoolFrozenItemVo> iterator = frozenItemVos.iterator();
            BigDecimal reducer = unfrozenFee;
            BigDecimal countReducer = unfrozenCount;
            while (iterator.hasNext()) {
                RepFeePoolFrozenItemVo item = iterator.next();
                if (reducer.compareTo(BigDecimal.ZERO) < 1 || countReducer.compareTo(BigDecimal.ZERO) < 1) {
                    return;
                }
                if (item.getRemainFrozenCount().compareTo(countReducer) > -1) {
                    item.setRemainFrozenCount(item.getRemainFrozenCount().subtract(countReducer));
                    item.setUnfrozenCount(item.getUnfrozenCount().add(countReducer));
                    countReducer = BigDecimal.ZERO;
                } else {
                    item.setRemainFrozenCount(countReducer.subtract(item.getRemainFrozenCount()));
                    item.setUnfrozenCount(item.getUnfrozenCount().add(item.getRemainFrozenCount()));
                    countReducer = countReducer.subtract(item.getRemainFrozenCount());
                }
                if (item.getRemainFrozenFee().compareTo(reducer) > -1) {
                    item.setRemainFrozenFee(item.getRemainFrozenFee().subtract(reducer));
                    item.setUnfrozenFee(item.getUnfrozenFee().add(reducer));
                    reducer = BigDecimal.ZERO;
                    continue;
                }
                item.setRemainFrozenFee(reducer.subtract(item.getRemainFrozenFee()));
                item.setUnfrozenFee(item.getUnfrozenFee().add(item.getRemainFrozenFee()));
                reducer = reducer.subtract(item.getRemainFrozenFee());
            }
            ValidateUtils.isTrue((reducer.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u660e\u7ec6\u5df2\u51bb\u7ed3\u6570\u91cf\u4e0d\u8db3\u4ee5\u89e3\u51bb", (String[])new String[0]);
            ValidateUtils.isTrue((reducer.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u660e\u7ec6\u5df2\u51bb\u7ed3\u91d1\u989d\u4e0d\u8db3\u4ee5\u89e3\u51bb", (String[])new String[0]);
            frozenItemVos.forEach(f -> f.setFiles(frozenFiles));
            this.repFeePoolFrozenItemService.updateAll(frozenItemVos);
        }
    }

    private void computeAdjustFeeByCount(RepFeePoolItemDetailVo detail, BigDecimal price) {
        if (detail.getAdjustCountType() == null) {
            return;
        }
        ValidateUtils.validate((Object)detail.getAdjustCount(), (String)"\u8c03\u6574\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)(detail.getAdjustCount().compareTo(BigDecimal.ZERO) > -1 ? 1 : 0), (String)"\u8c03\u6574\u6570\u91cf\u65f6\uff0c\u8c03\u6574\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
        ValidateUtils.validate((Object)price, (String)"\u8c03\u6574\u6570\u91cf\u65f6\uff0c\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u4ef7\u683c\u4ee5\u3001\u4ef7\u683c\u7c7b\u578b\u5b57\u5178\u4ee5\u53ca\u5f53\u524d\u8ba1\u7b97\u4ef7\u683c\u7c7b\u578b\u5b57\u5178");
        ValidateUtils.validate((Object)(price.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0), (String)"\u8c03\u6574\u6570\u91cf\u65f6\uff0c\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u8bf7\u68c0\u67e5");
        detail.setAdjustFee(detail.getAdjustCount().multiply(price));
        detail.setAdjustFeeType(detail.getAdjustCountType());
    }

    private void computeAdjustFee(RepFeePoolItemDetailVo vo) {
        if (vo == null || vo.getAdjustFee() == null || vo.getAdjustFee().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal adjustFee = vo.getAdjustFee();
        ValidateUtils.isTrue((adjustFee.compareTo(BigDecimal.ZERO) > -1 ? 1 : 0) != 0, (String)"\u8c03\u6574\u6761\u76ee\u65f6\uff0c\u8c03\u6574\u91d1\u989d\u8bf7\u8f93\u5165\u6b63\u6570", (String[])new String[0]);
        switch (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.getEnumByCode(vo.getAdjustFeeType())) {
            case HAND_ON_ACCOUNT: 
            case BACK_REBATE_ON_ACCOUNT: 
            case FEE_ON_ACCOUNT: {
                vo.setOnAccountFee(vo.getOnAccountFee().add(adjustFee));
                vo.setAvailableFee(vo.getAvailableFee().add(adjustFee));
                break;
            }
            case HAND_REDUCE: 
            case ORDER_REDUCE: {
                ValidateUtils.isTrue((vo.getAvailableFee().compareTo(adjustFee) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\u4ee5\u6263\u51cf\uff0c\u8bf7\u786e\u8ba4", (String[])new String[]{vo.getCode()});
                vo.setAvailableFee(vo.getAvailableFee().subtract(adjustFee));
                vo.setUsedFee(vo.getUsedFee().add(adjustFee));
                break;
            }
            case ORDER_BACK: {
                ValidateUtils.isTrue((vo.getUsedFee().compareTo(adjustFee) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u5df2\u4f7f\u7528\u91d1\u989d\u4e0d\u8db3\u4ee5\u51b2\u9500\uff0c\u8bf7\u786e\u8ba4", (String[])new String[]{vo.getCode()});
                vo.setAvailableFee(vo.getAvailableFee().add(adjustFee));
                vo.setUsedFee(vo.getUsedFee().subtract(adjustFee));
                break;
            }
            case FROZEN: {
                ValidateUtils.isTrue((vo.getAvailableFee().compareTo(adjustFee) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\u4ee5\u51bb\u7ed3\uff0c\u8bf7\u786e\u8ba4", (String[])new String[]{vo.getCode()});
                vo.setAvailableFee(vo.getAvailableFee().subtract(adjustFee));
                vo.setFrozenFee(vo.getFrozenFee().add(adjustFee));
                break;
            }
            case UNFROZEN: {
                ValidateUtils.isTrue((vo.getFrozenFee().compareTo(adjustFee) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u51bb\u7ed3\u91d1\u989d\u4e0d\u8db3\u4ee5\u89e3\u51bb\uff0c\u8bf7\u786e\u8ba4", (String[])new String[]{vo.getCode()});
                vo.setAvailableFee(vo.getAvailableFee().add(adjustFee));
                vo.setFrozenFee(vo.getFrozenFee().subtract(adjustFee));
                break;
            }
            default: {
                throw new BusinessException("\u8c03\u6574\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8be5\u529f\u80fd\u53ea\u652f\u6301\u624b\u52a8\u4e0a\u8d26\u3001\u8fd4\u5229\u4e0a\u8d26\u3001\u8d39\u7528\u4e0a\u8d26\u3001\u8ba2\u5355\u56de\u9000\u3001\u624b\u52a8\u6263\u51cf\u3001\u8ba2\u5355\u6263\u51cf\u3001\u51bb\u7ed3\u3001\u89e3\u51bb");
            }
        }
    }

    private void computeAdjustCount(RepFeePoolItemDetailVo detailVo) {
        if (detailVo == null || detailVo.getAdjustCount() == null || detailVo.getAdjustCount().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal adjustCount = detailVo.getAdjustCount();
        ValidateUtils.isTrue((adjustCount.compareTo(BigDecimal.ZERO) > -1 ? 1 : 0) != 0, (String)"\u8c03\u6574\u6761\u76ee\u65f6\uff0c\u8c03\u6574\u6570\u91cf\u8bf7\u8f93\u5165\u6b63\u6570", (String[])new String[0]);
        switch (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.getEnumByCode(detailVo.getAdjustCountType())) {
            case HAND_ON_ACCOUNT: 
            case BACK_REBATE_ON_ACCOUNT: 
            case FEE_ON_ACCOUNT: {
                detailVo.setOnAccountCount(detailVo.getOnAccountCount().add(adjustCount));
                detailVo.setAvailableCount(detailVo.getAvailableCount().add(adjustCount));
                break;
            }
            case HAND_REDUCE: 
            case ORDER_REDUCE: {
                ValidateUtils.isTrue((detailVo.getAvailableCount().compareTo(adjustCount) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u53ef\u7528\u4f59\u91cf\u4e0d\u8db3\u4ee5\u6263\u51cf\u4e0d\u8db3\uff0c\u8bf7\u786e\u8ba4", (String[])new String[]{detailVo.getCode()});
                detailVo.setAvailableCount(detailVo.getAvailableCount().subtract(adjustCount));
                detailVo.setUsedCount(detailVo.getUsedCount().add(adjustCount));
                break;
            }
            case ORDER_BACK: {
                ValidateUtils.isTrue((detailVo.getUsedCount().compareTo(adjustCount) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u5df2\u4f7f\u7528\u6570\u91cf\u4e0d\u8db3\u4ee5\u51b2\u9500\uff0c\u8bf7\u786e\u8ba4", (String[])new String[]{detailVo.getCode()});
                detailVo.setAvailableCount(detailVo.getAvailableCount().add(adjustCount));
                detailVo.setUsedCount(detailVo.getUsedCount().subtract(adjustCount));
                break;
            }
            case FROZEN: {
                ValidateUtils.isTrue((detailVo.getAvailableCount().compareTo(adjustCount) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\u4ee5\u51bb\u7ed3\uff0c\u8bf7\u786e\u8ba4", (String[])new String[]{detailVo.getCode()});
                detailVo.setAvailableCount(detailVo.getAvailableCount().subtract(adjustCount));
                detailVo.setFrozenCount(detailVo.getFrozenCount().add(adjustCount));
                break;
            }
            case UNFROZEN: {
                ValidateUtils.isTrue((detailVo.getFrozenCount().compareTo(adjustCount) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u51bb\u7ed3\u6570\u91cf\u4e0d\u8db3\u4ee5\u89e3\u51bb\uff0c\u8bf7\u786e\u8ba4", (String[])new String[]{detailVo.getCode()});
                detailVo.setAvailableCount(detailVo.getAvailableCount().add(adjustCount));
                detailVo.setFrozenCount(detailVo.getFrozenCount().subtract(adjustCount));
                break;
            }
            default: {
                throw new BusinessException("\u8c03\u6574\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8be5\u529f\u80fd\u53ea\u652f\u6301\u624b\u52a8\u4e0a\u8d26\u3001\u8fd4\u5229\u4e0a\u8d26\u3001\u8d39\u7528\u4e0a\u8d26\u3001\u51b2\u9500\u3001\u624b\u52a8\u6263\u51cf\u3001\u8ba2\u5355\u6263\u51cf\u3001\u51bb\u7ed3\u3001\u89e3\u51bb");
            }
        }
    }

    @Override
    public List<RepFeePoolItemVo> findByPoolCode(String repFeePoolCode) {
        if (StringUtils.isEmpty((String)repFeePoolCode)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"rep_fee_pool_code", (Object)repFeePoolCode);
        List entities = this.repFeePoolItemMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        return BeanCopyUtil.copyList(entities, RepFeePoolItemVo.class);
    }

    @Override
    public Map<String, Map<String, MdmPriceSettingRespVo>> findPriceByProductCodes(String cusCode, List<String> codes) {
        if (CollectionUtil.listEmpty(codes)) {
            return Maps.newHashMap();
        }
        MdmPriceSearchReqVo param = new MdmPriceSearchReqVo();
        param.setProductCodeList(codes);
        param.setCustomerCode(cusCode);
        ArrayList fields = Lists.newArrayList();
        Map priceTypeDict = DictUtil.dictMap((String)"price_search_type");
        ValidateUtils.notEmpty((Map)priceTypeDict, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u4ef7\u683c\u7c7b\u578b\u5b57\u5178\u3010%s\u3011\uff0c\u8bf7\u5148\u7ef4\u62a4\u8be5\u5b57\u5178", (String[])new String[]{"price_search_type"});
        fields.addAll(priceTypeDict.keySet());
        param.setConditionTypeCodeList((List)fields);
        Result result = this.mdmPriceSettingFeign.search(param);
        if (result == null || result.getResult() == null) {
            return Maps.newHashMap();
        }
        return (Map)result.getResult();
    }

    @Override
    public Map<String, BigDecimal> findAvailablePriceByProductCodes(String cusCode, String ... codes) {
        if (codes == null || codes.length == 0) {
            return Maps.newHashMap();
        }
        TreeMap result = Maps.newTreeMap();
        Map priceUsingType = DictUtil.dictMap((String)"rep_fee_price_type_using");
        ValidateUtils.isTrue((priceUsingType != null && priceUsingType.size() == 1 ? 1 : 0) != 0, (String)"\u83b7\u53d6\u5f53\u524d\u8ba1\u7b97\u4ef7\u683c\u7c7b\u578b\u5b57\u5178\u3010%s\u3011\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5b58\u5728\u8be5\u7c7b\u578b\u5b57\u5178\uff0c\u5e76\u4e14\u8be5\u5b57\u5178\u7c7b\u578b\u5e94\u8be5\u53ea\u6709\u4e00\u4e2a\u5b57\u5178\u503c", (String[])new String[]{"rep_fee_price_type_using"});
        String priceType = (String)priceUsingType.entrySet().iterator().next().getKey();
        Map<String, Map<String, MdmPriceSettingRespVo>> prices = this.findPriceByProductCodes(cusCode, Arrays.asList(codes));
        for (String code : codes) {
            MdmPriceSettingRespVo priceObj;
            Map<String, MdmPriceSettingRespVo> priceMap = prices.get(code);
            if (priceMap == null || (priceObj = priceMap.get(priceType)) == null) continue;
            MdmPriceSettingRespVo priceVo = (MdmPriceSettingRespVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)priceObj), MdmPriceSettingRespVo.class);
            result.put(code, priceVo.getPrice());
        }
        return result;
    }

    @Override
    @Transactional
    public boolean wrapperFrozen(RepFeePoolItemVo itemVo) {
        BigDecimal reducer;
        ValidateUtils.validate((Object)itemVo, (String)"\u51bb\u7ed3/\u89e3\u51bb\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.validate((Object)itemVo.getRepFeePoolVo(), (String)"\u51bb\u7ed3/\u89e3\u51bb\u65f6\uff0c\u8d39\u7528\u6c60\u5fc5\u987b\u4f20\u5165");
        QueryWrapper<RebateFeePoolEntity> wrapper = RepFeePoolUtil.buildUniqueWrapperParam(itemVo.getRepFeePoolVo());
        List<RepFeePoolVo> repFeePoolVos = this.repFeePoolService.findByWrapper(wrapper);
        ValidateUtils.notEmpty(repFeePoolVos, (String)"\u51bb\u7ed3/\u89e3\u51bb\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u8d39\u7528\u6c60\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u53ca\u76f8\u5173\u5b57\u6bb5\u503c\u662f\u5426\u6b63\u786e\u4f20\u5165", (String[])new String[0]);
        ValidateUtils.isTrue((repFeePoolVos.size() == 1 ? 1 : 0) != 0, (String)"\u51bb\u7ed3/\u89e3\u51bb\u65f6\uff0c\u83b7\u53d6\u5230\u591a\u6761\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u8d39\u7528\u6c60\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u53ca\u76f8\u5173\u5b57\u6bb5\u503c\u662f\u5426\u6b63\u786e\u4f20\u5165", (String[])new String[0]);
        QueryWrapper itemWrapper = Wrappers.query();
        itemWrapper.eq((Object)"rep_fee_pool_code", (Object)repFeePoolVos.get(0).getCode());
        itemWrapper.eq((Object)"product_code", (Object)itemVo.getProductCode());
        List entities = this.repFeePoolItemMapper.selectList((Wrapper)itemWrapper);
        ValidateUtils.notEmpty((Collection)entities, (String)"\u6839\u636e\u552f\u4e00\u7ea6\u675f\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8d39\u7528\u6c60\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u548c\u5bf9\u5e94\u503c\u662f\u5426\u6b63\u786e\u4f20\u5165", (String[])new String[0]);
        ValidateUtils.isTrue((entities.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636e\u552f\u4e00\u7ea6\u675f\u83b7\u53d6\u5230\u591a\u6761\u8d39\u7528\u6c60\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u548c\u5bf9\u5e94\u503c\u662f\u5426\u6b63\u786e\u4f20\u5165", (String[])new String[0]);
        RepFeePoolItemEntity entity = (RepFeePoolItemEntity)((Object)entities.get(0));
        List<RepFeePoolItemDetailVo> details = this.repFeePoolIItemDetailService.findByItemCodeAndDictRule(entity.getCode(), itemVo.getIndexDictCode());
        ValidateUtils.notEmpty(details, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u6761\u76ee\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u6392\u5e8f\u89c4\u5219\u662f\u5426\u6b63\u786e\u4f20\u5165", (String[])new String[0]);
        RebateFeePoolDetailLogUtil.AdjustTypeEnum adjustTypeEnum = RebateFeePoolDetailLogUtil.AdjustTypeEnum.getEnumByCode(itemVo.getAdjustCountType());
        ValidateUtils.validate((Object)((Object)adjustTypeEnum), (String)"\u8c03\u6574\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u8be5\u529f\u80fd\u53ea\u80fd\u4f20\u5165\u51bb\u7ed3\uff088\uff09/\u89e3\u51bb\uff089\uff09\u7c7b\u578b");
        FieldHandleUtil.initDecimalZero(itemVo);
        switch (adjustTypeEnum) {
            case FROZEN: {
                reducer = this.computeFrozenDetails(details, itemVo);
                break;
            }
            case UNFROZEN: {
                reducer = this.computeUnfrozenDetails(details, itemVo);
                break;
            }
            default: {
                throw new BusinessException("\u51bb\u7ed3/\u89e3\u51bb\u65f6\u8c03\u6574\u7c7b\u578b\u4f20\u9012\u4e0d\u6b63\u786e\uff0c\u53ea\u5141\u8bb8\u4f208\uff08\u51bb\u7ed3\uff09\u30019\uff08\u89e3\u51bb\uff09");
            }
        }
        ValidateUtils.isTrue((reducer.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u5931\u8d25\uff0c\u53ef\u4f7f\u7528\u4f59\u989d\u4e0d\u8db3", (String[])new String[0]);
        itemVo.setDetailVos(details);
        this.adjust(itemVo);
        return true;
    }

    @Override
    public List<RepFeePoolItemVo> findByConditions(Map<String, Object> map) {
        if (map == null) {
            map = Maps.newHashMap();
        }
        return this.repFeePoolItemMapper.findByConditions(map);
    }

    @Override
    @Transactional
    public Boolean wrapperAdjustItems(List<RepFeePoolItemVo> repFeePoolItemVos) {
        if (CollectionUtil.listEmpty(repFeePoolItemVos)) {
            return false;
        }
        repFeePoolItemVos.forEach(itemVo -> this.wrapperAdjustItem((RepFeePoolItemVo)itemVo));
        return true;
    }

    @Override
    public void wrapperAdjustItem(RepFeePoolItemVo itemVo) {
        ValidateUtils.validate((Object)itemVo, (String)"\u8c03\u6574\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        itemVo.setUseItemPrice(true);
        ValidateUtils.validate((Object)((Object)RepFeePoolItemDetailLogUtil.AdjustTypeEnum.getEnumByCode(itemVo.getAdjustCountType())), (String)"\u6570\u91cf\u8c03\u6574\u7c7b\u578b\u5fc5\u987b\u4f20\u5165");
        switch (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.getEnumByCode(itemVo.getAdjustCountType())) {
            case HAND_ON_ACCOUNT: {
                RepFeePoolVo addVo = this.repFeePoolService.findByCode(itemVo.getRepFeePoolCode());
                ValidateUtils.validate((Object)addVo, (String)"\u8c03\u6574\u8d39\u7528\u6c60\u660e\u7ec6\u65f6\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8d39\u7528\u6c60\uff0c\u8bf7\u786e\u8ba4\u8d39\u7528\u6c60\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
                RepFeePoolItemVo addParam = BeanCopyUtil.copyBen(itemVo, RepFeePoolItemVo.class);
                addParam.setOnAccountCount(itemVo.getAdjustCount());
                addParam.setOnAccountFee(itemVo.getAdjustFee());
                addParam.setResourceCode(itemVo.getResourceCode());
                addParam.setRemarks(itemVo.getRemarks());
                addParam.setFiles(itemVo.getFiles());
                addParam.setIndexDictCode(itemVo.getIndexDictCode());
                addParam.setPrice(itemVo.getPrice());
                addParam.setCostPrice(itemVo.getCostPrice());
                addParam.setSalePrice(itemVo.getSalePrice());
                addVo.setRepFeePoolItemVos((List)Lists.newArrayList((Object[])new RepFeePoolItemVo[]{addParam}));
                this.repFeePoolService.onAccount(addVo);
                break;
            }
            case HAND_REDUCE: {
                RepFeePoolVo repFeePoolVo = this.repFeePoolService.findByCode(itemVo.getRepFeePoolCode());
                ValidateUtils.validate((Object)repFeePoolVo, (String)"\u8c03\u6574\u8d39\u7528\u6c60\u660e\u7ec6\u65f6\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8d39\u7528\u6c60\uff0c\u8bf7\u786e\u8ba4\u8d39\u7528\u6c60\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
                RepFeePoolItemVo subtractParam = BeanCopyUtil.copyBen(itemVo, RepFeePoolItemVo.class);
                subtractParam.setSubtractCount(itemVo.getAdjustCount());
                subtractParam.setResourceCode(itemVo.getResourceCode());
                subtractParam.setRemarks(itemVo.getRemarks());
                subtractParam.setFiles(itemVo.getFiles());
                subtractParam.setIndexDictCode(itemVo.getIndexDictCode());
                repFeePoolVo.setRepFeePoolItemVos((List)Lists.newArrayList((Object[])new RepFeePoolItemVo[]{subtractParam}));
                subtractParam.setPrice(itemVo.getPrice());
                itemVo.setUseItemPrice(false);
                subtractParam.setCostPrice(itemVo.getCostPrice());
                subtractParam.setSalePrice(itemVo.getSalePrice());
                this.repFeePoolService.subtractBalance(repFeePoolVo, itemVo.getPrice());
                break;
            }
            case FROZEN: 
            case UNFROZEN: {
                RepFeePoolVo frozenRepFeePoolVo = this.repFeePoolService.findByCode(itemVo.getRepFeePoolCode());
                ValidateUtils.validate((Object)frozenRepFeePoolVo, (String)"\u8c03\u6574\u8d39\u7528\u6c60\u660e\u7ec6\u65f6\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8d39\u7528\u6c60\uff0c\u8bf7\u786e\u8ba4\u8d39\u7528\u6c60\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
                RepFeePoolItemVo frozenParam = BeanCopyUtil.copyBen(itemVo, RepFeePoolItemVo.class);
                frozenParam.setRepFeePoolVo(frozenRepFeePoolVo);
                frozenParam.setResourceCode(itemVo.getResourceCode());
                frozenParam.setRemarks(itemVo.getRemarks());
                frozenParam.setFiles(itemVo.getFiles());
                frozenParam.setIndexDictCode(itemVo.getIndexDictCode());
                frozenParam.setPrice(itemVo.getPrice());
                frozenParam.setCostPrice(itemVo.getCostPrice());
                frozenParam.setSalePrice(itemVo.getSalePrice());
                frozenParam.setUseItemPrice(false);
                this.wrapperFrozen(frozenParam);
                break;
            }
            default: {
                throw new BusinessException("\u8c03\u6574\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
        }
    }

    @Override
    public RepFeePoolItemVo findByCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"code", (Object)code);
        RepFeePoolItemEntity entity = (RepFeePoolItemEntity)((Object)this.repFeePoolItemMapper.selectOne((Wrapper)wrapper));
        return BeanCopyUtil.copyBen((Object)entity, RepFeePoolItemVo.class);
    }

    @Override
    public Boolean unfrozenItem(RepFeePoolItemVo itemVo) {
        ValidateUtils.validate((Object)itemVo, (String)"\u89e3\u51bb\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)itemVo.getCode(), (String)"\u89e3\u51bb\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0c\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.validate((Object)itemVo.getRepFeePoolFrozenItemCode(), (String)"\u89e3\u51bb\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0c\u51bb\u7ed3\u660e\u7ec6\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.isTrue((Objects.equals(itemVo.getAdjustCountType(), RepFeePoolItemDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode()) || Objects.equals(itemVo.getAdjustFeeType(), RepFeePoolItemDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode()) ? 1 : 0) != 0, (String)"\u8be5\u529f\u80fd\u4ec5\u652f\u6301\u89e3\u51bb\uff0c\u8c03\u6574\u7c7b\u578b\u8bf7\u4f20\u90129\uff08\u89e3\u51bb\uff09", (String[])new String[0]);
        RepFeePoolItemVo oldItemVo = this.findByCode(itemVo.getCode());
        ValidateUtils.validate((Object)oldItemVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8d39\u7528\u6c60\u660e\u7ec6\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
        RepFeePoolVo oldVo = this.repFeePoolService.findByCode(oldItemVo.getRepFeePoolCode());
        ValidateUtils.validate((Object)oldVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u8d39\u7528\u6c60\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
        oldItemVo.setRepFeePoolVo(oldVo);
        oldItemVo.setIndexDictCode(itemVo.getIndexDictCode());
        oldItemVo.setAdjustCountType(itemVo.getAdjustCountType());
        oldItemVo.setAdjustFeeType(itemVo.getAdjustFeeType());
        oldItemVo.setAdjustCount(itemVo.getAdjustCount());
        oldItemVo.setAdjustFee(itemVo.getAdjustFee());
        oldItemVo.setRepFeePoolFrozenItemCode(itemVo.getRepFeePoolFrozenItemCode());
        oldItemVo.setRemarks(itemVo.getRemarks());
        oldItemVo.setResourceCode(itemVo.getResourceCode());
        oldItemVo.setAdjustReason(itemVo.getAdjustReason());
        oldItemVo.setFiles(itemVo.getFiles());
        oldItemVo.setPrice(itemVo.getPrice());
        return this.wrapperFrozen(oldItemVo);
    }

    @Override
    @Transactional
    public void reflush(String cusCode, String salesCompanyCode, String goodsCode) {
        this.repFeePoolIItemDetailService.reflush(cusCode, salesCompanyCode, goodsCode);
        this.reflushItemForReflush(cusCode, salesCompanyCode, goodsCode);
    }

    public void reflushItemForReflush(String cusCode, String salesCompanyCode, String goodsCode) {
        List<RepFeePoolItemEntity> itemEntities = this.repFeePoolItemMapper.listByParam(cusCode, salesCompanyCode, goodsCode);
        if (CollectionUtils.isEmpty(itemEntities)) {
            return;
        }
        RepFeePoolItemEntity itemEntity = itemEntities.get(0);
        RepItemReflushVo vo = this.repFeePoolIItemDetailService.sumFeeByItemCode(itemEntity.getCode());
        RepItemReflushVo logVo = null;
        this.updateById((Object)RepFeePoolItemUtil.packageEntityForReflush(itemEntity, vo, logVo));
    }

    private BigDecimal computeFrozenDetails(List<RepFeePoolItemDetailVo> details, RepFeePoolItemVo itemVo) {
        BigDecimal reducer = itemVo.getAdjustCount();
        for (RepFeePoolItemDetailVo detail : details) {
            if (reducer.compareTo(BigDecimal.ZERO) < 1) break;
            detail.setAdjustCountType(itemVo.getAdjustCountType());
            detail.setResourceCode(itemVo.getResourceCode());
            detail.setRemarks(itemVo.getRemarks());
            detail.setFiles(itemVo.getFiles());
            detail.setAdjustReason(itemVo.getAdjustReason());
            if (detail.getAvailableCount().compareTo(reducer) > -1) {
                detail.setAdjustCount(reducer);
                reducer = BigDecimal.ZERO;
                continue;
            }
            detail.setAdjustCount(detail.getAvailableCount());
            reducer = reducer.subtract(detail.getAvailableCount());
        }
        return reducer;
    }

    private BigDecimal computeUnfrozenDetails(List<RepFeePoolItemDetailVo> details, RepFeePoolItemVo itemVo) {
        BigDecimal reducer = itemVo.getAdjustCount();
        for (RepFeePoolItemDetailVo detail : details) {
            if (reducer.compareTo(BigDecimal.ZERO) < 1) break;
            detail.setAdjustCountType(itemVo.getAdjustCountType());
            detail.setResourceCode(itemVo.getResourceCode());
            detail.setRemarks(itemVo.getRemarks());
            detail.setFiles(itemVo.getFiles());
            detail.setAdjustReason(itemVo.getAdjustReason());
            if (detail.getFrozenCount().compareTo(reducer) > -1) {
                detail.setAdjustCount(reducer);
                reducer = BigDecimal.ZERO;
                continue;
            }
            detail.setAdjustCount(detail.getFrozenCount());
            reducer = reducer.subtract(detail.getFrozenCount());
        }
        return reducer;
    }
}

