/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.dms.PromotionEnum;
import com.biz.crm.nebular.dms.promotion.policy.req.DmsPromotionPolicyOrderDetailReqVo;
import com.biz.crm.promotion.entity.DmsPromotionPolicyOrderDetailEntity;
import com.biz.crm.promotion.mapper.DmsPromotionPolicyOrderDetailMapper;
import com.biz.crm.promotion.mapper.PromotionPolicyMapper;
import com.biz.crm.promotion.service.IDmsPromotionPolicyOrderDetailService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.StringUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"DmsPromotionPolicyOrderDetailServiceExpandImpl"})
public class DmsPromotionPolicyOrderDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<DmsPromotionPolicyOrderDetailMapper, DmsPromotionPolicyOrderDetailEntity>
implements IDmsPromotionPolicyOrderDetailService {
    private static final Logger log = LoggerFactory.getLogger(DmsPromotionPolicyOrderDetailServiceImpl.class);
    @Resource
    private DmsPromotionPolicyOrderDetailMapper dmsPromotionPolicyOrderDetailMapper;
    @Resource
    private PromotionPolicyMapper promotionPolicyMapper;
    @Autowired
    private RedissonUtil redissonUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean lockPromotionPolicyOrderDetailList(List<DmsPromotionPolicyOrderDetailReqVo> reqVoList) {
        Boolean flag;
        block6: {
            Set promotionPolicyIdList = reqVoList.stream().map(DmsPromotionPolicyOrderDetailReqVo::getPromotionPolicyId).collect(Collectors.toSet());
            if (promotionPolicyIdList.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u591a\u4e2a\u4e0d\u540c\u7684\u4fc3\u9500\u653f\u7b56id");
            }
            reqVoList.forEach(data -> this.checkParam((DmsPromotionPolicyOrderDetailReqVo)data));
            String promotionPolicyIdLock = reqVoList.get(0).getPromotionPolicyId();
            flag = false;
            Boolean lockFlag = false;
            RLock rLock = this.redissonUtil.createLock(promotionPolicyIdLock);
            try {
                if (rLock.tryLock()) {
                    lockFlag = true;
                    reqVoList.forEach(reqVo -> {
                        BigDecimal surplusUsedQty = this.promotionPolicyMapper.selectPromotionPolicySurplusUsedQty(reqVo.getPromotionPolicyId());
                        if (reqVo.getUsedQty().compareTo(surplusUsedQty) == 1) {
                            throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u4f7f\u7528\u91cf\u5927\u4e8e\u5269\u4f59\u4f7f\u7528\u91cf");
                        }
                        DmsPromotionPolicyOrderDetailEntity entity = (DmsPromotionPolicyOrderDetailEntity)((Object)((Object)CrmBeanUtil.copy((Object)reqVo, DmsPromotionPolicyOrderDetailEntity.class)));
                        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                        this.save((Object)entity);
                    });
                    flag = true;
                    break block6;
                }
                throw new BusinessException("\u6b64\u4fc3\u9500\u653f\u7b56\u6b63\u5728\u4f7f\u7528,\u8bf7\u7a0d\u7b49....");
            }
            finally {
                if (lockFlag.booleanValue()) {
                    this.redissonUtil.unLock(rLock);
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean lockPromotionPolicyOrderDetail(DmsPromotionPolicyOrderDetailReqVo reqVo) {
        Boolean flag;
        block6: {
            reqVo.setPolicyOrderDetailStatus(PromotionEnum.POLICY_ORDER_DETAIL.locked.getVal());
            this.checkParam(reqVo);
            String promotionPolicyIdLock = reqVo.getPromotionPolicyId();
            flag = false;
            Boolean lockFlag = false;
            RLock rLock = this.redissonUtil.createLock(promotionPolicyIdLock);
            try {
                if (rLock.tryLock()) {
                    lockFlag = true;
                    BigDecimal surplusUsedQty = this.promotionPolicyMapper.selectPromotionPolicySurplusUsedQty(reqVo.getPromotionPolicyId());
                    if (reqVo.getUsedQty().compareTo(surplusUsedQty) == 1) {
                        throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u4f7f\u7528\u91cf\u5927\u4e8e\u5269\u4f59\u4f7f\u7528\u91cf");
                    }
                    DmsPromotionPolicyOrderDetailEntity entity = (DmsPromotionPolicyOrderDetailEntity)((Object)CrmBeanUtil.copy((Object)reqVo, DmsPromotionPolicyOrderDetailEntity.class));
                    entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                    entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                    this.save((Object)entity);
                    flag = true;
                    break block6;
                }
                throw new BusinessException("\u6b64\u4fc3\u9500\u653f\u7b56\u6b63\u5728\u4f7f\u7528,\u8bf7\u7a0d\u7b49....");
            }
            finally {
                if (lockFlag.booleanValue()) {
                    this.redissonUtil.unLock(rLock);
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean commitPromotionPolicyOrderDetail(DmsPromotionPolicyOrderDetailReqVo reqVo) {
        Boolean flag;
        block7: {
            if (!StringUtils.isNotEmpty((String)reqVo.getOrderNo())) {
                throw new BusinessException("\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a");
            }
            flag = false;
            Boolean lock = false;
            List entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DmsPromotionPolicyOrderDetailEntity::getOrderNo, (Object)reqVo.getOrderNo())).eq(DmsPromotionPolicyOrderDetailEntity::getPolicyOrderDetailStatus, (Object)PromotionEnum.POLICY_ORDER_DETAIL.locked)).list();
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) {
                flag = true;
                return flag;
            }
            RLock rLock = this.redissonUtil.createLock(reqVo.getOrderNo());
            try {
                if (rLock.tryLock()) {
                    lock = true;
                    entityList.forEach(data -> data.setPolicyOrderDetailStatus(PromotionEnum.POLICY_ORDER_DETAIL.commit.getVal()));
                    flag = true;
                    break block7;
                }
                throw new BusinessException("\u6b63\u5728\u8fdb\u884c\u63d0\u4ea4\u4fc3\u9500\u653f\u7b56\u4f7f\u7528\u660e\u7ec6,\u8bf7\u7a0d\u7b49");
            }
            finally {
                if (lock.booleanValue()) {
                    this.redissonUtil.unLock(rLock);
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean unlockPromotionPolicyOrderDetail(DmsPromotionPolicyOrderDetailReqVo reqVo) {
        Boolean flag;
        block7: {
            if (!StringUtils.isNotEmpty((String)reqVo.getOrderNo())) {
                throw new BusinessException("\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a");
            }
            flag = false;
            Boolean lock = false;
            List entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DmsPromotionPolicyOrderDetailEntity::getOrderNo, (Object)reqVo.getOrderNo())).eq(DmsPromotionPolicyOrderDetailEntity::getPolicyOrderDetailStatus, (Object)PromotionEnum.POLICY_ORDER_DETAIL.locked)).list();
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) {
                flag = true;
                return flag;
            }
            RLock rLock = this.redissonUtil.createLock(reqVo.getOrderNo());
            try {
                if (rLock.tryLock()) {
                    lock = true;
                    entityList.forEach(data -> data.setPolicyOrderDetailStatus(PromotionEnum.POLICY_ORDER_DETAIL.unlock.getVal()));
                    flag = true;
                    break block7;
                }
                throw new BusinessException("\u6b63\u5728\u8fdb\u884c\u63d0\u4ea4\u4fc3\u9500\u653f\u7b56\u4f7f\u7528\u660e\u7ec6,\u8bf7\u7a0d\u7b49");
            }
            finally {
                if (lock.booleanValue()) {
                    this.redissonUtil.unLock(rLock);
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean rollbackPromotionPolicyOrderDetail(DmsPromotionPolicyOrderDetailReqVo reqVo) {
        Boolean flag;
        block7: {
            if (!StringUtils.isNotEmpty((String)reqVo.getOrderNo())) {
                throw new BusinessException("\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a");
            }
            flag = false;
            Boolean lock = false;
            List entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DmsPromotionPolicyOrderDetailEntity::getOrderNo, (Object)reqVo.getOrderNo())).eq(DmsPromotionPolicyOrderDetailEntity::getPolicyOrderDetailStatus, (Object)PromotionEnum.POLICY_ORDER_DETAIL.locked)).list();
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) {
                flag = true;
                return flag;
            }
            RLock rLock = this.redissonUtil.createLock(reqVo.getOrderNo());
            try {
                if (rLock.tryLock()) {
                    lock = true;
                    entityList.forEach(data -> data.setPolicyOrderDetailStatus(PromotionEnum.POLICY_ORDER_DETAIL.rollback.getVal()));
                    flag = true;
                    break block7;
                }
                throw new BusinessException("\u6b63\u5728\u8fdb\u884c\u63d0\u4ea4\u4fc3\u9500\u653f\u7b56\u4f7f\u7528\u660e\u7ec6,\u8bf7\u7a0d\u7b49");
            }
            finally {
                if (lock.booleanValue()) {
                    this.redissonUtil.unLock(rLock);
                }
            }
        }
        return flag;
    }

    private void checkParam(DmsPromotionPolicyOrderDetailReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getPolicyOrderDetailStatus(), (String)"\u4fc3\u9500\u653f\u7b56\u4f7f\u7528\u660e\u7ec6\u72b6\u6001\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPromotionPolicyId(), (String)"\u4fc3\u9500\u653f\u7b56id\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOrderId(), (String)"\u8ba2\u5355id\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOrderNo(), (String)"\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a");
        if (reqVo.getUsedQty() == null) {
            throw new BusinessException("\u4fc3\u9500\u653f\u7b56id\u4e3a\u7a7a");
        }
        AssertUtils.isNotEmpty((String)reqVo.getUsedQtyType(), (String)"\u653f\u7b56\u4f7f\u7528\u91cf\u7c7b\u578b\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getUsedQtyUnit(), (String)"\u653f\u7b56\u4f7f\u7528\u91cf\u5355\u4f4d\u4e3a\u7a7a");
    }
}

