/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.contract.entity.ContractEntity;
import com.biz.crm.contract.entity.ContractSalesAreaEntity;
import com.biz.crm.contract.mapper.ContractSalesAreaMapper;
import com.biz.crm.contract.service.ContractSalesAreaService;
import com.biz.crm.nebular.dms.contract.ContractSalesAreaVo;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"contractSalesAreaServiceExpandImpl"})
@Service(value="contractSalesAreaService")
public class ContractSalesAreaServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<ContractSalesAreaMapper, ContractSalesAreaEntity>
implements ContractSalesAreaService {
    @Resource
    private ContractSalesAreaMapper contractSalesAreaMapper;

    @Override
    @Transactional
    public void replace(final ContractEntity contractEntity, List<ContractSalesAreaVo> salesAreas) {
        this.removeByMap(new HashMap<String, Object>(){
            {
                this.put("contract_id", contractEntity.getId());
            }
        });
        if (CollectionUtils.isEmpty(salesAreas)) {
            return;
        }
        this.checkRepeat(salesAreas);
        ArrayList<ContractSalesAreaEntity> entities = new ArrayList<ContractSalesAreaEntity>(salesAreas.size());
        for (ContractSalesAreaVo vo : salesAreas) {
            ContractSalesAreaEntity entity = new ContractSalesAreaEntity();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
            entity.setContractId(contractEntity.getId());
            entities.add(entity);
        }
        this.saveBatch(entities);
    }

    private void checkRepeat(List<ContractSalesAreaVo> salesAreas) {
        if (CollectionUtil.listEmpty(salesAreas)) {
            return;
        }
        salesAreas.forEach(a -> {
            List<ContractSalesAreaVo> nAreas = BeanCopyUtil.copyList(salesAreas, ContractSalesAreaVo.class);
            nAreas.remove(a);
            nAreas.forEach(b -> {
                if (!(StringUtils.isEmpty((Object)a.getProvinceCode()) || StringUtils.isEmpty((Object)a.getCityCode()) || StringUtils.isEmpty((Object)a.getDistrictCode()))) {
                    ValidateUtils.isTrue((!Objects.equals(a.getDistrictCode(), b.getDistrictCode()) ? 1 : 0) != 0, (String)"\u68c0\u6d4b\u5230\u9500\u552e\u8303\u56f4%s%s%s\u91cd\u590d", (String[])new String[]{a.getProvince(), a.getCity(), a.getDistrict()});
                } else if (!StringUtils.isEmpty((Object)a.getProvinceCode()) && !StringUtils.isEmpty((Object)a.getCityCode())) {
                    ValidateUtils.isTrue((!Objects.equals(a.getCityCode(), b.getCityCode()) ? 1 : 0) != 0, (String)"\u68c0\u6d4b\u5230\u9500\u552e\u8303\u56f4%s%s\u91cd\u590d", (String[])new String[]{a.getProvince(), a.getCity()});
                } else if (!StringUtils.isEmpty((Object)a.getProvinceCode())) {
                    ValidateUtils.isTrue((!Objects.equals(a.getProvinceCode(), b.getProvinceCode()) ? 1 : 0) != 0, (String)"\u68c0\u6d4b\u5230\u9500\u552e\u8303\u56f4%s\u91cd\u590d", (String[])new String[]{a.getProvince()});
                } else {
                    throw new BusinessException("\u9500\u552e\u533a\u57df\u586b\u5199\u6709\u8bef");
                }
            });
        });
    }

    @Override
    public List<ContractSalesAreaVo> findByContractId(String contractId) {
        if (StringUtils.isEmpty((Object)contractId)) {
            return new ArrayList<ContractSalesAreaVo>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        List salesAreaEntities = this.contractSalesAreaMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)salesAreaEntities)) {
            return new ArrayList<ContractSalesAreaVo>();
        }
        ArrayList<ContractSalesAreaVo> salesAreaVos = new ArrayList<ContractSalesAreaVo>(salesAreaEntities.size());
        for (ContractSalesAreaEntity entity : salesAreaEntities) {
            ContractSalesAreaVo salesAreaVo = new ContractSalesAreaVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)salesAreaVo);
            salesAreaVos.add(salesAreaVo);
        }
        return salesAreaVos;
    }

    @Override
    @Transactional
    public void delByContractIds(List<String> contractIds) {
        if (CollectionUtils.isEmpty(contractIds)) {
            throw new BusinessException("\u5408\u540cid\u4e3a\u7a7a");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"contract_id", contractIds);
        this.contractSalesAreaMapper.delete((Wrapper)wrapper);
    }
}

