/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebatefeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolFrozenFileVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolFrozenItemVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolVo;
import com.biz.crm.rebatefeepool.entity.RebateFeePoolFrozenItemEntity;
import com.biz.crm.rebatefeepool.mapper.RebateFeePoolFrozenItemMapper;
import com.biz.crm.rebatefeepool.service.RebateFeePoolFrozenFileService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolFrozenItemService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolService;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rebateFeePoolFrozenItemService")
@ConditionalOnMissingBean(name={"rebateFeePoolFrozenItemServiceImpl"})
public class RebateFeePoolFrozenItemServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateFeePoolFrozenItemMapper, RebateFeePoolFrozenItemEntity>
implements RebateFeePoolFrozenItemService {
    @Resource
    private RebateFeePoolFrozenItemMapper rebateFeePoolFrozenItemMapper;
    @Resource
    private RebateFeePoolService rebateFeePoolService;
    @Resource
    private RebateFeePoolFrozenFileService rebateFeePoolFrozenFileService;

    @Override
    public List<RebateFeePoolFrozenItemVo> findByPoolCode(String poolCode) {
        if (StringUtils.isEmpty((String)poolCode)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"rebate_fee_pool_code", (Object)poolCode);
        wrapper.orderByAsc((Object)"create_date");
        wrapper.orderByAsc((Object)"create_date_second");
        List entities = this.rebateFeePoolFrozenItemMapper.selectList((Wrapper)wrapper);
        return BeanCopyUtil.copyList(entities, RebateFeePoolFrozenItemVo.class);
    }

    @Override
    @Transactional
    public void create(RebateFeePoolFrozenItemVo frozenItemVo) {
        ValidateUtils.validate((Object)frozenItemVo, (String)"\u65b0\u589e\u6298\u6263\u8d39\u7528\u6c60\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)frozenItemVo.getRebateFeePoolCode(), (String)"\u65b0\u589e\u6298\u6263\u8d39\u7528\u6c60\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        frozenItemVo.setCode(CodeUtil.getCode());
        RebateFeePoolFrozenItemEntity entity = BeanCopyUtil.copyBen(frozenItemVo, RebateFeePoolFrozenItemEntity.class);
        FieldHandleUtil.initDecimalZero((Object)entity);
        FieldHandleUtil.initCreateFields((Object)entity);
        this.rebateFeePoolFrozenItemMapper.insert((Object)entity);
        List files = frozenItemVo.getFiles();
        files.forEach(f -> f.setRebateFeePoolFrozenItemCode(frozenItemVo.getCode()));
        this.rebateFeePoolFrozenFileService.createAll(files);
    }

    @Override
    @Transactional
    public void updateAll(List<RebateFeePoolFrozenItemVo> frozenItemVos) {
        ValidateUtils.notEmpty(frozenItemVos, (String)"\u6279\u91cf\u7f16\u8f91\u8d39\u7528\u6c60\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        frozenItemVos.forEach(frozenItemVo -> this.update((RebateFeePoolFrozenItemVo)frozenItemVo));
    }

    @Override
    @Transactional
    public void update(RebateFeePoolFrozenItemVo frozenItemVo) {
        ValidateUtils.validate((Object)frozenItemVo, (String)"\u7f16\u8f91\u8d39\u7528\u6c60\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)frozenItemVo.getId(), (String)"\u7f16\u8f91\u8d39\u7528\u6c60\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)frozenItemVo.getRebateFeePoolCode(), (String)"\u7f16\u8f91\u8d39\u7528\u6c60\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        RebateFeePoolFrozenItemEntity oldEntity = (RebateFeePoolFrozenItemEntity)((Object)this.rebateFeePoolFrozenItemMapper.selectById((Serializable)((Object)frozenItemVo.getId())));
        ValidateUtils.validate((Object)((Object)oldEntity), (String)"\u7f16\u8f91\u8d39\u7528\u6c60\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8bb0\u5f55");
        FieldHandleUtil.initDecimalZero(frozenItemVo);
        FieldHandleUtil.initUpdateFields(frozenItemVo);
        RebateFeePoolFrozenItemEntity entity = BeanCopyUtil.copyBen(frozenItemVo, RebateFeePoolFrozenItemEntity.class);
        this.rebateFeePoolFrozenItemMapper.updateById((Object)entity);
        List files = frozenItemVo.getFiles();
        files.forEach(f -> f.setRebateFeePoolFrozenItemCode(frozenItemVo.getCode()));
        this.rebateFeePoolFrozenFileService.createAll(files);
    }

    @Override
    public PageResult<RebateFeePoolFrozenItemVo> findPageByConditions(RebateFeePoolFrozenItemVo param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        List<RebateFeePoolFrozenItemVo> pageResult = this.rebateFeePoolFrozenItemMapper.findPageByConditions((Page<RebateFeePoolFrozenItemVo>)page, param);
        if (CollectionUtil.listEmpty(pageResult)) {
            return PageResult.builder().data((List)Lists.newArrayList()).count(Long.valueOf(0L)).build();
        }
        pageResult.forEach(vo -> {
            RebateFeePoolVo rebateFeePoolVo = this.rebateFeePoolService.findPoolByCode(vo.getRebateFeePoolCode());
            List<RebateFeePoolFrozenFileVo> files = this.rebateFeePoolFrozenFileService.findByFrozenItemCode(vo.getCode());
            vo.setFiles(files);
            vo.setRebateFeePoolVo(rebateFeePoolVo);
        });
        return PageResult.builder().data(pageResult).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public RebateFeePoolFrozenItemVo findByCode(String rebateFeePoolFrozenItemCode) {
        if (StringUtils.isEmpty((String)rebateFeePoolFrozenItemCode)) {
            return null;
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"code", (Object)rebateFeePoolFrozenItemCode);
        List entities = this.rebateFeePoolFrozenItemMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return null;
        }
        ValidateUtils.isTrue((entities.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636e\u51bb\u7ed3\u660e\u7ec6\u7f16\u7801\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e", (String[])new String[0]);
        return BeanCopyUtil.copyBen(entities.get(0), RebateFeePoolFrozenItemVo.class);
    }
}

