/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebatefeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.feepool.FeePoolDetailLogVo;
import com.biz.crm.nebular.dms.rebatefeepool.FeePoolSumReportRes;
import com.biz.crm.nebular.dms.rebatefeepool.ListAccountRes;
import com.biz.crm.nebular.dms.rebatefeepool.ListFeeReq;
import com.biz.crm.nebular.dms.rebatefeepool.ListReq;
import com.biz.crm.nebular.dms.rebatefeepool.ListUsedRes;
import com.biz.crm.nebular.dms.rebatefeepool.RebateDetailReflushVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolBpmVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolDetailLogVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolDetailVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolFrozenFileVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolFrozenItemVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolSumReportReq;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolSumReportRes;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolVo;
import com.biz.crm.nebular.dms.rebatefeepool.SelectBanceVo;
import com.biz.crm.nebular.dms.rebatefeepool.SelectBanlanceRebateRes;
import com.biz.crm.nebular.dms.rebatefeepool.SelectBanlanceRes;
import com.biz.crm.rebatefeepool.entity.RebateFeePoolEntity;
import com.biz.crm.rebatefeepool.mapper.RebateFeePoolDetailLogMapper;
import com.biz.crm.rebatefeepool.mapper.RebateFeePoolDetailMapper;
import com.biz.crm.rebatefeepool.mapper.RebateFeePoolMapper;
import com.biz.crm.rebatefeepool.service.RebateFeePoolBpmService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolDetailLogService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolDetailService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolFrozenItemService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolService;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolBpmUtil;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolDetailLogUtil;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolUtil;
import com.biz.crm.repfeepool.service.RepFeePoolService;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TimeUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="rebateFeePoolService")
@ConditionalOnMissingBean(name={"rebateFeePoolServiceImpl"})
public class RebateFeePoolServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateFeePoolMapper, RebateFeePoolEntity>
implements RebateFeePoolService {
    private static final String REBATE_FEE_KEY = "rebateFee";
    private static final String REP_FEE_KEY = "repFee";
    @Resource
    private RebateFeePoolMapper rebateFeePoolMapper;
    @Resource
    private RebateFeePoolDetailService rebateFeePoolDetailService;
    @Resource
    private RebateFeePoolDetailLogMapper rebateFeePoolDetailLogMapper;
    @Resource
    private RebateFeePoolDetailMapper rebateFeePoolDetailMapper;
    @Resource
    private RepFeePoolService repFeePoolService;
    @Resource
    private RebateFeePoolFrozenItemService rebateFeePoolFrozenItemService;
    @Resource
    private RebateFeePoolBpmService rebateFeePoolBpmService;
    @Resource
    private RebateFeePoolDetailLogService rebateFeePoolDetailLogService;
    @Resource
    private RebateFeePoolService rebateFeePoolService;

    @Override
    public List<RebateFeePoolEntity> selectPoolList(QueryWrapper<RebateFeePoolEntity> wrapper) {
        return this.rebateFeePoolMapper.selectList((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void onAccount(RebateFeePoolVo vo) {
        RebateFeePoolBpmVo bpmVo;
        RebateFeePoolEntity rebateFeePoolEntity;
        RebateFeePoolUtil.validate(vo);
        ValidateUtils.isTrue((RebateFeePoolDetailLogUtil.AdjustTypeEnum.BEGIN_PERIOD.getCode().equals(vo.getAdjustType()) || RebateFeePoolDetailLogUtil.AdjustTypeEnum.HAND_ON_ACCOUNT.getCode().equals(vo.getAdjustType()) || RebateFeePoolDetailLogUtil.AdjustTypeEnum.AUTO_ON_ACCOUNT.getCode().equals(vo.getAdjustType()) ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u53ea\u652f\u6301\u624b\u52a8\u4e0a\u8d26\u3001\u81ea\u52a8\u4e0a\u8d26\u548c\u671f\u521d\u4e0a\u8d26", (String[])new String[0]);
        QueryWrapper<RebateFeePoolEntity> wrapper = RebateFeePoolUtil.buildUniqueWrapperParam(vo);
        List rebateFeePoolEntities = this.rebateFeePoolMapper.selectList((Wrapper)wrapper);
        FieldHandleUtil.initDecimalZero(vo);
        ValidateUtils.isTrue((vo.getTotalFee().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u5fc5\u987b\u5927\u4e8e0", (String[])new String[0]);
        if (CollectionUtil.listNotEmpty((List)rebateFeePoolEntities)) {
            rebateFeePoolEntity = (RebateFeePoolEntity)((Object)rebateFeePoolEntities.get(0));
            FieldHandleUtil.initUpdateFields((Object)rebateFeePoolEntity);
            rebateFeePoolEntity.setBalance(rebateFeePoolEntity.getBalance().add(vo.getTotalFee()));
            rebateFeePoolEntity.setTotalFee(rebateFeePoolEntity.getTotalFee().add(vo.getTotalFee()));
            this.rebateFeePoolMapper.updateById((Object)rebateFeePoolEntity);
        } else {
            FieldHandleUtil.initCreateFields(vo);
            vo.setCode(CodeUtil.getCode());
            vo.setUsedFee(BigDecimal.ZERO);
            vo.setBalance(vo.getTotalFee());
            rebateFeePoolEntity = new RebateFeePoolEntity();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)rebateFeePoolEntity));
            rebateFeePoolEntity.setRemarks(null);
            this.rebateFeePoolMapper.insert((Object)rebateFeePoolEntity);
        }
        vo.setAdjustFee(vo.getTotalFee());
        if (vo.getBpmVo() == null || StringUtils.isEmpty((String)vo.getBpmVo().getCode())) {
            vo.setCode(rebateFeePoolEntity.getCode());
            bpmVo = this.saveBpm(vo, CollectionUtil.listEmpty((List)rebateFeePoolEntities) ? null : (RebateFeePoolEntity)((Object)rebateFeePoolEntities.get(0)));
        } else {
            bpmVo = vo.getBpmVo();
        }
        if (this.rebateFeePoolBpmService.isApproval(vo.getAdjustType()) && !vo.isApproved()) {
            bpmVo.setBpmState(RebateFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState());
        }
        RebateFeePoolDetailVo rebateFeePoolDetailVo = new RebateFeePoolDetailVo();
        rebateFeePoolDetailVo.setCode(CodeUtil.getCode());
        rebateFeePoolDetailVo.setItemTotalFee(vo.getTotalFee());
        rebateFeePoolDetailVo.setItemAvailableBalance(vo.getTotalFee());
        rebateFeePoolDetailVo.setItemFrozenFee(BigDecimal.ZERO);
        rebateFeePoolDetailVo.setItemUsedFee(BigDecimal.ZERO);
        rebateFeePoolDetailVo.setPayType(vo.getPayType());
        rebateFeePoolDetailVo.setItemAvailableBalance(vo.getTotalFee());
        rebateFeePoolDetailVo.setRebateFeePoolCode(rebateFeePoolEntity.getCode());
        rebateFeePoolDetailVo.setAdjustType(vo.getAdjustType());
        rebateFeePoolDetailVo.setFiles(vo.getFiles());
        rebateFeePoolDetailVo.setRemarks(vo.getRemarks());
        rebateFeePoolDetailVo.setAdjustReason(vo.getAdjustReason());
        rebateFeePoolDetailVo.setOnAccountReason(vo.getOnAccountReason());
        this.rebateFeePoolDetailService.create(rebateFeePoolDetailVo, bpmVo);
        this.rebateFeePoolService.reflush(vo.getCusCode(), vo.getSaleCompanyCode());
    }

    @Override
    @Transactional
    public void adjust(RebateFeePoolVo vo) {
        RebateFeePoolUtil.validate(vo);
        ValidateUtils.validate((Object)vo.getId(), (String)"\u7f16\u8f91\u6298\u6263\u8d39\u7528\u6c60\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a");
        RebateFeePoolEntity rebateFeePoolEntity = (RebateFeePoolEntity)((Object)this.rebateFeePoolMapper.selectById((Serializable)((Object)vo.getId())));
        ValidateUtils.validate((Object)((Object)rebateFeePoolEntity), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6298\u6263\u8d39\u7528\u6c60\u539f\u59cb\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4id\u662f\u5426\u6b63\u786e");
        List rebateFeePoolDetailVos = vo.getRebateFeePoolDetailVos();
        ValidateUtils.notEmpty((Collection)rebateFeePoolDetailVos, (String)"\u7f16\u7801\u6298\u6263\u8d39\u7528\u6c60\u65f6\uff0c\u6298\u6263\u8d39\u7528\u6c60\u6761\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        RebateFeePoolFrozenItemVo frozenItemVo = this.saveFrozenItem(vo);
        String frozenItemCode = frozenItemVo == null ? null : frozenItemVo.getCode();
        RebateFeePoolBpmVo bpmVo = vo.getBpmVo() != null && !StringUtils.isEmpty((String)vo.getBpmVo().getCode()) ? vo.getBpmVo() : this.saveBpm(vo, rebateFeePoolEntity);
        ValidateUtils.validate((Object)bpmVo, (String)"\u65b0\u589e\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25");
        if (this.rebateFeePoolBpmService.isApproval(vo.getAdjustType())) {
            if (!vo.isApproved()) {
                bpmVo.setBpmState(RebateFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState());
                this.saveLog(vo, vo.getRebateFeePoolDetailVos(), bpmVo, frozenItemCode);
            }
        } else {
            bpmVo.setBpmState(RebateFeePoolBpmUtil.ApprovalEnum.PROCESSED.getState());
            this.saveLog(vo, vo.getRebateFeePoolDetailVos(), bpmVo, frozenItemCode);
        }
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal frozen = BigDecimal.ZERO;
        BigDecimal used = BigDecimal.ZERO;
        BigDecimal balance = BigDecimal.ZERO;
        vo.setCode(rebateFeePoolEntity.getCode());
        for (RebateFeePoolDetailVo v : rebateFeePoolDetailVos) {
            if (StringUtils.isEmpty((String)v.getCode())) {
                ValidateUtils.isTrue((RebateFeePoolDetailLogUtil.AdjustTypeEnum.getType(v.getAdjustType()) == 1 ? 1 : 0) != 0, (String)"\u8c03\u6574\u91d1\u989d\u7684\u65f6\u5019\uff0c\u65b0\u589e\u7684\u6761\u76ee\u53ea\u80fd\u662f\u4e0a\u8d26\u7c7b\u578b", (String[])new String[0]);
            }
            FieldHandleUtil.initDecimalZero(v);
            this.computeAdjustFee(v);
            total = total.add(v.getItemTotalFee());
            frozen = frozen.add(v.getItemFrozenFee());
            used = used.add(v.getItemUsedFee());
            balance = balance.add(v.getItemAvailableBalance());
            if (!StringUtils.isEmpty((String)v.getRebateFeePoolCode())) continue;
            v.setRebateFeePoolCode(vo.getCode());
        }
        vo.setTotalFee(total);
        vo.setBalance(balance);
        vo.setFrozenFee(frozen);
        rebateFeePoolEntity.setTotalFee(total);
        rebateFeePoolEntity.setBalance(balance);
        rebateFeePoolEntity.setFrozenFee(frozen);
        rebateFeePoolEntity.setUsedFee(used);
        this.rebateFeePoolService.reflush(rebateFeePoolEntity.getCusCode(), rebateFeePoolEntity.getSaleCompanyCode());
    }

    private void saveLog(RebateFeePoolVo rebateFeePoolVo, List<RebateFeePoolDetailVo> detailVos, RebateFeePoolBpmVo bpmVo, String frozenItemCode) {
        ValidateUtils.validate((Object)rebateFeePoolVo, (String)"\u65b0\u589e\u64cd\u4f5c\u8bb0\u5f55\uff0c\u539f\u59cb\u8d39\u7528\u6c60\u8bb0\u5f55\u6ca1\u6709\u83b7\u53d6\u5230");
        if (rebateFeePoolVo.getAdjustType() == null) {
            return;
        }
        for (RebateFeePoolDetailVo detail : detailVos) {
            if (detail.getAdjustType() == null) continue;
            ValidateUtils.validate((Object)detail.getCode(), (String)"\u65b0\u589e\u65e5\u5fd7\u65f6\uff0c\u6761\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            RebateFeePoolDetailLogVo logVo = new RebateFeePoolDetailLogVo();
            logVo.setFiles(detail.getFiles());
            logVo.setAdjustFee(detail.getAdjustFee());
            logVo.setFrozenFee(detail.getAdjustFrozenFee());
            logVo.setAdjustType(detail.getAdjustType());
            logVo.setPayType(detail.getPayType());
            logVo.setRebateFeePoolDetailCode(detail.getCode());
            logVo.setRemarks(detail.getRemarks());
            logVo.setAdjustReason(detail.getAdjustReason());
            logVo.setRebateFeePoolBpmCode(bpmVo.getCode());
            logVo.setCusCode(rebateFeePoolVo.getCusCode());
            logVo.setSaleCompanyCode(rebateFeePoolVo.getSaleCompanyCode());
            logVo.setUniqueDictCode(rebateFeePoolVo.getUniqueDictCode());
            logVo.setBpmState(bpmVo.getBpmState());
            logVo.setFrozenItemCode(frozenItemCode);
            this.rebateFeePoolDetailLogService.create(logVo);
        }
    }

    private RebateFeePoolBpmVo saveBpm(RebateFeePoolVo rebateFeePoolVo, RebateFeePoolEntity rebateFeePoolEntity) {
        ValidateUtils.validate((Object)rebateFeePoolVo, (String)"\u65b0\u589e\u64cd\u4f5c\u8bb0\u5f55\uff0c\u539f\u59cb\u8d39\u7528\u6c60\u8bb0\u5f55\u6ca1\u6709\u83b7\u53d6\u5230");
        if (rebateFeePoolVo.getAdjustType() == null) {
            return null;
        }
        RebateFeePoolBpmVo bpmVo = new RebateFeePoolBpmVo();
        bpmVo.setCusCode(rebateFeePoolVo.getCusCode());
        bpmVo.setCusName(rebateFeePoolVo.getCusName());
        bpmVo.setSaleCompanyCode(rebateFeePoolVo.getSaleCompanyCode());
        bpmVo.setSaleCompanyName(rebateFeePoolVo.getSaleCompanyName());
        bpmVo.setUniqueDictCode(rebateFeePoolVo.getUniqueDictCode());
        bpmVo.setIndexDictCode(rebateFeePoolVo.getIndexDictCode());
        bpmVo.setAdjustFee(rebateFeePoolVo.getAdjustFee());
        bpmVo.setAdjustType(rebateFeePoolVo.getAdjustType());
        bpmVo.setFiles(rebateFeePoolVo.getFiles());
        bpmVo.setRemarks(rebateFeePoolVo.getRemarks());
        bpmVo.setResourceCode(rebateFeePoolVo.getResourceCode());
        bpmVo.setAdjustReason(rebateFeePoolVo.getAdjustReason());
        bpmVo.setRebateFeePoolCode(rebateFeePoolVo.getCode());
        if (rebateFeePoolEntity != null) {
            bpmVo.setBeforeAvailableFee(rebateFeePoolEntity.getBalance());
        }
        return this.rebateFeePoolBpmService.create(bpmVo);
    }

    private RebateFeePoolFrozenItemVo saveFrozenItem(RebateFeePoolVo vo) {
        if (vo == null || CollectionUtil.listEmpty((List)vo.getRebateFeePoolDetailVos())) {
            return null;
        }
        List files = Lists.newArrayList();
        BigDecimal frozenFee = BigDecimal.ZERO;
        BigDecimal unfrozenFee = BigDecimal.ZERO;
        for (RebateFeePoolDetailVo detailVo : vo.getRebateFeePoolDetailVos()) {
            FieldHandleUtil.initDecimalZero(detailVo);
            if (RebateFeePoolDetailLogUtil.AdjustTypeEnum.FROZEN.getCode().equals(detailVo.getAdjustType())) {
                frozenFee = frozenFee.add(detailVo.getAdjustFee());
                files = detailVo.getFiles();
            }
            if (!RebateFeePoolDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode().equals(detailVo.getAdjustType())) continue;
            unfrozenFee = unfrozenFee.add(detailVo.getAdjustFee());
            files = detailVo.getFiles();
        }
        List<RebateFeePoolFrozenFileVo> frozenFiles = BeanCopyUtil.copyList(files, RebateFeePoolFrozenFileVo.class);
        if (frozenFee.compareTo(BigDecimal.ZERO) > 0) {
            RebateFeePoolFrozenItemVo frozenItemVo = new RebateFeePoolFrozenItemVo();
            frozenItemVo.setFrozenFee(frozenFee);
            frozenItemVo.setFrozenReason(vo.getAdjustReason());
            frozenItemVo.setRebateFeePoolCode(vo.getCode());
            frozenItemVo.setUnfrozenFee(BigDecimal.ZERO);
            frozenItemVo.setRemainFrozenFee(frozenFee);
            frozenItemVo.setRemarks(vo.getRemarks());
            frozenItemVo.setFiles(frozenFiles);
            frozenItemVo.setCode(CodeUtil.getCode());
            this.rebateFeePoolFrozenItemService.create(frozenItemVo);
            return frozenItemVo;
        }
        if (unfrozenFee.compareTo(BigDecimal.ZERO) > 0) {
            ArrayList frozenItemVos;
            if (StringUtils.isEmpty((String)vo.getRebateFeePoolFrozenItemCode())) {
                frozenItemVos = this.rebateFeePoolFrozenItemService.findByPoolCode(vo.getCode());
            } else {
                RebateFeePoolFrozenItemVo frozenItemVo = this.rebateFeePoolFrozenItemService.findByCode(vo.getRebateFeePoolFrozenItemCode());
                ValidateUtils.validate((Object)frozenItemVo, (String)"\u51bb\u7ed3\u660e\u7ec6\u3010%s\u3011\u4e0d\u5b58\u5728", (String[])new String[]{vo.getRebateFeePoolFrozenItemCode()});
                frozenItemVos = Lists.newArrayList((Object[])new RebateFeePoolFrozenItemVo[]{frozenItemVo});
            }
            ValidateUtils.notEmpty(frozenItemVos, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u51bb\u7ed3\u660e\u7ec6\uff0c\u4e0d\u80fd\u89e3\u51bb\u8be5\u6298\u6263\u8d39\u7528\u6c60", (String[])new String[0]);
            Iterator<RebateFeePoolFrozenItemVo> iterator = frozenItemVos.iterator();
            BigDecimal reducer = unfrozenFee;
            while (iterator.hasNext()) {
                RebateFeePoolFrozenItemVo item = iterator.next();
                if (reducer.compareTo(BigDecimal.ZERO) < 1) break;
                if (item.getRemainFrozenFee().compareTo(reducer) > -1) {
                    item.setRemainFrozenFee(item.getRemainFrozenFee().subtract(reducer));
                    item.setUnfrozenFee(item.getUnfrozenFee().add(reducer));
                    reducer = BigDecimal.ZERO;
                    continue;
                }
                item.setRemainFrozenFee(BigDecimal.ZERO);
                item.setUnfrozenFee(item.getUnfrozenFee().add(item.getRemainFrozenFee()));
                reducer = reducer.subtract(item.getRemainFrozenFee());
            }
            ValidateUtils.isTrue((reducer.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u660e\u7ec6\u5df2\u51bb\u7ed3\u91d1\u989d\u4e0d\u8db3\u4ee5\u89e3\u51bb", (String[])new String[0]);
            frozenItemVos.forEach(f -> f.setFiles(frozenFiles));
            this.rebateFeePoolFrozenItemService.updateAll(frozenItemVos);
            return (RebateFeePoolFrozenItemVo)frozenItemVos.get(0);
        }
        return null;
    }

    private void computeAdjustFee(RebateFeePoolDetailVo v) {
        if (v == null || v.getAdjustFee() == null || v.getAdjustFee().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        RebateFeePoolDetailLogUtil.AdjustTypeEnum adjustTypeEnum = RebateFeePoolDetailLogUtil.AdjustTypeEnum.getEnumByCode(v.getAdjustType());
        ValidateUtils.validate((Object)((Object)adjustTypeEnum), (String)"\u8c03\u6574\u7c7b\u578b\u4e0d\u6b63\u786e");
        ValidateUtils.isTrue((v.getAdjustFee().compareTo(BigDecimal.ZERO) > -1 ? 1 : 0) != 0, (String)"\u8c03\u6574\u6761\u76ee\u65f6\uff0c\u8c03\u6574\u91d1\u989d\u8bf7\u8f93\u5165\u6b63\u6570", (String[])new String[0]);
        switch (RebateFeePoolDetailLogUtil.AdjustTypeEnum.getEnumByCode(v.getAdjustType())) {
            case ADJUST_ADD: 
            case HAND_ON_ACCOUNT: 
            case BACK_REBATE_ON_ACCOUNT: 
            case FEE_ON_ACCOUNT: {
                v.setItemTotalFee(v.getItemTotalFee().add(v.getAdjustFee()));
                v.setItemAvailableBalance(v.getItemAvailableBalance().add(v.getAdjustFee()));
                break;
            }
            case ADJUST_REDUCE: 
            case HAND_REDUCE: 
            case ORDER_REDUCE: {
                ValidateUtils.isTrue((v.getItemAvailableBalance().compareTo(v.getAdjustFee()) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u53ef\u7528\u4f59\u91cf\u4e0d\u8db3\u4ee5\u6263\u51cf\u4e0d\u8db3\uff0c\u8bf7\u786e\u8ba4", (String[])new String[]{v.getCode()});
                v.setItemAvailableBalance(v.getItemAvailableBalance().subtract(v.getAdjustFee()));
                v.setItemUsedFee(v.getItemUsedFee().add(v.getAdjustFee()));
                break;
            }
            case ORDER_BACK: {
                ValidateUtils.isTrue((v.getItemUsedFee().compareTo(v.getAdjustFee()) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u5df2\u4f7f\u7528\u91d1\u989d\u4e0d\u8db3\u4ee5\u51b2\u9500", (String[])new String[]{v.getCode()});
                v.setItemAvailableBalance(v.getItemAvailableBalance().add(v.getAdjustFee()));
                v.setItemUsedFee(v.getItemUsedFee().subtract(v.getAdjustFee()));
                break;
            }
            case FROZEN: {
                ValidateUtils.isTrue((v.getItemAvailableBalance().compareTo(v.getAdjustFee()) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u53ef\u7528\u4f59\u91cf\u4e0d\u8db3\u4ee5\u51bb\u7ed3\uff0c\u8bf7\u786e\u8ba4", (String[])new String[]{v.getCode()});
                v.setItemFrozenFee(v.getItemFrozenFee().add(v.getAdjustFee()));
                v.setItemAvailableBalance(v.getItemAvailableBalance().subtract(v.getAdjustFee()));
                break;
            }
            case UNFROZEN: {
                ValidateUtils.isTrue((v.getItemFrozenFee().compareTo(v.getAdjustFee()) > -1 ? 1 : 0) != 0, (String)"\u6761\u76ee%s\u5df2\u51bb\u7ed3\u91d1\u989d\u4e0d\u8db3\u4ee5\u89e3\u51bb\uff0c\u8bf7\u786e\u8ba4", (String[])new String[]{v.getCode()});
                v.setItemFrozenFee(v.getItemFrozenFee().subtract(v.getAdjustFee()));
                v.setItemAvailableBalance(v.getItemAvailableBalance().add(v.getAdjustFee()));
                break;
            }
            default: {
                throw new BusinessException("\u8c03\u6574\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8be5\u529f\u80fd\u53ea\u652f\u6301\u624b\u52a8\u4e0a\u8d26\u3001\u8fd4\u5229\u4e0a\u8d26\u3001\u8d39\u7528\u4e0a\u8d26\u3001\u8ba2\u5355\u56de\u9000\u3001\u624b\u52a8\u6263\u51cf\u3001\u8ba2\u5355\u6263\u51cf\u3001\u51bb\u7ed3\u3001\u89e3\u51bb");
            }
        }
    }

    @Override
    public BigDecimal findAvailableBalance(RebateFeePoolVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u67e5\u8be2\u6298\u6263\u8d39\u7528\u6c60\u53ef\u7528\u4f59\u989d\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getUniqueDictCode(), (String)"\u6298\u6263\u8d39\u7528\u6c60\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper<RebateFeePoolEntity> wrapper = RebateFeePoolUtil.buildUniqueWrapperParam(vo);
        List rebateFeePoolEntities = this.rebateFeePoolMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)rebateFeePoolEntities)) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalBalance = BigDecimal.ZERO;
        for (RebateFeePoolEntity entity : rebateFeePoolEntities) {
            totalBalance = totalBalance.add(entity.getBalance());
        }
        return totalBalance;
    }

    @Override
    @Transactional
    public boolean subtractBalance(RebateFeePoolVo vo) {
        BigDecimal reducer = this.subtractBalanceFree(vo);
        ValidateUtils.isTrue((reducer.compareTo(BigDecimal.ZERO) < 1 ? 1 : 0) != 0, (String)"\u4f59\u91cf\u4e0d\u8db3\uff0c\u6263\u51cf\u5931\u8d25", (String[])new String[0]);
        return true;
    }

    @Override
    @Transactional
    public BigDecimal subtractBalanceFree(RebateFeePoolVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u6298\u6263\u8d39\u7528\u6263\u51cf\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getUniqueDictCode(), (String)"\u6298\u6263\u8d39\u7528\u6263\u51cf\u65f6\uff0c\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.validate((Object)vo.getIndexDictCode(), (String)"\u6298\u6263\u8d39\u7528\u6263\u51cf\u65f6\uff0c\u6392\u5e8f\u89c4\u5219\u5b57\u5178\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        if (vo.getAdjustType() == null) {
            vo.setAdjustType(RebateFeePoolDetailLogUtil.AdjustTypeEnum.ORDER_REDUCE.getCode());
        }
        ValidateUtils.isTrue((boolean)RebateFeePoolDetailLogUtil.AdjustTypeEnum.isType(vo.getAdjustType(), 0), (String)"\u8c03\u6574\u7c7b\u578b\u4f20\u5165\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f20\u51653\u62167\uff0c3\uff1a\u624b\u52a8\u6263\u51cf\uff0c7\uff1a\u8ba2\u5355\u6263\u51cf", (String[])new String[0]);
        BigDecimal subtractFee = vo.getSubtractFee();
        ValidateUtils.isTrue((subtractFee != null && subtractFee.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u6263\u51cf\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String[])new String[0]);
        QueryWrapper<RebateFeePoolEntity> wrapper = RebateFeePoolUtil.buildUniqueWrapperParam(vo);
        List entities = this.rebateFeePoolMapper.selectList((Wrapper)wrapper);
        ValidateUtils.notEmpty((Collection)entities, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u6298\u6263\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6b63\u786e\u4f20\u5165\u552f\u4e00\u7ea6\u675f\uff0c\u6216\u8005\u552f\u4e00\u7ea6\u675f\u5bf9\u5e94\u7684\u5b57\u6bb5\u503c\u662f\u5426\u6b63\u786e", (String[])new String[0]);
        ValidateUtils.isTrue((entities.size() == 1 ? 1 : 0) != 0, (String)"\u901a\u8fc7\u552f\u4e00\u7ea6\u675f\u6761\u4ef6\u67e5\u5230\u591a\u6761\u6298\u6263\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6b63\u786e\u4f20\u5165\u552f\u4e00\u7ea6\u675f\uff0c\u6216\u8005\u552f\u4e00\u7ea6\u675f\u5bf9\u5e94\u7684\u5b57\u6bb5\u503c\u662f\u5426\u6b63\u786e", (String[])new String[0]);
        RebateFeePoolEntity entity = (RebateFeePoolEntity)((Object)entities.get(0));
        RebateFeePoolVo poolVo = BeanCopyUtil.copyBen((Object)entity, RebateFeePoolVo.class);
        poolVo.setApproved(vo.isApproved());
        poolVo.setBpmVo(vo.getBpmVo());
        poolVo.setAdjustType(vo.getAdjustType());
        poolVo.setAdjustFee(vo.getSubtractFee());
        poolVo.setAdjustReason(vo.getAdjustReason());
        poolVo.setResourceCode(vo.getResourceCode());
        poolVo.setRemarks(vo.getRemarks());
        poolVo.setFiles(vo.getFiles());
        List<RebateFeePoolDetailVo> rebateFeePoolDetailVos = this.rebateFeePoolDetailService.findByPoolCodeAndDictRule(entity.getCode(), vo.getIndexDictCode());
        ValidateUtils.notEmpty(rebateFeePoolDetailVos, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6298\u6263\u8d39\u7528\u6761\u76ee", (String[])new String[0]);
        BigDecimal reducer = subtractFee;
        ValidateUtils.isTrue((reducer.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u6263\u51cf\u65f6\uff0c\u8c03\u6574\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (String[])new String[0]);
        for (RebateFeePoolDetailVo detail : rebateFeePoolDetailVos) {
            if (reducer.compareTo(BigDecimal.ZERO) < 1) continue;
            detail.setAdjustType(vo.getAdjustType());
            detail.setRemarks(vo.getRemarks());
            detail.setResourceCode(vo.getResourceCode());
            detail.setFiles(vo.getFiles());
            detail.setAdjustReason(vo.getAdjustReason());
            if (detail.getItemAvailableBalance().compareTo(reducer) > -1) {
                detail.setAdjustFee(reducer);
                reducer = BigDecimal.ZERO;
                continue;
            }
            detail.setAdjustFee(detail.getItemAvailableBalance());
            reducer = reducer.subtract(detail.getItemAvailableBalance());
        }
        poolVo.setRebateFeePoolDetailVos(rebateFeePoolDetailVos);
        this.adjust(poolVo);
        return reducer;
    }

    @Override
    @Transactional
    public boolean redTrick(RebateFeePoolVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u6298\u6263\u8d39\u7528\u7ea2\u51b2\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getUniqueDictCode(), (String)"\u6298\u6263\u8d39\u7528\u7ea2\u51b2\u65f6\uff0c\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.validate((Object)vo.getIndexDictCode(), (String)"\u6298\u6263\u8d39\u7528\u7ea2\u51b2\u65f6\uff0c\u6392\u5e8f\u89c4\u5219\u5b57\u5178\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        if (vo.getAdjustType() == null) {
            vo.setAdjustType(RebateFeePoolDetailLogUtil.AdjustTypeEnum.ORDER_BACK.getCode());
        }
        ValidateUtils.isTrue((boolean)RebateFeePoolDetailLogUtil.AdjustTypeEnum.isType(vo.getAdjustType(), 3), (String)"\u8c03\u6574\u7c7b\u578b\u4f20\u5165\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f20\u51656\uff0c6\uff1a\u8ba2\u5355\u56de\u9000", (String[])new String[0]);
        BigDecimal redTrickFee = vo.getRedTrickFee();
        ValidateUtils.validate((Object)vo.getIndexDictCode(), (String)"\u51b2\u9500\u65f6\uff0c\u51b2\u9500\u6392\u5e8f\u89c4\u5219\u5b57\u5178\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.isTrue((redTrickFee != null && redTrickFee.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u7ea2\u51b2\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String[])new String[0]);
        QueryWrapper<RebateFeePoolEntity> wrapper = RebateFeePoolUtil.buildUniqueWrapperParam(vo);
        List entities = this.rebateFeePoolMapper.selectList((Wrapper)wrapper);
        ValidateUtils.notEmpty((Collection)entities, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u6298\u6263\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6b63\u786e\u4f20\u5165\u552f\u4e00\u7ea6\u675f\uff0c\u6216\u8005\u552f\u4e00\u7ea6\u675f\u5bf9\u5e94\u7684\u5b57\u6bb5\u503c\u662f\u5426\u6b63\u786e", (String[])new String[0]);
        ValidateUtils.isTrue((entities.size() == 1 ? 1 : 0) != 0, (String)"\u901a\u8fc7\u552f\u4e00\u7ea6\u675f\u6761\u4ef6\u67e5\u5230\u591a\u6761\u6298\u6263\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6b63\u786e\u4f20\u5165\u552f\u4e00\u7ea6\u675f\uff0c\u6216\u8005\u552f\u4e00\u7ea6\u675f\u5bf9\u5e94\u7684\u5b57\u6bb5\u503c\u662f\u5426\u6b63\u786e", (String[])new String[0]);
        RebateFeePoolEntity entity = (RebateFeePoolEntity)((Object)entities.get(0));
        RebateFeePoolVo poolVo = BeanCopyUtil.copyBen((Object)entity, RebateFeePoolVo.class);
        List<RebateFeePoolDetailVo> rebateFeePoolDetailVos = this.rebateFeePoolDetailService.findByPoolCodeAndDictRule(entity.getCode(), vo.getIndexDictCode());
        ValidateUtils.notEmpty(rebateFeePoolDetailVos, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6298\u6263\u8d39\u7528\u6761\u76ee", (String[])new String[0]);
        poolVo.setAdjustType(vo.getAdjustType());
        poolVo.setAdjustFee(vo.getRedTrickFee());
        poolVo.setAdjustReason(vo.getAdjustReason());
        poolVo.setFiles(vo.getFiles());
        poolVo.setRemarks(vo.getRemarks());
        poolVo.setResourceCode(vo.getResourceCode());
        BigDecimal reducer = redTrickFee;
        ValidateUtils.isTrue((reducer.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u51b2\u9500\u65f6\uff0c\u51b2\u9500\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (String[])new String[0]);
        for (RebateFeePoolDetailVo detail : rebateFeePoolDetailVos) {
            if (reducer.compareTo(BigDecimal.ZERO) < 1) continue;
            detail.setAdjustType(vo.getAdjustType());
            detail.setRemarks(vo.getRemarks());
            detail.setResourceCode(vo.getResourceCode());
            detail.setFiles(vo.getFiles());
            detail.setAdjustReason(vo.getAdjustReason());
            if (detail.getItemUsedFee().compareTo(reducer) > -1) {
                detail.setAdjustFee(reducer);
                reducer = BigDecimal.ZERO;
                continue;
            }
            detail.setAdjustFee(detail.getItemUsedFee());
            reducer = reducer.subtract(detail.getItemUsedFee());
        }
        ValidateUtils.isTrue((reducer.compareTo(BigDecimal.ZERO) < 1 ? 1 : 0) != 0, (String)"\u51b2\u9500\u5931\u8d25\uff0c\u6ca1\u6709\u4f7f\u7528\u91cf\u4e0d\u8db3\u4ee5\u51b2\u9500", (String[])new String[0]);
        poolVo.setRebateFeePoolDetailVos(rebateFeePoolDetailVos);
        this.adjust(poolVo);
        return true;
    }

    @Override
    public PageResult<RebateFeePoolVo> findPageByConditions(RebateFeePoolVo param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        List<RebateFeePoolVo> list = this.rebateFeePoolMapper.findPageByConditions((Page<RebateFeePoolVo>)page, param.getCusOrgName(), param.getCusName(), param.getCusChannelName(), param.getCusCode());
        if (CollectionUtil.listEmpty(list)) {
            return PageResult.builder().data((List)Lists.newArrayList()).count(Long.valueOf(page.getTotal())).build();
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public RebateFeePoolVo findPoolByCode(String rebateFeePoolCode) {
        if (StringUtils.isEmpty((String)rebateFeePoolCode)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"code", (Object)rebateFeePoolCode);
        RebateFeePoolEntity entity = (RebateFeePoolEntity)((Object)this.rebateFeePoolMapper.selectOne((Wrapper)wrapper));
        if (entity == null) {
            return null;
        }
        RebateFeePoolVo vo = new RebateFeePoolVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        return vo;
    }

    @Override
    public FeePoolSumReportRes findFeePoolSum(RebateFeePoolVo param) {
        Map<String, FeePoolSumReportRes> deviceRel = this.findFeePoolSumDevice(param);
        FeePoolSumReportRes result = new FeePoolSumReportRes();
        result.setAvailableBalance(deviceRel.get(REBATE_FEE_KEY).getAvailableBalance().add(deviceRel.get(REP_FEE_KEY).getAvailableBalance()));
        result.setLastBalance(deviceRel.get(REBATE_FEE_KEY).getLastBalance().add(deviceRel.get(REP_FEE_KEY).getLastBalance()));
        result.setCurrentUsedFee(deviceRel.get(REBATE_FEE_KEY).getCurrentUsedFee().add(deviceRel.get(REP_FEE_KEY).getCurrentUsedFee()));
        result.setCurrentOnAccountFee(deviceRel.get(REBATE_FEE_KEY).getCurrentOnAccountFee().add(deviceRel.get(REP_FEE_KEY).getCurrentOnAccountFee()));
        return result;
    }

    @Override
    public Map<String, FeePoolSumReportRes> findFeePoolSumDevice(RebateFeePoolVo param) {
        Map<String, Object> map = this.buildFeePoolSumParam(param);
        FeePoolSumReportRes rebateRel = this.findRebateFeePoolSum(map);
        Map<String, Object> mapRep = this.buildFeePoolSumParam(param);
        FeePoolSumReportRes repRel = this.repFeePoolService.findRepFeePoolFeeSum(mapRep);
        HashMap result = Maps.newHashMap();
        result.put(REBATE_FEE_KEY, rebateRel);
        result.put(REP_FEE_KEY, repRel);
        return result;
    }

    private Map<String, Object> buildFeePoolSumParam(RebateFeePoolVo param) {
        ValidateUtils.validate((Object)param, (String)"\u67e5\u8be2\u8d39\u7528\u6c47\u603b\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.validate((Object)param.getUniqueDictCode(), (String)"\u67e5\u8be2\u8d39\u7528\u6c47\u603b\u65f6\uff0c\u552f\u4e00\u7ea6\u675f\u6570\u636e\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        Map<String, Object> map = RebateFeePoolUtil.buildUniqueMapParam(param);
        String startTime = param.getStartDate();
        String endTime = param.getEndDate();
        if (StringUtils.isEmpty((String)startTime) || StringUtils.isEmpty((String)endTime)) {
            startTime = TimeUtil.getMonthStart(null, "yyyy-MM-dd HH:mm:ss");
            endTime = TimeUtil.getMonthEnd(null, "yyyy-MM-dd HH:mm:ss");
        }
        map.put("startDate", startTime);
        map.put("endDate", endTime);
        return map;
    }

    private FeePoolSumReportRes findRebateFeePoolSum(Map<String, Object> map) {
        ArrayList rebateFeePoolDetailVos = this.rebateFeePoolDetailMapper.findByConditions(map);
        if (rebateFeePoolDetailVos == null) {
            rebateFeePoolDetailVos = Lists.newArrayList();
        }
        ArrayList fees = Lists.newArrayList();
        rebateFeePoolDetailVos.forEach(r -> {
            map.put("detailCode", r.getCode());
            FeePoolSumReportRes rebateFee = this.rebateFeePoolDetailLogMapper.findFee(map);
            if (rebateFee != null) {
                fees.add(rebateFee);
            }
        });
        FeePoolSumReportRes feeRel = this.buildFeePoolFeeSumResult(fees);
        feeRel.setCusCode((String)map.get("cusCode"));
        feeRel.setProjectName("\u73b0\u91d1\u6298\u6263\u60c5\u51b5");
        feeRel.setPeriod(String.join((CharSequence)"\u81f3", map.get("startDate").toString().replace(" 00:00:00", ""), map.get("endDate").toString().replace(" 23:59:59", "")));
        return feeRel;
    }

    @Override
    public FeePoolSumReportRes buildFeePoolFeeSumResult(List<FeePoolSumReportRes> fees) {
        FeePoolSumReportRes feeRel = new FeePoolSumReportRes();
        BigDecimal currentBalance = BigDecimal.ZERO;
        BigDecimal lastBalance = BigDecimal.ZERO;
        BigDecimal currentOnAccountFee = BigDecimal.ZERO;
        BigDecimal currentUsedFee = BigDecimal.ZERO;
        for (FeePoolSumReportRes r : fees) {
            FieldHandleUtil.initDecimalZero(r);
            lastBalance = lastBalance.add(r.getLastBalance());
            currentOnAccountFee = currentOnAccountFee.add(r.getCurrentOnAccountFee());
            currentUsedFee = currentUsedFee.add(r.getCurrentUsedFee());
            currentBalance = currentBalance.add(r.getAvailableBalance());
        }
        feeRel.setAvailableBalance(currentBalance);
        feeRel.setLastBalance(lastBalance);
        feeRel.setCurrentOnAccountFee(currentOnAccountFee);
        feeRel.setCurrentUsedFee(currentUsedFee);
        return feeRel;
    }

    @Override
    public List<FeePoolDetailLogVo> listLog(RebateFeePoolVo vo) {
        if (vo == null) {
            return Lists.newArrayList();
        }
        UserRedis user = UserUtils.getUser();
        ValidateUtils.validate((Object)user, (String)"\u6ca1\u6709\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u767b\u5f55");
        vo.setCusCode(user.getCustcode());
        List<FeePoolDetailLogVo> logs = this.rebateFeePoolDetailLogMapper.listLog(vo);
        return logs;
    }

    @Override
    public PageResult<FeePoolDetailLogVo> pageLog(RebateFeePoolVo vo) {
        if (vo == null) {
            return PageResult.builder().data((List)Lists.newArrayList()).build();
        }
        Page page = new Page((long)vo.getPageNum().intValue(), (long)vo.getPageSize().intValue());
        UserRedis user = UserUtils.getUser();
        ValidateUtils.validate((Object)user, (String)"\u6ca1\u6709\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u767b\u5f55");
        vo.setCusCode(user.getCustcode());
        List<FeePoolDetailLogVo> logs = this.rebateFeePoolDetailLogMapper.pageLog(page, vo);
        if (CollectionUtil.listEmpty(logs)) {
            return PageResult.builder().data((List)Lists.newArrayList()).build();
        }
        return PageResult.builder().data(logs).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public boolean wrapperFrozen(RebateFeePoolVo vo) {
        BigDecimal reducer;
        ValidateUtils.validate((Object)vo, (String)"\u51bb\u7ed3/\u89e3\u51bb\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.validate((Object)(Objects.equals(vo.getAdjustType(), RebateFeePoolDetailLogUtil.AdjustTypeEnum.FROZEN.getCode()) || Objects.equals(vo.getAdjustType(), (Object)RebateFeePoolDetailLogUtil.AdjustTypeEnum.UNFROZEN) ? 1 : 0), (String)"\u8be5\u529f\u80fd\u4ec5\u652f\u6301\u51bb\u7ed3\uff088\uff09\u6216\u8005\u89e3\u51bb\uff089\uff09");
        QueryWrapper<RebateFeePoolEntity> wrapper = RebateFeePoolUtil.buildUniqueWrapperParam(vo);
        List entities = this.rebateFeePoolMapper.selectList((Wrapper)wrapper);
        ValidateUtils.notEmpty((Collection)entities, (String)"\u6839\u636e\u552f\u4e00\u7ea6\u675f\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8d39\u7528\u6c60\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u548c\u5bf9\u5e94\u503c\u662f\u5426\u6b63\u786e\u4f20\u5165", (String[])new String[0]);
        ValidateUtils.isTrue((entities.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636e\u552f\u4e00\u7ea6\u675f\u83b7\u53d6\u5230\u591a\u6761\u8d39\u7528\u6c60\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u548c\u5bf9\u5e94\u503c\u662f\u5426\u6b63\u786e\u4f20\u5165", (String[])new String[0]);
        RebateFeePoolEntity entity = (RebateFeePoolEntity)((Object)entities.get(0));
        List<RebateFeePoolDetailVo> details = this.rebateFeePoolDetailService.findByPoolCodeAndDictRule(entity.getCode(), vo.getIndexDictCode());
        ValidateUtils.notEmpty(details, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u6761\u76ee\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u6392\u5e8f\u89c4\u5219\u662f\u5426\u6b63\u786e\u4f20\u5165", (String[])new String[0]);
        RebateFeePoolDetailLogUtil.AdjustTypeEnum adjustTypeEnum = RebateFeePoolDetailLogUtil.AdjustTypeEnum.getEnumByCode(vo.getAdjustType());
        ValidateUtils.validate((Object)((Object)adjustTypeEnum), (String)"\u8c03\u6574\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u8be5\u529f\u80fd\u53ea\u80fd\u4f20\u5165\u51bb\u7ed3\uff088\uff09/\u89e3\u51bb\uff089\uff09\u7c7b\u578b");
        vo.setId(entity.getId());
        vo.setCode(entity.getCode());
        FieldHandleUtil.initDecimalZero(vo);
        switch (adjustTypeEnum) {
            case FROZEN: {
                reducer = this.computeFrozenDetails(details, vo);
                break;
            }
            case UNFROZEN: {
                reducer = this.computeUnfrozenDetails(details, vo);
                break;
            }
            default: {
                throw new BusinessException("\u51bb\u7ed3/\u89e3\u51bb\u65f6\u8c03\u6574\u7c7b\u578b\u4f20\u9012\u4e0d\u6b63\u786e\uff0c\u53ea\u5141\u8bb8\u4f208\uff08\u51bb\u7ed3\uff09\u30019\uff08\u89e3\u51bb\uff09");
            }
        }
        ValidateUtils.isTrue((reducer.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3/\u89e3\u51bb\u5931\u8d25\uff0c\u53ef\u4f7f\u7528\u4f59\u989d\u4e0d\u8db3", (String[])new String[0]);
        vo.setRebateFeePoolDetailVos(details);
        this.adjust(vo);
        return true;
    }

    @Override
    public List<RebateFeePoolSumReportRes> findRebateFeePoolSum(RebateFeePoolSumReportReq param) {
        if (param == null) {
            return Lists.newArrayList();
        }
        String startTime = param.getStartDate();
        String endTime = param.getEndDate();
        if (StringUtils.isEmpty((String)startTime) || StringUtils.isEmpty((String)endTime)) {
            startTime = TimeUtil.getMonthStart(null, "yyyy-MM-dd HH:mm:ss");
            endTime = TimeUtil.getMonthEnd(null, "yyyy-MM-dd HH:mm:ss");
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq(StringUtils.isNotEmpty((String)param.getCusCode()), (Object)"cus_code", (Object)param.getCusCode());
        wrapper.eq(StringUtils.isNotEmpty((String)param.getCusOrgCode()), (Object)"cus_org_code", (Object)param.getCusOrgCode());
        wrapper.eq(StringUtils.isNotEmpty((String)param.getCusChannelCode()), (Object)"cus_channel_code", (Object)param.getCusChannelCode());
        wrapper.eq(StringUtils.isNotEmpty((String)param.getSaleCompanyCode()), (Object)"sale_company_code", (Object)param.getSaleCompanyCode());
        List entities = this.rebateFeePoolMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        HashMap map = Maps.newHashMap();
        map.put("startDate", startTime);
        map.put("endDate", endTime);
        ArrayList result = Lists.newArrayList();
        entities.forEach(en -> {
            map.put("repFeePoolCode", en.getCode());
            FeePoolSumReportRes feeRel = this.findRebateFeePoolSum(map);
            RebateFeePoolSumReportRes rel = BeanCopyUtil.copyBen(feeRel, RebateFeePoolSumReportRes.class);
            rel.setCusCode(en.getCusCode());
            rel.setCusName(en.getCusName());
            rel.setCusOrgCode(en.getCusOrgCode());
            rel.setCusOrgName(en.getCusOrgName());
            rel.setCusChannelCode(en.getCusChannelCode());
            rel.setCusChannelName(en.getCusChannelName());
            rel.setSaleCompanyCode(en.getSaleCompanyCode());
            rel.setSaleCompanyName(en.getSaleCompanyName());
            result.add(rel);
        });
        return result;
    }

    @Override
    @Transactional
    public Boolean wrapperAdjust(RebateFeePoolVo vo) {
        Validate.notNull((Object)vo, (String)"\u8c03\u6574\u6298\u6263\u8d39\u7528\u6c60\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RebateFeePoolVo rebateFeePoolVo = this.findPoolByCode(vo.getCode());
        Validate.notNull((Object)rebateFeePoolVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8d39\u7528\u6c60\u8bb0\u5f55", (Object[])new Object[0]);
        switch (RebateFeePoolDetailLogUtil.AdjustTypeEnum.getEnumByCode(vo.getAdjustType())) {
            case ADJUST_REDUCE: {
                RebateFeePoolVo subtractParam = BeanCopyUtil.copyBen(vo, RebateFeePoolVo.class);
                subtractParam.setSubtractFee(vo.getAdjustFee());
                this.subtractBalance(subtractParam);
                break;
            }
            case ADJUST_ADD: {
                RebateFeePoolVo addParam = BeanCopyUtil.copyBen(vo, RebateFeePoolVo.class);
                List<RebateFeePoolDetailVo> details = this.rebateFeePoolDetailService.findByPoolCodeAndDictRule(vo.getCode(), vo.getIndexDictCode());
                ValidateUtils.notEmpty(details, (String)"\u8c03\u589e\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u6761\u76ee\u5217\u8868", (String[])new String[0]);
                RebateFeePoolDetailVo detailVo = details.get(details.size() - 1);
                detailVo.setAdjustFee(vo.getAdjustFee());
                detailVo.setAdjustType(vo.getAdjustType());
                detailVo.setRemarks(vo.getRemarks());
                detailVo.setFiles(vo.getFiles());
                detailVo.setResourceCode(vo.getResourceCode());
                detailVo.setAdjustReason(vo.getAdjustReason());
                addParam.setRebateFeePoolDetailVos(details);
                this.adjust(addParam);
                break;
            }
            case FROZEN: 
            case UNFROZEN: {
                RebateFeePoolVo frozenParam = BeanCopyUtil.copyBen(vo, RebateFeePoolVo.class);
                frozenParam.setAdjustFee(vo.getFrozenFee());
                this.wrapperFrozen(frozenParam);
                break;
            }
            default: {
                throw new BusinessException("\u8c03\u6574\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
        }
        return true;
    }

    @Override
    public Boolean unfrozenItem(RebateFeePoolVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u89e3\u51bb\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getCode(), (String)"\u89e3\u51bb\u660e\u7ec6\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.validate((Object)vo.getRebateFeePoolFrozenItemCode(), (String)"\u89e3\u51bb\u660e\u7ec6\u65f6\uff0c\u51bb\u7ed3\u660e\u7ec6\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.isTrue((boolean)Objects.equals(vo.getAdjustType(), RebateFeePoolDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode()), (String)"\u8be5\u529f\u80fd\u4ec5\u652f\u6301\u89e3\u51bb\uff0c\u8c03\u6574\u7c7b\u578b\u8bf7\u4f20\u90129\uff08\u89e3\u51bb\uff09", (String[])new String[0]);
        RebateFeePoolVo oldVo = this.findPoolByCode(vo.getCode());
        ValidateUtils.validate((Object)oldVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u8d39\u7528\u6c60\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
        oldVo.setIndexDictCode(vo.getIndexDictCode());
        oldVo.setAdjustType(vo.getAdjustType());
        oldVo.setAdjustFee(vo.getAdjustFee());
        oldVo.setRebateFeePoolFrozenItemCode(vo.getRebateFeePoolFrozenItemCode());
        oldVo.setResourceCode(vo.getResourceCode());
        oldVo.setAdjustReason(vo.getAdjustReason());
        oldVo.setUniqueDictCode(vo.getUniqueDictCode());
        oldVo.setFiles(vo.getFiles());
        oldVo.setRemarks(vo.getRemarks());
        return this.wrapperFrozen(oldVo);
    }

    @Override
    @Transactional
    public void reflush(String cusCode, String salesCompanyCode) {
        this.rebateFeePoolDetailService.reflush(cusCode, salesCompanyCode);
        this.reflushItemForReflush(cusCode, salesCompanyCode);
    }

    @Override
    public SelectBanlanceRes selectBanlance(String cusCode) {
        SelectBanlanceRes res = SelectBanlanceRes.instanceEmpty();
        if (StringUtils.isEmpty((String)cusCode)) {
            return res;
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"cus_code", (Object)cusCode);
        List entities = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return res;
        }
        BigDecimal rebateBanlance = BigDecimal.ZERO;
        for (RebateFeePoolEntity rebateFeePoolEntity : entities) {
            rebateBanlance = rebateBanlance.add(null == rebateFeePoolEntity.getBalance() ? BigDecimal.ZERO : rebateFeePoolEntity.getBalance());
        }
        res.setRebateBanlance(rebateBanlance);
        List<SelectBanceVo> logList = this.rebateFeePoolDetailLogService.listSumForPC(cusCode, DateUtil.date2Str((Date)DateUtil.getFirstDayOfMonth((Date)DateUtil.getDate()), (SimpleDateFormat)DateUtil.date_sdf), DateUtil.date2Str((Date)DateUtil.getLastDayOfMonth((Date)DateUtil.getDate()), (SimpleDateFormat)DateUtil.date_sdf));
        ArrayList<SelectBanlanceRebateRes> selectBanlanceRebateResList = new ArrayList<SelectBanlanceRebateRes>(entities.size());
        for (RebateFeePoolEntity entity : entities) {
            SelectBanlanceRebateRes selectBanlanceRebateRes = new SelectBanlanceRebateRes();
            selectBanlanceRebateRes.setSaleCompaneyName(entity.getSaleCompanyName());
            selectBanlanceRebateRes.setRebateBanlance(entity.getBalance());
            selectBanlanceRebateRes.setRebateAccount(BigDecimal.ZERO);
            selectBanlanceRebateRes.setRebateUsedBanlance(BigDecimal.ZERO);
            if (CollectionUtils.isEmpty(logList)) {
                selectBanlanceRebateResList.add(selectBanlanceRebateRes);
                continue;
            }
            for (SelectBanceVo selectBanceVo : logList) {
                if (!selectBanceVo.getSaleCompanyCode().equals(entity.getSaleCompanyCode())) continue;
                if (RebateFeePoolDetailLogUtil.AdjustTypeEnum.isType(selectBanceVo.getAdjustType(), 1)) {
                    selectBanlanceRebateRes.setRebateAccount(selectBanlanceRebateRes.getRebateAccount().add(selectBanceVo.getFee()));
                }
                if (!RebateFeePoolDetailLogUtil.AdjustTypeEnum.isType(selectBanceVo.getAdjustType(), 0)) continue;
                selectBanlanceRebateRes.setRebateUsedBanlance(selectBanlanceRebateRes.getRebateUsedBanlance().add(selectBanceVo.getFee()));
            }
            selectBanlanceRebateResList.add(selectBanlanceRebateRes);
        }
        res.setSelectBanlanceRebateRes(selectBanlanceRebateResList);
        return res;
    }

    @Override
    public Map<String, Object> list(String cusCode, ListReq listReq) {
        String startDate = null;
        String endDate = null;
        if (!StringUtils.isEmpty((String)listReq.getMonth())) {
            Date month = DateUtil.str2Date((String)listReq.getMonth(), (SimpleDateFormat)DateUtil.yyyy_MM);
            startDate = DateUtil.date2Str((Date)DateUtil.getFirstDayOfMonth((Date)month), (SimpleDateFormat)DateUtil.date_sdf);
            endDate = DateUtil.date2Str((Date)DateUtil.getLastDayOfMonth((Date)month), (SimpleDateFormat)DateUtil.date_sdf);
        }
        ListFeeReq listFeeReq = ListFeeReq.newInstance((String)listReq.getSalesCompaneyCode(), startDate, endDate);
        PageResult<ListAccountRes> accountPageResult = this.rebateFeePoolDetailLogService.listAccount(cusCode, listFeeReq);
        PageResult<ListUsedRes> usePageResult = this.rebateFeePoolBpmService.listUsed(cusCode, listFeeReq);
        RebateFeePoolVo param = new RebateFeePoolVo();
        param.setStartDate(startDate);
        param.setEndDate(endDate);
        param.setCusCode(cusCode);
        HashMap sumParam = Maps.newHashMap();
        sumParam.put("startDate", startDate.concat(" 00:00:00"));
        sumParam.put("endDate", endDate.concat(" 23:59:59"));
        if (startDate == null) {
            sumParam.put("startDate", TimeUtil.getMonthStart(new Date(), "yyyy-MM-dd").concat(" 00:00:00"));
        }
        if (endDate == null) {
            sumParam.put("endDate", TimeUtil.getMonthEnd(new Date(), "yyyy-MM-dd").concat(" 23:59:59"));
        }
        sumParam.put("cusCode", cusCode);
        FeePoolSumReportRes sum = StringUtils.isEmpty((String)cusCode) ? new FeePoolSumReportRes() : this.findRebateFeePoolSum(sumParam);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Account", accountPageResult.getData());
        map.put("Used", usePageResult.getData());
        map.put("Sum", sum);
        return map;
    }

    public void reflushItemForReflush(String cusCode, String salesCompanyCode) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"cus_code", (Object)cusCode)).eq((Object)"sale_company_code", (Object)salesCompanyCode);
        List entities = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return;
        }
        RebateFeePoolEntity entity = (RebateFeePoolEntity)((Object)entities.get(0));
        RebateDetailReflushVo vo = this.rebateFeePoolDetailService.sumFeeByPoolCode(entity.getCode());
        RebateDetailReflushVo logVo = this.rebateFeePoolBpmService.sumFeeByPoolCode(entity.getCode());
        this.updateById((Object)RebateFeePoolUtil.packageEntityForReflush(entity, vo, logVo));
    }

    private BigDecimal computeFrozenDetails(List<RebateFeePoolDetailVo> details, RebateFeePoolVo vo) {
        BigDecimal reducer = vo.getAdjustFee();
        ValidateUtils.isTrue((reducer.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u65f6\uff0c\u8c03\u6574\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (String[])new String[0]);
        for (RebateFeePoolDetailVo detail : details) {
            if (reducer.compareTo(BigDecimal.ZERO) < 1) break;
            detail.setAdjustType(vo.getAdjustType());
            detail.setResourceCode(vo.getResourceCode());
            detail.setRemarks(vo.getRemarks());
            detail.setFiles(vo.getFiles());
            detail.setAdjustReason(vo.getAdjustReason());
            if (detail.getItemAvailableBalance().compareTo(reducer) > -1) {
                detail.setAdjustFee(reducer);
                reducer = BigDecimal.ZERO;
                continue;
            }
            detail.setAdjustFee(detail.getItemAvailableBalance());
            reducer = reducer.subtract(detail.getItemAvailableBalance());
        }
        return reducer;
    }

    private BigDecimal computeUnfrozenDetails(List<RebateFeePoolDetailVo> details, RebateFeePoolVo vo) {
        BigDecimal reducer = vo.getAdjustFee();
        ValidateUtils.isTrue((reducer.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u89e3\u51bb\u65f6\uff0c\u8c03\u6574\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (String[])new String[0]);
        for (RebateFeePoolDetailVo detail : details) {
            if (reducer.compareTo(BigDecimal.ZERO) < 1) break;
            detail.setAdjustType(vo.getAdjustType());
            detail.setResourceCode(vo.getResourceCode());
            detail.setRemarks(vo.getRemarks());
            detail.setFiles(vo.getFiles());
            detail.setAdjustReason(vo.getAdjustReason());
            if (detail.getItemFrozenFee().compareTo(reducer) > -1) {
                detail.setAdjustFee(reducer);
                reducer = BigDecimal.ZERO;
                continue;
            }
            detail.setAdjustFee(detail.getItemFrozenFee());
            reducer = reducer.subtract(detail.getItemFrozenFee());
        }
        return reducer;
    }
}

