/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.rebatefeepool.FeePoolSumReportRes;
import com.biz.crm.nebular.dms.rebatefeepool.SelectBanlanceRepRes;
import com.biz.crm.nebular.dms.repfeepool.ListAccountRes;
import com.biz.crm.nebular.dms.repfeepool.ListFeeReq;
import com.biz.crm.nebular.dms.repfeepool.ListReq;
import com.biz.crm.nebular.dms.repfeepool.ListUsedRes;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolSumReportReq;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolSumReportRes;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolVo;
import com.biz.crm.nebular.dms.repfeepool.SelectRepBanceVo;
import com.biz.crm.rebatefeepool.entity.RebateFeePoolEntity;
import com.biz.crm.rebatefeepool.service.RebateFeePoolService;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolDetailLogUtil;
import com.biz.crm.repfeepool.entity.RepFeePoolEntity;
import com.biz.crm.repfeepool.entity.RepFeePoolItemEntity;
import com.biz.crm.repfeepool.mapper.RepFeePoolItemDetailLogMapper;
import com.biz.crm.repfeepool.mapper.RepFeePoolItemDetailMapper;
import com.biz.crm.repfeepool.mapper.RepFeePoolMapper;
import com.biz.crm.repfeepool.service.RepFeePoolBpmService;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailLogService;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailService;
import com.biz.crm.repfeepool.service.RepFeePoolItemService;
import com.biz.crm.repfeepool.service.RepFeePoolService;
import com.biz.crm.repfeepool.utils.RepFeePoolItemDetailLogUtil;
import com.biz.crm.repfeepool.utils.RepFeePoolItemDetailUtil;
import com.biz.crm.repfeepool.utils.RepFeePoolUtil;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TimeUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="repFeePoolService")
@ConditionalOnMissingBean(name={"repFeePoolServiceImpl"})
public class RepFeePoolServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RepFeePoolMapper, RepFeePoolEntity>
implements RepFeePoolService {
    @Resource
    private RepFeePoolMapper repFeePoolMapper;
    @Resource
    private RepFeePoolItemService repFeePoolItemService;
    @Resource
    private RepFeePoolIItemDetailService repFeePoolIItemDetailService;
    @Resource
    private RepFeePoolItemDetailMapper repFeePoolItemDetailMapper;
    @Resource
    private RepFeePoolItemDetailLogMapper repFeePoolItemDetailLogMapper;
    @Resource
    private RebateFeePoolService rebateFeePoolService;
    @Resource
    private RepFeePoolBpmService repFeePoolBpmService;
    @Resource
    private RepFeePoolIItemDetailLogService repFeePoolIItemDetailLogService;

    @Override
    @Transactional
    public Map<String, Boolean> subtractBalance(RepFeePoolVo vo, BigDecimal price) {
        Map<String, BigDecimal> result = this.subtractBalanceFree(vo, price);
        ValidateUtils.notEmpty(result, (String)"\u6263\u51cf\u5931\u8d25", (String[])new String[0]);
        HashMap map = Maps.newHashMap();
        result.forEach((k, v) -> {
            ValidateUtils.isTrue((v.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u5546\u54c1\u3010%s\u3011\u4f59\u989d\u4e0d\u8db3\uff0c\u6263\u51cf\u5931\u8d25", (String[])new String[]{k});
            map.put(k, true);
        });
        return map;
    }

    @Override
    @Transactional
    public Map<String, BigDecimal> subtractBalanceFree(RepFeePoolVo vo, BigDecimal price) {
        return this.subtractOrRedTrickCount(vo, price);
    }

    private Map<String, BigDecimal> subtractOrRedTrickCount(RepFeePoolVo vo, BigDecimal price) {
        ValidateUtils.validate((Object)vo, (String)"\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.validate((Object)vo.getUniqueDictCode(), (String)"\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.notEmpty((Collection)vo.getRepFeePoolItemVos(), (String)"\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        TreeMap result = Maps.newTreeMap();
        QueryWrapper<RebateFeePoolEntity> wrapper = RepFeePoolUtil.buildUniqueWrapperParam(vo);
        List repFeePoolEntities = this.repFeePoolMapper.selectList((Wrapper)wrapper);
        ValidateUtils.notEmpty((Collection)repFeePoolEntities, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8d39\u7528\u6c60\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u662f\u5426\u4f20\u9012\u6b63\u786e", (String[])new String[0]);
        ValidateUtils.isTrue((repFeePoolEntities.size() == 1 ? 1 : 0) != 0, (String)"\u83b7\u53d6\u5230\u591a\u6761\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u662f\u5426\u4f20\u9012\u6b63\u786e", (String[])new String[0]);
        RepFeePoolEntity repFeePoolEntity = (RepFeePoolEntity)((Object)repFeePoolEntities.get(0));
        List<RepFeePoolItemVo> itemVos = this.repFeePoolItemService.findByPoolCode(repFeePoolEntity.getCode());
        ValidateUtils.notEmpty(itemVos, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8d39\u7528\u6c60\u660e\u7ec6\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4e0a\u8fc7\u8d26", (String[])new String[0]);
        HashMap itemVoMap = Maps.newHashMap();
        itemVos.forEach(item -> itemVoMap.put(item.getProductCode(), item));
        HashSet productCodes = Sets.newHashSet();
        vo.getRepFeePoolItemVos().forEach(v -> productCodes.add(v.getProductCode()));
        ValidateUtils.isTrue((productCodes.size() == vo.getRepFeePoolItemVos().size() ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u6bcf\u6761\u660e\u7ec6\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (String[])new String[0]);
        block4: for (RepFeePoolItemVo item2 : vo.getRepFeePoolItemVos()) {
            BigDecimal reducer;
            RepFeePoolItemVo dbItem = (RepFeePoolItemVo)itemVoMap.get(item2.getProductCode());
            dbItem.setApproved(item2.isApproved());
            dbItem.setBpmVo(item2.getBpmVo());
            if (item2.isUseItemPrice()) {
                dbItem.setSalePrice(item2.getSalePrice());
                dbItem.setCostPrice(item2.getCostPrice());
            }
            dbItem.setRemarks(item2.getRemarks());
            dbItem.setFiles(item2.getFiles());
            dbItem.setResourceCode(item2.getResourceCode());
            dbItem.setAdjustReason(item2.getAdjustReason());
            List<RepFeePoolItemDetailVo> detailVos = this.repFeePoolIItemDetailService.findByItemCodeAndDictRule(dbItem.getCode(), item2.getIndexDictCode());
            ValidateUtils.notEmpty(detailVos, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6761\u76ee\u5217\u8868\uff0c\u4e0d\u80fd\u8c03\u6574\uff0c\u8bf7\u5148\u4e0a\u8d26", (String[])new String[0]);
            switch (RebateFeePoolDetailLogUtil.AdjustTypeEnum.getType(item2.getAdjustCountType())) {
                case 0: {
                    if (dbItem == null) {
                        result.put(item2.getProductCode(), item2.getSubtractCount());
                        continue block4;
                    }
                    if (CollectionUtil.listEmpty(detailVos)) {
                        result.put(item2.getProductCode(), item2.getSubtractCount());
                        continue block4;
                    }
                    reducer = this.computeSubtractCount(item2, detailVos);
                    break;
                }
                case 3: {
                    if (dbItem == null) {
                        result.put(item2.getProductCode(), item2.getRedTrickCount());
                        continue block4;
                    }
                    if (CollectionUtil.listEmpty(detailVos)) {
                        result.put(item2.getProductCode(), item2.getRedTrickCount());
                        continue block4;
                    }
                    reducer = this.computeRedTrickCount(item2, detailVos);
                    ValidateUtils.isTrue((reducer.compareTo(BigDecimal.ZERO) < 1 ? 1 : 0) != 0, (String)"\u5df2\u4f7f\u7528\u6570\u91cf\uff0c\u4e0d\u8db3\u4ee5\u51b2\u9500", (String[])new String[0]);
                    break;
                }
                default: {
                    throw new BusinessException("\u8c03\u6574\u72b6\u6001[adjustCountType]\u4e0d\u6b63\u786e\uff0c\u51b2\u9500\u8bf7\u4f206\uff0c\u6263\u51cf\u8bf7\u4f203\u62167");
                }
            }
            result.put(item2.getProductCode(), reducer);
            detailVos.forEach(d -> {
                d.setAdjustCountType(item2.getAdjustCountType());
                d.setAdjustFeeType(item2.getAdjustFeeType());
            });
            dbItem.setPrice(price);
            dbItem.setDetailVos(detailVos);
            dbItem.setAdjustCountType(item2.getAdjustCountType());
            dbItem.setAdjustFeeType(item2.getAdjustFeeType());
            dbItem.setAdjustCount(item2.getAdjustCount());
            dbItem.setAdjustFee(item2.getAdjustFee());
            this.repFeePoolItemService.adjust(dbItem);
        }
        return result;
    }

    private BigDecimal computeRedTrickCount(RepFeePoolItemVo item, List<RepFeePoolItemDetailVo> detailVos) {
        BigDecimal reducer = item.getRedTrickCount();
        ValidateUtils.isTrue((reducer.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u51b2\u9500\u65f6\uff0c\u51b2\u9500\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0", (String[])new String[0]);
        for (RepFeePoolItemDetailVo detail : detailVos) {
            if (reducer.compareTo(BigDecimal.ZERO) < 1) break;
            detail.setAdjustCountType(item.getAdjustCountType());
            detail.setRemarks(item.getRemarks());
            detail.setResourceCode(item.getResourceCode());
            detail.setFiles(item.getFiles());
            detail.setAdjustReason(item.getAdjustReason());
            item.setAdjustCount(item.getRedTrickCount());
            item.setAdjustFee(item.getAdjustFee());
            if (detail.getUsedCount().compareTo(reducer) > -1) {
                detail.setAdjustCount(reducer);
                reducer = BigDecimal.ZERO;
                continue;
            }
            detail.setAdjustCount(detail.getUsedCount());
            reducer = reducer.subtract(detail.getUsedCount());
        }
        return reducer;
    }

    private BigDecimal computeSubtractCount(RepFeePoolItemVo item, List<RepFeePoolItemDetailVo> detailVos) {
        Iterator<RepFeePoolItemDetailVo> iterator = detailVos.iterator();
        BigDecimal reducer = item.getSubtractCount();
        ValidateUtils.isTrue((reducer.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u6263\u51cf\u65f6\uff0c\u6263\u51cf\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0", (String[])new String[0]);
        while (iterator.hasNext()) {
            RepFeePoolItemDetailVo detail = iterator.next();
            if (reducer.compareTo(BigDecimal.ZERO) < 1) break;
            detail.setAdjustCountType(item.getAdjustCountType());
            detail.setRemarks(item.getRemarks());
            detail.setResourceCode(item.getResourceCode());
            detail.setFiles(item.getFiles());
            detail.setAdjustReason(item.getAdjustReason());
            item.setAdjustCount(item.getSubtractCount());
            if (detail.getAvailableCount().compareTo(reducer) > -1) {
                detail.setAdjustCount(reducer);
                reducer = BigDecimal.ZERO;
                continue;
            }
            detail.setAdjustCount(detail.getAvailableCount());
            reducer = reducer.subtract(detail.getAvailableCount());
        }
        return reducer;
    }

    @Override
    @Transactional
    public Map<String, BigDecimal> redTrick(RepFeePoolVo vo) {
        return this.subtractOrRedTrickCount(vo, null);
    }

    @Override
    @Transactional
    public void onAccount(RepFeePoolVo vo) {
        RepFeePoolEntity entity;
        RepFeePoolUtil.validate(vo);
        ValidateUtils.notEmpty((Collection)vo.getRepFeePoolItemVos(), (String)"\u4e0a\u8d26\u65f6\uff0c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        QueryWrapper<RebateFeePoolEntity> wrapper = RepFeePoolUtil.buildUniqueWrapperParam(vo);
        List entities = this.repFeePoolMapper.selectList((Wrapper)wrapper);
        BigDecimal totalFee = BigDecimal.ZERO;
        BigDecimal totalCount = BigDecimal.ZERO;
        String[] productCodes = new String[vo.getRepFeePoolItemVos().size()];
        for (int i = 0; i < vo.getRepFeePoolItemVos().size(); ++i) {
            productCodes[i] = ((RepFeePoolItemVo)vo.getRepFeePoolItemVos().get(i)).getProductCode();
        }
        for (RepFeePoolItemVo item : vo.getRepFeePoolItemVos()) {
            BigDecimal price = item.getPrice();
            FieldHandleUtil.initDecimalZero(item);
            item.setRepFeePoolCode(vo.getCode());
            item.setPrice(price);
            item.setOnAccountReason(vo.getOnAccountReason());
            this.computeOnAccountFeeByCount(item, price);
            totalFee = totalFee.add(item.getOnAccountFee());
            totalCount = totalCount.add(item.getOnAccountCount());
        }
        if (CollectionUtil.listEmpty((List)entities)) {
            entity = new RepFeePoolEntity();
            FieldHandleUtil.initCreateFields(vo);
            BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
            entity.setCode(CodeUtil.generateCode((String)"dms_rep_fee_pool"));
            entity.setTotalCount(totalCount);
            entity.setTotalFee(totalFee);
            this.repFeePoolMapper.insert((Object)entity);
        } else {
            ValidateUtils.isTrue((entities.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636e\u552f\u4e00\u7ea6\u675f\u5b57\u6bb5\u67e5\u51fa\u591a\u6761\u8d27\u8865\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u552f\u4e00\u7ea6\u675f\u5b57\u5178\u662f\u5426\u8bbe\u7f6e\u6b63\u786e", (String[])new String[0]);
            entity = (RepFeePoolEntity)((Object)entities.get(0));
            FieldHandleUtil.initUpdateFields((Object)entity);
            entity.setTotalCount(totalCount);
            entity.setTotalFee(totalFee);
        }
        vo.getRepFeePoolItemVos().forEach(v -> {
            v.setRepFeePoolCode(entity.getCode());
            v.setPayType(RepFeePoolItemDetailUtil.PayTypeEnum.REP.getCode());
        });
        this.repFeePoolItemService.onCountItems(vo, vo.getRepFeePoolItemVos());
    }

    private boolean isSave(RepFeePoolVo vo) {
        return !this.repFeePoolBpmService.isApproval() || vo.isApproved();
    }

    private void computeOnAccountFeeByCount(RepFeePoolItemVo item, BigDecimal price) {
        ValidateUtils.validate((Object)item.getAdjustCountType(), (String)"\u4e0a\u8d26\u65f6\uff0c\u8c03\u6574\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)price, (String)"\u4e0a\u8d26\u65f6\uff0c\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u4ef7\u683c\u4ee5\u3001\u4ef7\u683c\u7c7b\u578b\u5b57\u5178\u4ee5\u53ca\u5f53\u524d\u8ba1\u7b97\u4ef7\u683c\u7c7b\u578b\u5b57\u5178");
        ValidateUtils.validate((Object)item.getOnAccountCount(), (String)"\u4e0a\u8d26\u65f6\uff0c\u4e0a\u8d26\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.isTrue((item.getOnAccountCount().compareTo(BigDecimal.ZERO) > -1 ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u65f6\uff0c\u4e0a\u8d26\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0", (String[])new String[0]);
        ValidateUtils.isTrue((price.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u65f6\uff0c\u6210\u672c\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0", (String[])new String[0]);
        item.setAdjustFeeType(item.getAdjustCountType());
        item.setOnAccountFee(item.getOnAccountCount().multiply(price));
    }

    @Override
    @Transactional
    public void summaryItems(String repFeePoolCode) {
        ValidateUtils.validate((Object)repFeePoolCode, (String)"\u6c47\u603b\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u8d27\u8865\u8d39\u7528\u6c60\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"code", (Object)repFeePoolCode);
        RepFeePoolEntity entity = (RepFeePoolEntity)((Object)this.repFeePoolMapper.selectOne((Wrapper)wrapper));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u6c47\u603b\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u8d27\u8865\u8d39\u7528\u6c60\u539f\u59cb\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4f20\u5165\u6b63\u786e\u7684\u8d27\u8865\u8d39\u7528\u6c60\u7f16\u7801");
        List<RepFeePoolItemVo> items = this.repFeePoolItemService.findByPoolCode(repFeePoolCode);
        ValidateUtils.notEmpty(items, (String)"\u6c47\u603b\u8d27\u8865\u8d39\u7528\u6c60\u65f6\uff0c\u68c0\u6d4b\u90fd\u6ca1\u6709\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u660e\u7ec6\u662f\u5426\u5df2\u5165\u5e93", (String[])new String[0]);
        BigDecimal totalCount = BigDecimal.ZERO;
        BigDecimal totalFee = BigDecimal.ZERO;
        for (RepFeePoolItemVo item : items) {
            totalCount = totalCount.add(item.getOnAccountCount());
            totalFee = totalFee.add(item.getOnAccountFee());
        }
        entity.setTotalFee(totalFee);
        entity.setTotalCount(totalCount);
        this.repFeePoolMapper.updateById((Object)entity);
    }

    @Override
    public PageResult<RepFeePoolVo> findPageByConditions(RepFeePoolVo param) {
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        List<RepFeePoolVo> list = this.repFeePoolMapper.findPageByConditions((Page<RepFeePoolVo>)page, param.getCusName(), param.getCusOrgName(), param.getCusChannelName(), param.getCusCode());
        if (CollectionUtil.listEmpty(list)) {
            return PageResult.builder().data((List)Lists.newArrayList()).build();
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<RepFeePoolVo> findByWrapper(QueryWrapper wrapper) {
        if (wrapper == null) {
            return Lists.newArrayList();
        }
        List entities = this.repFeePoolMapper.selectList((Wrapper)wrapper);
        return BeanCopyUtil.copyList(entities, RepFeePoolVo.class);
    }

    @Override
    public FeePoolSumReportRes findRepFeePoolFeeSum(Map<String, Object> map) {
        ArrayList repFeePoolItemDetailVos = this.repFeePoolItemDetailMapper.findByConditions(map);
        if (repFeePoolItemDetailVos == null) {
            repFeePoolItemDetailVos = Lists.newArrayList();
        }
        ArrayList repFees = Lists.newArrayList();
        repFeePoolItemDetailVos.forEach(r -> {
            map.put("detailCode", r.getCode());
            FeePoolSumReportRes repFee = this.repFeePoolItemDetailLogMapper.findFee(map);
            if (repFee != null) {
                repFees.add(repFee);
            }
        });
        FeePoolSumReportRes repRel = this.rebateFeePoolService.buildFeePoolFeeSumResult(repFees);
        repRel.setProjectName("\u4ea7\u54c1\u6298\u6263\u60c5\u51b5");
        repRel.setCusCode((String)map.get("cusCode"));
        repRel.setPeriod(String.join((CharSequence)"\u81f3", map.get("startDate").toString().replace(" 00:00:00", ""), map.get("endDate").toString().replace(" 23:59:59", "")));
        return repRel;
    }

    @Override
    public RepFeePoolSumReportRes findRepFeePoolCountSum(Map<String, Object> map) {
        ArrayList repFeePoolItemDetailVos = this.repFeePoolItemDetailMapper.findByConditions(map);
        if (repFeePoolItemDetailVos == null) {
            repFeePoolItemDetailVos = Lists.newArrayList();
        }
        ArrayList repFees = Lists.newArrayList();
        repFeePoolItemDetailVos.forEach(r -> {
            map.put("detailCode", r.getCode());
            RepFeePoolSumReportRes repFee = this.repFeePoolItemDetailLogMapper.findCount(map);
            if (repFee != null) {
                repFees.add(repFee);
            }
        });
        RepFeePoolSumReportRes repRel = this.buildFeePoolCountSumResult(repFees);
        repRel.setPeriod(String.join((CharSequence)map.get("startDate").toString(), "\u81f3", map.get("endDate").toString()));
        return repRel;
    }

    private RepFeePoolSumReportRes buildFeePoolCountSumResult(List<RepFeePoolSumReportRes> counts) {
        RepFeePoolSumReportRes countRel = new RepFeePoolSumReportRes();
        BigDecimal currentCount = BigDecimal.ZERO;
        BigDecimal lastCount = BigDecimal.ZERO;
        BigDecimal currentOnAccountCount = BigDecimal.ZERO;
        BigDecimal currentUsedCount = BigDecimal.ZERO;
        for (RepFeePoolSumReportRes r : counts) {
            FieldHandleUtil.initDecimalZero(r);
            lastCount = lastCount.add(r.getLastCount());
            currentOnAccountCount = currentOnAccountCount.add(r.getCurrentOnAccountCount());
            currentUsedCount = currentUsedCount.add(r.getCurrentUsedCount());
            currentCount = currentCount.add(r.getAvailableCount());
        }
        countRel.setAvailableCount(currentCount);
        countRel.setLastCount(lastCount);
        countRel.setCurrentOnAccountCount(currentOnAccountCount);
        countRel.setCurrentUsedCount(currentUsedCount);
        return countRel;
    }

    @Override
    public List<RepFeePoolSumReportRes> findRepFeePoolFeeSum(RepFeePoolSumReportReq param) {
        if (param == null) {
            return Lists.newArrayList();
        }
        HashMap map = Maps.newHashMap();
        map.put("cusCode", param.getCusCode());
        map.put("cusOrgCode", param.getCusOrgCode());
        map.put("cusChannelCode", param.getCusChannelCode());
        map.put("saleCompanyCode", param.getSaleCompanyCode());
        map.put("productCode", param.getProductCode());
        List<RepFeePoolItemVo> itemVos = this.repFeePoolItemService.findByConditions(map);
        if (CollectionUtil.listEmpty(itemVos)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        HashMap detailParam = Maps.newHashMap();
        String startTime = param.getStartDate();
        String endTime = param.getEndDate();
        if (StringUtils.isEmpty((String)startTime) || StringUtils.isEmpty((String)endTime)) {
            startTime = TimeUtil.getMonthStart(null, "yyyy-MM-dd HH:mm:ss");
            endTime = TimeUtil.getMonthEnd(null, "yyyy-MM-dd HH:mm:ss");
        }
        detailParam.put("startDate", startTime);
        detailParam.put("endDate", endTime);
        itemVos.forEach(item -> {
            QueryWrapper wrapper = Wrappers.query();
            wrapper.eq((Object)"code", (Object)item.getRepFeePoolCode());
            RepFeePoolEntity repFeePoolEntity = (RepFeePoolEntity)((Object)((Object)this.repFeePoolMapper.selectOne((Wrapper)wrapper)));
            ValidateUtils.validate((Object)((Object)repFeePoolEntity), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8d27\u8865\u8d39\u7528\u6c60\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u660e\u7ec6\u8bb0\u5f55\u3010%s\u3011\u4fdd\u5b58\u7684\u8d39\u7528\u6c60\u7f16\u7801\u662f\u5426\u6b63\u786e", (String[])new String[]{item.getRepFeePoolCode()});
            detailParam.put("repFeePoolItemCode", item.getCode());
            FeePoolSumReportRes feePoolSumReportRes = this.findRepFeePoolFeeSum(detailParam);
            RepFeePoolSumReportRes rel = BeanCopyUtil.copyBen(feePoolSumReportRes, RepFeePoolSumReportRes.class);
            RepFeePoolSumReportRes countRel = this.findRepFeePoolCountSum(detailParam);
            rel.setCusCode(repFeePoolEntity.getCusCode());
            rel.setCusName(repFeePoolEntity.getCusName());
            rel.setCusOrgCode(repFeePoolEntity.getCusOrgCode());
            rel.setCusOrgName(repFeePoolEntity.getCusOrgName());
            rel.setCusChannelCode(repFeePoolEntity.getCusChannelCode());
            rel.setCusChannelName(repFeePoolEntity.getCusChannelName());
            rel.setSaleCompanyCode(repFeePoolEntity.getSaleCompanyCode());
            rel.setSaleCompanyName(repFeePoolEntity.getSaleCompanyName());
            rel.setUnit(item.getUnitName());
            rel.setSpec(item.getSpec());
            rel.setAvailableCount(countRel.getAvailableCount());
            rel.setCurrentOnAccountCount(countRel.getCurrentOnAccountCount());
            rel.setLastCount(countRel.getLastCount());
            rel.setCurrentUsedCount(countRel.getCurrentUsedCount());
            result.add(rel);
        });
        return result;
    }

    @Override
    @Transactional
    public Boolean wrapperAdjust(RepFeePoolVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u8c03\u6574\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List itemVos = vo.getRepFeePoolItemVos();
        ValidateUtils.notEmpty((Collection)itemVos, (String)"\u8c03\u6574\u65f6\uff0c\u660e\u7ec6\u5217\u8868\u5fc5\u987b\u4f20\u5165", (String[])new String[0]);
        Map<String, RepFeePoolItemVo> map = itemVos.stream().collect(Collectors.toMap(RepFeePoolItemVo::getRepFeePoolCode, v -> v));
        ValidateUtils.isTrue((map.size() == 1 ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u6bcf\u6761\u660e\u7ec6\uff0c\u8d39\u7528\u6c60\u7f16\u7801\u5fc5\u987b\u76f8\u540c", (String[])new String[0]);
        return this.repFeePoolItemService.wrapperAdjustItems(itemVos);
    }

    @Override
    public RepFeePoolVo findByCode(String repFeePoolCode) {
        if (StringUtils.isEmpty((String)repFeePoolCode)) {
            return null;
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"code", (Object)repFeePoolCode);
        List<RepFeePoolVo> vos = this.findByWrapper(wrapper);
        if (CollectionUtil.listEmpty(vos)) {
            return null;
        }
        ValidateUtils.isTrue((vos.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u8d27\u8865\u8d39\u7528\u6c60\u65f6\uff0c\u6570\u636e\u5f02\u5e38\uff0c\u6570\u636e\u5e93\u4e2d\u7f16\u7801\u91cd\u590d", (String[])new String[0]);
        return vos.get(0);
    }

    @Override
    public List<SelectBanlanceRepRes> selectBanlance(String cusCode) {
        if (StringUtils.isEmpty((String)cusCode)) {
            return new ArrayList<SelectBanlanceRepRes>();
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"cus_code", (Object)cusCode);
        List entities = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return new ArrayList<SelectBanlanceRepRes>();
        }
        List<String> repFeePoolCodes = entities.stream().filter(vo -> !StringUtils.isEmpty((String)vo.getCode())).map(vo -> vo.getCode()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return new ArrayList<SelectBanlanceRepRes>();
        }
        List<RepFeePoolItemEntity> items = this.repFeePoolItemService.findByPoolCodes(repFeePoolCodes);
        if (CollectionUtils.isEmpty(items)) {
            return new ArrayList<SelectBanlanceRepRes>();
        }
        TreeMap itemMap = Maps.newTreeMap();
        items.forEach(item -> itemMap.put(item.getRepFeePoolCode(), item));
        ArrayList<RepFeePoolEntity> currentEntities = new ArrayList<RepFeePoolEntity>();
        for (RepFeePoolEntity entity : entities) {
            if (null == itemMap.get(entity.getCode())) continue;
            currentEntities.add(entity);
        }
        ArrayList<SelectBanlanceRepRes> reList = new ArrayList<SelectBanlanceRepRes>();
        List<SelectRepBanceVo> logList = this.repFeePoolItemDetailLogMapper.listSumForPc(cusCode, DateUtil.date2Str((Date)DateUtil.getFirstDayOfMonth((Date)DateUtil.getDate()), (SimpleDateFormat)DateUtil.date_sdf), DateUtil.date2Str((Date)DateUtil.getLastDayOfMonth((Date)DateUtil.getDate()), (SimpleDateFormat)DateUtil.date_sdf));
        for (RepFeePoolEntity pool : currentEntities) {
            RepFeePoolItemEntity item2 = (RepFeePoolItemEntity)((Object)itemMap.get(pool.getCode()));
            SelectBanlanceRepRes res = new SelectBanlanceRepRes();
            res.setSaleCompaneyName(pool.getSaleCompanyName());
            res.setGoodsCode(item2.getProductCode());
            res.setGoodsName(item2.getProductName());
            res.setSpec(item2.getSpec());
            res.setUnitName(item2.getUnitName());
            res.setSurplusNum(item2.getAvailableCount());
            res.setAccountNum(BigDecimal.ZERO);
            res.setUsedNum(BigDecimal.ZERO);
            if (CollectionUtils.isEmpty(logList)) {
                reList.add(res);
                continue;
            }
            for (SelectRepBanceVo selectRepBanceVo : logList) {
                if (!selectRepBanceVo.getGoodsCode().equals(item2.getProductCode()) || !selectRepBanceVo.getSaleCompanyCode().equals(pool.getSaleCompanyCode())) continue;
                if (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.isType(selectRepBanceVo.getAdjustType(), 1)) {
                    res.setAccountNum(res.getAccountNum().add(selectRepBanceVo.getNum()));
                }
                if (!RepFeePoolItemDetailLogUtil.AdjustTypeEnum.isType(selectRepBanceVo.getAdjustType(), 0)) continue;
                res.setUsedNum(res.getUsedNum().add(selectRepBanceVo.getNum()));
            }
            reList.add(res);
        }
        return reList;
    }

    @Override
    public RepFeePoolEntity getEntityByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)code);
        return (RepFeePoolEntity)((Object)this.getOne((Wrapper)queryWrapper));
    }

    @Override
    public RepFeePoolEntity getEntityByCustAndCompany(String custCode, String companyCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"cus_code", (Object)custCode);
        queryWrapper.eq((Object)"sale_company_code", (Object)companyCode);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return (RepFeePoolEntity)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public Map<String, Object> list(String cusCode, ListReq listReq) {
        String startDate = null;
        String endDate = null;
        if (!StringUtils.isEmpty((String)listReq.getMonth())) {
            Date month = DateUtil.str2Date((String)listReq.getMonth(), (SimpleDateFormat)DateUtil.yyyy_MM);
            startDate = DateUtil.date2Str((Date)DateUtil.getFirstDayOfMonth((Date)month), (SimpleDateFormat)DateUtil.date_sdf);
            endDate = DateUtil.date2Str((Date)DateUtil.getLastDayOfMonth((Date)month), (SimpleDateFormat)DateUtil.date_sdf);
        }
        ListFeeReq listFeeReq = ListFeeReq.newInstance((String)listReq.getSalesCompaneyCode(), startDate, endDate);
        PageResult<ListAccountRes> accountPageResult = this.repFeePoolIItemDetailLogService.listAccount(cusCode, listFeeReq);
        PageResult<ListUsedRes> usePageResult = this.repFeePoolBpmService.listUsed(cusCode, listFeeReq);
        HashMap sumParam = Maps.newHashMap();
        sumParam.put("cusCode", cusCode);
        sumParam.put("startDate", startDate.concat(" 00:00:00"));
        sumParam.put("endDate", endDate.concat(" 23:59:59"));
        if (startDate == null) {
            sumParam.put("startDate", TimeUtil.getMonthStart(new Date(), "yyyy-MM-dd").concat(" 00:00:00"));
        }
        if (endDate == null) {
            sumParam.put("endDate", TimeUtil.getMonthEnd(new Date(), "yyyy-MM-dd").concat(" 23:59:59"));
        }
        FeePoolSumReportRes sum = StringUtils.isEmpty((String)cusCode) ? new FeePoolSumReportRes() : this.findRepFeePoolFeeSum(sumParam);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Account", accountPageResult.getData());
        map.put("Used", usePageResult.getData());
        map.put("Sum", sum);
        return map;
    }
}

