/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.dms.repfeepool.ListAccountRes;
import com.biz.crm.nebular.dms.repfeepool.ListFeeReq;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolFileVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailLogVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailVo;
import com.biz.crm.nebular.dms.repfeepool.RepItemDetailReflushVo;
import com.biz.crm.nebular.dms.repfeepool.SelectRepBanceVo;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolDetailLogUtil;
import com.biz.crm.repfeepool.entity.RepFeePoolItemDetailLogEntity;
import com.biz.crm.repfeepool.mapper.RepFeePoolItemDetailLogMapper;
import com.biz.crm.repfeepool.service.RepFeePoolBpmService;
import com.biz.crm.repfeepool.service.RepFeePoolFileService;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailLogService;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailService;
import com.biz.crm.repfeepool.service.RepFeePoolItemService;
import com.biz.crm.repfeepool.utils.RepFeePoolBpmUtil;
import com.biz.crm.repfeepool.utils.RepFeePoolItemDetailLogUtil;
import com.biz.crm.repfeepool.utils.RepFeePoolItemDetailUtil;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="repFeePoolItemDetailLogService")
@ConditionalOnMissingBean(name={"repFeePoolItemDetailLogServiceImpl"})
public class RepFeePoolIItemDetailLogServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RepFeePoolItemDetailLogMapper, RepFeePoolItemDetailLogEntity>
implements RepFeePoolIItemDetailLogService {
    @Resource
    private RepFeePoolItemDetailLogMapper repFeePoolItemDetailLogMapper;
    @Resource
    private RepFeePoolFileService repFeePoolFileService;
    @Resource
    private RepFeePoolIItemDetailService repFeePoolIItemDetailService;
    @Resource
    private RepFeePoolItemService repFeePoolItemService;
    @Resource
    private RepFeePoolBpmService repFeePoolBpmService;

    @Override
    @Transactional
    public void create(RepFeePoolItemDetailLogVo logVo) {
        ValidateUtils.validate((Object)logVo, (String)"\u65b0\u589e\u5355\u6761\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65e5\u5fd7\u8bb0\u5f55\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.isTrue((logVo.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u5355\u6761\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65e5\u5fd7\u8bb0\u5f55\u65f6\uff0cid\u4e0d\u80fd\u6709\u503c", (String[])new String[0]);
        ValidateUtils.validate((Object)logVo.getRepFeePoolItemDetailCode(), (String)"\u65b0\u589e\u5355\u6761\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65e5\u5fd7\u8bb0\u5f55\u65f6\uff0c\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u7f16\u7801\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.isTrue((logVo.getAdjustCountType() != null && logVo.getAdjustCount() != null || logVo.getAdjustFeeType() != null && logVo.getAdjustFee() != null ? 1 : 0) != 0, (String)"\u65b0\u589e\u5355\u6761\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65e5\u5fd7\u8bb0\u5f55\u65f6\uff0c\u8c03\u6574\u7c7b\u578b\u5fc5\u987b\u4f20\u5165\uff0c\u5e76\u4e14\u5fc5\u987b\u6709\u8c03\u6574\u503c", (String[])new String[0]);
        if (logVo.getPayType() == null) {
            logVo.setPayType(RepFeePoolItemDetailUtil.PayTypeEnum.REP.getCode());
        }
        if (this.repFeePoolBpmService.isApproval(logVo.getAdjustCountType())) {
            logVo.setBpmState(RepFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState());
        } else {
            logVo.setBpmState(RepFeePoolBpmUtil.ApprovalEnum.PROCESSED.getState());
        }
        logVo.setCode(CodeUtil.getCode());
        RepFeePoolItemDetailLogEntity entity = new RepFeePoolItemDetailLogEntity();
        BeanUtils.copyProperties((Object)logVo, (Object)((Object)entity));
        this.repFeePoolItemDetailLogMapper.insert((Object)entity);
        this.setCounts(entity);
        this.setAmounts(entity);
        this.repFeePoolItemDetailLogMapper.updateById((Object)entity);
        List files = logVo.getFiles();
        if (!CollectionUtil.listEmpty((List)files)) {
            files.forEach(f -> f.setRebateFeePoolDetailLogCode(entity.getCode()));
            this.repFeePoolFileService.createAll(files);
        }
    }

    private void setCounts(RepFeePoolItemDetailLogEntity entity) {
        Integer adjustType = entity.getAdjustCountType();
        if (adjustType == null || entity.getAdjustCount() == null) {
            return;
        }
        int type2 = RepFeePoolItemDetailLogUtil.AdjustTypeEnum.getType(adjustType);
        RepFeePoolItemDetailVo detail = this.repFeePoolIItemDetailService.findByDetailCode(entity.getRepFeePoolItemDetailCode());
        ValidateUtils.validate((Object)detail, (String)"\u65b0\u589e\u65e5\u5fd7\u65f6\u6ca1\u6709\u83b7\u53d6\u5230\u5176\u5173\u8054\u7684\u6761\u76ee\u8bb0\u5f55");
        entity.setAvailableCount(detail.getAvailableCount());
        switch (type2) {
            case 0: {
                entity.setOnAccountCount(BigDecimal.ZERO);
                entity.setUsedCount(entity.getAdjustCount());
                break;
            }
            case 1: {
                entity.setOnAccountCount(entity.getAdjustCount());
                entity.setUsedCount(BigDecimal.ZERO);
                break;
            }
            case 2: {
                entity.setOnAccountCount(BigDecimal.ZERO);
                entity.setUsedCount(BigDecimal.ZERO);
                break;
            }
            case 3: {
                entity.setOnAccountCount(BigDecimal.ZERO);
                entity.setUsedCount(entity.getAdjustCount().multiply(BigDecimal.valueOf(-1.0)));
                break;
            }
            default: {
                throw new BusinessException("\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65e5\u5fd7\u65f6\uff0c\u68c0\u6d4b\u5230\u6570\u91cf\u8c03\u6574\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
        }
    }

    private void setAmounts(RepFeePoolItemDetailLogEntity entity) {
        Integer adjustType = entity.getAdjustFeeType();
        if (adjustType == null || entity.getAdjustFee() == null) {
            return;
        }
        int type2 = RepFeePoolItemDetailLogUtil.AdjustTypeEnum.getType(adjustType);
        RepFeePoolItemDetailVo detail = this.repFeePoolIItemDetailService.findByDetailCode(entity.getRepFeePoolItemDetailCode());
        ValidateUtils.validate((Object)detail, (String)"\u65b0\u589e\u65e5\u5fd7\u65f6\u6ca1\u6709\u83b7\u53d6\u5230\u5176\u5173\u8054\u7684\u6761\u76ee\u8bb0\u5f55");
        entity.setAvailableFee(detail.getAvailableFee());
        switch (type2) {
            case 0: {
                entity.setOnAccountFee(BigDecimal.ZERO);
                entity.setUsedFee(entity.getAdjustFee());
                break;
            }
            case 1: {
                entity.setOnAccountFee(entity.getAdjustFee());
                entity.setUsedFee(BigDecimal.ZERO);
                break;
            }
            case 2: {
                entity.setOnAccountFee(BigDecimal.ZERO);
                entity.setUsedFee(BigDecimal.ZERO);
                break;
            }
            case 3: {
                entity.setOnAccountFee(BigDecimal.ZERO);
                entity.setUsedFee(entity.getAdjustFee().multiply(BigDecimal.valueOf(-1.0)));
                break;
            }
            default: {
                throw new BusinessException("\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u6761\u76ee\u65e5\u5fd7\u65f6\uff0c\u68c0\u6d4b\u5230\u91d1\u989d\u8c03\u6574\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
        }
    }

    @Override
    @CrmDictMethod
    public PageResult<RepFeePoolItemDetailLogVo> findPageByConditions(RepFeePoolItemDetailLogVo param) {
        if (param == null) {
            param = new RepFeePoolItemDetailLogVo();
        }
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        HashMap map = Maps.newHashMap();
        map.put("repFeePoolItemDetailCode", param.getRepFeePoolItemDetailCode());
        map.put("adjustCountType", param.getAdjustCountType());
        map.put("adjustTypes", param.getAdjustTypes());
        map.put("repFeePoolItemCode", param.getRepFeePoolItemCode());
        map.put("cusCode", param.getCusCode());
        map.put("repFeePoolBpmCode", param.getRepFeePoolBpmCode());
        map.put("frozenItemCode", param.getFrozenItemCode());
        List<RepFeePoolItemDetailLogVo> list = this.repFeePoolItemDetailLogMapper.findPageByConditions((Page<RepFeePoolItemDetailLogVo>)page, map);
        if (CollectionUtil.listEmpty(list)) {
            return PageResult.builder().data((List)Lists.newArrayList()).build();
        }
        list.forEach(li -> {
            List<RepFeePoolFileVo> files = this.repFeePoolFileService.findByLogCode(li.getCode());
            li.setFiles(files);
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public RepFeePoolItemDetailVo frozen(RepFeePoolItemDetailLogVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u51bb\u7ed3\u6216\u8005\u89e3\u51bb\u6761\u76ee\u65f6\uff0c\u53c2\u6570\u5fc5\u987b\u4f20\u5165");
        ValidateUtils.validate((Object)vo.getRepFeePoolItemDetailCode(), (String)"\u51bb\u7ed3\u6216\u8005\u89e3\u51bb\u6761\u76ee\u65f6\uff0c\u8d39\u7528\u6c60\u6761\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.isTrue((Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.FROZEN.getCode(), vo.getAdjustFeeType()) || Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode(), vo.getAdjustFeeType()) ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u6216\u8005\u89e3\u51bb\u6761\u76ee\u65f6\uff0c\u8c03\u6574\u7c7b\u578b\u53ea\u80fd\u65f6\u51bb\u7ed3\u6216\u8005\u89e3\u51bb", (String[])new String[0]);
        RepFeePoolItemDetailVo detailVo = this.repFeePoolIItemDetailService.findByDetailCode(vo.getRepFeePoolItemDetailCode());
        ValidateUtils.validate((Object)detailVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u6761\u76ee\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u6761\u76ee\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u9012");
        if (vo.getAdjustCountType() != null) {
            this.frozenCount(detailVo, vo);
        }
        if (vo.getAdjustFeeType() != null) {
            this.frozenFee(detailVo, vo);
        }
        this.repFeePoolIItemDetailService.update(detailVo);
        return detailVo;
    }

    @Override
    public List<RepItemDetailReflushVo> listSum(String cusCode, String salesCompanyCode, String goodsCode) {
        List<RepItemDetailReflushVo> list = this.repFeePoolItemDetailLogMapper.listSum(cusCode, salesCompanyCode, goodsCode);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<RepItemDetailReflushVo>();
        }
        return list;
    }

    @Override
    public List<SelectRepBanceVo> listSumForPc(String cusCode) {
        List<SelectRepBanceVo> list = this.repFeePoolItemDetailLogMapper.listSumForPc(cusCode, DateUtil.date2Str((Date)DateUtil.getFirstDayOfMonth((Date)DateUtil.getDate()), (SimpleDateFormat)DateUtil.date_sdf), DateUtil.date2Str((Date)DateUtil.getLastDayOfMonth((Date)DateUtil.getDate()), (SimpleDateFormat)DateUtil.date_sdf));
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<SelectRepBanceVo>();
        }
        return list;
    }

    @Override
    @CrmDictMethod
    public PageResult<ListAccountRes> listAccount(String cusCode, ListFeeReq listFeeReq) {
        Page page = PageUtil.buildPage((Integer)listFeeReq.getPageNum(), (Integer)listFeeReq.getPageSize());
        List<ListAccountRes> list = this.repFeePoolItemDetailLogMapper.listAccount(page, cusCode, listFeeReq, RebateFeePoolDetailLogUtil.AdjustTypeEnum.getCodeByType(1));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            List<String> codes = list.stream().map(vo -> vo.getCode()).collect(Collectors.toList());
            Map<String, List<String>> fileMap = this.repFeePoolFileService.getFileByCodes(codes);
            for (ListAccountRes listAccountRes : list) {
                listAccountRes.setFileUrls(fileMap.get(fileMap.get(listAccountRes.getCode())));
                listAccountRes.setCreateTime(listAccountRes.getHappenDate() + " " + listAccountRes.getCreateTime());
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public RepFeePoolItemDetailLogVo update(RepFeePoolItemDetailLogVo logVo) {
        ValidateUtils.validate((Object)logVo, (String)"\u4fee\u6539\u6761\u76ee\u65e5\u5fd7\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        RepFeePoolItemDetailLogEntity entity = (RepFeePoolItemDetailLogEntity)((Object)this.repFeePoolItemDetailLogMapper.selectById((Serializable)((Object)logVo.getId())));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u4fee\u6539\u6761\u76ee\u65e5\u5fd7\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4id\u662f\u5426\u6b63\u786e\u4f20\u5165");
        FieldHandleUtil.initUpdateFields(logVo);
        RepFeePoolItemDetailLogEntity repFeePoolItemDetailLogEntity = BeanCopyUtil.copyBen(logVo, RepFeePoolItemDetailLogEntity.class);
        this.setCounts(repFeePoolItemDetailLogEntity);
        this.setAmounts(repFeePoolItemDetailLogEntity);
        this.repFeePoolItemDetailLogMapper.updateById((Object)repFeePoolItemDetailLogEntity);
        List<RepFeePoolFileVo> oldFiles = this.repFeePoolFileService.findByLogCode(logVo.getCode());
        if (!CollectionUtil.listEmpty(oldFiles)) {
            this.repFeePoolFileService.deleteAll(oldFiles);
        }
        if (!CollectionUtil.listEmpty((List)logVo.getFiles())) {
            logVo.getFiles().forEach(f -> f.setRebateFeePoolDetailLogCode(logVo.getCode()));
            this.repFeePoolFileService.createAll(logVo.getFiles());
        }
        return logVo;
    }

    @Override
    public List<RepFeePoolItemDetailLogVo> findByBpmCode(String bpmCode) {
        if (StringUtils.isEmpty((String)bpmCode)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"rep_fee_pool_bpm_code", (Object)bpmCode);
        List entities = this.repFeePoolItemDetailLogMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        return BeanCopyUtil.copyList(entities, RepFeePoolItemDetailLogVo.class);
    }

    @Override
    public void deleteByIds(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            return;
        }
        this.repFeePoolItemDetailLogMapper.deleteBatchIds(ids);
    }

    private void frozenFee(RepFeePoolItemDetailVo detailVo, RepFeePoolItemDetailLogVo vo) {
        if (Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.FROZEN.getCode(), vo.getAdjustCountType())) {
            ValidateUtils.isTrue((detailVo.getAvailableCount().compareTo(vo.getFrozenCount()) >= 0 ? 1 : 0) != 0, (String)"\u6761\u76ee\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u51bb\u7ed3", (String[])new String[0]);
            detailVo.setFrozenCount(detailVo.getAvailableCount().add(vo.getFrozenCount()));
            detailVo.setAvailableCount(detailVo.getAvailableCount().subtract(vo.getFrozenCount()));
        } else if (Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode(), vo.getAdjustCountType())) {
            ValidateUtils.isTrue((detailVo.getFrozenCount().compareTo(vo.getFrozenCount()) >= 0 ? 1 : 0) != 0, (String)"\u6761\u76ee\u51bb\u7ed3\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u89e3\u51bb", (String[])new String[0]);
            detailVo.setFrozenCount(detailVo.getFrozenCount().subtract(vo.getFrozenCount()));
            detailVo.setAvailableCount(detailVo.getFrozenCount().add(vo.getFrozenCount()));
        } else {
            throw new BusinessException("\u8c03\u6574\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u53ea\u5141\u8bb8\u4f20\u5165\u51bb\u7ed3\u6216\u8005\u89e3\u51bb");
        }
    }

    private void frozenCount(RepFeePoolItemDetailVo detailVo, RepFeePoolItemDetailLogVo vo) {
        if (Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.FROZEN.getCode(), vo.getAdjustFeeType())) {
            ValidateUtils.isTrue((detailVo.getAvailableFee().compareTo(vo.getFrozenFee()) >= 0 ? 1 : 0) != 0, (String)"\u6761\u76ee\u53ef\u7528\u91d1\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u51bb\u7ed3", (String[])new String[0]);
            detailVo.setFrozenFee(detailVo.getAvailableFee().add(vo.getFrozenFee()));
            detailVo.setAvailableFee(detailVo.getAvailableFee().subtract(vo.getFrozenFee()));
        } else if (Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.UNFROZEN.getCode(), vo.getAdjustFeeType())) {
            ValidateUtils.isTrue((detailVo.getFrozenFee().compareTo(vo.getFrozenFee()) >= 0 ? 1 : 0) != 0, (String)"\u6761\u76ee\u51bb\u7ed3\u91d1\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u89e3\u51bb", (String[])new String[0]);
            detailVo.setFrozenFee(detailVo.getFrozenFee().subtract(vo.getFrozenFee()));
            detailVo.setAvailableFee(detailVo.getAvailableFee().add(vo.getFrozenFee()));
        } else {
            throw new BusinessException("\u8c03\u6574\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u53ea\u5141\u8bb8\u4f20\u5165\u51bb\u7ed3\u6216\u8005\u89e3\u51bb");
        }
    }
}

