/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class MathUtil {
    public static <T> T compute(String expressionValue, Class<T> cls) {
        ValidateUtils.validate((Object)expressionValue, (String)"\u6839\u636e\u516c\u5f0f\u8ba1\u7b97\u65f6\uff0c\u516c\u5f0f\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate(cls, (String)"\u6839\u636e\u516c\u5f0f\u8ba1\u7b97\u65f6\uff0c\u7ed3\u679c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Pattern intReg = Pattern.compile("(INT|int)\\(?[0-9]+\\.[1-9]+\\)?+");
        Matcher matcher = intReg.matcher(expressionValue);
        ArrayList list = Lists.newArrayList();
        while (matcher.find()) {
            list.add(matcher.group());
        }
        for (String li : list) {
            expressionValue = expressionValue.replace(li, MathUtil.ceil(li));
        }
        Expression expression = new SpelExpressionParser().parseExpression(expressionValue);
        return (T)expression.getValue(cls);
    }

    private static String ceil(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return new String();
        }
        String num = str.replace("INT", "").replace("int", "").replace("(", "").replace(")", "");
        if (num.contains(".")) {
            num = num.substring(0, num.indexOf(46));
        }
        return num;
    }
}

