/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.SpelParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class MathUtil {
    public static <T> T computeExpression(String expressionValue, Class<T> cls) {
        Object result;
        String expressionStr = expressionValue;
        ValidateUtils.validate((Object)expressionStr, (String)"\u6839\u636e\u516c\u5f0f\u8ba1\u7b97\u65f6\uff0c\u516c\u5f0f\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate(cls, (String)"\u6839\u636e\u516c\u5f0f\u8ba1\u7b97\u65f6\uff0c\u7ed3\u679c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Pattern intReg = Pattern.compile("(INT|int)\\(?\\-?[0-9]+\\.[1-9]+\\)?+");
        Matcher matcher = intReg.matcher(expressionStr);
        ArrayList list = Lists.newArrayList();
        while (matcher.find()) {
            list.add(matcher.group());
        }
        for (String li : list) {
            expressionStr = expressionStr.replace(li, MathUtil.floor(li));
        }
        expressionStr = MathUtil.formatFloat(expressionStr);
        try {
            Expression expression = new SpelExpressionParser().parseExpression(expressionStr);
            result = expression.getValue(cls);
        }
        catch (SpelParseException e) {
            throw new BusinessException("\u6570\u5b66\u8868\u8fbe\u5f0f\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u8868\u8fbe\u5f0f\u662f\u5426\u6b63\u786e\uff1a".concat(expressionValue), (Throwable)e);
        }
        return (T)result;
    }

    private static String formatFloat(String expressionStr) {
        StringBuilder builder = new StringBuilder(expressionStr);
        if (StringUtils.isBlank((CharSequence)expressionStr)) {
            return new String();
        }
        Pattern reg = Pattern.compile("-?\\d+(\\.\\d+)?");
        Matcher matcher = reg.matcher(expressionStr);
        int index = 0;
        while (matcher.find()) {
            String num = matcher.group();
            int start = matcher.start() + index;
            int end = matcher.end() + index;
            if (num.contains(".")) continue;
            builder.replace(start, end, num.concat(".0"));
            index += 2;
        }
        return builder.toString();
    }

    private static String floor(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return new String();
        }
        String num = str.replace("INT", "").replace("int", "").replace("(", "").replace(")", "");
        if (num.contains(".")) {
            num = num.substring(0, num.indexOf(46));
        }
        return num;
    }
}

