/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component.filter.impl;

import com.biz.crm.nebular.dms.promotion.PromotionPolicyInfoVo;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.biz.crm.promotion.service.component.filter.AbstractFilter;
import com.biz.crm.promotion.service.component.filter.PromotionPolicyUtils;
import com.biz.crm.promotion.service.impl.LoadConfigInfoContext;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="promotionPolicySingleProductFilter")
public class PromotionPolicySingleProductFilter
extends AbstractFilter<PromotionPolicyInfoVo, LoadConfigInfoContext> {
    @Override
    public boolean filter(PromotionPolicyInfoVo promotionPolicyInfoVo, LoadConfigInfoContext context) {
        Map<String, Map<String, PromotionPolicyProductEntity>> currentProductMap = context.getCurrentProductY();
        Map<String, PromotionPolicyProductEntity> currentProduct = currentProductMap.get(promotionPolicyInfoVo.getId());
        Map<String, Map<String, BigDecimal>> productsOrderBuyMap = context.getProductsOrderBuyMap();
        for (Map.Entry<String, PromotionPolicyProductEntity> entry : currentProduct.entrySet()) {
            PromotionPolicyProductEntity productEntity = entry.getValue();
            String qtyType = productEntity.getProductOrderQtyType();
            BigDecimal qty = productEntity.getProductOrderQty();
            if (!StringUtils.isNotBlank((CharSequence)qtyType) || null == qty) continue;
            String currentProductCode = entry.getKey();
            if (!productsOrderBuyMap.containsKey(currentProductCode)) {
                return false;
            }
            BigDecimal orderQty = PromotionPolicyUtils.getOrderQty(qtyType, currentProductCode, context);
            if (null != orderQty && qty.compareTo(orderQty) <= 0) continue;
            return false;
        }
        return true;
    }
}

