/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component.filter.impl;

import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.biz.crm.promotion.service.component.filter.AbstractFilter;
import com.biz.crm.promotion.service.component.filter.PromotionPolicyUtils;
import com.biz.crm.promotion.service.impl.LoadConfigInfoContext;
import com.biz.crm.util.JsonPropertyUtil;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="promotionPolicyGroupFilter")
public class PromotionPolicyGroupFilter
extends AbstractFilter<PromotionPolicyInfoDataVo, LoadConfigInfoContext> {
    @Override
    public boolean filter(PromotionPolicyInfoDataVo promotionPolicyInfoVo, LoadConfigInfoContext context) {
        Map<String, PromotionPolicyProductEntity> currentProductY = context.getCurrentProductY().get(promotionPolicyInfoVo.getId());
        Map<String, Map<String, BigDecimal>> productsOrderBuyMap = context.getProductsOrderBuyMap();
        this.addHitDetail(promotionPolicyInfoVo, "currentProductY", String.valueOf(JsonPropertyUtil.toJsonString(currentProductY)));
        this.addHitDetail(promotionPolicyInfoVo, "productsOrderBuyMap", String.valueOf(JsonPropertyUtil.toJsonString(productsOrderBuyMap)));
        String qtyType = promotionPolicyInfoVo.getProductsOrderQtyType();
        BigDecimal qty = promotionPolicyInfoVo.getProductsOrderQty();
        if (StringUtils.isNotBlank((CharSequence)qtyType) && null != qty) {
            if (null == currentProductY) {
                return false;
            }
            BigDecimal sum = BigDecimal.ZERO;
            for (Map.Entry<String, PromotionPolicyProductEntity> entry : currentProductY.entrySet()) {
                String currentProductCode = entry.getKey();
                if (!productsOrderBuyMap.containsKey(currentProductCode)) {
                    return false;
                }
                BigDecimal orderQty = PromotionPolicyUtils.getOrderQty(qtyType, currentProductCode, context);
                if (null == orderQty) continue;
                sum = sum.add(orderQty);
            }
            if (qty.compareTo(sum) > 0) {
                return false;
            }
        }
        return true;
    }
}

