/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRuleVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.RuleExecutor;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.LimitedRuleParam;
import com.biz.crm.util.JsonPropertyUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="defaultRuleExecutor")
public class DefaultRuleExecutor
implements RuleExecutor<CalculateRuleResponse> {
    private static final Logger log = LoggerFactory.getLogger(DefaultRuleExecutor.class);

    @Override
    public CalculateRuleResponse execute(RuleExecuteParam ruleExecuteParam) {
        RuleFunction ruleFunction;
        this.checkParam(ruleExecuteParam);
        PromotionPolicyRuleVo condition = ruleExecuteParam.getCondition();
        PromotionPolicyRuleVo calculate = ruleExecuteParam.getCalculate();
        try {
            ruleFunction = (RuleFunction)SpringApplicationContextUtil.getApplicationContext().getBean(calculate.getFuncBody(), RuleFunction.class);
        }
        catch (BeansException e) {
            throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u8ba1\u7b97\u89c4\u5219[" + calculate.getRuleCode() + "]\u8ba1\u7b97\u5931\u8d25, \u672a\u67e5\u627e\u5230\u8be5\u89c4\u5219\u7684\u8ba1\u7b97\u5b9e\u4f8b", (Throwable)e);
        }
        CalculateRuleParam calculateRuleParam = new CalculateRuleParam();
        calculateRuleParam.setLadderList(JsonPropertyUtil.toArray((String)condition.getParams(), PromotionRuleEditVo.ControlRow.class));
        List<RuleExecuteParam.ProductOrderBuy> productOrderBuy = ruleExecuteParam.getProductOrderBuy();
        calculateRuleParam.setProductOrderBuy(productOrderBuy);
        calculateRuleParam.setConditionRuleFunctionBeanName(condition.getFuncBody());
        CalculateRuleResponse calculateRuleResponse = (CalculateRuleResponse)ruleFunction.apply(calculateRuleParam);
        calculateRuleResponse = this.calculateRuleExecuted(ruleExecuteParam, calculateRuleResponse);
        if (null == calculateRuleResponse) {
            throw new BusinessException("\u8ba1\u7b97\u89c4\u5219\u7ed3\u679c\u6269\u5c55\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002");
        }
        this.doLimited(ruleExecuteParam, calculateRuleResponse);
        return calculateRuleResponse;
    }

    protected void doLimited(RuleExecuteParam ruleExecuteParam, CalculateRuleResponse calculateRuleResponse) {
        List<PromotionPolicyRuleVo> limited = ruleExecuteParam.getLimited();
        if (CollectionUtils.isEmpty(limited)) {
            return;
        }
        LimitedRuleParam limitedRuleParam = new LimitedRuleParam();
        for (PromotionPolicyRuleVo ruleVo : limited) {
            RuleFunction ruleFunction;
            PromotionRuleEditVo.KeyValParamControl keyValParamControl = this.limitedKeyValParam(ruleVo.getParams());
            Object limitedConfigStr = keyValParamControl.getValue();
            if (null != limitedConfigStr || StringUtils.isBlank((CharSequence)limitedConfigStr.toString())) {
                limitedRuleParam.setLimitedConfig(new BigDecimal(limitedConfigStr.toString()));
            }
            limitedRuleParam.setGift(calculateRuleResponse.getResultData());
            try {
                ruleFunction = (RuleFunction)SpringApplicationContextUtil.getApplicationContext().getBean(ruleVo.getFuncBody(), RuleFunction.class);
            }
            catch (BeansException e) {
                throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u9650\u91cf\u89c4\u5219[" + ruleVo.getRuleCode() + "]\u8ba1\u7b97\u5931\u8d25, \u672a\u67e5\u627e\u5230\u8be5\u89c4\u5219\u7684\u8ba1\u7b97\u5b9e\u4f8b", (Throwable)e);
            }
            BigDecimal result = (BigDecimal)ruleFunction.apply(limitedRuleParam);
            if (null == result) {
                throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u9650\u91cf\u89c4\u5219[" + ruleVo.getRuleCode() + "]\u8ba1\u7b97\u5931\u8d25\uff0c \u8be5\u89c4\u5219\u672a\u8ba1\u7b97\u51fa\u53ef\u7528\u7684\u7ed3\u679c");
            }
            calculateRuleResponse.setResultData(result);
        }
    }

    protected PromotionRuleEditVo.KeyValParamControl limitedKeyValParam(String paramStr) {
        PromotionRuleEditVo.ControlRow controlRow;
        List controlRows;
        if (StringUtils.isNotBlank((CharSequence)paramStr) && !CollectionUtils.isEmpty((Collection)(controlRows = JsonPropertyUtil.toArray((String)paramStr, PromotionRuleEditVo.ControlRow.class))) && null != controlRows.get(0) && !CollectionUtils.isEmpty((Collection)(controlRow = (PromotionRuleEditVo.ControlRow)controlRows.get(0)).getControls())) {
            return (PromotionRuleEditVo.KeyValParamControl)controlRow.getControls().get(0);
        }
        return new PromotionRuleEditVo.KeyValParamControl();
    }

    protected CalculateRuleResponse calculateRuleExecuted(RuleExecuteParam ruleExecuteParam, CalculateRuleResponse calculateRuleResponse) {
        return calculateRuleResponse;
    }

    protected void checkParam(RuleExecuteParam ruleExecuteParam) {
        if (null == ruleExecuteParam) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<RuleExecuteParam.ProductOrderBuy> productOrderBuy = ruleExecuteParam.getProductOrderBuy();
        if (CollectionUtils.isEmpty(productOrderBuy)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9700\u8981\u8ba1\u7b97\u7684\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        }
        productOrderBuy.forEach(v -> {
            if (null == v.getProductBuyAmount()) {
                throw new BusinessException("\u8bf7\u6307\u5b9a\u5546\u54c1[" + v.getProductCode() + "]\u7684\u91d1\u989d\u8d2d\u4e70\u91d1\u989d");
            }
            if (null == v.getProductBuyNo()) {
                throw new BusinessException("\u8bf7\u6307\u5b9a\u5546\u54c1[" + v.getProductCode() + "]\u7684\u6570\u91cf\u8d2d\u4e70\u6570\u91cf");
            }
        });
        PromotionPolicyRuleVo condition = ruleExecuteParam.getCondition();
        PromotionPolicyRuleVo calculate = ruleExecuteParam.getCalculate();
        if (null == calculate) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u8ba1\u7b97\u89c4\u5219");
        }
        if (StringUtils.isBlank((CharSequence)condition.getRuleCode())) {
            throw new BusinessException("\u8ba1\u7b97\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)condition.getFuncBody())) {
            throw new BusinessException("\u8ba1\u7b97\u89c4\u5219\u811a\u672c\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == condition) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6761\u4ef6\u89c4\u5219");
        }
        if (StringUtils.isBlank((CharSequence)condition.getRuleCode())) {
            throw new BusinessException("\u6761\u4ef6\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)condition.getFuncBody())) {
            throw new BusinessException("\u6761\u4ef6\u89c4\u5219\u811a\u672c\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)condition.getParams())) {
            throw new BusinessException("\u6761\u4ef6\u89c4\u5219\u9636\u68af\u914d\u7f6e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

