/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component.resolver.ladder;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.component.resolver.ConditionRuleLadderResolver;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractConditionRuleLadderResolver
implements ConditionRuleLadderResolver {
    protected String funcBody;
    protected Integer valueIndexAsProductCurrentY = 0;
    protected Integer unitIndexAsProductCurrentY = 1;
    protected Integer valueIndexAsProductCurrentN = 2;
    protected Integer unitIndexAsProductCurrentN = 3;
    protected Integer controlSize = 4;

    @PostConstruct
    public void init() {
        Config config = this.config();
        this.valueIndexAsProductCurrentY = config.getValueIndexAsProductCurrentY();
        this.unitIndexAsProductCurrentY = config.getUnitIndexAsProductCurrentY();
        this.valueIndexAsProductCurrentN = config.getValueIndexAsProductCurrentN();
        this.unitIndexAsProductCurrentN = config.getUnitIndexAsProductCurrentN();
        this.controlSize = config.getControlSize();
        this.funcBody = config.getFuncBody();
    }

    protected abstract Config config();

    @Override
    public BigDecimal valueAsProductCurrentY(PromotionRuleEditVo.ControlRow controlRow) {
        this.check(controlRow);
        List controls = controlRow.getControls();
        Object ladderNo = ((PromotionRuleEditVo.KeyValParamControl)controls.get(this.valueIndexAsProductCurrentY)).getValue();
        if (null == ladderNo || StringUtils.isBlank((CharSequence)ladderNo.toString())) {
            throw new BusinessException("\u89c4\u5219[" + this.funcBody + "]\u9636\u68af\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u914d\u7f6e\u9636\u68af\u672c\u54c1\u6ee1\u8d60\u6570\u91cf");
        }
        return new BigDecimal(ladderNo.toString());
    }

    @Override
    public String unitAsProductCurrentY(PromotionRuleEditVo.ControlRow controlRow) {
        this.check(controlRow);
        List controls = controlRow.getControls();
        Object ladderNoUnit = ((PromotionRuleEditVo.KeyValParamControl)controls.get(this.unitIndexAsProductCurrentY)).getValue();
        if (null == ladderNoUnit || StringUtils.isBlank((CharSequence)ladderNoUnit.toString())) {
            throw new BusinessException("\u89c4\u5219[" + this.funcBody + "]\u9636\u68af\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u914d\u7f6e\u9636\u68af\u672c\u54c1\u6ee1\u8d60\u6570\u91cf\u5355\u4f4d");
        }
        return ladderNoUnit.toString();
    }

    @Override
    public BigDecimal valueAsProductCurrentN(PromotionRuleEditVo.ControlRow controlRow) {
        this.check(controlRow);
        List controls = controlRow.getControls();
        Object ladderNo = ((PromotionRuleEditVo.KeyValParamControl)controls.get(this.valueIndexAsProductCurrentN)).getValue();
        if (null == ladderNo || StringUtils.isBlank((CharSequence)ladderNo.toString())) {
            throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u89c4\u5219[" + this.funcBody + "]\u9636\u68af\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u914d\u7f6e\u9636\u68af\u8d60\u54c1\u6570\u91cf");
        }
        return new BigDecimal(ladderNo.toString());
    }

    @Override
    public String unitAsProductCurrentN(PromotionRuleEditVo.ControlRow controlRow) {
        this.check(controlRow);
        List controls = controlRow.getControls();
        Object ladderNoUnit = ((PromotionRuleEditVo.KeyValParamControl)controls.get(this.unitIndexAsProductCurrentN)).getValue();
        if (null == ladderNoUnit || StringUtils.isBlank((CharSequence)ladderNoUnit.toString())) {
            throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u89c4\u5219[" + this.funcBody + "]\u9636\u68af\u914d\u7f6e\u9519\u8bef\uff0c\u8d60\u9001\u5f62\u5f0f\u4e3a\u201c\u6570\u91cf\u201d\u7684\u9636\u68af\u5fc5\u987b\u6307\u5b9a\u8d60\u54c1\u7684\u5355\u4f4d\u7c7b\u578b(\u57fa\u672c\u5355\u4f4d/\u9500\u552e\u5355\u4f4d)\u3002");
        }
        return ladderNoUnit.toString();
    }

    @Override
    public Object controlValue(PromotionRuleEditVo.ControlRow controlRow, int index) {
        this.check(controlRow);
        List controls = controlRow.getControls();
        Object ladderNoUnit = ((PromotionRuleEditVo.KeyValParamControl)controls.get(index)).getValue();
        if (null == ladderNoUnit || StringUtils.isBlank((CharSequence)ladderNoUnit.toString())) {
            throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u89c4\u5219[" + this.funcBody + "][\u7b2c" + index + "\u4f4d]\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u672a\u83b7\u53d6\u5230\u53ef\u7528\u7684\u53c2\u6570\u503c\u3002");
        }
        return ladderNoUnit;
    }

    @Override
    public Object controlValue(PromotionRuleEditVo.ControlRow controlRow) {
        return this.controlValue(controlRow, 0);
    }

    protected void check(PromotionRuleEditVo.ControlRow controlRow) {
        List controls = controlRow.getControls();
        if (null == controls || controls.size() != this.controlSize.intValue()) {
            throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u89c4\u5219[" + this.funcBody + "]\u9636\u68af\u63a7\u4ef6\u914d\u7f6e\u4e0d\u7b26\u89c4\u8303\uff0c\u8bf7\u68c0\u67e5\u3002");
        }
    }

    public static class Config {
        private String funcBody;
        private Integer valueIndexAsProductCurrentY;
        private Integer unitIndexAsProductCurrentY;
        private Integer valueIndexAsProductCurrentN;
        private Integer unitIndexAsProductCurrentN;
        private Integer controlSize;

        public String getFuncBody() {
            return this.funcBody;
        }

        public Integer getValueIndexAsProductCurrentY() {
            return this.valueIndexAsProductCurrentY;
        }

        public Integer getUnitIndexAsProductCurrentY() {
            return this.unitIndexAsProductCurrentY;
        }

        public Integer getValueIndexAsProductCurrentN() {
            return this.valueIndexAsProductCurrentN;
        }

        public Integer getUnitIndexAsProductCurrentN() {
            return this.unitIndexAsProductCurrentN;
        }

        public Integer getControlSize() {
            return this.controlSize;
        }

        public void setFuncBody(String funcBody) {
            this.funcBody = funcBody;
        }

        public void setValueIndexAsProductCurrentY(Integer valueIndexAsProductCurrentY) {
            this.valueIndexAsProductCurrentY = valueIndexAsProductCurrentY;
        }

        public void setUnitIndexAsProductCurrentY(Integer unitIndexAsProductCurrentY) {
            this.unitIndexAsProductCurrentY = unitIndexAsProductCurrentY;
        }

        public void setValueIndexAsProductCurrentN(Integer valueIndexAsProductCurrentN) {
            this.valueIndexAsProductCurrentN = valueIndexAsProductCurrentN;
        }

        public void setUnitIndexAsProductCurrentN(Integer unitIndexAsProductCurrentN) {
            this.unitIndexAsProductCurrentN = unitIndexAsProductCurrentN;
        }

        public void setControlSize(Integer controlSize) {
            this.controlSize = controlSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$funcBody = this.getFuncBody();
            String other$funcBody = other.getFuncBody();
            if (this$funcBody == null ? other$funcBody != null : !this$funcBody.equals(other$funcBody)) {
                return false;
            }
            Integer this$valueIndexAsProductCurrentY = this.getValueIndexAsProductCurrentY();
            Integer other$valueIndexAsProductCurrentY = other.getValueIndexAsProductCurrentY();
            if (this$valueIndexAsProductCurrentY == null ? other$valueIndexAsProductCurrentY != null : !((Object)this$valueIndexAsProductCurrentY).equals(other$valueIndexAsProductCurrentY)) {
                return false;
            }
            Integer this$unitIndexAsProductCurrentY = this.getUnitIndexAsProductCurrentY();
            Integer other$unitIndexAsProductCurrentY = other.getUnitIndexAsProductCurrentY();
            if (this$unitIndexAsProductCurrentY == null ? other$unitIndexAsProductCurrentY != null : !((Object)this$unitIndexAsProductCurrentY).equals(other$unitIndexAsProductCurrentY)) {
                return false;
            }
            Integer this$valueIndexAsProductCurrentN = this.getValueIndexAsProductCurrentN();
            Integer other$valueIndexAsProductCurrentN = other.getValueIndexAsProductCurrentN();
            if (this$valueIndexAsProductCurrentN == null ? other$valueIndexAsProductCurrentN != null : !((Object)this$valueIndexAsProductCurrentN).equals(other$valueIndexAsProductCurrentN)) {
                return false;
            }
            Integer this$unitIndexAsProductCurrentN = this.getUnitIndexAsProductCurrentN();
            Integer other$unitIndexAsProductCurrentN = other.getUnitIndexAsProductCurrentN();
            if (this$unitIndexAsProductCurrentN == null ? other$unitIndexAsProductCurrentN != null : !((Object)this$unitIndexAsProductCurrentN).equals(other$unitIndexAsProductCurrentN)) {
                return false;
            }
            Integer this$controlSize = this.getControlSize();
            Integer other$controlSize = other.getControlSize();
            return !(this$controlSize == null ? other$controlSize != null : !((Object)this$controlSize).equals(other$controlSize));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $funcBody = this.getFuncBody();
            result = result * 59 + ($funcBody == null ? 43 : $funcBody.hashCode());
            Integer $valueIndexAsProductCurrentY = this.getValueIndexAsProductCurrentY();
            result = result * 59 + ($valueIndexAsProductCurrentY == null ? 43 : ((Object)$valueIndexAsProductCurrentY).hashCode());
            Integer $unitIndexAsProductCurrentY = this.getUnitIndexAsProductCurrentY();
            result = result * 59 + ($unitIndexAsProductCurrentY == null ? 43 : ((Object)$unitIndexAsProductCurrentY).hashCode());
            Integer $valueIndexAsProductCurrentN = this.getValueIndexAsProductCurrentN();
            result = result * 59 + ($valueIndexAsProductCurrentN == null ? 43 : ((Object)$valueIndexAsProductCurrentN).hashCode());
            Integer $unitIndexAsProductCurrentN = this.getUnitIndexAsProductCurrentN();
            result = result * 59 + ($unitIndexAsProductCurrentN == null ? 43 : ((Object)$unitIndexAsProductCurrentN).hashCode());
            Integer $controlSize = this.getControlSize();
            result = result * 59 + ($controlSize == null ? 43 : ((Object)$controlSize).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractConditionRuleLadderResolver.Config(funcBody=" + this.getFuncBody() + ", valueIndexAsProductCurrentY=" + this.getValueIndexAsProductCurrentY() + ", unitIndexAsProductCurrentY=" + this.getUnitIndexAsProductCurrentY() + ", valueIndexAsProductCurrentN=" + this.getValueIndexAsProductCurrentN() + ", unitIndexAsProductCurrentN=" + this.getUnitIndexAsProductCurrentN() + ", controlSize=" + this.getControlSize() + ")";
        }
    }
}

