/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolFrozenFileVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolFrozenItemVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolVo;
import com.biz.crm.repfeepool.entity.RepFeePoolFrozenItemEntity;
import com.biz.crm.repfeepool.mapper.RepFeePoolFrozenItemMapper;
import com.biz.crm.repfeepool.service.RepFeePoolFrozenFileService;
import com.biz.crm.repfeepool.service.RepFeePoolFrozenItemService;
import com.biz.crm.repfeepool.service.RepFeePoolItemService;
import com.biz.crm.repfeepool.service.RepFeePoolService;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="repFeePoolFrozenItemService")
@ConditionalOnMissingBean(name={"repFeePoolFrozenItemServiceImpl"})
public class RepFeePoolFrozenItemServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RepFeePoolFrozenItemMapper, RepFeePoolFrozenItemEntity>
implements RepFeePoolFrozenItemService {
    @Resource
    private RepFeePoolFrozenItemMapper repFeePoolFrozenItemMapper;
    @Resource
    private RepFeePoolItemService repFeePoolItemService;
    @Resource
    private RepFeePoolFrozenFileService repFeePoolFrozenFileService;
    @Resource
    private RepFeePoolService repFeePoolService;

    @Override
    public List<RepFeePoolFrozenItemVo> findByPoolItemCode(String poolItemCode) {
        if (StringUtils.isEmpty((String)poolItemCode)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.eq((Object)"rep_fee_pool_item_code", (Object)poolItemCode);
        wrapper.orderByAsc((Object)"create_date");
        wrapper.orderByAsc((Object)"create_date_second");
        List entities = this.repFeePoolFrozenItemMapper.selectList((Wrapper)wrapper);
        return BeanCopyUtil.copyList(entities, RepFeePoolFrozenItemVo.class);
    }

    @Override
    public RepFeePoolFrozenItemVo findByCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"code", (Object)code);
        List entities = this.repFeePoolFrozenItemMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return null;
        }
        ValidateUtils.isTrue((entities.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636e\u51bb\u7ed3\u660e\u7ec6\u7f16\u7801\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e", (Object[])new Object[0]);
        return BeanCopyUtil.copyBen(entities.get(0), RepFeePoolFrozenItemVo.class);
    }

    @Override
    @Transactional
    public void create(RepFeePoolFrozenItemVo frozenItemVo) {
        ValidateUtils.validate((Object)frozenItemVo, (String)"\u65b0\u589e\u8d27\u8865\u8d39\u7528\u6c60\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)frozenItemVo.getRepFeePoolItemCode(), (String)"\u65b0\u589e\u6298\u6263\u8d39\u7528\u6c60\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        RepFeePoolFrozenItemEntity entity = BeanCopyUtil.copyBen(frozenItemVo, RepFeePoolFrozenItemEntity.class);
        FieldHandleUtil.initDecimalZero((Object)entity);
        FieldHandleUtil.initCreateFields((Object)entity);
        this.repFeePoolFrozenItemMapper.insert((Object)entity);
        List files = frozenItemVo.getFiles();
        files.forEach(f -> f.setRepFeePoolFrozenItemCode(frozenItemVo.getCode()));
        this.repFeePoolFrozenFileService.createAll(files);
    }

    @Override
    @Transactional
    public void updateAll(List<RepFeePoolFrozenItemVo> frozenItemVos) {
        ValidateUtils.notEmpty(frozenItemVos, (String)"\u6279\u91cf\u7f16\u8f91\u8d39\u7528\u6c60\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        frozenItemVos.forEach(frozenItemVo -> this.update((RepFeePoolFrozenItemVo)frozenItemVo));
    }

    @Override
    @Transactional
    public void update(RepFeePoolFrozenItemVo frozenItemVo) {
        ValidateUtils.validate((Object)frozenItemVo, (String)"\u7f16\u8f91\u8d39\u7528\u6c60\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)frozenItemVo.getId(), (String)"\u7f16\u8f91\u8d39\u7528\u6c60\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)frozenItemVo.getRepFeePoolItemCode(), (String)"\u7f16\u8f91\u8d39\u7528\u6c60\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        RepFeePoolFrozenItemEntity oldEntity = (RepFeePoolFrozenItemEntity)((Object)this.repFeePoolFrozenItemMapper.selectById((Serializable)((Object)frozenItemVo.getId())));
        ValidateUtils.validate((Object)((Object)oldEntity), (String)"\u7f16\u8f91\u8d39\u7528\u6c60\u51bb\u7ed3\u660e\u7ec6\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8bb0\u5f55");
        FieldHandleUtil.initDecimalZero(frozenItemVo);
        FieldHandleUtil.initUpdateFields(frozenItemVo);
        RepFeePoolFrozenItemEntity entity = BeanCopyUtil.copyBen(frozenItemVo, RepFeePoolFrozenItemEntity.class);
        this.repFeePoolFrozenItemMapper.updateById((Object)entity);
        List files = frozenItemVo.getFiles();
        files.forEach(f -> f.setRepFeePoolFrozenItemCode(frozenItemVo.getCode()));
        this.repFeePoolFrozenFileService.createAll(files);
    }

    @Override
    public PageResult<RepFeePoolFrozenItemVo> findPageByConditions(RepFeePoolFrozenItemVo param) {
        List<RepFeePoolFrozenItemVo> pageResult;
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        if (!StringUtils.isEmpty((String)param.getStartDate())) {
            param.setStartDate(param.getStartDate().split(" ")[0]);
        }
        if (!StringUtils.isEmpty((String)param.getEndDate())) {
            param.setEndDate(param.getEndDate().split(" ")[0]);
        }
        if (CollectionUtil.listEmpty(pageResult = this.repFeePoolFrozenItemMapper.findPageByConditions((Page<RepFeePoolFrozenItemVo>)page, param))) {
            return PageResult.builder().data((List)Lists.newArrayList()).count(Long.valueOf(0L)).build();
        }
        pageResult.forEach(vo -> {
            RepFeePoolItemVo repFeePoolItemVo = this.repFeePoolItemService.findByCode(vo.getRepFeePoolItemCode());
            if (repFeePoolItemVo != null) {
                RepFeePoolVo repFeePoolVo = this.repFeePoolService.findByCode(repFeePoolItemVo.getRepFeePoolCode());
                repFeePoolItemVo.setRepFeePoolVo(repFeePoolVo);
            }
            List<RepFeePoolFrozenFileVo> files = this.repFeePoolFrozenFileService.findByFrozenItemCode(vo.getCode());
            vo.setFiles(files);
            vo.setRepFeePoolItemVo(repFeePoolItemVo);
        });
        return PageResult.builder().data(pageResult).count(Long.valueOf(page.getTotal())).build();
    }
}

