/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.order.MinOrderVo;
import com.biz.crm.order.entity.MinOrderEntity;
import com.biz.crm.order.repositories.MinOrderRepositories;
import com.biz.crm.order.service.MinOrderService;
import com.biz.crm.order.utils.MinOrderUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.EsUtil;
import com.biz.crm.util.RedissonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"MinOrderServiceExpandImpl"})
@Service(value="minOrderService")
public class MinOrderServiceImpl
implements MinOrderService {
    @Resource
    private ElasticsearchTemplate elasticsearchTemplate;
    @Resource
    private RedissonUtil redissonUtil;
    @Resource
    private MinOrderRepositories minOrderRepositories;

    @Override
    @Transactional
    public void add(ArrayList<MinOrderVo> minOrderVos) {
        if (CollectionUtils.isEmpty(minOrderVos)) {
            return;
        }
        MinOrderUtil.validParamBatch(minOrderVos);
        List<MinOrderEntity> minOrderEntities = MinOrderUtil.assembleEntities(minOrderVos);
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, MinOrderEntity.class, (RedissonUtil)this.redissonUtil)) {
            this.minOrderRepositories.saveAll(minOrderEntities);
            this.elasticsearchTemplate.refresh("minorderindex");
            return;
        }
        List<String> onlyKeys = minOrderEntities.stream().map(MinOrderEntity::getOnlyKey).collect(Collectors.toList());
        this.minOrderRepositories.deleteAllByOnlyKeyIn(onlyKeys);
        this.minOrderRepositories.saveAll(minOrderEntities);
        this.elasticsearchTemplate.refresh("minorderindex");
    }

    @Override
    public PageResult<MinOrderVo> list(MinOrderVo minOrderVo) {
        NativeSearchQuery searchQuery;
        AggregatedPage scroll;
        List list;
        PageResult pageResult = new PageResult();
        pageResult.setCount(Long.valueOf(Long.parseLong("0")));
        pageResult.setData(new ArrayList());
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, MinOrderEntity.class, (RedissonUtil)this.redissonUtil)) {
            return pageResult;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)minOrderVo.getProductCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productCode", (Object)minOrderVo.getProductCode()));
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getProductName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productName", (Object)minOrderVo.getProductName()));
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getOrgCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"orgCode", (Object)minOrderVo.getOrgCode()));
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getOrgName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"orgName", (Object)minOrderVo.getOrgName()));
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getCusCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"cusCode", (Object)minOrderVo.getCusCode()));
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getCusName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"cusName", (Object)minOrderVo.getCusName()));
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getTerminalCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"terminalCode", (Object)minOrderVo.getTerminalCode()));
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getTerminalName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"terminalName", (Object)minOrderVo.getTerminalName()));
        }
        if (minOrderVo.getEffectiveFlag() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"effectiveFlag", (Object)minOrderVo.getEffectiveFlag()));
        }
        if (CollectionUtils.isEmpty((Collection)(list = (scroll = this.elasticsearchTemplate.queryForPage((SearchQuery)(searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"minorderindex"}).withQuery((QueryBuilder)boolQueryBuilder).withSort(SortBuilders.fieldSort((String)"operationTimeNum").unmappedType("keyword").order(SortOrder.DESC)).withPageable((Pageable)PageRequest.of((int)(minOrderVo.getPageNum() - 1), (int)minOrderVo.getPageSize())).build()), MinOrderEntity.class)).getContent()))) {
            return pageResult;
        }
        pageResult.setData(CrmBeanUtil.copyList((List)list, MinOrderVo.class));
        pageResult.setCount(Long.valueOf(scroll.getTotalElements()));
        return pageResult;
    }

    @Override
    @Transactional
    public void updateEffectiveFlag(ArrayList<String> ids, Integer code) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<MinOrderEntity> minOrderEntities = this.minOrderRepositories.findByIdIn(ids);
        if (CollectionUtils.isEmpty(minOrderEntities) || minOrderEntities.size() < ids.size()) {
            throw new BusinessException("\u90e8\u5206\u8d77\u8ba2\u91cf\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        minOrderEntities = minOrderEntities.stream().map(minOrderEntity -> minOrderEntity.setEffectiveFlag(code)).collect(Collectors.toList());
        this.minOrderRepositories.saveAll(minOrderEntities);
        this.elasticsearchTemplate.refresh("minorderindex");
    }

    @Override
    public void update(final MinOrderVo minOrderVo) {
        if (minOrderVo == null) {
            return;
        }
        MinOrderUtil.validParam(minOrderVo);
        List<MinOrderEntity> minOrderEntities = this.minOrderRepositories.findByIdIn((List<String>)new ArrayList<String>(){
            {
                this.add(minOrderVo.getId());
            }
        });
        if (CollectionUtils.isEmpty(minOrderEntities)) {
            throw new BusinessException("\u8981\u4fee\u6539\u7684\u8d77\u8ba2\u91cf\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u88ab\u5220\u9664\uff01");
        }
        this.minOrderRepositories.save(CrmBeanUtil.copy((Object)minOrderVo, MinOrderEntity.class));
        this.elasticsearchTemplate.refresh("minorderindex");
    }

    @Override
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u8981\u5220\u9664\u7684\u8d77\u8ba2\u91cf\uff01");
        }
        this.minOrderRepositories.deleteAllByIdIn(ids);
        this.elasticsearchTemplate.refresh("minorderindex");
    }
}

