/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.utils;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.order.MinOrderVo;
import com.biz.crm.order.entity.MinOrderEntity;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class MinOrderUtil {
    public static void validParamBatch(ArrayList<MinOrderVo> minOrderVos) {
        minOrderVos.stream().forEach(minOrderVo -> MinOrderUtil.validParam(minOrderVo));
    }

    public static void validParam(MinOrderVo minOrderVo) {
        ValidateUtils.validate((Object)minOrderVo.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ValidateUtils.validate((Object)minOrderVo.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        boolean flag = false;
        if (!StringUtils.isEmpty((Object)minOrderVo.getOrgCode()) && !StringUtils.isEmpty((Object)minOrderVo.getOrgName())) {
            flag = true;
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getCusCode()) && !StringUtils.isEmpty((Object)minOrderVo.getCusName())) {
            flag = true;
        }
        if (!StringUtils.isEmpty((Object)minOrderVo.getTerminalCode()) && !StringUtils.isEmpty((Object)minOrderVo.getTerminalName())) {
            flag = true;
        }
        if (!flag) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3001\u5ba2\u6237\u6216\u7ec8\u7aef\uff01");
        }
        ValidateUtils.validate((Object)minOrderVo.getVerificationMode(), (String)"\u8bf7\u6307\u5b9a\u9a8c\u8bc1\u65b9\u5f0f\uff01");
        ValidateUtils.validate((Object)minOrderVo.getMinOrderQuantity(), (String)"\u8d77\u8ba2\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    public static List<MinOrderEntity> assembleEntities(ArrayList<MinOrderVo> minOrderVos) {
        List minOrderEntities = CrmBeanUtil.copyList(minOrderVos, MinOrderEntity.class);
        return minOrderEntities.stream().map(minOrderEntity -> {
            minOrderEntity.setId(UUIDGenerator.generate());
            minOrderEntity.setOnlyKey(MinOrderUtil.getOnlyKey(minOrderEntity));
            return minOrderEntity;
        }).collect(Collectors.toList());
    }

    private static String getOnlyKey(MinOrderEntity minOrderEntity) {
        StringBuilder key = new StringBuilder();
        if (!StringUtils.isEmpty((Object)minOrderEntity.getOrgCode())) {
            key.append(minOrderEntity.getOrgCode());
        } else if (!StringUtils.isEmpty((Object)minOrderEntity.getCusCode())) {
            key.append(minOrderEntity.getCusCode());
        } else {
            key.append(minOrderEntity.getTerminalCode());
        }
        key.append(minOrderEntity.getProductCode());
        return key.toString();
    }
}

